Option Explicit

' These are the text global constants
Global Const GERMAN = 0
Global Const ENGLISH = 1000
Global Const TEXT_1 = 0
Global Const TEXT_2 = 1
Global Const TEXT_3 = 2
' and so forth...

' Constants for fiel names
Global Const TEXTFILENAME = 0
Global Const HELPFILENAME = 1

' Global variables
Global nLanguage As Integer
Global hInstLng As Integer

Sub ChangeLanguage (newLang%)
  Dim n%, temp$, myFile$
  nLanguage = newLang
  ' Change the name of the help file
  myFile$ = GetLanguageFileName(nLanguage, HELPFILENAME)
  App.HelpFile = App.Path + "\" + myFile$
  ' Unload the text DLL, if it was loaded, and reload it
  If hInstLng Then FreeLibrary (hInstLng)
  myFile$ = App.Path + "\" + GetLanguageFileName(nLanguage, TEXTFILENAME)
  hInstLng = LoadLibrary(myFile$)
  ' Load failed - set handle to 0
  If hInstLng >= 0 And hInstLng <= 32 Then hInstLng = 0
End Sub

Function GetLanguageFileName (nLang%, nFile%) As String
  Dim temp$
  Select Case nLang
    Case GERMAN
      temp$ = "GERMAN"
    Case ENGLISH
      temp$ = "ENGLISH"
  End Select
  Select Case nFile
    Case TEXTFILENAME
      temp$ = temp$ + ".DLL"
    Case HELPFILENAME
      temp$ = temp$ + ".HLP"
  End Select
  GetLanguageFileName = temp$
End Function

Sub Terminate ()
  FreeLibrary (hInstLng)
  End
End Sub

