VERSION 2.00
Begin Form frmMain 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Echo Sample Application"
   ClientHeight    =   5820
   ClientLeft      =   4620
   ClientTop       =   2565
   ClientWidth     =   4545
   FontBold        =   -1  'True
   FontItalic      =   0   'False
   FontName        =   "Arial"
   FontSize        =   8.25
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   6225
   Icon            =   ECHO.FRX:0000
   Left            =   4560
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   5820
   ScaleWidth      =   4545
   Top             =   2220
   Width           =   4665
   Begin dsSocket dsSocket1 
      DataSize        =   2048
      Left            =   3840
      Linger          =   -1  'True
      LocalPort       =   0
      RemoteDotAddr   =   ""
      RemoteHost      =   ""
      RemotePort      =   0
      ServiceName     =   ""
      Timeout         =   10
      Top             =   1920
   End
   Begin TextBox txStatus 
      BackColor       =   &H00C0C0C0&
      Height          =   330
      Left            =   105
      TabIndex        =   14
      Top             =   5355
      Width           =   4320
   End
   Begin CommandButton btnEcho 
      Caption         =   "&Echo"
      Height          =   330
      Left            =   210
      TabIndex        =   0
      Top             =   3045
      Width           =   1275
   End
   Begin ListBox lbEcho 
      BackColor       =   &H00C0C0C0&
      Height          =   1590
      Left            =   105
      TabIndex        =   1
      Top             =   3675
      Width           =   4320
   End
   Begin TextBox txData 
      BackColor       =   &H00FFFFFF&
      Height          =   750
      Left            =   1575
      TabIndex        =   13
      Text            =   "This is a sample of echo data."
      Top             =   2625
      Width           =   2850
   End
   Begin OptionButton opServiceNumber 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Use echo Port Number (7)"
      Height          =   225
      Left            =   315
      TabIndex        =   11
      Top             =   2205
      Value           =   -1  'True
      Width           =   2535
   End
   Begin OptionButton opServiceName 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Use echo Service Name"
      Height          =   225
      Left            =   315
      TabIndex        =   10
      Top             =   1890
      Width           =   2535
   End
   Begin PictureBox Picture1 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   1065
      Left            =   105
      ScaleHeight     =   1065
      ScaleWidth      =   4425
      TabIndex        =   3
      Top             =   630
      Width           =   4425
      Begin OptionButton opServerAddress 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Use Server Address"
         Height          =   225
         Left            =   2310
         TabIndex        =   9
         Top             =   735
         Width           =   2115
      End
      Begin OptionButton opServerName 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Use Server Name"
         Height          =   225
         Left            =   210
         TabIndex        =   8
         Top             =   735
         Value           =   -1  'True
         Width           =   1905
      End
      Begin TextBox txServerAddress 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   1575
         TabIndex        =   7
         Top             =   315
         Width           =   2745
      End
      Begin TextBox txServerName 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   1575
         TabIndex        =   6
         Top             =   0
         Width           =   2745
      End
      Begin Label Label2 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Server Address :"
         Height          =   225
         Left            =   0
         TabIndex        =   5
         Top             =   315
         Width           =   1485
      End
      Begin Label Label1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Server Name :"
         Height          =   225
         Left            =   0
         TabIndex        =   4
         Top             =   0
         Width           =   1485
      End
   End
   Begin Label Label4 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Echo from server :"
      Height          =   225
      Left            =   105
      TabIndex        =   2
      Top             =   3465
      Width           =   1905
   End
   Begin Label Label3 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Data to echo :"
      Height          =   225
      Left            =   105
      TabIndex        =   12
      Top             =   2625
      Width           =   1380
   End
End

Option Explicit

'   Declare the constants used to set the Action property
'   and check the State of the socket

Const SOCK_ACTION_CLOSE = 1
Const SOCK_ACTION_CONNECT = 2
Const SOCK_ACTION_LISTEN = 3
Const SOCK_STATE_CONNECTED = 2

Sub btnEcho_Click ()

    '   Setup to handle errors as they occur
    On Error Resume Next

    '   If the user selected to use the ServerName, then
    '   set the properties accordingly.  If RemoteDotAddr is
    '   blank, then the control will use the RemoteHost information
    '   to resolve an address.
    If (opServerName) Then
        dsSocket1.RemoteHost = txServerName.Text
        dsSocket1.RemoteDotAddr = ""
    Else
        dsSocket1.RemoteHost = ""
        dsSocket1.RemoteDotAddr = txServerAddress.Text
    End If

    '   If the user selected to use the ServiceName, then
    '   set the properties accordingly.  If RemotePort property is
    '   zero, then the control will use the ServiceName information
    '   to resolve a port number for making the connection.
    If (opServiceName) Then
        dsSocket1.ServiceName = "echo"  ' set service name to "echo"
        dsSocket1.RemotePort = 0
    Else
        dsSocket1.ServiceName = ""
        dsSocket1.RemotePort = 7    ' standard TCP port number for echo
                                    ' as defined in SERVICES file
    End If

    '   If the socket is not already connected, the do a Connect
    If (dsSocket1.State <> SOCK_STATE_CONNECTED) Then
        
        '   show the status information
        txStatus.Text = "Connecting to server..."
        
        '   issue the connect command
        dsSocket1.Action = SOCK_ACTION_CONNECT
        
        '   if there were any errors establishing the connection
        '   then report them
        If (Err > 0) Then
            MsgBox "Error connecting to server." & Chr(13) & Format(Err) & " : " & Error
            txStatus.Text = Error & "..."
            Exit Sub
        
        '   else show the status
        Else
            txStatus.Text = "Connected to server " + txServerName.Text + "..."
        End If

    End If

    '   now that the socket is connected, send the data string to be echoed back
    dsSocket1.Send = txData.Text
    
    '   if there were any errors establishing the connection
    '   then report them
    If (Err > 0) Then
        MsgBox "Error sending data to server." & Chr(13) & Format(Err) & " : " & Error
        txStatus.Text = Error & "..."
    
    '   else show the status
    Else
        txStatus.Text = Format(Len(txData.Text)) + " bytes sent to server..."
    
    End If

End Sub

Sub dsSocket1_Receive (ReceiveData As String)

    '
    '   Process data echoed back from server
    '
    
    On Error Resume Next

    '   Display the data in the listbox
    lbEcho.AddItem ReceiveData

    '   Make the last item the current one
    lbEcho.ListIndex = lbEcho.ListCount - 1

    '   Close the connection.  Normally this wouldn't be done
    '   until we are actually finished with the connection.  We
    '   do it here for demonstration purposes
    dsSocket1.Action = SOCK_ACTION_CLOSE

    '   If there were any errors then report them.  The Action property
    '   will return errors in the standard VB error variables
    If (Err > 0) Then
        MsgBox "Error disconnecting from server." & Chr(13) & Format(Err) & " : " & Error
        txStatus.Text = Error & "..."
        Exit Sub
    
    '   If no errors, just report the status
    Else
        txStatus.Text = "Disconnected from server " + txServerName.Text + "..."
    
    End If

End Sub

Sub Form_Paint ()

    '
    '   This is simply some pretty header code
    '

    '   Setup to do a shadowed text title and copyright notice.
    FontSize = 30
    FontItalic = True
    Forecolor = &H808080
    CurrentX = 140
    CurrentY = -50
    Print "Echo"

    Forecolor = &HFF0000
    CurrentX = 170
    CurrentY = -20
    Print "Echo"

    FontSize = 12
    CurrentX = 1800
    CurrentY = 300
    Print Chr(169) & "Dolphin Systems Inc."

End Sub

