Option Explicit

Dim msDir As String
Dim mnDirNameLength As Integer

Declare Function KRN_GetWindowsDirectory Lib "Kernel" Alias "GetWindowsDirectory" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
Declare Function KRN_GetSystemDirectory Lib "Kernel" Alias "GetSystemDirectory" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer

Function CopyFile (rsFileName As String, rsDestination As String) As Integer
'
'   This routine will copy a file to a given destination.
'
    CopyFile = False

    On Error GoTo CopyFile_ER

    FileCopy rsFileName, rsDestination
    Exit Function

CopyFile_ER:
    CopyFile = Err
    gsMsg = "Error in CopyFile, Error is " & Error
    gsMsgTitle = "Copy File"
    Exit Function
End Function

Function FileExists (rsFilePath As String) As Integer
'
'   This routine will check for the existence of a
'   file by attempting an OPEN. It will return a TRUE
'   value if the file exists, FALSE otherwise.
'
    Dim nFile As Integer

    nFile = FreeFile

    On Error Resume Next
    Open rsFilePath For Input As nFile
    If Err = 0 Then
        FileExists = True
    Else
        FileExists = False
    End If
    Close nFile
End Function

Function GetWinDir () As String
'
'   This routine will find and return the users windows
'   directory.
'
    msDir = String$(145, 0)              ' Size Buffer
    mnDirNameLength = KRN_GetWindowsDirectory(msDir, 145)  ' Make API Call
    msDir = Left$(msDir, mnDirNameLength)              ' Trim Buffer

    If Right$(msDir, 1) <> "\" Then      ' Add \ if necessary
        GetWinDir = msDir + "\"
    Else
        GetWinDir = msDir
    End If
End Function

Function GetWinSysDir () As String
'
'   This routine will return the users windows system
'   directory
'
    msDir = String$(145, 0)                 ' Size Buffer
    mnDirNameLength = KRN_GetSystemDirectory(msDir, 145)      ' Make API Call
    msDir = Left$(msDir, mnDirNameLength)                 ' Trim Buffer

    If Right$(msDir, 1) <> "\" Then         ' Add \ if necessary
        GetWinSysDir = msDir + "\"
    Else
        GetWinSysDir = msDir
    End If
End Function

