//---------------------------------------------------------------------------
// List.c
//---------------------------------------------------------------------------
// List Button Control
//---------------------------------------------------------------------------

#define NOCOMM

#include <windows.h>

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "vbapi.h"
#include "filelist.h"

#define RESET_MASK  0x0000
#define SELECT_MASK 0x0001
#define GRAY_MASK   0x0002
#define INVALID_GRAY -1

static 	BOOL NEAR 				InitiateListBuffer 		(PFILELIST);
static 	BOOL NEAR 				TeminateListBuffer 		(PFILELIST);
static 	LPSTR NEAR 				GetListLine 			(int, PFILELIST);
static 	LPSTR NEAR 				DisplayLine 			(LPSTR, LPSTR, PFILELIST, int);
static 	LPSTR NEAR 				OutputLine 				(LPSTR, LPSTR, PFILELIST, int);
static 	LPSTR NEAR 				InputLine 				(LPSTR, LPSTR, PFILELIST, int);
static 	BOOL NEAR 				GoToLine 				(int, HWND, PFILELIST);
static 	BOOL NEAR 				FindString 				(LPSTR, HWND, PFILELIST);
static 	LPSTR NEAR 				VerifyString 			(LPSTR, HWND, PFILELIST);
static 	LPSTR NEAR 				LocateString 			(LPSTR, HWND, PFILELIST);
BOOL    ItemStatus              (HCTL, HWND, int);
BOOL    SpillItem               (HCTL, HWND, LONG, PFILELIST);
BOOL    CheckItem               (HCTL, HWND, LPDRAWITEMSTRUCT, PFILELIST);
BOOL    DrawItem                (HCTL, HWND, LPDRAWITEMSTRUCT, PFILELIST);

//---------------------------------------------------------------------------
// InitiateListBuffer
//---------------------------------------------------------------------------
static BOOL NEAR InitiateListBuffer (PFILELIST	lpListStruct) {

	LONG lBufferLen;

	// BUFFER ALLOCATION
	lBufferLen = (lpListStruct->nLineSize + 1) * NUMBER_LINES;
	if (lpListStruct->hListBuffer = GlobalAlloc (GHND, lBufferLen)) {

		lpListStruct->lpListBuffer = (LPSTR)
		 							 GlobalLock (lpListStruct->hListBuffer);
 		return (TRUE);
    }
    return (FALSE);
}

//---------------------------------------------------------------------------
// TeminateListBuffer
//---------------------------------------------------------------------------
static BOOL NEAR TeminateListBuffer (PFILELIST	lpListStruct) {

	// BUFFER DEALLOCATION
	if (lpListStruct->hListBuffer) {
		GlobalUnlock (lpListStruct->hListBuffer);
		GlobalFree   (lpListStruct->hListBuffer);
		lpListStruct->hListBuffer  = (HANDLE)NULL;
		lpListStruct->lpListBuffer = (LPSTR)NULL;
		return (TRUE);
	}
	return (FALSE);
}

//---------------------------------------------------------------------------
// GetFileLength
//---------------------------------------------------------------------------
static WORD NEAR GetFileLength (PFILELIST lpListStruct) {

	int 	fH,
			nLastLine;
	LPSTR 	lpFileName;

	lpFileName = VBDerefHsz (lpListStruct->hFileName);
	if ((fH = _lopen (lpFileName, OF_READ )) != -1) {
		int  nLastLine;

		nLastLine = _llseek (fH, 0L, 2) / lpListStruct->nLineSize;
		_llseek (fH, 0l, 0);
		_lclose (fH);
		return (nLastLine);
	}
	return (FALSE);
}

//---------------------------------------------------------------------------
// FillBuffer
//---------------------------------------------------------------------------
static BOOL NEAR FillBuffer (int 		nStartLine,
							 PFILELIST	lpListStruct) {

	int 	fH,
			nLastLine;
	LPSTR 	lpFileName;

	// IS THE BUFFER READY ?
    if (!lpListStruct->lpListBuffer) {
		if (!InitiateListBuffer (lpListStruct)) {
			return (FALSE);
		}
	}

	lpFileName = VBDerefHsz (lpListStruct->hFileName);
	if ((fH = _lopen (lpFileName, OF_READ )) != -1) {
		LONG lOffSet;
		int  nLastLine,
			 n;

		nLastLine = _llseek (fH, 0L, 2) / lpListStruct->nLineSize;

		lpListStruct->nStartLine = nStartLine;
		lpListStruct->nEndLine = min (nLastLine,
									  lpListStruct->nStartLine +
									  NUMBER_LINES - 1);
		lOffSet = lpListStruct->nLineSize * lpListStruct->nStartLine;
		if (_llseek (fH, lOffSet, 0) != -1) {
			for (n = lpListStruct->nStartLine;
				 n <= lpListStruct->nEndLine;
				 ++n)
				_lread (fH,
						lpListStruct->lpListBuffer +
						(n  - lpListStruct->nStartLine) *
						(lpListStruct->nLineSize + 1),
					    lpListStruct->nLineSize);
			_lclose (fH);
            return (TRUE);
		}
	}
	return (FALSE);
}

//---------------------------------------------------------------------------
// GoToLine
//---------------------------------------------------------------------------
static BOOL NEAR GoToLine (	int 		nLine,
							HWND		hWnd,
							PFILELIST	lpListStruct) {

		RECT rTemp;

		// INHIBIT REPAINT
		SendMessage (hWnd,
					WM_SETREDRAW,
					(WORD)NULL,
					(LONG)NULL);

		// SCROLL TO TOP
		SendMessage (hWnd,
					LB_SETTOPINDEX,
					nLine,
					(LONG)NULL);

		// GET TOP RECTANGLE
		SendMessage (hWnd,
					LB_GETITEMRECT,
					nLine,
					(LONG)(LPRECT)&rTemp);

		// CLICK TWICE ON TOP RECTANGLE
		SendMessage (hWnd,
					WM_LBUTTONDOWN,
					(WORD)NULL,
					MAKELONG (rTemp.left, rTemp.top));
		SendMessage (hWnd,
					WM_LBUTTONUP,
					(WORD)NULL,
					MAKELONG (rTemp.left, rTemp.top));
		SendMessage (hWnd,
					WM_LBUTTONDOWN,
					(WORD)NULL,
					MAKELONG (rTemp.left, rTemp.top));
		SendMessage (hWnd,
					WM_LBUTTONUP,
					(WORD)NULL,
					MAKELONG (rTemp.left, rTemp.top));

		// REPAINT LISTBOX
		SendMessage (hWnd,
					WM_SETREDRAW,
					(WORD)TRUE,
					(LONG)NULL);
		InvalidateRect (hWnd, (LPRECT)NULL, TRUE);

		// SAVE NEW POSITIONS
		lpListStruct->nCurrPos = nLine;

		return (TRUE);
}

//---------------------------------------------------------------------------
// FindString
//---------------------------------------------------------------------------
static BOOL NEAR FindString (LPSTR		lpString,
							 HWND		hWnd,
							 PFILELIST	lpListStruct) {

    static char szInString	[LINE_SIZE + 1];
    static char szOutString [LINE_SIZE + 1];
    LPSTR		lpFileName;
    int			fH;

	// GET FILE NAME
	lpFileName = VBDerefHsz (lpListStruct->hFileName);

	// OPEN FILE
	if ((fH = _lopen (lpFileName, OF_READ )) != -1) {
		int  n, nLastLine;

		// GET NUMBER OF LINES
		nLastLine = _llseek (fH, 0L, 2) / lpListStruct->nLineSize;
		for (n = 0; n <= nLastLine; ++n) {

			// GO TO NEXT LINE
			_llseek (fH, (LONG)(n * lpListStruct->nLineSize), 0);
			_lread (fH,
					(LPSTR)szInString,
					lpListStruct->nLineSize);
			lstrcpy (szOutString,
					 DisplayLine ((LPSTR)szInString,
								  (LPSTR)szOutString,
							 	  lpListStruct,
							 	  LINE_SIZE));

			if (_fstrnicmp (szOutString, lpString, lstrlen (lpString)) == 0) {
				_lclose (fH);
				return (GoToLine (n, hWnd, lpListStruct));
			}
		}
		_lclose (fH);
	}
	return (FALSE);


}

//---------------------------------------------------------------------------
// VerifyString
//---------------------------------------------------------------------------
static LPSTR NEAR VerifyString (LPSTR		lpString,
								HWND		hWnd,
							 	PFILELIST	lpListStruct) {

    static char szInString	[LINE_SIZE + 1];
    static char szOutString [LINE_SIZE + 1];
    LPSTR		lpFileName;
    int			fH;

	// GET FILE NAME
	lpFileName = VBDerefHsz (lpListStruct->hFileName);

	// OPEN FILE
	if ((fH = _lopen (lpFileName, OF_READ )) != -1) {
		int  n, nLastLine;

		// GET NUMBER OF LINES
		nLastLine = _llseek (fH, 0L, 2) / lpListStruct->nLineSize;
		for (n = 0; n <= nLastLine; ++n) {

			// GO TO NEXT LINE
			_llseek (fH, (LONG)(n * lpListStruct->nLineSize), 0);

			// LOOP OVER ALL LINES OF TEXT
			_lread (fH,
					(LPSTR)szInString,
					lpListStruct->nLineSize);
			lstrcpy (szOutString,
					InputLine ((LPSTR)szInString,
							   (LPSTR)szOutString,
							   lpListStruct,
							   LINE_SIZE));

			if (_fstrnicmp (szOutString, lpString, lstrlen (szOutString)) == 0) {
				LONG lCurr;
				// OBTAIN OUTPUT STRING
				lCurr = _llseek (fH, 0l, 1);
				_llseek (fH, lCurr - lpListStruct->nLineSize, 0);
				_lread (fH,
					     (LPSTR)szInString,
						 lpListStruct->nLineSize);
				lstrcpy (szOutString,
						OutputLine ((LPSTR)szInString,
								   	(LPSTR)szOutString,
								 	lpListStruct,
								 	LINE_SIZE));
				_lclose (fH);
				return ((LPSTR)szOutString);
			}
		}
		_lclose (fH);
	}
	return ((LPSTR)NULL);

}

//---------------------------------------------------------------------------
// LocateString
//---------------------------------------------------------------------------
static LPSTR NEAR LocateString (LPSTR		lpString,
								HWND		hWnd,
							 	PFILELIST	lpListStruct) {

    static char szInString	[LINE_SIZE + 1];
    static char szOutString [LINE_SIZE + 1];
    LPSTR		lpFileName;
    int			fH;

	// GET FILE NAME
	lpFileName = VBDerefHsz (lpListStruct->hFileName);

	// OPEN FILE
	if ((fH = _lopen (lpFileName, OF_READ )) != -1) {
		int  n, nLastLine;

		// GET NUMBER OF LINES
		nLastLine = _llseek (fH, 0L, 2) / lpListStruct->nLineSize;
		for (n = 0; n <= nLastLine; ++n) {

			// GO TO NEXT LINE
			_llseek (fH, (LONG)(n * lpListStruct->nLineSize), 0);

			// LOOP OVER ALL LINES OF TEXT
			_lread (fH,
					(LPSTR)szInString,
					lpListStruct->nLineSize);
			lstrcpy (szOutString,
					InputLine ((LPSTR)szInString,
							   (LPSTR)szOutString,
							   lpListStruct,
							   LINE_SIZE));

			if (_fstrnicmp (szOutString, lpString, lstrlen (szOutString)) == 0) {
				LONG lCurr;
				// OBTAIN OUTPUT STRING
				lCurr = _llseek (fH, 0l, 1);
				_llseek (fH, lCurr - lpListStruct->nLineSize, 0);
				_lread (fH,
					     (LPSTR)szInString,
						 lpListStruct->nLineSize);
				lstrcpy (szOutString,
						OutputLine ((LPSTR)szInString,
								   	(LPSTR)szOutString,
								 	lpListStruct,
								 	LINE_SIZE));
				_lclose (fH);
				GoToLine (n, hWnd, lpListStruct);
				return ((LPSTR)szOutString);
			}
		}
		_lclose (fH);
	}
	return ((LPSTR)NULL);

}

//---------------------------------------------------------------------------
// GetListLine
//---------------------------------------------------------------------------
static LPSTR NEAR GetListLine (	int 		nLine,
								PFILELIST 	lpListStruct) {

	if (
		(nLine < lpListStruct->nStartLine) ||
		(nLine > lpListStruct->nEndLine)
	   ) {

	    int nStartLine,
	    	nPage;

		// NEED TO GET NEW STAFF INTO THE BUFFER
		nPage      = (nLine - 1) / lpListStruct->nLineSize;
		nStartLine = nPage * lpListStruct->nLineSize;
		if (FillBuffer (nStartLine, lpListStruct)) {

			return (lpListStruct->lpListBuffer +
					(nLine - lpListStruct->nStartLine) *
					(lpListStruct->nLineSize + 1));
		} else
			return (FALSE);
	}

	return (lpListStruct->lpListBuffer +
			(nLine - lpListStruct->nStartLine) *
			(lpListStruct->nLineSize + 1));
}

//---------------------------------------------------------------------------
// ItemStatus
//---------------------------------------------------------------------------
BOOL ItemStatus (HCTL hctl,
                 HWND hWnd,
                 int  nItemId) {

    DATASTRUCT  ds;
    BOOL        bRet = RESET_MASK;
    int         n, nGrayIndex, nSelectIndex;

    ds.cindex               = 1;
    ds.index[0].datatype    = DT_SHORT;

    // LOOP OVER ALL GRAY INDEXES (NON-SELECTABLE ITEMS)
    n = 0;
    while (n < ARRMAX) {

        // GET nth GRAY FILELIST ITEM
        ds.index[0].data        = n++;
        VBGetControlProperty (hctl, IPROP_FILELIST_LISTGRAY, &ds);

        if ((nGrayIndex = LOWORD (ds.data)) == nItemId) {

            bRet = GRAY_MASK;

            // FIND OUT IF ITEMID IN GRAY FILELIST IS ALSO SELECTED
            n = 0;
            while (n < ARRMAX) {

                // GET nth SELECT FILELIST ITEM
                ds.index[0].data        = n++;
                VBGetControlProperty (hctl, IPROP_FILELIST_LISTSELECT, &ds);
                if ((nSelectIndex = LOWORD (ds.data)) == nItemId) {
                    bRet |= SELECT_MASK;
                    return (bRet);
                } else if (nSelectIndex == -1)
                    return (bRet);

            }
            return (bRet);

        } else if (nGrayIndex == -1) {

            // IF GRAY LIST IS EXHAUSTED RETURN
            bRet = RESET_MASK;

            // FIND OUT IF ITEMID NOT IN GRAY LIST IS SELECTED
            n = 0;
            while (n < ARRMAX) {

                // GET nth SELECT FILELIST ITEM
                ds.index[0].data        = n++;
                VBGetControlProperty (hctl, IPROP_FILELIST_LISTSELECT, &ds);
                if ((nSelectIndex = LOWORD (ds.data)) == nItemId) {
                    bRet |= SELECT_MASK;
                    return (bRet);
                } else if (nSelectIndex == -1)
                    return (bRet);

            }
            return (bRet);

        }
    }
    return (bRet);
}

//---------------------------------------------------------------------------
// SpillItem
//---------------------------------------------------------------------------
BOOL SpillItem (HCTL  		hctl,
                HWND  		hWnd,
                LONG  		lParam,
                PFILELIST 	lpListStruct) {

    LONG         n;
    LPDATASTRUCT lpDs = (LPDATASTRUCT) lParam;
    LPSTR        lpString;
	static char  szString [LINE_SIZE + 1];

    // GET CURRENT INDEX
    n = lpDs->index [0].data;
    if (
        (n < 0)             				||
        (n > GetFileLength (lpListStruct))
       ) {

        lpDs->data = (LONG)(HSZ)NULL;
        return (381);

    } else {
        lpString   = GetListLine (LOWORD(n), lpListStruct);

        // PERFORM OUTPUT CONVERSION
        lstrcpy ((LPSTR)szString, lpString);
		lpString = OutputLine (lpString,
							   (LPSTR)szString,
							   lpListStruct,
							   LINE_SIZE);

        if (lstrlen (lpString))
        	lpDs->data = (LONG) VBCreateHsz ((_segment) hctl, lpString);
		else
        	lpDs->data = (LONG) VBCreateHsz ((_segment) hctl, (LPSTR)" ");
        return (FALSE);
    }
}


//---------------------------------------------------------------------------
// CheckItem
//---------------------------------------------------------------------------
BOOL CheckItem (HCTL             hctl,
                HWND             hWnd,
                LPDRAWITEMSTRUCT lpDis,
                PFILELIST        lpListStruct) {
    BOOL bStat;

    if (
        (lpDis->itemID != -1)             &&
        (lpDis->itemAction == ODA_SELECT)
       ) {
      	if ((bStat = ItemStatus (hctl, hWnd, lpDis->itemID)) & GRAY_MASK) {

            if (lpDis->itemState == ODS_SELECTED) {
                PostMessage (hWnd,
                             LB_SETSEL,
                             0,
                             (LONG)lpDis->itemID);
                MessageBeep (0);
                return (FALSE);
            } else if (
                     (lpDis->itemState == ODS_DISABLED) ||
                     (lpDis->itemState == 0)
                    ) {
                PostMessage (hWnd,
                             LB_SETSEL,
                             1,
                             (LONG)lpDis->itemID);
                MessageBeep (0);
                return (FALSE);
            }

        } else if (lpDis->itemState == ODS_SELECTED) {
            int nSel;

            nSel = SendMessage (hWnd,
                                LB_GETSELCOUNT,
                                NULL,
                                (LONG)NULL);
            if (nSel > lpListStruct->nMaxSelect) {
                PostMessage (hWnd,
                             LB_SETSEL,
                             0,
                             (LONG)lpDis->itemID);
                MessageBeep (0);
                return (FALSE);
            }
        }
    }
   	return (TRUE);
}

//---------------------------------------------------------------------------
// DisplayLine
//---------------------------------------------------------------------------
static LPSTR NEAR DisplayLine (	LPSTR		lpInputLine,
								LPSTR		lpOutputLine,
				                PFILELIST   lpListStruct,
				                int			nMaxLineLength) {

	static char szString [LINE_SIZE + 1];
	LPSTR		lpString;
	int			n, m;

    // INITIALIZE STRING TO ORIGINAL
	*lpOutputLine = *lpInputLine;

	for (n = 0; n < COLMAX; ++n) {

		// COPY ON TEMPORARY STRING
		lstrcpy ((LPSTR)szString, lpInputLine);

		// EXIT WHEN -1 FOUND
		if (lpListStruct->nDisplayCol [n] == -1)
			break;
		else {

			// INITIALLY RESET EVERYTHING
			if (!n)
				lstrcpy (lpOutputLine, (LPSTR)"");

			lpString = _fstrtok ((LPSTR)szString, (LPSTR)" ,\r\t\n");
			for (m = 1; m < lpListStruct->nDisplayCol [n]; ++m) {
				if (!(lpString = _fstrtok (NULL, (LPSTR)" ,\r\t\n")))
					break;
			}

			if (lpString) {
				if (n) {
					if ((lstrlen (lpOutputLine) + 1) <= nMaxLineLength)
						lstrcat (lpOutputLine, " ");
					if ((lstrlen (lpOutputLine) + lstrlen (lpString)) <= nMaxLineLength)
						lstrcat (lpOutputLine, lpString);
				} else {
					if (lstrlen (lpString) <= nMaxLineLength)
						lstrcpy (lpOutputLine, lpString);
				}
			}
		}

	}
	return (lpOutputLine);

}

//---------------------------------------------------------------------------
// OutputLine
//---------------------------------------------------------------------------
static LPSTR NEAR OutputLine (	LPSTR		lpInputLine,
								LPSTR		lpOutputLine,
				                PFILELIST   lpListStruct,
				                int			nMaxLineLength) {

	static char szString [LINE_SIZE + 1];
	LPSTR		lpString;
	int			n, m;

    // INITIALIZE STRING TO ORIGINAL
	*lpOutputLine = *lpInputLine;

	for (n = 0; n < COLMAX; ++n) {

		// COPY ON TEMPORARY STRING
		lstrcpy ((LPSTR)szString, lpInputLine);

		// EXIT WHEN -1 FOUND
		if (lpListStruct->nOutputCol [n] == -1)
			break;
		else {

			// INITIALLY RESET EVERYTHING
			if (!n)
				lstrcpy (lpOutputLine, (LPSTR)"");

			lpString = _fstrtok ((LPSTR)szString, (LPSTR)" ,\r\t\n");
			for (m = 1; m < lpListStruct->nOutputCol [n]; ++m) {
				if (!(lpString = _fstrtok (NULL, (LPSTR)" ,\r\t\n")))
					break;
			}

			if (lpString) {
				if (n) {
					if ((lstrlen (lpOutputLine) + 1) <= nMaxLineLength)
						lstrcat (lpOutputLine, " ");
					if ((lstrlen (lpOutputLine) + lstrlen (lpString)) <= nMaxLineLength)
						lstrcat (lpOutputLine, lpString);
				} else {
					if (lstrlen (lpString) <= nMaxLineLength)
						lstrcpy (lpOutputLine, lpString);
				}
			}
		}

	}
	return (lpOutputLine);

}


//---------------------------------------------------------------------------
// InputLine
//---------------------------------------------------------------------------
static LPSTR NEAR InputLine (	LPSTR		lpInputLine,
								LPSTR		lpOutputLine,
				                PFILELIST   lpListStruct,
				                int			nMaxLineLength) {

	static char szString [LINE_SIZE + 1];
	LPSTR		lpString;
	int			n, m;

    // INITIALIZE STRING TO ORIGINAL
	*lpOutputLine = *lpInputLine;

	for (n = 0; n < COLMAX; ++n) {

		// COPY ON TEMPORARY STRING
		lstrcpy ((LPSTR)szString, lpInputLine);

		// EXIT WHEN -1 FOUND
		if (lpListStruct->nInputCol [n] == -1)
			break;
		else {

			// INITIALLY RESET EVERYTHING
			if (!n)
				lstrcpy (lpOutputLine, (LPSTR)"");

			lpString = _fstrtok ((LPSTR)szString, (LPSTR)" ,\r\t\n");
			for (m = 1; m < lpListStruct->nInputCol [n]; ++m) {
				if (!(lpString = _fstrtok (NULL, (LPSTR)" ,\r\t\n")))
					break;
			}

			if (lpString) {
				if (n) {
					if ((lstrlen (lpOutputLine) + 1) <= nMaxLineLength)
						lstrcat (lpOutputLine, " ");
					if ((lstrlen (lpOutputLine) + lstrlen (lpString)) <= nMaxLineLength)
						lstrcat (lpOutputLine, lpString);
				} else {
					if (lstrlen (lpString) <= nMaxLineLength)
						lstrcpy (lpOutputLine, lpString);
				}
			}
		}

	}
	return (lpOutputLine);

}

//---------------------------------------------------------------------------
// DrawItem
//---------------------------------------------------------------------------
BOOL DrawItem (HCTL             hctl,
               HWND             hWnd,
               LPDRAWITEMSTRUCT lpDis,
               PFILELIST        lpListStruct) {

    HBRUSH  	hbr;
    LPSTR   	lpString;
    static char	szString [LINE_SIZE + 1];

    if (lpDis->itemID == -1)
        return (FALSE);

    if (lpString = GetListLine (lpDis->itemID, lpListStruct)) {

        LONG        lBackColor, lForeColor;
        int         nOldBkMode;
        COLORREF    lOldBkColor, lOldTxColor;
        HDC         hDC;
        HPEN        hPen;
        HBRUSH      hBrush;
        HFONT       hOldFont;
        BOOL        bStat;

        #define SYS_COLOR_MASK     0x80000000
        #define NOT_SYS_COLOR_MASK 0x7fffffff

        if ((bStat = ItemStatus (hctl, hWnd, lpDis->itemID)) & GRAY_MASK) {

            // GET BACKGROUND COLOR FOR GRAYED ITEM
            VBGetControlProperty (hctl, IPROP_FILELIST_BACKCOLORGRAY, &lBackColor);
            if (lBackColor & SYS_COLOR_MASK)
                lBackColor = GetSysColor (LOWORD (lBackColor & NOT_SYS_COLOR_MASK));

            // GET FOREGROUND COLOR FOR GRAYED ITEM
            VBGetControlProperty (hctl, IPROP_FILELIST_FORECOLORGRAY, &lForeColor);
            if (lForeColor & SYS_COLOR_MASK)
                lForeColor = GetSysColor (LOWORD (lForeColor & NOT_SYS_COLOR_MASK));


        } else {

            // GET BACKGROUND COLOR
            VBGetControlProperty (hctl, IPROP_FILELIST_BACKCOLOR, &lBackColor);
            if (lBackColor & SYS_COLOR_MASK)
                lBackColor = GetSysColor (LOWORD (lBackColor & NOT_SYS_COLOR_MASK));

            // GET FOREGROUND COLOR
            VBGetControlProperty (hctl, IPROP_FILELIST_FORECOLOR, &lForeColor);
            if (lForeColor & SYS_COLOR_MASK)
                lForeColor = GetSysColor (LOWORD (lForeColor & NOT_SYS_COLOR_MASK));

        }

        // SET COLOR IN CHILD WINDOW
        if (!(lpDis->itemState & ODS_SELECTED)) {

            // UNSELECTED LINES
            nOldBkMode  = SetBkMode  (lpDis->hDC, TRANSPARENT);
            lOldBkColor = SetBkColor (lpDis->hDC, lBackColor);
            lOldTxColor = SetTextColor (lpDis->hDC, lForeColor);

            if (
                (lpDis->itemAction == ODA_DRAWENTIRE) ||
                (lpDis->itemAction == ODA_SELECT)
               ) {

                if (hBrush = CreateSolidBrush (lBackColor)) {
                    FillRect (lpDis->hDC, (LPRECT)&lpDis->rcItem, hBrush);
                    DeleteObject (hBrush);
                }

                // CONVERT STRING TO SELECTED COLUMNS
                lstrcpy ((LPSTR)szString, lpString);
				lpString = DisplayLine (lpString,
										(LPSTR)szString,
										lpListStruct,
										LINE_SIZE);

             	if (lstrlen (lpString)) {

                	if (lpListStruct->hFont) {
	                    hOldFont = SelectObject (lpDis->hDC, lpListStruct->hFont);
                    	TextOut (lpDis->hDC,
                            	lpDis->rcItem.left,
                            	lpDis->rcItem.top,
                            	lpString,
                            	min (lpListStruct->nLineSize, lstrlen (lpString)));
                    	SelectObject (lpDis->hDC, hOldFont);
                	} else
	                    TextOut (lpDis->hDC,
                            	lpDis->rcItem.left,
                            	lpDis->rcItem.top,
                            	lpString,
                            	min (lpListStruct->nLineSize, lstrlen (lpString)));

				}

            } else {
                if (hPen = CreatePen (PS_DOT, 1, lForeColor)) {
                    HPEN hOldPen;

                    hOldPen = SelectObject (lpDis->hDC, hPen);
					DrawFocusRect (lpDis->hDC, (LPRECT)&lpDis->rcItem);

                    SelectObject (lpDis->hDC, hOldPen);
                    DeleteObject (hPen);
                }
            }

            SetBkMode  (lpDis->hDC,   nOldBkMode);
            SetBkColor (lpDis->hDC,   lOldBkColor);
            SetTextColor (lpDis->hDC, lOldTxColor);

        } else {

            // SELECTED LINES
            nOldBkMode  = SetBkMode  (lpDis->hDC, TRANSPARENT);
            lOldBkColor = SetBkColor (lpDis->hDC, lForeColor);
            lOldTxColor = SetTextColor (lpDis->hDC, lBackColor);

            if (
                (lpDis->itemAction == ODA_DRAWENTIRE) ||
                (lpDis->itemAction == ODA_SELECT)
               ) {
                if (hBrush = CreateSolidBrush (lForeColor)) {
                    FillRect (lpDis->hDC, (LPRECT)&lpDis->rcItem, hBrush);
                    DeleteObject (hBrush);
                }

                // CONVERT STRING TO SELECTED COLUMNS
                lstrcpy (szString, lpString);
				lpString = DisplayLine (lpString,
										szString,
										lpListStruct,
										LINE_SIZE);

				if (lstrlen (lpString)) {

	                if (lpListStruct->hFont) {
                    	hOldFont = SelectObject (lpDis->hDC, lpListStruct->hFont);
                    	TextOut (lpDis->hDC,
                             	lpDis->rcItem.left,
                             	lpDis->rcItem.top,
                             	lpString,
                             	min (lpListStruct->nLineSize, lstrlen (lpString)));
                     	SelectObject (lpDis->hDC, hOldFont);
                	} else
	                    TextOut (lpDis->hDC,
                             	lpDis->rcItem.left,
                             	lpDis->rcItem.top,
                             	lpString,
                             	min (lpListStruct->nLineSize, lstrlen (lpString)));

                }

             } else {
                if (hPen = CreatePen (PS_DOT, 1, lBackColor)) {
                    HPEN hOldPen;

                    hOldPen = SelectObject (lpDis->hDC, hPen);
                    DrawFocusRect (lpDis->hDC, (LPRECT)&lpDis->rcItem);

                    // SAVE CURRENT POSITION
                    lpListStruct->nCurrPos = lpDis->itemID;

                    SelectObject (lpDis->hDC, hOldPen);
                    DeleteObject (hPen);
                }
            }

            SetBkMode  (lpDis->hDC, nOldBkMode);
            SetBkColor (lpDis->hDC, lOldBkColor);
            SetTextColor (lpDis->hDC, lOldTxColor);

        }
        return(TRUE);
    }

    return(FALSE);
}

//---------------------------------------------------------------------------
// List control function
//---------------------------------------------------------------------------
LONG _export FileListCtlProc (	HCTL        hctl,
                          		HWND        hWnd,
                         		USHORT      msg,
                          		USHORT      wp,
                          		LONG        lp) {

    LONG        lResult;
    PFILELIST   lpListStruct = FILELISTDEREF(hctl);

    // Message pre-processing
    switch( msg ) {

        case WM_CREATE: {
            int n;

            // INITIALIZE PROPERTIES
            lpListStruct->lBackColorGray = RGB ((BYTE)0xff, (BYTE)0xff, (BYTE)0xff);
            lpListStruct->lForeColorGray = RGB ((BYTE)0, (BYTE)0, (BYTE)0);
            lpListStruct->nMaxSelect     = (LONG)ARRMAX;
            lpListStruct->hWnd           = 0;
            lpListStruct->hFileName      = (HSZ)NULL;
            lpListStruct->hVerifyText    = (HSZ)NULL;
            lpListStruct->nLineSize      = LINE_SIZE;

            lpListStruct->hListArray[0]  = (HSZ)NULL;
            for (n = 0; n < ARRMAX; ++n) {
                lpListStruct->nListGray[n]   = -1;
                lpListStruct->nListSelect[n] = -1;
            }

            for (n = 0; n < COLMAX; ++n) {
                lpListStruct->nDisplayCol[n] = -1;
                lpListStruct->nOutputCol[n] = -1;
                lpListStruct->nInputCol[n] = -1;
            }

            // INITIALIZE NON-PROPERTIES
            lpListStruct->hFont					= 0;
            lpListStruct->nStartLine			= -1;
            lpListStruct->nEndLine				= -1;
            lpListStruct->hListBuffer			= (HANDLE)NULL;
            lpListStruct->lpListBuffer			= (LPSTR)NULL;
            lpListStruct->nCurrPos				= -1;
            lpListStruct->nSearchStringLen 		= 0;
            lpListStruct->szSearchString [0]	= 0;

        }
        break;

        case VBM_GETPROPERTY:
            switch (wp) {
                case IPROP_FILELIST_LISTARRAY:
                    return (SpillItem (hctl, hWnd, lp, lpListStruct));

                case IPROP_FILELIST_LISTGRAY: {
                    SHORT n;
                    LPDATASTRUCT lpDs = (LPDATASTRUCT) lp;

                    n = lpDs->index [0].data;
                    if (
                        (n >= 0)     &&
                        (n < ARRMAX)
                       )
                        lpDs->data = (LONG)lpListStruct->nListGray [n];
                    else
                        return 381L;
                }
                break;

                case IPROP_FILELIST_DISPLAYCOL: {
                    SHORT n;
                    LPDATASTRUCT lpDs = (LPDATASTRUCT) lp;

                    n = lpDs->index [0].data;
                    if (
                        (n >= 0)     &&
                        (n < COLMAX)
                       )
                        lpDs->data = (LONG)lpListStruct->nDisplayCol [n];
                    else
                        return 381L;
                }
                break;

                case IPROP_FILELIST_OUTPUTCOL: {
                    SHORT n;
                    LPDATASTRUCT lpDs = (LPDATASTRUCT) lp;

                    n = lpDs->index [0].data;
                    if (
                        (n >= 0)     &&
                        (n < COLMAX)
                       )
                        lpDs->data = (LONG)lpListStruct->nOutputCol [n];
                    else
                        return 381L;
                }
                break;

                case IPROP_FILELIST_INPUTCOL: {
                    SHORT n;
                    LPDATASTRUCT lpDs = (LPDATASTRUCT) lp;

                    n = lpDs->index [0].data;
                    if (
                        (n >= 0)     &&
                        (n < COLMAX)
                       )
                        lpDs->data = (LONG)lpListStruct->nInputCol [n];
                    else
                        return 381L;
                }
                break;

                case IPROP_FILELIST_LISTSELECT: {
                    SHORT n;
                    LPDATASTRUCT lpDs = (LPDATASTRUCT) lp;

                    n = lpDs->index [0].data;
                    if (
                        (n >= 0)     &&
                        (n < ARRMAX)
                       )
                        lpDs->data = (LONG)lpListStruct->nListSelect [n];
                    else
                        return 381L;
                }
                break;
            }
            break;

        case VBM_SETPROPERTY:
            switch (wp) {
                case IPROP_FILELIST_FONTNAME:
                case IPROP_FILELIST_FONTSIZE:
                case IPROP_FILELIST_FONTBOLD:
                case IPROP_FILELIST_FONTITALIC:
                case IPROP_FILELIST_FONTSTRIKE:
                case IPROP_FILELIST_FONTUNDER:
                case IPROP_FILELIST_BACKCOLOR:
                case IPROP_FILELIST_FORECOLOR:
                case IPROP_FILELIST_BACKCOLORGRAY:
                case IPROP_FILELIST_FORECOLORGRAY:
                    InvalidateRect (hWnd, NULL, TRUE);
                    break;

                case IPROP_FILELIST_MAXSELECT:
                    lpListStruct->nMaxSelect = LOWORD (lp);
                    break;

                case IPROP_FILELIST_HWND:
                    lpListStruct->hWnd = LOWORD (lp);
                    break;

                case IPROP_FILELIST_LINESIZE:
                	if (LOWORD (lp) > LINE_SIZE) {
                		return (380);
                	}
                    lpListStruct->nLineSize = LOWORD (lp);
                    break;

                case IPROP_FILELIST_VERIFYTEXT:
                	if (lstrlen ((LPSTR)lp)) {
                		LPSTR lpStr;

        				if (lpStr = VerifyString ((LPSTR)lp, hWnd, lpListStruct))
	                    	lpListStruct->hVerifyText = VBCreateHsz (
                    									(_segment)hctl,
                    									lpStr);
                    	else
	                    	return (380);
	                }

					break;


                case IPROP_FILELIST_LOCATETEXT:
                	if (lstrlen ((LPSTR)lp)) {
                		LPSTR lpStr;

        				if (lpStr = LocateString ((LPSTR)lp, hWnd, lpListStruct))
	                    	lpListStruct->hLocateText = VBCreateHsz (
                    									(_segment)hctl,
                    									lpStr);
                    	else
	                    	return (380);
	                }

					break;

                case IPROP_FILELIST_FILENAME: {
                	if (lstrlen ((LPSTR)lp)) {
                		int 	n,
                				nLastLine,
                				nOffSet;
                    	LPSTR 	lpListBuffer;


        	            lpListStruct->hFileName = VBCreateHsz ((_segment)hctl,
                    									   		(LPSTR)lp);

				    	// NOW FILL LIST BOX WITH EMPTY STRINGS
        				SendMessage (	hWnd,
                        				LB_RESETCONTENT,
                         				(WORD)NULL,
                         				(LONG)NULL);

						nLastLine = GetFileLength (lpListStruct);
                    	for (n = 0; n < nLastLine; ++n)
	            			SendMessage (hWnd,
                        			 	LB_ADDSTRING,
                         			 	(WORD)NULL,
                         			 	(LONG)(LPSTR)" ");

					}
				}
                break;

                case IPROP_FILELIST_LISTGRAY: {
                    SHORT n;
                    LPDATASTRUCT lpDs = (LPDATASTRUCT) lp;

                    n = lpDs->index [0].data;
                    if (
                        (n >= 0)     &&
                        (n < ARRMAX)
                       )
                        lpListStruct->nListGray [n] = (SHORT)lpDs->data;
                    else
                        return 381L;
                }
                break;

                case IPROP_FILELIST_DISPLAYCOL: {
                    SHORT n;
                    LPDATASTRUCT lpDs = (LPDATASTRUCT) lp;

                    n = lpDs->index [0].data;
                    if (
                        (n >= 0)     &&
                        (n < COLMAX)
                       )
                        lpListStruct->nDisplayCol [n] = (SHORT)lpDs->data;
                    else
                        return 381L;
                }
                break;

                case IPROP_FILELIST_OUTPUTCOL: {
                    SHORT n;
                    LPDATASTRUCT lpDs = (LPDATASTRUCT) lp;

                    n = lpDs->index [0].data;
                    if (
                        (n >= 0)     &&
                        (n < COLMAX)
                       )
                        lpListStruct->nOutputCol [n] = (SHORT)lpDs->data;
                    else
                        return 381L;
                }
                break;

                case IPROP_FILELIST_INPUTCOL: {
                    SHORT n;
                    LPDATASTRUCT lpDs = (LPDATASTRUCT) lp;

                    n = lpDs->index [0].data;
                    if (
                        (n >= 0)     &&
                        (n < COLMAX)
                       )
                        lpListStruct->nInputCol [n] = (SHORT)lpDs->data;
                    else
                        return 381L;
                }
                break;

                case IPROP_FILELIST_LISTSELECT: {
                    SHORT n, nCount, nSel;
                    LPDATASTRUCT lpDs = (LPDATASTRUCT) lp;

                    n = lpDs->index [0].data;
                    if (
                        (n >= 0)     &&
                        (n < ARRMAX)
                       ) {

                        // SELECT ITEM IN FILELIST
                        nCount = SendMessage (hWnd,
                                              LB_GETCOUNT,
                                              NULL,
                                              (LONG)NULL);
                        nSel = SendMessage (hWnd,
                                            LB_GETSELCOUNT,
                                            NULL,
                                            (LONG)NULL);
                        if ((SHORT)lpDs->data == -1) {

                        	// REMOVE SELECTION
                            if (lpListStruct->nListSelect [n] >= 0) {
                            	int nSel;

                                SendMessage (hWnd,
                                            LB_SETSEL,
                                            0,
                                            (LONG)lpListStruct->nListSelect [n]);

                    			SendMessage (hWnd,
                                			 LB_GETSELITEMS,
                                 			 ARRMAX,
                                 			 (LONG)(LPSTR)lpListStruct->nListSelect);
                    			nSel = SendMessage (hWnd,
                                		     LB_GETSELCOUNT,
                                        	 NULL,
                                        	 (LONG)NULL);
                    			lpListStruct->nListSelect [nSel] = -1;
                    		}

                        } else if (
                            ((SHORT)lpDs->data < nCount) &&
                            (nSel < lpListStruct->nMaxSelect)
                           ) {

                           	// ADD SELECTION
                            lpListStruct->nListSelect [n] = (SHORT)lpDs->data;
                            if (lpListStruct->nListSelect [n] >= 0)
                                SendMessage (hWnd,
                                            LB_SETSEL,
                                            1,
                                            (LONG)lpListStruct->nListSelect [n]);
                        }
                    } else
                        return 381L;
                }
                break;
            }
            break;

        case VBN_COMMAND:
            switch (HIWORD (lp)) {
                case LBN_SELCHANGE: {
                    int nSel;

                    SendMessage (hWnd,
                                 LB_GETSELITEMS,
                                 ARRMAX,
                                 (
                                 LONG)(LPSTR)lpListStruct->nListSelect);
                    nSel = SendMessage (hWnd,
                                        LB_GETSELCOUNT,
                                        NULL,
                                        (LONG)NULL);
                    lpListStruct->nListSelect [nSel] = -1;
            	}
            	break;

            }
            break;

        case VBN_DRAWITEM:
             if (CheckItem (hctl,
                            hWnd,
                            (LPDRAWITEMSTRUCT) lp,
                            lpListStruct))
                DrawItem (hctl,
                          hWnd,
                          (LPDRAWITEMSTRUCT) lp,
                          lpListStruct);
            break;

        case VBN_MEASUREITEM: {

            LPMEASUREITEMSTRUCT lpMis;
            HDC                 hDC;
            TEXTMETRIC          tTextMetric;
            HFONT               hOldFont;

            lpMis    = (LPMEASUREITEMSTRUCT) lp;
            hDC      = GetDC (hWnd);

            hOldFont = SelectObject (hDC, lpListStruct->hFont);
            GetTextMetrics(hDC, &tTextMetric);
            SelectObject (hDC, hOldFont);

            ReleaseDC(hWnd, hDC);

            lpMis->itemHeight = tTextMetric.tmHeight;
        }
        break;

        case WM_SETFONT:
            lpListStruct->hFont = (HFONT)wp;
            break;

        case WM_GETFONT:
            return (lpListStruct->hFont);

        case WM_NCDESTROY: {
            int n = 0;

            while (lpListStruct->hListArray [n]) {
                VBDestroyHsz (lpListStruct->hListArray [n]);
                lpListStruct->hListArray [n] = (HSZ)NULL;
                ++n;
            }
            TeminateListBuffer (lpListStruct);
        }
        break;

        case WM_KEYUP:
            switch (wp) {
				case VK_UP:
				case VK_DOWN:
				case VK_PRIOR:
				case VK_NEXT:
				case VK_END:
				case VK_HOME:
        			lpListStruct->nSearchStringLen 		= 0;
        			lpListStruct->szSearchString [0] 	= 0;
					break;
			}
			break;

       case WM_CHAR: {

            switch (wp) {

				case VK_ESCAPE:
        			lpListStruct->nSearchStringLen	= 0;
        			lpListStruct->szSearchString [0] = 0;
        			GoToLine (0, hWnd, lpListStruct);
        			break;

        		case VK_BACK:
        			if (lpListStruct->nSearchStringLen > 1) {
	        			--lpListStruct->nSearchStringLen;
	        			lpListStruct->szSearchString
	        				[lpListStruct->nSearchStringLen] = 0;
        				FindString (lpListStruct->szSearchString,
        							hWnd,
        							lpListStruct);
	        		} else {
		        		lpListStruct->nSearchStringLen   = 0;
    	    			lpListStruct->szSearchString [0] = 0;
        				GoToLine (0, hWnd, lpListStruct);
	        		}
	        		break;

        		default:
        			if (isalnum (wp)) {
        				lpListStruct->szSearchString
        					[lpListStruct->nSearchStringLen] = wp;
        				++lpListStruct->nSearchStringLen;
        				lpListStruct->szSearchString
        					[lpListStruct->nSearchStringLen] = 0;
        				if (!FindString (lpListStruct->szSearchString,
        								 hWnd, lpListStruct)) {
        					--lpListStruct->nSearchStringLen;
        					lpListStruct->szSearchString
        						[lpListStruct->nSearchStringLen] = 0;
        				}
        			}
        	}

        }
        break;

    }
    // Default processing:
    lResult = VBDefControlProc (hctl, hWnd, msg, wp, lp);
    return lResult;
}
