#ifndef _FCC_
/*-----------------------------------------------------------------------*/
#define _FCC_

#ifdef __cplusplus
extern "C" {
#endif


#define FCC_RDONLY         (1)
#define FCC_CREATE         (2)
#define FCC_WRITE          (4)
#define FCC_WCACHE         (8)

#define FCC_SEEKSET        (1)
#define FCC_SEEKCUR        (2)
#define FCC_SEEKEND        (3)

#define FCC_ERR_OPEN       (1)
#define FCC_ERR_WRITE      (2)
#define FCC_ERR_READ       (3)
#define FCC_ERR_CLOSE      (4)
#define FCC_ERR_SEEK       (5)
#define FCC_ERR_CACCESS    (6)
#define FCC_ERR_VERSION    (7)
#define FCC_ERR_NOMEM      (8)
#define FCC_ERR_PARAM      (9)
#define FCC_ERR_CANCELED   (10)
#define FCC_ERR_UNKNOWN    (11)

#define FCC_CNONE          (-1)
#define FCC_CDEFAULT       (0)

typedef struct {
   int   whand;
   int   message;
   int   wparam;
   long  lparam;
   
   int   cancel;
   long  length;
   long  plength;
   long  curpos;
} FCC_COPYT;

int FCCAPI FCC_open(
      int   *handle,
      char  *name,
      int   flags,
      int   compress,
      int   kbytes,
      int   blksize);

int FCCAPI FCC_close(int handle);
int FCCAPI FCC_flush(int handle);
int FCCAPI FCC_seek(int handle, long pos, int where, long *newpos);
int FCCAPI FCC_read(int handle, void *buff, long bytes, long *rbytes);
int FCCAPI FCC_write(int handle, void *buff, long bytes, long *wbytes);
int FCCAPI FCC_tell(int handle, long *pos);
int FCCAPI FCC_length(int handle, long *length);
int FCCAPI FCC_plength(int handle, long *length);
int FCCAPI FCC_exists(char *name, int *version, long *length, long *plength);
int FCCAPI FCC_version(void);
int FCCAPI FCC_copy(char *src, char *dst, int blksize, int compress, FCC_COPYT *progress);

#ifdef __cplusplus
}
#endif

/*-----------------------------------------------------------------------*/
#endif
