Option Explicit

'  Data type used by FillRect
Type RECT
    Left As Integer
    Top As Integer
    Right As Integer
    Bottom As Integer
End Type

Declare Function CreateSolidBrush Lib "GDI" (ByVal crColor As Long) As Integer
Declare Function FillRect Lib "User" (ByVal hDC As Integer, lpRect As RECT, ByVal hBrush As Integer) As Integer
Declare Function DeleteObject Lib "GDI" (ByVal hObject As Integer) As Integer
Declare Function GetDeviceCaps Lib "GDI" (ByVal hDC As Integer, ByVal nIndex As Integer) As Integer

' Standard Win constants
Const BITSPIXEL = 12    '  Number of bits per pixel
Const PLANES = 14       '  Number of planes

Sub FadeForm (frmIn As Form, intGradientType As Integer)
    ' intGradientType = 0 produces diagonal gradient
    ' intGradientType = 1 produces vertical gradient
    ' intGradientType = 2 produces horizontal gradient
    ' any other value     produces solid medium-blue background
    

    Static lngColorBits As Long, intRgnCnt As Integer
    
    Dim intNbrPlanes As Integer, intBitsPixel As Integer
    Dim intHeight As Integer, intWidth As Integer, intBlueLevel As Integer
    Dim intIntervalY As Integer, intIntervalX As Integer
    Dim intTemp As Integer, intRetVal As Integer, intColorInterval As Integer
    Dim FillArea As RECT, hBrush As Integer

    ' This init code will be performed only on the first pass through this routine.
    If lngColorBits = 0 Then
        ' determine number of color bits supported.
        intBitsPixel = GetDeviceCaps(frmIn.hDC, BITSPIXEL)
        intNbrPlanes = GetDeviceCaps(frmIn.hDC, PLANES)
        lngColorBits = intBitsPixel * intNbrPlanes
        ' Calculate the number of regions that the screen will be divided into.
        ' This is optimized for the current display's color depth.  Why waste
        ' time rendering 256 shades if you can only discern 32 or 64 of them?
        If lngColorBits = 24 Then       ' 16M colors:  8 bits for blue
            intRgnCnt = 256
        ElseIf lngColorBits = 16 Then   ' 64K colors:  5 bits for blue
            intRgnCnt = 32
        ElseIf lngColorBits = 15 Then   ' 32K colors:  5 bits for blue
            intRgnCnt = 32
        ElseIf lngColorBits = 8 Then    ' 256 colors:  64 dithered blues
            intRgnCnt = 64
        ElseIf lngColorBits = 4 Then    ' 16 colors :  64 dithered blues
            intRgnCnt = 64
        Else
            lngColorBits = 4
            intRgnCnt = 64              ' 16 colors assumed: 64 dithered blues
        End If
    End If

    If intGradientType < 0 Or intGradientType > 2 Then
        frmIn.BackColor = &H7F0000 ' med blue
        Exit Sub
    End If
            
    intTemp = frmIn.ScaleMode
    frmIn.ScaleMode = 3  'Pixel
    intHeight = frmIn.ScaleHeight
    intWidth = frmIn.ScaleWidth
    frmIn.ScaleMode = intTemp
    
    intColorInterval = 256 \ intRgnCnt          ' color diff between regions
    intIntervalY = intHeight \ intRgnCnt        ' # vert pixels per region
    intIntervalX = intWidth \ intRgnCnt         ' # horz pixels per region
    
    ' fill the client area from bottom/right to top/left except for top/left region
    FillArea.Left = 0
    FillArea.Top = 0
    FillArea.Right = intWidth
    FillArea.Bottom = intHeight
    intBlueLevel = 0
    For intTemp = 1 To intRgnCnt - 1
        hBrush = CreateSolidBrush(RGB(0, 0, intBlueLevel))
        If intGradientType = 0 Then         ' diagonal gradient
            FillArea.Top = FillArea.Bottom - intIntervalY
            FillArea.Left = 0
            intRetVal = FillRect(frmIn.hDC, FillArea, hBrush)
            FillArea.Top = 0
            FillArea.Left = FillArea.Right - intIntervalX
            intRetVal = FillRect(frmIn.hDC, FillArea, hBrush)
            FillArea.Bottom = FillArea.Bottom - intIntervalY
            FillArea.Right = FillArea.Right - intIntervalX
        ElseIf intGradientType = 1 Then     ' vertical gradient
            FillArea.Top = FillArea.Bottom - intIntervalY
            intRetVal = FillRect(frmIn.hDC, FillArea, hBrush)
            FillArea.Bottom = FillArea.Bottom - intIntervalY
        Else                                ' horizontal gradient implied
            FillArea.Left = FillArea.Right - intIntervalX
            intRetVal = FillRect(frmIn.hDC, FillArea, hBrush)
            FillArea.Right = FillArea.Right - intIntervalX
        End If
        intRetVal = DeleteObject(hBrush)
        intBlueLevel = intBlueLevel + intColorInterval
    Next

    ' Fill the remaining top/left of the client area with solid blue
    FillArea.Top = 0
    FillArea.Left = 0
    hBrush = CreateSolidBrush(RGB(0, 0, 255))
    intRetVal = FillRect(frmIn.hDC, FillArea, hBrush)
    intRetVal = DeleteObject(hBrush)
    
End Sub

