VERSION 2.00
Begin Form extIcons 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Icon Extractor"
   ClientHeight    =   7380
   ClientLeft      =   1095
   ClientTop       =   1485
   ClientWidth     =   7800
   FontBold        =   0   'False
   FontItalic      =   0   'False
   FontName        =   "Fixedsys"
   FontSize        =   9
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   7785
   Icon            =   EXTICONS.FRX:0000
   Left            =   1035
   LinkTopic       =   "Form1"
   ScaleHeight     =   492
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   520
   Top             =   1140
   Width           =   7920
   Begin CheckBox SrchSubs 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Search &Subdirectories"
      Height          =   255
      Left            =   1920
      TabIndex        =   14
      Top             =   90
      Width           =   2175
   End
   Begin Frame Frame1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Frame1"
      Height          =   3855
      Left            =   120
      TabIndex        =   7
      Top             =   3360
      Width           =   5055
      Begin DirListBox Dir1 
         Height          =   2280
         Left            =   240
         TabIndex        =   10
         Top             =   1260
         Width           =   2055
      End
      Begin FileListBox File1 
         Height          =   2955
         Left            =   2640
         TabIndex        =   9
         Top             =   600
         Width           =   2175
      End
      Begin DriveListBox Drive1 
         Height          =   315
         Left            =   240
         TabIndex        =   8
         Top             =   600
         Width           =   2055
      End
      Begin Label Label5 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Drive"
         Height          =   255
         Left            =   240
         TabIndex        =   13
         Top             =   360
         Width           =   615
      End
      Begin Label Label6 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Di&rectory"
         Height          =   255
         Left            =   240
         TabIndex        =   12
         Top             =   1020
         Width           =   855
      End
      Begin Label Label7 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&File"
         Height          =   255
         Left            =   2640
         TabIndex        =   11
         Top             =   360
         Width           =   375
      End
   End
   Begin CommandButton Command2 
      Caption         =   "E&xit"
      Height          =   285
      Left            =   4560
      TabIndex        =   6
      Top             =   960
      Width           =   1095
   End
   Begin CommandButton Command1 
      Caption         =   "&Go"
      Height          =   285
      Left            =   4560
      TabIndex        =   5
      Top             =   360
      Width           =   1095
   End
   Begin TextBox txtDestDir 
      Height          =   285
      Left            =   240
      TabIndex        =   4
      Text            =   "Text2"
      Top             =   960
      Width           =   3855
   End
   Begin TextBox txtFileName 
      Height          =   285
      Left            =   240
      TabIndex        =   2
      Text            =   "Text1"
      Top             =   360
      Width           =   3855
   End
   Begin Label Label4 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Label4"
      Height          =   255
      Left            =   240
      TabIndex        =   15
      Top             =   1320
      Width           =   5415
   End
   Begin Label Label3 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Destination Directory:"
      Height          =   195
      Left            =   240
      TabIndex        =   3
      Top             =   720
      Width           =   1860
   End
   Begin Label Label2 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Caption         =   "Source &File(s):"
      Height          =   195
      Left            =   240
      TabIndex        =   0
      Top             =   120
      Width           =   1245
   End
   Begin Image Image1 
      Height          =   495
      Left            =   6360
      Top             =   720
      Width           =   495
   End
   Begin Label Label1 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   "Label1"
      Height          =   255
      Left            =   6000
      TabIndex        =   1
      Top             =   360
      Width           =   1215
   End
End
Option Explicit
DefInt A-Z

Declare Function ExtractIcon% Lib "shell" (ByVal hInst, ByVal FileName$, ByVal iIcon)
Declare Function DestroyIcon% Lib "user" (ByVal hIcon)
Declare Function DrawIcon% Lib "user" (ByVal hDC%, ByVal x%, ByVal y%, ByVal hIcon%)
Declare Function GetWindowWord% Lib "user" (ByVal hWnd, ByVal nOffset)
Declare Function GetModuleHandle% Lib "kernel" (ByVal ModuleName$)
Declare Function GlobalLock& Lib "kernel" (ByVal hGlobal)
Declare Function GlobalSize& Lib "kernel" (ByVal hGlobal)
Declare Function GlobalUnlock% Lib "kernel" (ByVal hGlobal)
Declare Function GetWindowsDirectory% Lib "kernel" (ByVal WinDirPath$, ByVal lenPath)

' requires Win 3.1 for hmemcpy
Declare Sub hmemcpy Lib "kernel" (ByVal hpDest&, ByVal hpSource&, ByVal cbCopy&)

Const GWW_HINSTANCE = -6
Const MB_ICONSTOP = 16
Const MB_YESNO = 4
Const IDYES = 6
Const MINIMIZED = 1
Const HOURGLASS = 11
Const DEFAULT = 0

Dim Drive$, Path$, Pattern$, dstDir$

Dim xIcon, yIcon

Function BaseName$ (fSrc$, fmt$)
'=========================================
Dim p%, n$

' chop off extension
p = InStr(fSrc$, ".")
If p Then
    n$ = Left$(fSrc$, p - 1)
Else
    n$ = fSrc$
End If

' chop off drive letter
p = InStr(n$, ":")
If p Then n$ = Mid$(n$, p + 1)

' chop off path
p = InStr(n$, "\")
Do While p
    n$ = Mid$(n$, p + 1)
    p = InStr(n$, "\")
Loop

' should have base file name of source
While Len(n$) + Len(fmt$) > 8
    n$ = Left(n$, Len(n$) - 1)
Wend

While Len(n$) + Len(fmt$) < 8
    n$ = n$ & "0"
Wend

BaseName$ = n$
'=========================================
End Function

Sub Command1_Click ()
'=========================================================
Dim srcFile$, nl$, msg$, Title$

srcFile$ = Trim$(txtFilename)
dstDir$ = Trim$(txtDestDir)
xIcon = 0: yIcon = 120

' make sure destination directory exists

On Error GoTo dst_Error
ChDir dstDir$   ' possible error here

ChDir App.Path
Cls

If Len(dstDir$) > 0 And Right$(dstDir$, 1) <> "\" Then
    dstDir$ = dstDir$ & "\"
End If

ParsePath

MousePointer = HOURGLASS
SearchSubdirectories 0
MousePointer = DEFAULT
MsgBox "Done!"
Exit Sub

'=========================================================
dst_Error:
nl$ = Chr$(13) & Chr$(10)

Select Case Err
    Case 76     ' path not found
        msg$ = "Create the destination directory:" & nl$
        msg$ = msg$ & dstDir$
        Title$ = "!! Error - Destination directory does not exist. !!"
        If MsgBox(msg$, MB_ICONSTOP + MB_YESNO, Title$) = IDYES Then
            MkDir dstDir$
            Resume Next
        Else
            End
        End If

    Case Else

        msg$ = "Error " & Format$(Err) & nl$ & nl$
        msg$ = msg$ & Error$ & nl$ & nl$
        msg$ = msg$ & "has occurred."
        MsgBox msg$, MB_ICONSTOP, "!! Error !!"
        End

End Select
'=========================================================
End Sub

Sub Command2_Click ()
    End
End Sub

Sub CopyIconsFromFile (i As Image, fSrc$)
'===============================================================
Dim hInst, hIcon, IconsInFile, currIcon, destFile$, dstIcon
Dim z, iName$, fmt$, IconFile$

hInst = GetWindowWord(Me.hWnd, GWW_HINSTANCE)
IconsInFile = ExtractIcon(hInst, fSrc$, -1)

If IconsInFile = 0 Then Exit Sub

' get base file name for extracted icons
fmt$ = String$(Len(Format(IconsInFile)), "0")
iName$ = BaseName$(fSrc$, fmt$)

' the image control must have a DragIcon to start
i.DragIcon = Me.Icon

currIcon = 0

Do While currIcon < IconsInFile
    IconFile$ = iName$ & Format$(currIcon + 1, fmt$) & ".ico"
    Label1 = IconFile$
    destFile$ = dstDir$ & IconFile$
    hIcon = ExtractIcon(hInst, fSrc$, currIcon)
    If xIcon + 36 > ScaleWidth Then xIcon = 0: yIcon = yIcon + 40
    If yIcon + 36 > ScaleHeight Then yIcon = 120
    Me.Line (xIcon, yIcon)-(xIcon + 40, yIcon + 40), Me.BackColor, BF
    z = DrawIcon%(hDC, xIcon + 4, yIcon + 4, hIcon)
    xIcon = xIcon + 40
    dstIcon = i.DragIcon
    vbCopyIcon hIcon, dstIcon
    i.Picture = i.DragIcon
    DoEvents
    If WindowState = MINIMIZED Then
        Caption = IconFile$
        Me.Refresh
    Else
        i.Refresh
    End If
    SavePicture i.DragIcon, destFile$
    currIcon = currIcon + 1
    z = DestroyIcon(hIcon)
Loop
'===============================================================
End Sub

Sub Form_Load ()
'=====================================================
Dim pl%, WinDir$

Frame1.Visible = False

Me.Left = (Screen.Width - Me.Width) \ 2
Me.Top = (Screen.Height - Me.Height) \ 2

WinDir$ = Space$(256)
pl = GetWindowsDirectory%(WinDir$, 256)

' set a couple of default values
txtFilename = Left(WinDir$, pl) & "\moricons.dll"
txtDestDir = "c:\icons"

Label1 = ""
Label4 = "Directory being searched"
'=====================================================
End Sub

Sub Form_Resize ()
    If WindowState <> MINIMIZED Then Caption = "Icon Extractor"
End Sub

Sub ParsePath ()
'===================================================
Dim t$, r%, lr%

txtFilename = Trim$(txtFilename)
t$ = txtFilename
If InStr(t$, ":") = 2 Then
    Drive1.Drive = Left$(t$, 1)
Else
    Drive1.Drive = Left$(CurDir$, 1)
End If

r = InStr(t$, "\")
Do Until r = 0
    lr = r
    r = InStr(lr + 1, t$, "\")
Loop

Path$ = Left$(t$, lr - 1)
If Right$(Path$, 1) = ":" Then Path$ = Path$ & "\"
Pattern$ = Mid$(t$, lr + 1)

Dir1.Path = Path$
File1.Path = Path$
File1.Pattern = Pattern$
'===================================================
End Sub

Sub SearchCurrDir ()
'==========================================================
Dim subDir$, fc, cf$, hInst

If File1.ListCount = 0 Then Exit Sub

subDir$ = Dir1.Path
Label4 = subDir$
Label4.Refresh

If Right$(subDir$, 1) <> "\" Then subDir$ = subDir$ + "\"

fc = 0
Do While fc < File1.ListCount
    If Len(File1.List(fc)) > 3 Then
        ' don't extract icons from icon files
        If UCase$(Right$(File1.List(fc), 4)) <> ".ICO" Then
            cf$ = subDir$ + File1.List(fc)
            CopyIconsFromFile Me.Image1, cf$
        End If
    End If
    fc = fc + 1
Loop
'==========================================================
End Sub

Sub SearchSubdirectories (depth)
'==========================================================
Dim sd, sdMax
sd = -1

If SrchSubs Then
    sdMax = Dir1.ListCount
Else
    sdMax = 0
End If

Do While sd < sdMax
    If sd = -1 Then
        SearchCurrDir
    Else
        Dir1.Path = Dir1.List(sd)
        File1.Path = Dir1.Path
        SearchSubdirectories depth + 1
    End If
    sd = sd + 1
    DoEvents
Loop
If depth > 0 And sd > -1 Then Dir1.Path = Dir1.List(-2)
'==========================================================
End Sub

Sub txtFileName_KeyPress (KeyAscii As Integer)
'==================================================================
'If KeyAscii = 13 Then
'    If InStr(txtFilename, "*") Or InStr(txtFilename, "?") Then
'        File1.Pattern = LTrim$(RTrim$(txtFilename))
'        fMany% = True
'    Else
'        fMany% = False
'    End If: KeyAscii = 0
'End If
'==================================================================

End Sub

Sub vbCopyIcon (hSource, hDest)
'==========================================================
' Copies the icon from *hSource to *hDest, provided the
' memory blocks at *hSource and *hDest are the same size.
' hSource and hDest are Handles to Icons
' eg. hDest   = Control.DragIcon
'     hSource = ExtractIcon(hInst, SourceFile$, nIcon)

Dim sizeSource&, sizeDest&, fpSource&, fpDest&, x, msg$

' get size of memory blocks
sizeSource& = GlobalSize&(hSource)
sizeDest& = GlobalSize&(hDest)

If sizeDest& <> sizeSource& Then
    If sizeSource& <> 288 Then  ' not a monochrome icon
        msg$ = "Source size = " & Format$(sizeSource&) & Chr$(13) & Chr$(10)
        msg$ = msg$ & "Destination size = " & Format$(sizeDest&)
        MsgBox msg$, MB_ICONSTOP, "!! In vbCopyIcon !!"
    End If
    Exit Sub
End If

' lock memory and get far pointers to Source & Destination
fpSource& = GlobalLock&(hSource)
fpDest& = GlobalLock&(hDest)

' copy Source to Destination
hmemcpy fpDest&, fpSource&, sizeSource&

' unlock memory
x = GlobalUnlock(hDest)
x = GlobalUnlock(hSource)
'==========================================================
End Sub

