VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CSymbolTable"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
'------------------------------------------------
'CSymbolTable.cls - Symbol table class used by CEval
'Written for Visual Basic 4.0
'Copyright  1995 SoftCircuits Programming
'Redistributed by Permission.
'
'SoftCircuits
'P.O. Box 16262
'Irvine, CA 92713
'CIS: 72134,263
'------------------------------------------------
Option Explicit

'Private collection to hold symbol values
Private m_Symbols As New Collection

'Add a symbol to the symbol table
'Raises run-time error if symbol already exists or if nValue is not numeric
Public Sub Add(sName As String, nValue As Variant)
    If IsSymbolDefined(sName) = False Then
        If IsNumeric(nValue) Then
            m_Symbols.Add nValue, sName
        Else
            Err.Raise vbObjectError + 10, , "Invalid symbol value"
        End If
    Else
        Err.Raise vbObjectError + 11, , "Symbol already defined"
    End If
End Sub

'Delete the specified symbol from the symbol table
'If the symbol is not defined, the call is ignored
Public Sub Delete(sName As String)
    If IsSymbolDefined(sName) Then
        m_Symbols.Remove sName
    End If
End Sub

'Indicates if the specified symbol name is currently defined
Public Function IsSymbolDefined(sName As String) As Boolean
    Dim nValue As Variant
    On Error Resume Next
    nValue = m_Symbols(sName)
    If Err Then
        IsSymbolDefined = False
    Else
        IsSymbolDefined = True
    End If
End Function

'Sets the value of the specified symbol
'Raises a run-time error if the symbol is not currently defined or
'if the value is non-numeric
Public Property Let Value(sName As String, nValue As Variant)
    If IsSymbolDefined(sName) = True Then
        If IsNumeric(nValue) Then
            Delete sName
            Add sName, nValue
        Else
            Err.Raise vbObjectError + 10, , "Invalid symbol value"
        End If
    Else
        Err.Raise vbObjectError + 12, , "Symbol not defined"
    End If
End Property

'Returns the value for the specified symbol
'Raises a run-time error if the symbol is not currently defined
Public Property Get Value(sName As String) As Variant
    If IsSymbolDefined(sName) = True Then
        Value = m_Symbols(sName)
    Else
        Err.Raise vbObjectError + 12, , "Symbol not defined"
    End If
End Property

'Returns the number of symbols in table
Public Property Get Count() As Integer
    Count = m_Symbols.Count
End Property

