'ErrorHandler .bas file
'
'this file is required inorder to provide error handling
'code to your application
'
' DO NOT REMOVE IT !!!
'
' ErrorHandler(c) Micro90 1995 UK
' tel +44 [0] 1202 667337


'Used to store process details
Global gi_m90EHresult As Integer
Global gs_m90EH_Formname As String
Global gs_m90EH_Procname As String
Global gi_m90EH_Putlog As Integer
Global gi_m90EH_LastErrNo As Integer
Global gi_m90EH_LastCounter As Integer
Global Const gi_m90EH_LastRetry = 5

'INTERNATIONALIZTIONERISUM
Global Const gs_M90EH_dateformat = "DD/MM/YYYY"
Global Const gs_M90EH_timeformat = "hh:nn ss"

'localization
Global gs_m90EH_AppPath As String

'msgbox titles
Global Const gs_m90EH_title = "ErrorHandler"
Global Const gs_m90EH_contact = "Please Report Errors to Software supplier"
Global Const gs_m90EH_application = "ErrorHandler"

Function gfi_M90ErrorHandler (ls_Formname As String, ls_Procname As String, li_Putlog As Integer) As Integer
    'this is the main error handler
    'DONT DELETE OR RENAME OR CHANGE IT...
    '
    'Micro90,+44 [0] 1202 667337
    '

    Dim ls_error As String
    Dim li_M90result As Integer
    Dim RTN As String
    Dim ls_m90_MSGtext As String

    RTN = Chr$(13)

    'get the error from the csv file
    ls_error = Error

    'put details to error.log file
    If li_Putlog Then
        gp_M90Puterrorlog ls_Formname, ls_Procname, ls_error
    End If

    'builds error message string
    ls_m90_MSGtext = "An error has occured within the code : " & RTN & RTN
    ls_m90_MSGtext = ls_m90_MSGtext & "Error No       : " & Format(Err) & RTN
    ls_m90_MSGtext = ls_m90_MSGtext & "Description  : " & ls_error & RTN & RTN
    ls_m90_MSGtext = ls_m90_MSGtext & "Form            : " & (ls_Formname) & RTN
    ls_m90_MSGtext = ls_m90_MSGtext & "Sub/Fun       : " & (ls_Procname) & RTN & RTN
    ls_m90_MSGtext = ls_m90_MSGtext & gs_m90EH_contact
 
    li_M90result = MsgBox(ls_m90_MSGtext, 50, gs_m90EH_title)
    gfi_M90ErrorHandler = li_M90result
    
    'Repeatative error Quite questioning
    'if the same error occurs more than N times give the user the chance to stop software
    If gi_m90EH_LastErrNo = Err Then
        gi_m90EH_LastCounter = gi_m90EH_LastCounter + 1
        If gi_m90EH_LastCounter = gi_m90EH_LastRetry Then

            ls_m90_MSGtext = "An error has occured within the code : " & RTN & RTN
            ls_m90_MSGtext = ls_m90_MSGtext & "Error No       : " & Format(Err) & RTN
            ls_m90_MSGtext = ls_m90_MSGtext & "Description  : " & ls_error & RTN & RTN
            ls_m90_MSGtext = ls_m90_MSGtext & "Form            : " & (ls_Formname) & RTN
            ls_m90_MSGtext = ls_m90_MSGtext & "Sub/Fun       : " & (ls_Procname) & RTN & RTN
            ls_m90_MSGtext = ls_m90_MSGtext & "Do you want to quit software ?"

            li_M90result = MsgBox(ls_m90_MSGtext, 20, gs_m90EH_title)
            Select Case li_M90result
            Case 6
               'yes quit
               gp_M90exit
            Case 7
               'no
               gi_m90EH_LastCounter = 0
               gfi_M90ErrorHandler = 4
            End Select
        End If
    Else
        gi_m90EH_LastCounter = 0
    End If

    gi_m90EH_LastErrNo = Err

    SCREEN.MousePointer = 0

End Function

Sub gp_M90exit ()
    'this sub will end your application if the user selects abort


    End


End Sub

Sub gp_M90Puterrorlog (ls_Formname As String, ls_Procname As String, ls_error As String)
    'this sub will write the error details to file in the error.log
    'if the file does not exist then it will create it.

    Dim li_freefile As Integer
    Dim ls_errorblock As String
    Dim RTN As String

    RTN = Chr$(13) & Chr$(10)

    'build error
    ls_errorblock = ""
    ls_errorblock = ls_errorblock & "----------------------------------------------------" & RTN
    ls_errorblock = ls_errorblock & "ERROR HANDLER REPORT " & RTN
    ls_errorblock = ls_errorblock & "" & RTN
    ls_errorblock = ls_errorblock & "time (" & gs_M90EH_timeformat & ")  = " & Format(Now, gs_M90EH_timeformat) & RTN
    ls_errorblock = ls_errorblock & "date(" & gs_M90EH_dateformat & ") = " & Format(Now, gs_M90EH_dateformat) & RTN
    ls_errorblock = ls_errorblock & "Application      = " & gs_m90EH_application & RTN
    ls_errorblock = ls_errorblock & "Form             = " & ls_Formname & RTN
    ls_errorblock = ls_errorblock & "Sub/Fun          = " & ls_Procname & RTN
    ls_errorblock = ls_errorblock & "" & RTN
    ls_errorblock = ls_errorblock & "Error No         = " & Format(Err) & RTN
    ls_errorblock = ls_errorblock & "Description      = " & ls_error & RTN

    'Check Path for error log
    gs_m90EH_AppPath = app.Path
    If Not Mid$(gs_m90EH_AppPath, Len(gs_m90EH_AppPath), 1) = "\" Then
           gs_m90EH_AppPath = gs_m90EH_AppPath & "\"
    End If

    'write error
    li_freefile = FreeFile
    Open gs_m90EH_AppPath & "error.log" For Append As li_freefile
        Print #li_freefile, ls_errorblock
    Close li_freefile


End Sub

