Program TPDemo2;
uses WinCrt;

Procedure DXFOpen(FileName:PChar); far; external 'TURBODXF' index 1;
Procedure DXFHeader(X1,Y1,X2,Y2:double); far; external 'TURBODXF' index 2;
Procedure DXFStartTables(NumLayers : integer); far; external 'TURBODXF' index 3;
Procedure DXFAddLayer(LayerName : PChar; LayerColor : integer); far; external 'TURBODXF' index 4;
Procedure DXFStartViewTable(NumViews:integer); far; external 'TURBODXF' index 5;
Procedure DXFAddView(ViewName: PChar;
			Height,Width,CentreX,CentreY : double);far; external 'TURBODXF' index 6;
Procedure DXFEndTables; far; external 'TURBODXF' index 7;
Procedure DXFAddText10(X1,Y1,Z1,Height,Rotate : double; Txt,LayerName : PChar); far; external 'TURBODXF'index 9;
Procedure DXFAddPoint(X1,Y1,Z1 : double; Layer : PChar); far; external 'TURBODXF' index 10;
Procedure DXFAddArc( X1,Y1,Z1,Radius,StartAngle,EndAngle : double;Layer : PChar); far; external 'TURBODXF' index 11;
Procedure DXFAddSolid( X1,Y1,Z1,
                       X2,Y2,Z2,
                       X3,Y3,Z3,
                       X4,Y4,Z4 : double;
                       Layer : PChar);far; external 'TURBODXF' index 12;

Procedure DXFAddLine(X1,Y1,Z1,X2,Y2,Z2: double;LayerName : PChar); far; external 'TURBODXF' index 13;

Procedure DXFAddPoly(Layer : PChar);far; external 'TURBODXF' index 14;

Procedure DXFAddVertex( X1, Y1, Z1, StartWidth, EndWidth : double;
                        Layer : PChar);far; external 'TURBODXF' index 15;

Procedure DXFEndPoly; far; external 'TURBODXF' index 16;

procedure DXFAdd3DFace(X1,Y1,Z1,X2,Y2,Z2,X3,Y3,Z3,X4,Y4,Z4:double;
           Layer:PChar);far; external 'TURBODXF' index 17;

Procedure DXFAddCircle(X1,Y1,Z1,Radius,Extrusion:double; LayerName:PChar); far; external 'TURBODXF' index 18;

Procedure DXFClose; far; external 'TURBODXF' index 19;

Procedure DXFAddBar(X1,Y1,Width,Height:double; Layer:PChar);far; external 'TURBODXF' index 20;

Procedure DXFAddXAxis(X1,Y1,X2:double;NumTicks:integer;Layer:PChar);far; external 'TURBODXF' index 21;

Procedure DXFAddYAxis(X1,Y1,Y2:double;NumTicks:integer;Layer:PChar);far; external 'TURBODXF' index 22;
{=========================================================================================}

var
  i : integer;
  DXFFileName : PChar;
  YVals : array[1..10] of double;
  MaxY : double;

begin
  DXFFileName := 'TPDEMO2.DXF';
  Writeln('Testing TURBODXF DLL. Creating DXF file: ',DXFFileName);

  MaxY := 0;


  DXFOpen(DXFFileName);

  DXFHeader(1,1,10,10);

  DXFStartTables(3);

  DXFADDLayer('TITLE',3);
  DXFADDLayer('BARS',7);
  DXFADDLayer('AXES',1);

  DXFStartViewTable(0);

  DXFEndTables;

  for I := 0 to 9 do
  begin
  	write('Enter the Y value for point number ',I,' ');
  	readln(YVals[I]);
        if YVals[I] > MaxY then MaxY := YVals[I];
        DXFAddBar(I,0,1,YVals[I],'BARS');   {X1=I; Y1=0; Width=1; Height = user entry}
  end;

  DXFAddXAxis(0,0,10,10,'AXES');      {Axis from 0,0 to 10,0 with 10 ticks}

  DXFAddYAxis(0,0,MaxY,10,'AXES');    {Axis from 0,0 to 0,MaxY with 10 ticks}

  DXFAddText10(2,Maxy+1,0,0.25,0,'TurboDXF Bar Chart Demo','TITLE');

  DXFClose;

  Writeln('Test Complete. DXF file closed.');
  writeln('Use Corel Draw, Micrografx Designer etc to view.');

end.

