'Ŀ
'                                                                             
'  GetDriveType for PB/DLL                                                    
'  Copyright (c) 1995 by PowerBASIC, Inc.                                     
'                                                                             
'  In Visual Basic:                                                           
'    Declare Function pbGetDriveType% Lib "DRVTYPE.DLL" (ByVal Drive%)        
'                                                                             
'  Returns:                                                                   
'    DRIVE_UNKNOWN   = 0                                                      
'    DRIVE_NOROOT    = 1                                                      
'    DRIVE_REMOVABLE = 2                                                      
'    DRIVE_FIXED     = 3                                                      
'    DRIVE_REMOTE    = 4                                                      
'    DRIVE_CDROM     = 5       ' Windows 95/NT only                           
'    DRIVE_RAMDISK   = 6       ' Windows 95/NT only                           
'                                                                             
'

$COMPILE DLL "DRVTYPE.EXE"
$INCLUDE "WINAPI.INC"

DIM lpGetDriveTypeA     AS SHARED DWORD ' address of GetDriveTypeA
DIM lpCallProc32W       AS SHARED DWORD ' address of CallProc32W
DIM lpFreeLibrary32W    AS SHARED DWORD ' address of FreeLibrary32W 3
DIM lpLoadLibraryEx32W  AS SHARED DWORD ' address of LoadLibraryEx32W
DIM lpGetProcAddress32W AS SHARED DWORD ' address of GetProcAddress32W

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

FUNCTION LibMain ( BYVAL hModule     AS INTEGER, _
                   BYVAL wDataSeg    AS WORD, _
                   BYVAL cbHeapSize  AS WORD, _
                   lpszCmdLine AS ASCIIZ ) EXPORT AS INTEGER

  DIM hInstKernel       AS WORD
  DIM hInstKernel32     AS DWORD
  DIM Text              AS ASCIIZ * 255

  hInstKernel = LoadLibrary("KERNEL")

  lpLoadLibraryEx32W =  GetProcAddress(hinstKernel, "LOADLIBRARYEX32W")
  lpGetProcAddress32W = GetProcAddress(hinstKernel, "GETPROCADDRESS32W")
  lpCallProc32W = GetProcAddress(hinstKernel, "CALLPROC32W")
  lpFreeLibrary32W = GetProcAddress(hinstKernel, "FREELIBRARY32W")

  IF ISFALSE(lpLoadLibraryEx32W) THEN   ' is WOW thunking layer present?
    EXIT FUNCTION                       ' no, exit
  END IF

  FreeLibrary hinstKernel

  '** load KERNEL32 into memory and put 32-bit handle in hInstKernel32
  CALL DWORD lpLoadLibraryEx32W BDECL ("KERNEL32", BYVAL 0???, BYVAL 0???)
  ! mov hInstKernel32[0], AX
  ! mov hInstKernel32[2], DX

  '** Get address of "GetDriveTypeA" and place into lpGetDriveTypeA
  CALL DWORD lpGetProcAddress32W BDECL (BYVAL hInstKernel32, "GetDriveTypeA")
  ! mov lpGetDriveTypeA[0], AX
  ! mov lpGetDriveTypeA[2], DX

  CALL DWORD lpFreeLibrary32W BDECL (BYVAL hInstKernel32)

END FUNCTION


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

FUNCTION pbGetDriveType(BYVAL Drive AS INTEGER) EXPORT AS INTEGER

  DIM DriveText AS ASCIIZ * 10
  DIM DrivePtr  AS DWORD

  IF lpCallProc32W > 0 THEN            ' 32-bit call

    IF Drive > 0 THEN
      DriveText = CHR$(64+Drive) + ":\"
      DrivePtr = VARPTR(DriveText)
    END IF
    CALL DWORD lpCallProc32W BDECL (BYVAL DrivePtr, BYVAL lpGetDriveTypeA, _
                                    BYVAL 1???, BYVAL 1???)
    ! mov FUNCTION, AX

  ELSE                                 ' 16-bit call

    FUNCTION = GetDriveType( Drive )

  END IF

END FUNCTION
