'This code demonstrates dragging a form without a title bar
'and also dragging a textbox using similar code.
'
'To drag the form the code first assigns global variables
'to the x and y coordinates of the cursor (in form coordinates)
'when the Sub Form_MouseDown event is triggered. Then as the
'Sub Form_MouseMove is triggered thereafter with the Left button
'down the global variables are subtracted from the cursor
'position as it relates to the screen and the result is the new
'x and y of the upper left corner of our form after we call
'SetWindowPos. In other words if the cursor form coordinates were
'say 50,50 at mousedown time, then as the cursor is moved
'thereafter 50 is subtracted from the cursor screen x and y
'say at first 500,500 so the (form is moved to 450,450. As you
'continue to move the mouse the upper left window position always will
'be moved to cursor screen x - 50, cursor screen y - 50.
'
'The text box is similar with one difference. The Text1_Keydown
'event tracks the mouse position as it relates to the textbox when
'the Control key is down. It goes into auto dragmode until the Control
'key is released. When the mouse goes down the last coordinates are
'stored in our global variables as key and mouse events are unrecognized
'during a drag. When the dragdrop event occurs thereafter, the global
'variables are subtracted from the new coordinates as they relate
'to the form, and this is the new x and y for our textbox after the
'call to MoveWindow. This can be a little confusing but lets say
'you start to drag in the upper left (0,0) corner of the textbox..
'Then when you dropped the new x and y for the textbox would be the cursor form
'position. So, if you started the drag a little inside the textbox
'the difference from that location and 0,0 are subtracted out.
'That's it.
'
'The call to GetWindowRect was just to avoid a twips to pixel conversion
'for the MoveWindow call.
'
'Contributed by Jeff Simms, 72200,3173
'COMING SOON: An enhanced version of my APIX program, look for it!


DefInt A-Z

Type POINTAPI
   X As Integer
   Y As Integer
End Type

Type RECT
  Left As Integer
  Top As Integer
  Right As Integer
  Bottom As Integer
End Type

Declare Sub GetCursorPos Lib "User" (lpPoint As POINTAPI)
Declare Sub GetWindowRect Lib "User" (ByVal hWnd As Integer, lpRect As RECT)
Declare Sub MoveWindow Lib "User" (ByVal hWnd As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal bRepaint As Integer)
Declare Sub ScreenToClient Lib "User" (ByVal hWnd As Integer, lpPoint As POINTAPI)
Declare Sub SetWindowPos Lib "User" (ByVal hWnd As Integer, ByVal hWndInsertAfter As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal cx As Integer, ByVal cy As Integer, ByVal wFlags As Integer)
Declare Function GetFocus Lib "User" () As Integer

Global Const SWP_NOSIZE = &H1
Global Const TRUE = -1
Global Const FALSE = 0
Global Const Left_Button = 1
Global CurPos As POINTAPI
Global TextBoxRect As RECT
Global MyPosX As Integer
Global MyPosY As Integer
Global TBhWnd As Integer




