' Ctl3D.Bas - Control 3D Start and End
' 94/08/11 Copyright 1994, Larry Rebich, The Bridge, Inc.
' Start by calling Ctl3D_Start
' End by calling   Ctl3D_End
' 95/03/26 Use either Ctl3D or Ctl3DV2
'--------------------------------------------------------

    Option Explicit
    DefInt A-Z
    
    Declare Function GetWindowWord Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer) As Integer
    
    Declare Function Ctl3DAutoSubclassV2 Lib "Ctl3Dv2.DLL" Alias "Ctl3DAutoSubclass" (ByVal hInst As Integer) As Integer
    Declare Function Ctl3DRegisterV2 Lib "Ctl3Dv2.DLL" Alias "Ctl3DRegister" (ByVal hInst As Integer) As Integer
    Declare Function Ctl3DUnregisterV2 Lib "Ctl3Dv2.DLL" Alias "Ctl3DUnregister" (ByVal hInst As Integer) As Integer
    Declare Function Ctl3DGetVerV2 Lib "Ctl3Dv2.DLL" Alias "Ctl3DGetVer" () As Integer

    Declare Function Ctl3DAutoSubclassV1 Lib "Ctl3D.DLL" Alias "Ctl3DAutoSubclass" (ByVal hInst As Integer) As Integer
    Declare Function Ctl3DRegisterV1 Lib "Ctl3D.DLL" Alias "Ctl3DRegister" (ByVal hInst As Integer) As Integer
    Declare Function Ctl3DUnregisterV1 Lib "Ctl3D.DLL" Alias "Ctl3DUnregister" (ByVal hInst As Integer) As Integer
    Declare Function Ctl3DGetVerV1 Lib "Ctl3D.DLL" Alias "Ctl3DGetVer" () As Integer
    
    Const GWW_HINSTANCE = (-6)

    Dim Ctl3D_Open As Integer   'set to true if open

    Global Const FileNameCtl3DV1 = "ctl3d.dll"
    Global Const FileNameCtl3DV2 = "ctl3dv2.dll"
    Dim ExistCtl3DV1 As Integer
    Dim ExistCtl3DV2 As Integer
    Global VerV1 As Integer
    Global VerV2 As Integer

Sub Ctl3D_End ()
    Rem This Sub is used to end the 3D effects
    Rem IMPORTANT: you must end 3D effects before your app ends
    If Not Ctl3D_Open Then Exit Sub 'not open, so forget it
    Dim inst, ret
    inst = GetWindowWord(Forms(0).hWnd, GWW_HINSTANCE) 'Get the Word of Frm
    If ExistCtl3DV2 Then                ' use V2
        ret = Ctl3DUnregisterV2(inst)   ' Unregister the program.
    Else
        ret = Ctl3DUnregisterV1(inst)   ' Unregister the program.
    End If
    Ctl3D_Open = False
End Sub

Sub Ctl3D_Start ()
    ' Use this to start the 3D dialogs
    If Ctl3D_Open Then Exit Sub     'already registered
    ExistCtl3DV1 = DoesCtl3DExist(FileNameCtl3DV1)
    ExistCtl3DV2 = DoesCtl3DExist(FileNameCtl3DV2)
    If ExistCtl3DV2 Or ExistCtl3DV1 Then
    Else
        Exit Sub                    'neither exists
    End If
    If Forms.Count = 0 Then
        Dim Msg As String
        Msg = "There is no loaded form.  "
        Msg = Msg & "To register your app with CTL3D "
        Msg = Msg & "there must be at least one loaded form.  "
        Msg = Msg & Chr$(13) & Chr$(13)
        Msg = Msg & "Use the Load statement to load a form, "
        Msg = Msg & "use Ctl3D_Start, then unload the form."
        MsgBox Msg, 48, "No Form Loaded"
        Exit Sub
    End If
    Dim inst, ret
    inst = GetWindowWord(Forms(0).hWnd, GWW_HINSTANCE)  'Get the Word from Frm
    If ExistCtl3DV2 Then
        ret = Ctl3DRegisterV2(inst)         ' Register program w/ Ctl3d.
        ret = Ctl3DAutoSubclassV2(inst)     ' Subclass the program.
        VerV2 = Ctl3DGetVerV2()   ' Version
    Else
        ret = Ctl3DRegisterV1(inst)           ' Register program w/ Ctl3d.
        ret = Ctl3DAutoSubclassV1(inst)       ' Subclass the program.
        VerV1 = Ctl3DGetVerV1()   ' Version
    End If
    Ctl3D_Open = True
End Sub

Function DoesCtl3DEitherExist () As Integer
' 95/03/12 Test for Both
    If DoesCtl3DExist(FileNameCtl3DV1) Or DoesCtl3DExist(FileNameCtl3DV2) Then
        DoesCtl3DEitherExist = True
    End If
End Function

Function DoesCtl3DExist (TheFile As String) As Integer
' Call this function to check for the existance of Ctl3Dv2.Dll on the user's system
    Dim Ff As String
    Dim Fd As Double
    GetFileFullNameAndDateTime TheFile, Ff, Fd
    If Ff <> "" Then
        DoesCtl3DExist = True
    End If
End Function

