#define STRICT
#define WIN31
#include <windows.h>
#include <windowsx.h>
#include "dimlib.h"
#include "cdemo.h"

HINSTANCE hInst;

void DimShowMsg(HWND hWnd, char *msg)
{
	DimWindow(hWnd);
	MessageBox(hWnd, msg, "DimLib Demo", MB_OK | MB_ICONINFORMATION);
	UnDimWindow(hWnd);
}

//	DlgProc is used by both dialog boxes.
BOOL _export CALLBACK DlgProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM)
{
	switch (msg) {
		case WM_INITDIALOG:
			{
			HWND chkHWnd = GetDlgItem(hWnd, DIMCHECK);
			if (chkHWnd)
				Button_SetCheck(chkHWnd, TRUE);
			}
			return TRUE;

		case WM_COMMAND:
			switch (wParam) {
				case TRYME:
					DimWindow(hWnd);
					DialogBox(hInst, "DIALOG2", hWnd, DlgProc);
					UnDimWindow(hWnd);
					break;

				case TRYMETOO:
					DimShowMsg(hWnd, "I knew you could do it!");
					break;

				case IDOK:
				case IDCANCEL:
					EndDialog(hWnd, 0);
					break;

				case IDYES:
					DimShowMsg(hWnd, "Thanks!");
					EndDialog(hWnd, 0);
					break;

				case IDNO:
					DimShowMsg(hWnd, "Bummer!");
					EndDialog(hWnd, 0);
					break;

				case DIMCHECK:
					EnableDim(Button_GetCheck(GetDlgItem(hWnd, DIMCHECK)));
					break;
			}
			return TRUE;
	}
	return FALSE;
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE, LPSTR, int)
{
	hInst = hInstance;

	DialogBox(hInst, "DIALOG1", 0, DlgProc);
	return 0;
}