'This file is strictly speaking not a Visual Basic form, but is contains
'Commands that should go into a Visual Basic form to properly use the
'DialogJB Dialog Box.

'This is what to use on the Main form to open the dialog box.
'The sample uses a Command Button, but clearly a menu or other device
'would work just as well.
'The sample also loads the files chosen by the Dialog Box into a
'Combo Box on the main form.  You may want to vary this depending on
'the kind of control you want and whether you are loading single or
'multiple files.

Sub cmdGetFile_Click ()
    cboFile.Clear 'This clears the Combo File

'At this point you may want to clear other containers or information
'already loaded into your program.  You may want to save the current
'file.  

    Load frmDialogJB

'You also need to draw a horizontal line called LinShadB on your Main form.
'Make this line invisible (LinShadB.Visible = False). It only appears
'When the DialogJB box is loaded to provide some shading and give a
'3D effect.

LinShadB.X1 = 0
LinShadB.X2 = frmMain.ScaleWidth
LinShadB.Y1 = ((frmDialogJB.ScaleHeight + (frmMain.ScaleHeight - frmDialogJB.ScaleHeight) / 2)) - 110
LinShadB.Y2 = ((frmDialogJB.ScaleHeight + (frmMain.ScaleHeight - frmDialogJB.ScaleHeight) / 2)) - 110
        LinShadB.Visible = True
End Sub

******************************************************************************
'The following items go in one of your MODULEx.BAS files.  They are
'called by DialogJB for shading and centering.  They are optional.
'The CenterForm routine is useful for most forms.

 
'This gives a 3D effect to most gray colored controls.
'I'm pretty sure I adpated this from Visual Basic Programmer's Journal,
'but I don't know which issue.
Sub Go3dGray (myForm As Form, myCtl As Control)
    myForm.CurrentX = myCtl.Left - 15
    myForm.CurrentY = myCtl.Top + myCtl.Height
    myForm.Line -Step(0, -(myCtl.Height + 15)), RGB(92, 92, 92)
    myForm.Line -Step(myCtl.Width + 15, 0), RGB(92, 92, 92)
    myForm.Line -Step(0, myCtl.Height + 15), RGB(255, 255, 255)
    myForm.Line -Step(-(myCtl.Width + 15), 0), RGB(255, 255, 255)

End Sub

'This gives a 3D effect to the border of any gray form. I used it on
'on the main form as well.
Sub BordGray3d (myForm As Form)
    myForm.Line (15, 15)-((myForm.ScaleWidth - 15), 15), RGB(255, 255, 255)
    myForm.Line (15, 15)-(15, (myForm.ScaleHeight - 15)), RGB(255, 255, 255)
    myForm.Line ((myForm.ScaleWidth - 15), 0)-((myForm.ScaleWidth - 15), myForm.ScaleHeight), RGB(0, 0, 0)
    myForm.Line (0, myForm.ScaleHeight - 15)-(myForm.ScaleWidth, myForm.ScaleHeight - 15), RGB(0, 0, 0)
    myForm.Line (15, (myForm.ScaleHeight - 30))-((myForm.ScaleWidth - 15), (myForm.ScaleHeight - 30)), RGB(92, 92, 92)
    myForm.Line ((myForm.ScaleWidth - 30), 15)-((myForm.ScaleWidth - 30), (myForm.ScaleHeight - 15)), RGB(92, 92, 92)
End Sub

'This is useful routine to center any form on the screen.
'I got this from Teach Yourself Visual Basic 3.0 by John Socha and
'Devra Hall.
Sub CenterForm (aForm As Form)
    Dim X, Y                    ' New top, left for the form

    X = (Screen.Width - aForm.Width) / 2
    Y = (Screen.Height - aForm.Height) / 2
    aForm.Move X, Y             ' Change location of the form
End Sub
