DefInt A-Z


Declare Sub FOpen Lib "QPRO200.DLL" (ByVal FileName$, Handle%)
Declare Sub FGet Lib "QPRO200.DLL" (ByVal Handle%, TEXT$)
Declare Sub FSeek Lib "QPRO200.DLL" (ByVal Handle%, NewLocation&)
Declare Sub FClose Lib "QPRO200.DLL" (ByVal Handle%)

Declare Function qInStr2% Lib "QPRO200.DLL" (ByVal start%, Source$, Search$)
Declare Function DosError% Lib "QPRO200.DLL" ()
Declare Function FLof& Lib "QPRO200.DLL" (ByVal Handle%)

Static Function ScanFile& (FileName$, TEXT$, start&)

   ScanFile& = -1                       'assume an error
   L = 0                                'ditto

   FOpen FileName$, Handle              'open the file for QuickPak Binary
   If DosError() Then Exit Function     'something bad must have happened
   LENGTH& = FLof&(Handle)              'now get the file's length
   If LENGTH& < 1 GoTo EXITFUNCTION     'can't search a zero-length file
   If LENGTH& < Len(TEXT$) GoTo EXITFUNCTION    'text is longer than the file
                                                'so it can't possibly be there
   BufSiz& = 4096                               '4096 evenly holds 8 sectors
   If BufSiz& > LENGTH& Then BufSiz& = LENGTH&  'don't need more than Length&
   TEMP$ = Space$(BufSiz&)                      'buffer for portions of file

   If start& < 1 Then start& = 1                'trap illegal start values
   If start& > LENGTH& GoTo EXITFUNCTION        'can't start past the end!

   LASTSEEK& = start& - 1               'start searching where they asked
   BASEADDR& = LASTSEEK&
   BYTES = 0

   Do
       BASEADDR& = BASEADDR& + BYTES    'track the start of each block

       If LENGTH& - LASTSEEK& >= BufSiz& Then
          BYTES = BufSiz&               'at least BufSiz& bytes still to do
       Else
          BYTES = LENGTH& - LASTSEEK&   'get just what remains
          TEMP$ = Space$(BYTES)         'FGet below uses LEN(Temp$) to know
       End If                           '  how many bytes are to be read

       FSeek Handle, LASTSEEK&          'seek to that part of the file
       FGet Handle, TEMP$               'read in a portion

       L = qInStr2%(1, TEMP$, TEXT$)    'search this portion of the file
      'L = QInstr%(1, Temp$, Text$)     'or use this to honor capitalization

       If L Then Exit Do                'we found it!

       If BufSiz& + LASTSEEK& < LENGTH& Then 'still more to examine
          BASEADDR& = BASEADDR& - Len(TEXT$) 'back up to avoid missing Text$
                                             ' in case it straddles a boundary
          LASTSEEK& = BASEADDR& + BYTES      'update the seek pointer
       Else
          Exit Do
       End If

   Loop                                      'go examine some more

EXITFUNCTION:
   FClose Handle                        'close the file

   If L Then
      ScanFile& = BASEADDR& + L         'assign the function output
   Else
      ScanFile& = 0                     'no match was found
   End If

   TEMP$ = ""                           'free up the memory

End Function

