'***********************************************************************
'*
'*   NAME
'*      error.bas
'*
'*   DESCRIPTION
'*      Holds error trapping routines.
'*
'*   HISTORY
'*      08-07-95 JL Created in VB 3.0.
'*
'*      Copyright (c) 1995 Graceland Research.
'*      All Rights Reserved.
'***********************************************************************

Option Explicit
DefInt A-Z

' restart codes
Global Const EW_RESTARTWINDOWS = &H42
Global Const EW_REBOOTSYSTEM = &H43

' MsgBox parameters
Global Const MB_OK = 0                 ' OK button only
Global Const MB_OKCANCEL = 1           ' OK and Cancel buttons
Global Const MB_ABORTRETRYIGNORE = 2   ' Abort, Retry, and Ignore buttons
Global Const MB_YESNOCANCEL = 3        ' Yes, No, and Cancel buttons
Global Const MB_YESNO = 4              ' Yes and No buttons
Global Const MB_RETRYCANCEL = 5        ' Retry and Cancel buttons

Global Const MB_ICONSTOP = 16          ' Critical message
Global Const MB_ICONQUESTION = 32      ' Warning query
Global Const MB_ICONEXCLAMATION = 48   ' Warning message
Global Const MB_ICONINFORMATION = 64   ' Information message

Global Const MB_APPLMODAL = 0          ' Application Modal Message Box
Global Const MB_DEFBUTTON1 = 0         ' First button is default
Global Const MB_DEFBUTTON2 = 256       ' Second button is default
Global Const MB_DEFBUTTON3 = 512       ' Third button is default
Global Const MB_SYSTEMMODAL = 4096     ' System Modal

' MsgBox return values
Global Const IDOK = 1                  ' OK button pressed
Global Const IDCANCEL = 2              ' Cancel button pressed
Global Const IDABORT = 3               ' Abort button pressed
Global Const IDRETRY = 4               ' Retry button pressed
Global Const IDIGNORE = 5              ' Ignore button pressed
Global Const IDYES = 6                 ' Yes button pressed
Global Const IDNO = 7                  ' No button pressed

Declare Function ExitWindows Lib "User" (ByVal ReturnCode, ByVal Reserved)


Sub ErrorHandler (sForm$, sFunc$, sError$, nErrNum, lErrLine&)
'***********************************************************************
'* Reports run-time errors to the user, logs them to disk
'***********************************************************************
    
    Dim sInfo$
    Dim rv
    
    ' create the output string
    sInfo$ = "Error" + Str$(nErrNum) + " in " + sForm$ + " (" + sFunc$ + ")" + CHR$(13) + CHR$(10)
    sInfo$ = sInfo$ + sError$
    
    If lErrLine& <> 0 Then
        sInfo$ = sInfo$ + " at line" + Str$(lErrLine&)
    End If
    
    sInfo$ = sInfo$ + "." + CHR$(13) + CHR$(10) + CHR$(13) + CHR$(10)
    
    ' append this data to the disk file error.log
    ErrorAppend sInfo$
    
    'sInfo$ = sInfo$ + "Press OK to reset the machine."
    
    ' tell the user
    'rv = MsgBox(sInfo$, MB_ICONSTOP, App.Title)
    
    ' reboot the machine
    'rv = ExitWindows(EW_RESTARTWINDOWS, 0)
    
    End
    
End Sub

SUB ErrorAppend(sInfo$)
'***********************************************************************
'* Appends the given string to the disk file Error.log
'***********************************************************************
    
    dim nHandle
    
    ' log it to the disk first
    nHandle = FreeFile
    
    Open App.Path + "\Error.log" For Append As #nHandle
    
    Print #1, "Date: " + Date$ + "  Time: " + Time$
    Print #1, sInfo$
    Print #1, ""
    
    Close #nHandle
    
END SUB

