/**********************************************************************
 *
 *   NAME
 *      findit.cpp
 *
 *   DESCRIPTION
 *      Given a file spec, returns all the files in the current
 *      directory that match that spec.
 *
 *   HISTORY
 *      08-26-94 JL Created, based on code I found somewhere for a
 *                  complete file finder program.
 *
 *      Copyright (c) 1994 Graceland Research.
 *      All Rights Reserved.
 *********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include <dir.h>
#include "findit.h"

#ifdef COMMENT_OUT
#define DEBUG
#endif


/*
 * fillfiles -- fills the array passed to it with files matching
 * the filespec passed from the current directory
 *
 * returns the number of files found
 *
 */

int
fillfiles(char *szFiles[], char *szFileSpec)
{
	struct ffblk    ffblk;
	int             rv = 0;
	int             nNumFiles = 0;

	if ( szFileSpec == NULL ) {
		return 0;
	}

#ifdef DEBUG
	printf("Directory listing of %s\n", szFileSpec);
#endif

	rv = findfirst(szFileSpec, &ffblk, 0);

	/* when rv goes true, it means there are no more files */
	while ( !rv ) {

		nNumFiles++;

#ifdef DEBUG
		printf("found file %d: %s\n", nNumFiles, ffblk.ff_name);
#endif

		szFiles[nNumFiles - 1] = new char[13];
		strcpy(szFiles[nNumFiles - 1], ffblk.ff_name);

		rv = findnext(&ffblk);
	}

	return nNumFiles;
}

