/**********************************************************************

	NAME
       debug.cpp

	DESCRIPTION
	   Adds and removes debugging code to basic procedures and
	   functions.

	HISTORY
	   08-08-95 JL  Created.

	   Copyright (c) 1995 Graceland Research.
	   All Rights Reserved.
**********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include <iostream.h>
#include "strs.h"
#include "findit.h"

#define true	1
#define false	0

#ifdef COMMENT_OUT
#define DEBUG
#endif

const int LINES_PER_SPIN = 100;
const int BACKSPACE = 8;

void Usage(char *szExe);
void Debug(char *szFilename, int bAdd);
void FormatNum(char *szDest, int nNum);


/*
 * main -- startup function
 *
 */

int
main (int argc, char * argv[])
{

	int     idx, jdx;
	int     nNumArgs = 0;
	int     nNumFound = 0;
	int     nNumFiles = 0;
	int		bAdd = false;
	char    szArgs[MAX_ARGS] [32];
	char    *szFiles[MAX_FILES];
	char    *szFileList[MAX_FILES];

	//clrscr();

	/*
	 * parse the command line
	 */
	if ( argc != 2 ) {

		Usage(argv[0]);

		exit(1);

	} else {

		if ( stricmp(argv[1], "-add") == 0 ) {

			bAdd = true;

		} else if ( stricmp(argv[1], "-remove") == 0 ) {

			bAdd = false;

		} else {

			Usage(argv[0]);

			exit(1);
		}
	}

	/*
	 * read the basic and form modules in the current directory
	 */

	nNumArgs = 2;
	strcpy(szArgs[0], "*.bas");
	strcpy(szArgs[1], "*.frm");

#ifdef DEBUG
	printf("num args = %d\n", nNumArgs);

	for (idx = 0; idx < nNumArgs; idx++) {

		printf("arg %d = %s\n", idx, szArgs[idx]);

	}
#endif

	/*
	 * Turn the wildcard specs into filenames
	 */

	for (idx = 0; idx < nNumArgs; idx++) {

		nNumFound = fillfiles(szFiles, szArgs[idx]);

		/*
		 * Take the files we got for each filespec, and
		 * add them to our complete list of filenames
		 */
		for (jdx = 0; jdx < nNumFound; jdx++) {
			nNumFiles++;
			szFileList[nNumFiles - 1] = new char[13];
			strcpy(szFileList[nNumFiles - 1], szFiles[jdx]);

            /* reclaim memory from the array */
			delete szFiles[jdx];
		}
	}

#ifdef DEBUG
	for (idx = 0; idx < nNumFiles; idx++) {
        printf("filename%d: %s\n", idx, szFileList[idx]);
	}
#endif

	if ( nNumFiles == 0 ) {
        cout << "No files to process.\n";

		return 0;
	}

	/*
     * Add or remove the code
	 */
	for (idx = 0; idx < nNumFiles; idx++) {

        Debug(szFileList[idx], bAdd);

		/* if there is a keypress waiting in the keyboard
		   buffer, check to see if it's the escape key */
		if ( kbhit() && getch() == 27 ) {
			exit(0);
		}
	}

	return 0;
}


/*
 * Instructions -- General usage parameters
 *
 */

void
Usage(char *szExe)
{

	char	szName[MAX_CHARS];

    // pull the filename out of the full path
    extract_file(szName, szExe);

	cout << "Usage:\n";
	cout << "   " << szName << " -add          Adds debugging code.\n";
	cout << "   " << szName << " -remove       Removes debugging code.\n";
}


/*
 * Debug -- adds or removes debug code to the specified file
 *
 */

void
Debug(char *szFilename, int bAdd)
{

	FILE    *fpIn;
	FILE    *fpOut;

	const char *szSpinner = "|/-\\";
	int     nSpincount = -1;

	char    szBuf[MAX_CHARS];
	char    szOrgBuf[MAX_CHARS];
	char    szName[MAX_CHARS];
	char    szTempname[13];
	char    szTemp[MAX_CHARS];
	char 	szLabel[10];
	char 	szNext[MAX_CHARS];
	char	*spResult;
    char    *spResult2;
	char	*spTemp;
	int     nNumlines = 0;
	int     bEntry = false;
	int		bExit = false;
	int     bSkip = false;
    int     bAddLabels = false;
    int     bLabel = false;
	int     nOffset = 0;
	int     nError = 1;
    unsigned int unLabel = 10000;
	fpos_t 	fposIn;

	cout << "processing " << szFilename << " ... ";

	/* Get a temporary filename for this directory */
	tmpnam(szTempname);

	/* open the input file */
	if ( (fpIn = fopen(szFilename, "r")) == NULL ) {
		cerr << "\nCouldn't open file (" << szFilename << ").\n";

		return;
	}

	/* open the output file */
	if ( (fpOut = fopen(szTempname, "w")) == NULL ) {
		cerr << "\nCouldn't open temporary file.\n";

		return;
	}

	/* set us at the beginning */
	fseek(fpIn, 0L, SEEK_SET);

	/* get the garbagy first line out of the way */
    /* NOTE: this may not be necessary with all compilers */
	if ( ! feof(fpIn) ) {
		fgets(szOrgBuf, MAX_CHARS - 1, fpIn);
	}

	for ( ; ! feof(fpIn) ; fgets(szOrgBuf, MAX_CHARS - 1, fpIn) ) {

		// make a copy and get rid of leading/trailing spaces
		strcpy(szBuf, szOrgBuf);
		trim(szBuf);

		/* do the little spinner */
		nNumlines++;

		if ( nNumlines % LINES_PER_SPIN == 0 ) {
			nSpincount++;

			if ( nSpincount > 3 ) {
				nSpincount = 0;
			}

			cout << (char) szSpinner[nSpincount] << (char) BACKSPACE;
		}

		// add debugging code
		if ( bAdd ) {

			// add entry code if we need to
			if ( bEntry ) {

				sprintf(szTemp, "On Local Error Goto ErrorDebug%s\n", itoa(nError, szLabel, 10) );

				fputs(szTemp, fpOut);

				bEntry = false;
			}

			// check if we hit a subroutine
			if ( stricmp(left(szTemp, szBuf, 4), "sub ") == 0 ) {

				// get the name of the routine
				spResult = strstr(szBuf + 4, "(");

				if ( *spResult ) {
					mid(szName, szBuf, 4, (int) spResult - ((int) szBuf + 4));
                	trim(szName);
				} else {
					*szName = '\0';
				}

				bEntry = true;
				bAddLabels = true;

			}

			// check if we hit a function
			if ( stricmp(left(szTemp, szBuf, 9), "function ") == 0 ) {

				// get the name of the routine
				spResult = strstr(szBuf + 9, "(");

				if ( *spResult ) {
					mid(szName, szBuf, 9, (int) spResult - ((int) szBuf + 9));
                	trim(szName);
				} else {
					*szName = '\0';
				}

				bEntry = true;
				bAddLabels = true;

			}

			// check if we hit an end sub/function
			if ( stricmp(left(szTemp, szBuf, 7), "end sub") == 0 ||
			  stricmp(left(szTemp, szBuf, 12), "end function") == 0 ) {

				// add exit code
				if ( stricmp(szTemp, "end function") == 0 ) {
					fputs("    Exit Function\n", fpOut);
				} else {
					fputs("    Exit Sub\n", fpOut);
				}

				sprintf(szTemp, "ErrorDebug%s:\n", itoa(nError++, szLabel, 10) );

				fputs(szTemp, fpOut);

				sprintf(szTemp, "    ErrorHandler \"%s\", \"%s\", Error$, Err, Erl\n\n",
				  szFilename, szName);

				fputs(szTemp, fpOut);

				bExit = true;
				bAddLabels = false;

			} else {

				bExit = false;

			}

			// check if we have and exit sub/function right before the
			// errordebug label
			if ( stricmp(left(szTemp, szBuf, 8), "exit sub") == 0 ||
			  stricmp(left(szTemp, szBuf, 13), "exit function") == 0 ) {

				if ( ! feof(fpIn) ) {

					// save the file pointer position
					fgetpos(fpIn, &fposIn);

					// get the next line
					fgets(szNext, MAX_CHARS - 1, fpIn);

					// check if it's an error label
					if ( stricmp(left(szTemp, szNext, 10), "errordebug") == 0 ) {

						// skip the next two lines
						bSkip = 1;

						continue;

					} else {

						// reset our position
						fsetpos(fpIn, &fposIn);
					}
				}
			}

			// check if we hit an existing error label
			if ( stricmp(left(szTemp, szBuf, 10), "errordebug") == 0 ) {

				// skip three lines (errordebugXX, errorhandler, blank line)
				bSkip = 3;

			}

			// look for the "on local error goto" label, and skip it
			if ( stricmp(left(szTemp, szBuf, 30), "on local error goto errordebug") == 0 ) {

				bSkip = 1;

			}

			// see if there is a colon, signifying a label, which doesn't
			// get a line number
            bLabel = false;
			spResult = strstr(szBuf, ":");

			// now check for the exceptions, like a single quote
			spResult2 = strstr(szBuf, "'");

			// if there was a comment, make sure it comes after the comment
			if ( *spResult && ( ! *spResult2 || spResult2 > spResult ) ) {
				bLabel = true;

				// if there is a space in the label, cancel it
				for (spTemp = szBuf; spTemp <= spResult; spTemp++) {
					if ( isspace(*spTemp) ) {
						bLabel = false;
						break;
                    }
                }
            }

            // check for case statements
            if ( ! bLabel ) {

				if ( stricmp(left(szTemp, szBuf, 11), "select case") == 0 ||
				  stricmp(left(szTemp, szBuf, 10), "end select") == 0 ||
				  stricmp(left(szTemp, szBuf, 5), "case ") == 0 ) {

                    bLabel = true;
                }
            }

            if ( bAddLabels && ! bLabel && ! bEntry && ! bExit && ! bSkip
              && *szBuf && *szBuf != '\'' && *szBuf != '\n' ) {

				// we have a line of code, so add a line number
				left(szTemp, szOrgBuf, 5);

				// check if there is an existing error label
				if ( *szTemp && atol(szTemp) ) {

					// skip past the label
					nOffset = 8;

				} else {

					nOffset = 0;

				}

				unLabel += 2;

				// add the label to the line of code
				sprintf(szTemp, "%s   %s", ltoa(unLabel, szLabel, 10),
				  szOrgBuf + nOffset);

				fputs(szTemp, fpOut);

			} else if ( ! bSkip ) {

				fputs (szOrgBuf, fpOut);

			} else {

				bSkip--;

			}

		// remove debugging code
		} else {

			// see if we have the end of the sub or function
			if ( bSkip ) {

				// check if we hit an end function
				if ( stricmp(left(szTemp, szBuf, 7), "end sub") == 0 ||
				  stricmp(left(szTemp, szBuf, 12), "end function") == 0 ) {

					bSkip = false;
					fputs(szOrgBuf, fpOut);

				}

			} else {

				// look for the "on local error goto" label, and skip it
				if ( stricmp(left(szTemp, szBuf, 30),
				  "on local error goto errordebug") == 0 ) {

					continue;

				}

				if ( *szBuf != '\'' && *szBuf != '\n' ) {
					// if this is a number, remove it
                    left(szTemp, szBuf, 5);

                    if ( *szTemp && atol(szTemp) ) {

                        // skip past the label
                        strcpy(szTemp, szBuf + 8);

                        fputs(szTemp, fpOut);

                    // look for the exit label
                    } else {

                        // check if we have and exit sub/function right before the
                        // errordebug label
                        if ( stricmp(left(szTemp, szBuf, 8), "exit sub") == 0 ||
                          stricmp(left(szTemp, szBuf, 13), "exit function") == 0 ) {

                            if ( ! feof(fpIn) ) {

                                // save the file pointer position
                                fgetpos(fpIn, &fposIn);

                                // get the next line
                                fgets(szNext, MAX_CHARS - 1, fpIn);

                                // check if it's an error label
                                if ( stricmp(left(szTemp, szNext, 10), "errordebug") == 0 ) {

                                    // skip until end of routine
                                    bSkip = true;

                                    continue;

                                } else {

                                    // write this line
                                    fputs(szOrgBuf, fpOut);

                                    // reset our position
                                    fsetpos(fpIn, &fposIn);
                                }
                            }

                        // start throwing away until the end of the sub or function
                        } else if ( stricmp(left(szTemp, szBuf, 10), "errordebug") == 0 ) {

							bSkip = true;

						} else {

							// just output the line
							fputs(szOrgBuf, fpOut);
						}
					}
				} else if ( ! bSkip ) {

                    fputs(szOrgBuf, fpOut);
                }
			}
		}
	}

	fclose(fpIn);
	fclose(fpOut);

	cout << "done.\n";

	/* delete the source code file */
	if ( remove(szFilename) == 0 ) {
		/* rename the temp file to be the source code file */
		rename(szTempname, szFilename);
	}

	return;
}


