Option Explicit
' MODIFIED BY   Don Blaylock 73132,1073
'               Systems Analyst,
'               Computer Associates, Inc.
'               January 8, 1995

'
'Used in FindWindow...
Declare Function GetClassName Lib "User" (ByVal hWnd As Integer, ByVal lpClassName As String, ByVal nMaxCount As Integer) As Integer
Declare Function GetWindowTextLength Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function GetWindowText Lib "user" (ByVal hWnd As Integer, ByVal lpString As String, ByVal nMaxCount As Integer) As Integer
Declare Function GetWindow Lib "user" (ByVal hWnd As Integer, ByVal wCmd As Integer) As Integer
Declare Sub SetWindowPos Lib "User" (ByVal hWnd As Integer, ByVal hWndInsertAfter As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal cx As Integer, ByVal cy As Integer, ByVal wFlags As Integer)


Global Const GW_CHILD = 5
Global Const GW_HWNDFIRST = 0
Global Const GW_HWNDLAST = 1
Global Const GW_HWNDNEXT = 2
Global Const GW_HWNDPREV = 3
Global Const GW_OWNER = 4
Declare Function SetFocusAPI Lib "User" Alias "SetFocus" (ByVal hWnd As Integer) As Integer
'
'Used in GetWinClassName...
Declare Function GetClassName Lib "User" (ByVal hWnd As Integer, ByVal lpClassName As String, ByVal nMaxCount As Integer) As Integer

Function FindWindow (strCaption As String, intParmType As Integer) As Integer
'-------------------------------------------------------------------------
'Author:        Barry Seymour, Marquette Computer Consultants

'Date:          December 29, 1992   15:53
'Global Vars:   CLASSNAME, CAPTIONTEXT (in LIB_API.BAS)
'Form Vars:
'Subs:
'Functions:
'Returns:       0 if fails; hWnd of sought window if succeeds.
'Explanation:  ----------------------------------------------------------------
'Function checks all active windows and returns the handle of the FIRST
'window containing the sought caption or classname.  It returns zero if
'there are no windows found.

' MODIFIED BY   Don Blaylock 73132,1073
'               Systems Analyst,
'               Computer Associates, Inc.
'               January 8, 1995

Dim strTest As String
Dim intTxtLen As Integer
Dim intThisHandle As Integer

    Const CAPTIONTEXT = 1
    Const CLASSNAME = 2
    
    strCaption = UCase$(strCaption) ' ensure case insensitivity
    FindWindow = 0 ' initialize return value

    '1. Traverse the list of all active windows
    DoEvents
    
    intThisHandle = GetWindow(Screen.ActiveForm.hWnd, GW_HWNDFIRST)

    Do While intThisHandle <> 0

	If intParmType = CAPTIONTEXT Then
	    intTxtLen = GetWindowTextLength(intThisHandle) 'Get the window caption length
	    If intTxtLen > 0 Then ' is it a sought window?
		strTest = Space$(intTxtLen + 2)
		intTxtLen = GetWindowText(intThisHandle, strTest, intTxtLen + 2)
		strTest = Left$(UCase$(strTest), intTxtLen)
	    End If ' if intTxtLen > 0
	ElseIf intParmType = CLASSNAME Then
	    strTest = UCase$(GetWinClassName(intThisHandle))
	End If

	If InStr(strTest, strCaption) Then ' you found the window you wanted!
	    FindWindow = intThisHandle
	    Exit Function
	End If

	' Get the next task list item in the master list.
	intThisHandle = GetWindow(intThisHandle, GW_HWNDNEXT)

	DoEvents ' Process Windows events.
    Loop

    'if you get this far, no windows were found meeting your.
    'caption criteria.  Function returns zero.

End Function

Function GetWinClassName (hWnd As Integer) As String
' MODIFIED BY   Don Blaylock 73132,1073
'               Systems Analyst,
'               Computer Associates, Inc.
'               January 8, 1995

Const MAX = 255
Dim strReturn As String
Dim intResult As Integer
Dim strResult As String

    strReturn = Space$(MAX)

    intResult = GetClassName(hWnd, strReturn, MAX)
    
    If intResult <> 0 Then
	strResult = Trim$(strReturn) ' TRIM OUT BLANKS
	strResult = Left$(strResult, Len(strResult) - 1) ' REMOVE CHR$(0) FROM END
	GetWinClassName = strResult
    End If

End Function

