VERSION 4.00
Begin VB.Form CustomersAndAddresses 
   Caption         =   "Customers And Addresses"
   ClientHeight    =   6000
   ClientLeft      =   255
   ClientTop       =   660
   ClientWidth     =   8865
   Height          =   6405
   Left            =   195
   LinkTopic       =   "Form1"
   ScaleHeight     =   6000
   ScaleWidth      =   8865
   Top             =   315
   Width           =   8985
   Begin VB.Data Data3 
      Caption         =   "Data3"
      Connect         =   "Access"
      DatabaseName    =   "VB4OO.mdb"
      Exclusive       =   0   'False
      Height          =   300
      Left            =   7920
      Options         =   0
      ReadOnly        =   -1  'True
      RecordsetType   =   1  'Dynaset
      RecordSource    =   "Phones"
      Top             =   1800
      Visible         =   0   'False
      Width           =   1140
   End
   Begin VB.CommandButton pbOK 
      Cancel          =   -1  'True
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   7800
      TabIndex        =   11
      Top             =   2280
      Width           =   975
   End
   Begin VB.CommandButton pbDeleteCustomer 
      Caption         =   "Delete"
      Height          =   375
      Left            =   7800
      TabIndex        =   10
      Top             =   1200
      Width           =   975
   End
   Begin VB.CommandButton pbUpdateCustomer 
      Caption         =   "Update"
      Height          =   375
      Left            =   7800
      TabIndex        =   9
      Top             =   720
      Width           =   975
   End
   Begin VB.CommandButton pbAddNewCustomer 
      Caption         =   "Add New"
      Height          =   375
      Left            =   7800
      TabIndex        =   8
      Top             =   240
      Width           =   975
   End
   Begin VB.Frame Frame1 
      Caption         =   "Customer Details"
      Height          =   2535
      Left            =   4440
      TabIndex        =   31
      Top             =   120
      Width           =   3255
      Begin VB.TextBox efCustomerNumber 
         Height          =   285
         Left            =   1200
         TabIndex        =   1
         Top             =   360
         Width           =   1815
      End
      Begin VB.TextBox efSex 
         Height          =   285
         Left            =   2640
         TabIndex        =   7
         Top             =   2160
         Width           =   375
      End
      Begin VB.TextBox efMaritalStatus 
         Height          =   285
         Left            =   1200
         TabIndex        =   6
         Top             =   2160
         Width           =   735
      End
      Begin VB.TextBox efDateOfBirth 
         Height          =   285
         Left            =   1200
         TabIndex        =   5
         Top             =   1800
         Width           =   1815
      End
      Begin VB.TextBox efFirstName 
         Height          =   285
         Left            =   1200
         TabIndex        =   2
         Top             =   720
         Width           =   1815
      End
      Begin VB.TextBox efLastName 
         Height          =   285
         Left            =   1200
         TabIndex        =   3
         Top             =   1080
         Width           =   1815
      End
      Begin VB.TextBox efSSN 
         Height          =   285
         Left            =   1200
         TabIndex        =   4
         Top             =   1440
         Width           =   1815
      End
      Begin VB.Label Label1 
         Caption         =   "Cust Number"
         Height          =   255
         Index           =   12
         Left            =   120
         TabIndex        =   38
         Top             =   360
         Width           =   975
      End
      Begin VB.Label Label1 
         Caption         =   "Sex"
         Height          =   255
         Index           =   11
         Left            =   2160
         TabIndex        =   37
         Top             =   2160
         Width           =   375
      End
      Begin VB.Label Label1 
         Caption         =   "Marital Status"
         Height          =   255
         Index           =   4
         Left            =   120
         TabIndex        =   36
         Top             =   2160
         Width           =   975
      End
      Begin VB.Label Label1 
         Caption         =   "Date Of Birth"
         Height          =   255
         Index           =   3
         Left            =   120
         TabIndex        =   35
         Top             =   1800
         Width           =   975
      End
      Begin VB.Label Label1 
         Caption         =   "First Name"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   34
         Top             =   720
         Width           =   975
      End
      Begin VB.Label Label1 
         Caption         =   "Last Name"
         Height          =   255
         Index           =   1
         Left            =   120
         TabIndex        =   33
         Top             =   1080
         Width           =   975
      End
      Begin VB.Label Label1 
         Caption         =   "SSN"
         Height          =   255
         Index           =   2
         Left            =   120
         TabIndex        =   32
         Top             =   1440
         Width           =   975
      End
   End
   Begin VB.Data Data2 
      Caption         =   "Data2"
      Connect         =   "Access"
      DatabaseName    =   "VB4OO.mdb"
      Exclusive       =   0   'False
      Height          =   300
      Left            =   7920
      Options         =   0
      ReadOnly        =   -1  'True
      RecordsetType   =   1  'Dynaset
      RecordSource    =   "Addresses"
      Top             =   1560
      Visible         =   0   'False
      Width           =   1140
   End
   Begin VB.Data Data1 
      Caption         =   "Data1"
      Connect         =   "Access"
      DatabaseName    =   "VB4OO.mdb"
      Exclusive       =   0   'False
      Height          =   300
      Left            =   7920
      Options         =   0
      ReadOnly        =   -1  'True
      RecordsetType   =   1  'Dynaset
      RecordSource    =   "Persons"
      Top             =   1320
      Visible         =   0   'False
      Width           =   1140
   End
   Begin TabDlg.SSTab SSTab1 
      Height          =   3135
      Left            =   120
      TabIndex        =   12
      Top             =   2760
      Width           =   8775
      _Version        =   65536
      _ExtentX        =   15478
      _ExtentY        =   5530
      _StockProps     =   15
      Caption         =   "Addresses"
      TabsPerRow      =   2
      Tab             =   0
      TabOrientation  =   0
      Tabs            =   2
      Style           =   1
      TabMaxWidth     =   0
      TabHeight       =   529
      TabCaption(0)   =   "Addresses"
      Tab(0).ControlCount=   7
      Tab(0).ControlEnabled=   -1  'True
      Tab(0).Control(0)=   "DBGrid2"
      Tab(0).Control(1)=   "Label1(13)"
      Tab(0).Control(2)=   "efFormattedAddress"
      Tab(0).Control(3)=   "Frame2"
      Tab(0).Control(4)=   "pbDeleteAddress"
      Tab(0).Control(5)=   "pbUpdateAddress"
      Tab(0).Control(6)=   "pbAddNewAddress"
      TabCaption(1)   =   "Phones"
      Tab(1).ControlCount=   7
      Tab(1).ControlEnabled=   0   'False
      Tab(1).Control(0)=   "DBGrid3"
      Tab(1).Control(1)=   "Label1(21)"
      Tab(1).Control(2)=   "efFormattedPhoneNumber"
      Tab(1).Control(3)=   "Frame3"
      Tab(1).Control(4)=   "pbDeletePhone"
      Tab(1).Control(5)=   "pbUpdatePhone"
      Tab(1).Control(6)=   "pbAddPhone"
      Begin VB.CommandButton pbAddPhone 
         Caption         =   "Add New"
         Height          =   375
         Left            =   -67320
         TabIndex        =   28
         Top             =   480
         Width           =   975
      End
      Begin VB.CommandButton pbUpdatePhone 
         Caption         =   "Update"
         Height          =   375
         Left            =   -67320
         TabIndex        =   29
         Top             =   960
         Width           =   975
      End
      Begin VB.CommandButton pbDeletePhone 
         Caption         =   "Delete"
         Height          =   375
         Left            =   -67320
         TabIndex        =   30
         Top             =   1440
         Width           =   975
      End
      Begin VB.Frame Frame3 
         Caption         =   "Address Details"
         Height          =   2655
         Left            =   -70680
         TabIndex        =   50
         Top             =   360
         Width           =   3255
         Begin VB.TextBox efUsage 
            Height          =   285
            Left            =   1200
            TabIndex        =   27
            Top             =   720
            Width           =   1815
         End
         Begin VB.TextBox efPhoneNumber 
            Height          =   285
            Left            =   1200
            TabIndex        =   26
            Top             =   360
            Width           =   1815
         End
         Begin VB.Label Label1 
            Caption         =   "Usage"
            Height          =   255
            Index           =   16
            Left            =   120
            TabIndex        =   52
            Top             =   720
            Width           =   975
         End
         Begin VB.Label Label1 
            Caption         =   "Phone Num"
            Height          =   255
            Index           =   15
            Left            =   120
            TabIndex        =   51
            Top             =   360
            Width           =   975
         End
      End
      Begin VB.CommandButton pbAddNewAddress 
         Caption         =   "Add New"
         Height          =   375
         Left            =   7680
         TabIndex        =   22
         Top             =   480
         Width           =   975
      End
      Begin VB.CommandButton pbUpdateAddress 
         Caption         =   "Update"
         Height          =   375
         Left            =   7680
         TabIndex        =   23
         Top             =   960
         Width           =   975
      End
      Begin VB.CommandButton pbDeleteAddress 
         Caption         =   "Delete"
         Height          =   375
         Left            =   7680
         TabIndex        =   24
         Top             =   1440
         Width           =   975
      End
      Begin VB.Frame Frame2 
         Caption         =   "Address Details"
         Height          =   2655
         Left            =   4320
         TabIndex        =   39
         Top             =   360
         Width           =   3255
         Begin VB.TextBox efLine1 
            Height          =   285
            Left            =   1200
            TabIndex        =   14
            Top             =   360
            Width           =   1815
         End
         Begin VB.TextBox efLine2 
            Height          =   285
            Left            =   1200
            TabIndex        =   15
            Top             =   720
            Width           =   1815
         End
         Begin VB.TextBox efLine3 
            Height          =   285
            Left            =   1200
            TabIndex        =   16
            Top             =   1080
            Width           =   1815
         End
         Begin VB.TextBox efCity 
            Height          =   285
            Left            =   1200
            TabIndex        =   17
            Top             =   1440
            Width           =   1815
         End
         Begin VB.TextBox efStateCode 
            Height          =   285
            Left            =   1200
            MaxLength       =   2
            TabIndex        =   18
            Top             =   1800
            Width           =   375
         End
         Begin VB.TextBox efZipCode 
            Height          =   285
            Left            =   1200
            MaxLength       =   5
            TabIndex        =   19
            Top             =   2160
            Width           =   735
         End
         Begin VB.TextBox efZipExtension 
            Height          =   285
            Left            =   2640
            MaxLength       =   2
            TabIndex        =   21
            Top             =   2160
            Width           =   375
         End
         Begin VB.TextBox efZipSupplement 
            Height          =   285
            Left            =   2040
            MaxLength       =   4
            TabIndex        =   20
            Top             =   2160
            Width           =   495
         End
         Begin VB.Label Label1 
            Caption         =   "Line 1"
            Height          =   255
            Index           =   5
            Left            =   120
            TabIndex        =   45
            Top             =   360
            Width           =   975
         End
         Begin VB.Label Label1 
            Caption         =   "Line 2"
            Height          =   255
            Index           =   6
            Left            =   120
            TabIndex        =   44
            Top             =   720
            Width           =   975
         End
         Begin VB.Label Label1 
            Caption         =   "Line 3"
            Height          =   255
            Index           =   7
            Left            =   120
            TabIndex        =   43
            Top             =   1080
            Width           =   975
         End
         Begin VB.Label Label1 
            Caption         =   "City"
            Height          =   255
            Index           =   10
            Left            =   120
            TabIndex        =   42
            Top             =   1440
            Width           =   975
         End
         Begin VB.Label Label1 
            Caption         =   "State"
            Height          =   255
            Index           =   8
            Left            =   120
            TabIndex        =   41
            Top             =   1800
            Width           =   975
         End
         Begin VB.Label Label1 
            Caption         =   "Zip Code"
            Height          =   255
            Index           =   9
            Left            =   120
            TabIndex        =   40
            Top             =   2160
            Width           =   975
         End
      End
      Begin VB.Label efFormattedPhoneNumber 
         BorderStyle     =   1  'Fixed Single
         ForeColor       =   &H00FF0000&
         Height          =   255
         Left            =   -74880
         TabIndex        =   54
         Top             =   2760
         Width           =   4095
      End
      Begin VB.Label Label1 
         Caption         =   "Formatted Phone"
         Height          =   255
         Index           =   21
         Left            =   -74880
         TabIndex        =   53
         Top             =   2520
         Width           =   1575
      End
      Begin MSDBGrid.DBGrid DBGrid3 
         Bindings        =   "CustDtls.frx":0000
         Height          =   1935
         Left            =   -74880
         OleObjectBlob   =   "CustDtls.frx":000E
         TabIndex        =   25
         Top             =   480
         Width           =   4095
      End
      Begin VB.Label efFormattedAddress 
         BorderStyle     =   1  'Fixed Single
         ForeColor       =   &H00FF0000&
         Height          =   975
         Left            =   120
         TabIndex        =   47
         Top             =   2040
         Width           =   4095
      End
      Begin VB.Label Label1 
         Caption         =   "Formatted Address"
         Height          =   255
         Index           =   13
         Left            =   120
         TabIndex        =   46
         Top             =   1800
         Width           =   1575
      End
      Begin MSDBGrid.DBGrid DBGrid2 
         Bindings        =   "CustDtls.frx":08E2
         Height          =   1215
         Left            =   120
         OleObjectBlob   =   "CustDtls.frx":08F0
         TabIndex        =   13
         Top             =   480
         Width           =   4095
      End
   End
   Begin VB.Label Label1 
      Caption         =   "Formatted Name"
      Height          =   255
      Index           =   14
      Left            =   120
      TabIndex        =   49
      Top             =   2160
      Width           =   1575
   End
   Begin VB.Label efFormattedName 
      BorderStyle     =   1  'Fixed Single
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   120
      TabIndex        =   48
      Top             =   2400
      Width           =   4215
   End
   Begin MSDBGrid.DBGrid DBGrid1 
      Bindings        =   "CustDtls.frx":0FF8
      Height          =   1935
      Left            =   120
      OleObjectBlob   =   "CustDtls.frx":1006
      TabIndex        =   0
      Top             =   120
      Width           =   4215
   End
End
Attribute VB_Name = "CustomersAndAddresses"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Private pvtCurrentPerson As Person
Private pvtCurrentAddress As Address
Private pvtCurrentPhone As Phone

Private Sub Data2_Reposition()
    
    On Local Error Resume Next
    Me.MousePointer = vbArrowHourglass

' map the selected Address to an Address in the
'   Person.Addresses collection
    Set pvtCurrentAddress = _
        pvtCurrentPerson _
            .Addresses _
            (CStr(Data2.RecordSet("ObjectID")))
    
    If pvtCurrentAddress Is Nothing Or Err = 3021 Then
        efLine1 = ""
        efLine2 = ""
        efLine3 = ""
        efCity = ""
        efStateCode = ""
        efZipCode = ""
        efZipSupplement = ""
        efZipExtension = ""
        efFormattedAddress = ""
        Me.MousePointer = vbArrow
        Exit Sub
    End If
    
    efLine1 = pvtCurrentAddress.Line1
    efLine2 = pvtCurrentAddress.Line2
    efLine3 = pvtCurrentAddress.Line3
    efCity = pvtCurrentAddress.City
    efStateCode = pvtCurrentAddress.StateCode
    efZipCode = pvtCurrentAddress.ZipCode
    efZipSupplement = pvtCurrentAddress.ZipSupplement
    efZipExtension = pvtCurrentAddress.ZipExtension
    efFormattedAddress = pvtCurrentAddress.FormattedAddress

    Me.MousePointer = vbArrow
End Sub

Private Sub Data3_Reposition()
    
    On Local Error Resume Next
    Me.MousePointer = vbArrowHourglass

' map the selected Phone to a Phone in the
'   Person.Phones collection
    Set pvtCurrentPhone = _
        pvtCurrentPerson _
            .Phones _
            (CStr(Data3.RecordSet("ObjectID")))
    
    If pvtCurrentPhone Is Nothing Or Err = 3021 Then
        efPhoneNumber = ""
        efUsage = ""
        efFormattedPhoneNumber = ""
        Me.MousePointer = vbArrow
        Exit Sub
    End If
    
    efPhoneNumber = pvtCurrentPhone.PhoneNumber
    efUsage = pvtCurrentPhone.Usage
    efFormattedPhoneNumber = pvtCurrentPhone.FormattedPhoneNumber

    Me.MousePointer = vbArrow

End Sub

Private Sub pbAddNewAddress_Click()
    
    Dim tempNewAddress As New Address
        
    On Local Error Resume Next

    Me.MousePointer = vbArrowHourglass

    With tempNewAddress
        .Line1 = efLine1
        .Line2 = efLine2
        .Line3 = efLine3
        .City = efCity
        .StateCode = efStateCode
        .ZipCode = efZipCode
        .ZipSupplement = efZipSupplement
        .ZipExtension = efZipExtension
    End With
            
    pvtCurrentPerson.AddAddress _
        Item:=tempNewAddress
        
    Set Data2.RecordSet = pvtCurrentPerson.Addresses.RecordSet
    Data2.RecordSet.MoveFirst
    Me.MousePointer = vbArrow

End Sub

Private Sub pbAddNewCustomer_Click()
    
    Dim tempNewPerson As New Person
        
    On Local Error Resume Next

    Me.MousePointer = vbArrowHourglass

    With tempNewPerson
        .CustomerNumber = efCustomerNumber
        .FirstName = efFirstName
        .LastName = efLastName
        .SSN = efSSN
        .Sex = efSex
        .MaritalStatus = efMaritalStatus
        .DateOfBirth = efDateOfBirth
    End With
        
    publicCompany.AddPerson _
        Item:=tempNewPerson
        
    Data2.Enabled = False
    Data3.Enabled = False

    Set Data1.RecordSet = publicCompany.Persons.RecordSet
    Data1.RecordSet.FindFirst "ObjectID = " & CStr(tempNewPerson.ObjectID)
    Me.MousePointer = vbArrow

End Sub

Private Sub pbAddPhone_Click()
    
    Dim tempNewPhone As New Phone
        
    On Local Error Resume Next

    Me.MousePointer = vbArrowHourglass

    With tempNewPhone
        .PhoneNumber = efPhoneNumber
        .Usage = efUsage
    End With
            
    pvtCurrentPerson.AddPhone _
        Item:=tempNewPhone
    
    Set Data3.RecordSet = pvtCurrentPerson.Phones.RecordSet
    Data3.RecordSet.MoveFirst
    Me.MousePointer = vbArrow

End Sub

Private Sub pbDeleteAddress_Click()
    
    On Local Error Resume Next
    
    Me.MousePointer = vbArrowHourglass
 
    Set pvtCurrentAddress = _
        pvtCurrentPerson _
            .Addresses _
            (CStr(Data2.RecordSet("ObjectID")))
           
    pvtCurrentPerson.Addresses.Remove _
        Item:=pvtCurrentAddress
        
    Set Data2.RecordSet = pvtCurrentPerson.Addresses.RecordSet
    Data2.RecordSet.MoveFirst
    Me.MousePointer = vbArrow
End Sub

Private Sub pbDeleteCustomer_Click()
    
    Dim saveObjectID As String
    
    On Local Error Resume Next
    
    Me.MousePointer = vbArrowHourglass
    
    Set pvtCurrentPerson = _
        publicCompany _
            .Persons _
            (CStr(Data1.RecordSet("ObjectID")))

    publicCompany.Persons.Remove _
        Item:=pvtCurrentPerson
        
    Set Data1.RecordSet = publicCompany.Persons.RecordSet
    Data1.RecordSet.MoveFirst
    Me.MousePointer = vbArrow

End Sub


Private Sub pbDeletePhone_Click()
    
    Dim saveObjectID As String
    
    On Local Error Resume Next
    
    Me.MousePointer = vbArrowHourglass
    saveObjectID = CStr(pvtCurrentPhone.ObjectID)

    With pvtCurrentPhone
        .PhoneNumber = efPhoneNumber
        .Usage = efUsage
    End With

    pvtCurrentPerson.Phones.Remove _
        Item:=pvtCurrentPhone
        
    Set Data3.RecordSet = pvtCurrentPerson.Phones.RecordSet
    Data3.RecordSet.MoveFirst
    Me.MousePointer = vbArrow

End Sub

Private Sub pbOK_Click()
    End
End Sub


Private Sub Data1_Reposition()
        
    On Local Error Resume Next
    
    Me.MousePointer = vbArrowHourglass
    Data2.Enabled = True
    Data3.Enabled = True
        
' set the CurrentPerson object to correspond to
'   Person selected in the DBGrid
'   Company.Persons collection
    Set pvtCurrentPerson = _
        publicCompany _
            .Persons _
            (CStr(Data1.RecordSet("ObjectID")))
    
    If pvtCurrentPerson Is Nothing Then
        Data2.Enabled = False
        Data3.Enabled = False
        Me.MousePointer = vbArrow
        Exit Sub
    End If
        
' display the person's detail information
    efCustomerNumber = pvtCurrentPerson.CustomerNumber
    efFirstName = pvtCurrentPerson.FirstName
    efLastName = pvtCurrentPerson.LastName
    efSSN = pvtCurrentPerson.SSN
    efDateOfBirth = Format$(pvtCurrentPerson.DateOfBirth, "mm/dd/yyyy")
    efMaritalStatus = pvtCurrentPerson.MaritalStatus
    efSex = pvtCurrentPerson.Sex
    efFormattedName = pvtCurrentPerson.FormattedName
    
' display details of the first Address
    pvtCurrentPerson.Addresses.RecordSet.MoveFirst
    
' reset the Person.Addresses RecordSet
'   (to bring to current the contents of the DBGrid)
    Set Data2.RecordSet = _
        pvtCurrentPerson.Addresses.RecordSet
    
' display details of the first Phone
    pvtCurrentPerson.Phones.RecordSet.MoveFirst
    
' reset the Person.Phones RecordSet
'   (to bring to current the contents of the DBGrid)
    Set Data3.RecordSet = _
        pvtCurrentPerson.Phones.RecordSet
    
    Me.MousePointer = vbArrow
End Sub

Private Sub DBGrid2_AfterInsert()

    Dim NewAddress As New Address

    Set NewAddress = _
        pvtCurrentPerson.Addresses.Add( _
            Line1:=Data2.RecordSet("Line1"), Line2:=Data2.RecordSet("Line2"), Line3:=Data2.RecordSet("Line3"), _
            City:=Data2.RecordSet("City"), StateCode:=Data2.RecordSet("StateCode"), _
            ZipCode:=Data2.RecordSet("ZipCode"), ZipSupplement:=Data2.RecordSet("ZipSupplement"), ZipExtension:=Data2.RecordSet("ZipExtension"), _
            Status:="Current", Usage:="Residence", _
            LinkTo:=pvtCurrentPerson)
End Sub

Private Sub Form_Load()
    Data2.Enabled = False
    Data3.Enabled = False
    
    Set Data1.RecordSet = _
        publicCompany.Persons.RecordSet
    
    Data1.RecordSet.MoveFirst
End Sub


Private Sub pbUpdateAddress_Click()
' update the person's detail information
    
    Dim saveObjectID As String
        
    On Local Error Resume Next

    Me.MousePointer = vbArrowHourglass
    saveObjectID = CStr(pvtCurrentAddress.ObjectID)

    With pvtCurrentAddress
        .Line1 = efLine1
        .Line2 = efLine2
        .Line3 = efLine3
        .City = efCity
        .StateCode = efStateCode
        .ZipCode = efZipCode
        .ZipSupplement = efZipSupplement
        .ZipExtension = efZipExtension
    End With

    pvtCurrentPerson.Addresses.Replace _
        Item:=pvtCurrentAddress, _
        ReplaceWith:=pvtCurrentAddress
        
    Set Data2.RecordSet = pvtCurrentPerson.Addresses.RecordSet
    Data2.RecordSet.FindFirst "ObjectID = " & saveObjectID
    Me.MousePointer = vbArrow

End Sub

Private Sub pbUpdateCustomer_Click()
' update the person's detail information
    
    Dim saveObjectID As String
        
    On Local Error Resume Next

    Me.MousePointer = vbArrowHourglass
    saveObjectID = CStr(pvtCurrentPerson.ObjectID)

    With pvtCurrentPerson
        .CustomerNumber = efCustomerNumber
        .FirstName = efFirstName
        .LastName = efLastName
        .SSN = efSSN
        .DateOfBirth = efDateOfBirth
        .MaritalStatus = efMaritalStatus
        .Sex = efSex
    End With

    publicCompany.Persons.Replace _
        Item:=CStr(pvtCurrentPerson.ObjectID), _
        ReplaceWith:=pvtCurrentPerson
        
    Set Data1.RecordSet = publicCompany.Persons.RecordSet
    Data1.RecordSet.FindFirst "ObjectID = " & saveObjectID
    Me.MousePointer = vbArrow
End Sub


Private Sub pbUpdatePhone_Click()
' update the person's Phone information
    
    Dim saveObjectID As String
        
    On Local Error Resume Next

    Me.MousePointer = vbArrowHourglass
    saveObjectID = CStr(pvtCurrentPhone.ObjectID)

    With pvtCurrentPhone
        .PhoneNumber = efPhoneNumber
        .Usage = efUsage
    End With
            
    pvtCurrentPerson.Phones.Replace _
        Item:=pvtCurrentPhone, _
        ReplaceWith:=pvtCurrentPhone
    
    Set Data3.RecordSet = pvtCurrentPerson.Phones.RecordSet
    Data3.RecordSet.MoveFirst
    Me.MousePointer = vbArrow

End Sub

