Option Explicit

Function zzByteHi (ByVal WordIn%) As Integer

  ' get high byte of word
  If WordIn < 0 Then
    zzByteHi = (WordIn + &H10000) \ &H100
  Else
    zzByteHi = WordIn \ &H100
  End If

End Function

Function zzByteLo (ByVal WordIn%) As Integer
  
  ' get low byte of word
  zzByteLo = WordIn And 255

End Function

Function zzGetDosVersion () As Integer

  ' return DOS version
  Dim nRet As Integer
  nRet = zzWordHi(GetVersion())
  zzGetDosVersion = (zzByteHi(nRet) * 100) + zzByteLo(nRet)

End Function

Function zzGetWinVersion () As Integer
  
  ' return Windows version
  Dim nRet As Integer
  nRet = zzWordLo(GetVersion())
  zzGetWinVersion = (zzByteLo(nRet) * 100) + zzByteHi(nRet)

End Function

Function zzWin95Running () As Integer
  
  ' is Win95 running
  zzWin95Running = (zzGetWinVersion() = 395)

End Function

Function zzWinNTRunning () As Integer

  ' is WinNT running
  zzWinNTRunning = (GetWinFlags() And &H4000)

End Function

Function zzWordHi (ByVal LongIn&) As Integer

  ' get high word of long
  If LongIn < 0 Then
    zzWordHi = LongIn \ &H10000 - 1
  Else
    zzWordHi = LongIn \ &H10000
  End If

End Function

Function zzWordLo (ByVal LongIn&) As Integer
  
  ' get low word of long
  If (LongIn And &HFFFF&) > &H7FFF Then
    zzWordLo = (LongIn And &HFFFF&) - &H10000
  Else
    zzWordLo = LongIn And &HFFFF&
  End If

End Function

