Option Explicit

  ' Sound: WAV play options
  Const SND_SYNC = &H0                                  ' play synchronously (foreground)
  Const SND_ASYNC = &H1                                 ' play asynchronously (background)
  Const SND_NODEFAULT = &H2                             ' if WAV not found play nothing
  Const SND_LOOP = &H8                                  ' play continuously until blank WAV file sent
  Const SND_NOSTOP = &H10                               ' don't play if another WAV file being played

Function zzWAVPlay (ByVal sWAVFile$) As Integer

 ' Description:
 '  Play WAV file synchronously

 ' Parameters:
 '  sWAVFile         WAV sound file

  ' play the WAV file
  DoEvents: zzWAVPlay = SndPlaySound(sWAVFile, SND_SYNC Or SND_NODEFAULT)

End Function

Function zzWAVPlayBackground (ByVal sWAVFile$) As Integer

 ' Description:
 '  Play WAV file asynchronously

 ' Parameters:
 '  sWAVFile         WAV sound file
 '  wFlags           Play flags

  ' play the WAV file
  zzWAVPlayBackground = SndPlaySound(sWAVFile, SND_ASYNC Or SND_LOOP)

End Function

Function zzWAVPlayLoop (ByVal sWAVFile$) As Integer

 ' Description:
 '  Play WAV file continously

 ' Parameters:
 '  sWAVFile         WAV sound file

  ' play the WAV file
  zzWAVPlayLoop = SndPlaySound(sWAVFile, SND_ASYNC Or SND_NODEFAULT Or SND_LOOP)

End Function

Function zzWAVStopLoop () As Integer
 
 ' Description:
 '  Stop a WAV file that is currently
 '  playing in a loop

  ' stop the WAV file that is looping
  zzWAVStopLoop = SndPlaySound(gsEMPTY, SND_ASYNC Or SND_NODEFAULT)

End Function

