Option Explicit

Sub zzStrArrayGet (s1 As String, asString() As String, sSeperator As String)

 ' Description:
 '  Returns string array containing information from s1.

 ' Parameters:
 '  s1                     string to parse
 '  asString               array that will contain strings
 '  sSeperator             seperator to look for

 ' Variables:
  Dim iZ                   As Integer    ' loop counter
  Dim nLowerBoundary       As Integer    ' lower boundary of array
  Dim nSepLocation         As Integer    ' seperator location
  Dim nUpperBoundary       As Integer    ' upper boundary of array

  ' get number of elements
  nLowerBoundary = LBound(asString)
  nUpperBoundary = UBound(asString)

  ' loop for each element
  For iZ = nLowerBoundary To nUpperBoundary

    ' clear field
    asString(iZ) = gsEMPTY

    ' try to find next seperator location
    nSepLocation = InStr(s1, sSeperator)

    ' if none found then
    If nSepLocation = 0 Then

      ' use hold string
      nSepLocation = Len(s1)

    ' move back one from seperator
    Else
      nSepLocation = nSepLocation - 1
    End If

    ' get into array, remove from string
    asString(iZ) = Left$(s1, nSepLocation)
    s1 = Mid$(s1, nSepLocation + 2)

  Next iZ

End Sub

Sub zzStrArraySort (sArray() As String, nLowCount As Integer, nHighCount As Integer)

 ' Description:
 '  Sorts the contents of a string array. Assumes first
 '  entry is 1.

 ' Parameters:
 '  sArray                          string array to sort
 '  nLowCount                       bottom item
 '  nHighCount                      top item

 ' Variables:
  Dim bSwapOccurred As Integer      ' swap occurred flag
  Dim nDex          As Integer      ' loop counter
  Dim sSwapArea     As String       ' area to use as swap

  ' loop until not swap occurred
  Do

    ' no swap yet
    bSwapOccurred = False

    ' if each item
    For nDex = nLowCount To nHighCount - 1

      ' if greater than next then
      If sArray(nDex) > sArray(nDex + 1) Then

        ' swap values and set flag on
        sSwapArea = sArray(nDex + 1)
        sArray(nDex + 1) = sArray(nDex)
        sArray(nDex) = sSwapArea
        bSwapOccurred = True

      End If

    Next nDex

  Loop Until bSwapOccurred = False

End Sub

Function zzStrExtract (ByVal sExtractFrom$, ByVal nItemIndex%, ByVal nItemLength%) As String

 ' Description:
 '  Extract an item from a string

 ' Parameters:
 '  sExtractFrom      string to extract from
 '  nItemIndex        item index
 '  nItemLength       length of each item
 
  zzStrExtract = RTrim$(Mid$(sExtractFrom, 1 + ((nItemIndex - 1) * nItemLength), nItemLength))

End Function

Function zzStrPadL (ByVal s1$, ByVal nLen%) As String

  ' pad a string with blanks
  zzStrPadL = Left$(Space$(nLen) & s1, nLen)

End Function

Function zzStrPadR (ByVal s1$, ByVal nLen%) As String

  ' pad a string with blanks
  zzStrPadR = Right$(Space$(nLen) & s1, nLen)

End Function

Function zzStrReplace (ByVal sString$, ByVal sReplace$, ByVal sWith$) As String

 ' Description:
 '  Replace every occurance of a specific character
 '  in a string with another character.
 
 ' Parameters:
 '  sString              string to scan
 '  sReplace             replace this character
 '  sWith                with this character

 ' Variables:
  Dim nPos As Integer    ' location of character
  
  nPos = InStr(sString, sReplace)
  Do Until nPos = 0
    Mid$(sString, nPos, 1) = sWith
    nPos = InStr(sString, sReplace)
  Loop

  zzStrReplace = sString

End Function

Function zzStrRInstr (ByVal sSearchMe$, ByVal sSearchForMe$) As Integer
 
 ' Description:
 '  Returns last location of character in string

 ' Parameters:
 '  sSearchMe            string to search
 '  sSearchForMe         string to search for
  
 ' Variables:
  Dim nPos1 As Integer   ' found in position 1
  Dim nPos2 As Integer   ' found in position 2

  ' get first location
  nPos1 = InStr(sSearchMe, sSearchForMe)
  nPos2 = nPos1

  ' loop until no more locations found
  Do While nPos2 > 0
    nPos2 = InStr(nPos1 + 1, sSearchMe, sSearchForMe)
    If nPos2 > 0 Then nPos1 = nPos2
  Loop

  ' return value to caller
  zzStrRInstr = nPos1

End Function

Function zzStrValidAlpha (ByVal KeyAscii%, ByVal bAllowSpecial%) As Integer

 ' Description:
 '   Check for valid characters

 ' Parameters:
 '  KeyAscii         ascii value
 '  bAllowSpecial    allow special characters

  ' back space
  If KeyAscii = 8 Then
    zzStrValidAlpha = KeyAscii
  
  ' special characters
  ElseIf InStr(" .{}_", Chr$(KeyAscii)) > 0 And bAllowSpecial Then
    zzStrValidAlpha = KeyAscii
  
  ' 0-9
  ElseIf KeyAscii >= 48 And KeyAscii <= 57 Then
    zzStrValidAlpha = KeyAscii
  
  ' a-z
  ElseIf KeyAscii >= 65 And KeyAscii <= 90 Then
    zzStrValidAlpha = KeyAscii

  ' A-Z
  ElseIf KeyAscii >= 97 And KeyAscii <= 122 Then
    zzStrValidAlpha = KeyAscii

  ' no good
  Else
    zzStrValidAlpha = 0
  End If
  
End Function

