Option Explicit

 ' Description:
 '  This module contains constants, declarations, and
 '  routines that deal with memory allocation and management.

 ' Constants:
  Global Const GMEM_FIXED = &H0
  Global Const GMEM_MOVEABLE = &H2
  Global Const GMEM_NOCOMPACT = &H10
  Global Const GMEM_NODISCARD = &H20
  Global Const GMEM_ZEROINIT = &H40
  Global Const GMEM_MODIFY = &H80
  Global Const GMEM_DISCARDABLE = &H100
  Global Const GMEM_NOT_BANKED = &H1000
  Global Const GMEM_LOWER = GMEM_NOT_BANKED
  Global Const GMEM_SHARE = &H2000
  Global Const GMEM_DDESHARE = &H2000
  Global Const GMEM_NOTIFY = &H4000
  Global Const GMEM_DISCARDED = &H4000
  Global Const GMEM_LOCKCOUNT = &HFF
  Global Const GMEM_HANDLE = (GMEM_MOVEABLE Or GMEM_ZEROINIT)
  Global Const GMEM_POINTER = (GMEM_FIXED Or GMEM_ZEROINIT)

Sub zzMemBlockFree (ByVal nMemoryHandle%)

 ' Description:
 '  Frees a block of memory

 ' Parameters:
 '  nMemoryHandle       memory handle assigned

 ' Varaibles:
  Dim nRC               As Integer

  ' unlock and free memory
  nRC = GlobalUnlock(nMemoryHandle)
  nRC = GlobalFree(nMemoryHandle)

End Sub

Sub zzMemBlockGet (ByVal nBytes%, nMemoryHandle%, lMemoryAddress&)

 ' Description:
 '  Allocates a block of memory

 ' Parameters:
 ' Input:
 '  nBytes              number of bytes to allocate
 ' Output:
 '  nMemoryHandle       memory handle assigned
 '  lMemoryAddress      memory address assigned

  ' get memory handle
  nMemoryHandle = GlobalAlloc(GMEM_POINTER, nBytes)

  ' get address of memory
  lMemoryAddress = GlobalLock(nMemoryHandle)

End Sub

