Option Explicit

Sub zzFormExplode (frm As Form, ByVal nSteps%)

 ' Description:
 '  "Explodes" a form by drawing successively larger versions
 '  of the form. The utlimate size and location is determined
 '  by the parameters passed in.

 ' Parameters:
 '  frm               form
 '  nSteps            number of steps to use
 '  lBackColor        color to use

 ' Variables:
  Dim nI           As Integer ' loop counter
  Dim nFrmHeight   As Integer ' temporary form height
  Dim nFrmLeft     As Integer ' temporary form left
  Dim nFrmTop      As Integer ' temporary form top
  Dim nFrmWidth    As Integer ' temporary form width
  Dim nRC          As Integer ' return code
  Dim nLeft        As Integer
  Dim nTop         As Integer
  Dim nWidth       As Integer
  Dim nHeight      As Integer
  Dim r1           As RECT
  
  ' get form size
  GetWindowRect frm.hWnd, r1
  nLeft = r1.Left
  nTop = r1.Top
  nWidth = r1.Right - r1.Left
  nHeight = r1.Bottom - r1.Top

  ' calculate initial settings
  nFrmWidth = nWidth * (1 / nSteps)
  nFrmHeight = nHeight * (1 / nSteps)
  nFrmLeft = nLeft + (nWidth - nFrmWidth) \ 2
  nFrmTop = nTop + (nHeight - nFrmHeight) \ 2

  ' move form and show
  Call MoveWindow(frm.hWnd, nFrmLeft, nFrmTop, nFrmWidth, nFrmHeight, True)
  nRC = ShowWindow(frm.hWnd, 5)

  ' draw form successively larger
  For nI = 2 To nSteps
    
    ' calculate next settings
    nFrmWidth = nWidth * (nI / nSteps)
    nFrmHeight = nHeight * (nI / nSteps)
    nFrmLeft = nLeft + (nWidth - nFrmWidth) \ 2
    nFrmTop = nTop + (nHeight - nFrmHeight) \ 2

    ' move form
    Call MoveWindow(frm.hWnd, nFrmLeft, nFrmTop, nFrmWidth, nFrmHeight, True)

  Next nI

  ' position at final location
  Call MoveWindow(frm.hWnd, nLeft, nTop, nWidth, nHeight, True)

End Sub

Sub zzFormExplodeFromPoint (frm As Form, ByVal nSteps%, ByVal nStartLeft%, ByVal nStartTop%, ByVal nStartWidth%, ByVal nStartHeight%)
      
 ' Description:
 '  "Explodes" a form by drawing successively larger versions
 '  of the form. This procedure starts with a specific location
 '  and size and builds from there. The utlimate size and
 '  location is determined by the parameters passed in.

 ' Parameters:
 '  frm                       form reference
 '  nSteps                    number of expansion steps
 '  nStartLeft                initial left location
 '  nStartTop                 initial top location
 '  nStartWidth               initial width
 '  nStartHeight              initial height

 ' Variables:
  Dim nEndLeft     As Integer ' final left location
  Dim nEndTop      As Integer ' final top location
  Dim nEndWidth    As Integer ' final width
  Dim nEndHeight   As Integer ' final height
  
  Dim nI           As Integer ' loop counter
  
  Dim nFrmHeight   As Integer ' temporary form height
  Dim nFrmLeft     As Integer ' temporary form left
  Dim nFrmTop      As Integer ' temporary form top
  Dim nFrmWidth    As Integer ' temporary form width
  
  Dim nHeightD     As Integer ' form reduction factors
  Dim nLeftD       As Integer
  Dim nTopD        As Integer
  Dim nWidthD      As Integer

  Dim nRC          As Integer ' return code
  
  Dim r1           As RECT
  
  ' get form size
  GetWindowRect frm.hWnd, r1
  nEndLeft = r1.Left
  nEndTop = r1.Top
  nEndWidth = r1.Right - r1.Left
  nEndHeight = r1.Bottom - r1.Top

  ' convert starting point to pixels
  nStartLeft = zzTwipsToPixelsX(nStartLeft)
  nStartTop = zzTwipsToPixelsY(nStartTop)
  nStartWidth = zzTwipsToPixelsX(nStartWidth)
  nStartHeight = zzTwipsToPixelsY(nStartHeight)
  
  ' calculate differences
  nLeftD = (nEndLeft - nStartLeft) \ nSteps
  nTopD = (nEndTop - nStartTop) \ nSteps
  nWidthD = (nEndWidth - nStartWidth) \ nSteps
  nHeightD = (nEndHeight - nStartHeight) \ nSteps

  ' calculate initial settings
  nFrmWidth = nStartWidth
  nFrmHeight = nStartHeight
  nFrmLeft = nStartLeft
  nFrmTop = nStartTop

  ' move form and show
  Call MoveWindow(frm.hWnd, nFrmLeft, nFrmTop, nFrmWidth, nFrmHeight, True)
  nRC = ShowWindow(frm.hWnd, 5)
  
  ' draw form successively larger
  For nI = 2 To nSteps
    
    ' calculate initial settings
    nFrmWidth = nFrmWidth + nWidthD
    nFrmHeight = nFrmHeight + nHeightD
    nFrmLeft = nFrmLeft + nLeftD
    nFrmTop = nFrmTop + nTopD

    ' move form and show
    Call MoveWindow(frm.hWnd, nFrmLeft, nFrmTop, nFrmWidth, nFrmHeight, True)
 
  Next nI

  ' position at final location
  Call MoveWindow(frm.hWnd, nEndLeft, nEndTop, nEndWidth, nEndHeight, True)

End Sub

Sub zzFormImplode (frm As Form, ByVal nSteps%, ByVal nLeft%, ByVal nTop%, ByVal nWidth%, ByVal nHeight%)

 ' Description:
 '  "Implodes" a form by drawing successively smaller versions
 '  of the form. The ultimate size and location are determined
 '  by the parameters passed in.

 ' Parameters:
 '  frm                       form
 '  nSteps                    number of steps
 '  nLeft                     final left location
 '  nTop                      final top location
 '  nWidth                    final width
 '  nHeight                   final height

 ' Variables:
  Dim nI           As Integer ' loop counter
  Dim nFrmHeight   As Integer ' temporary form height
  Dim nFrmLeft     As Integer ' temporary form left
  Dim nFrmTop      As Integer ' temporary form top
  Dim nFrmWidth    As Integer ' temporary form width
  
  Dim nHeightD     As Integer ' form reduction factors
  Dim nLeftD       As Integer
  Dim nTopD        As Integer
  Dim nWidthD      As Integer

  Dim nRC          As Integer ' return code

  Dim r1           As RECT    ' rectangle
  
  ' handle errors
  On Error Resume Next
  
  ' get form size
  GetWindowRect frm.hWnd, r1
  nFrmLeft = r1.Left
  nFrmTop = r1.Top
  nFrmWidth = r1.Right - r1.Left
  nFrmHeight = r1.Bottom - r1.Top
  
  ' show the form
  nRC = ShowWindow(frm.hWnd, 5)

  ' convert starting point to pixels
  nLeft = zzTwipsToPixelsX(nLeft)
  nTop = zzTwipsToPixelsY(nTop)
  nWidth = zzTwipsToPixelsX(nWidth)
  nHeight = zzTwipsToPixelsY(nHeight)
  
  ' calculate differences
  nLeftD = (nFrmLeft - nLeft) \ nSteps
  nTopD = (nFrmTop - nTop) \ nSteps
  nWidthD = (nFrmWidth - nWidth) \ nSteps
  nHeightD = (nFrmHeight - nHeight) \ nSteps

  ' calculate initial settings
  nFrmWidth = nFrmWidth - nWidthD
  nFrmHeight = nFrmHeight - nHeightD
  nFrmLeft = nFrmLeft - nLeftD
  nFrmTop = nFrmTop - nTopD

  ' move form and show
  Call MoveWindow(frm.hWnd, nFrmLeft, nFrmTop, nFrmWidth, nFrmHeight, True)
  DoEvents

  ' draw form successively smaller
  For nI = 2 To nSteps
    
    ' calculate initial settings
    nFrmWidth = nFrmWidth - nWidthD
    nFrmHeight = nFrmHeight - nHeightD
    nFrmLeft = nFrmLeft - nLeftD
    nFrmTop = nFrmTop - nTopD

    ' move form
    Call MoveWindow(frm.hWnd, nFrmLeft, nFrmTop, nFrmWidth, nFrmHeight, True)
    DoEvents

  Next nI

  ' position at final location
  Call MoveWindow(frm.hWnd, nLeft, nTop, nWidth, nHeight, True)

  ' hide the form
  nRC = ShowWindow(frm.hWnd, 0)
  DoEvents

End Sub

