Option Explicit

 ' Constants:
  Const MF_SEPARATOR = &H800
  
  Const MF_ENABLED = &H0
  Const MF_GRAYED = &H1
  Const MF_DISABLED = &H2
  
  Const MF_UNCHECKED = &H0
  Const MF_CHECKED = &H8
  Const MF_USECHECKBITMAPS = &H200
  
  Const MF_STRING = &H0
  
  Const MF_BYCOMMAND = &H0
  Const MF_BYPOSITION = &H400

  ' system menu IDs
  Global Const SC_CLOSE = &HF060
  Global Const SC_SIZE = &HF000
  Global Const SC_TASKLIST = &HF130

Sub zzFormSysMenuAdd (ByVal hWndForm%, ByVal sMenuText$, ByVal nMenuID%)

 ' Description:
 '  Add items to system menu within a form

 ' Parameters:
 '  hWndForm             form reference
 '  sMenuText            menu text
 '  nMenuID              menu ID

 ' Variables:
  Dim hMenu As Integer   ' menu handle
  Dim nRC   As Integer   ' return code

  ' get menu handle
  hMenu = GetSystemMenu(hWndForm, 0)

  ' add seperator
  If sMenuText = gsEMPTY Or nMenuID = 0 Then
    nRC = AppendMenuByString(hMenu, MF_SEPARATOR, nMenuID, gsEMPTY)

  ' add menu option
  Else
    nRC = AppendMenuByString(hMenu, MF_STRING, nMenuID, sMenuText)
  End If

End Sub

Sub zzFormSysMenuRemove (ByVal hWndForm%, ByVal nMenuID%)

 ' Description:
 '  Remove items from system menu within a form
 '  This procedure will remove seperators also.

 ' Parameters:
 '  hWndForm             form handle
 '  nMenuID              menu to remove

 ' Variables:
  Dim hMenu As Integer   ' menu handle
  Dim nRC   As Integer   ' return code

  ' get menu handle
  hMenu = GetSystemMenu(hWndForm, False)

  Select Case nMenuID
    
    ' task list and associated seperator
    Case SC_TASKLIST
      nRC = DeleteMenu(hMenu, 0, MF_BYCOMMAND)
      nRC = DeleteMenu(hMenu, SC_TASKLIST, MF_BYCOMMAND)

    ' close option and associated seperator
    Case SC_CLOSE
      nRC = DeleteMenu(hMenu, 0, MF_BYCOMMAND)
      nRC = DeleteMenu(hMenu, SC_CLOSE, MF_BYCOMMAND)
    
    Case Else
      nRC = DeleteMenu(hMenu, nMenuID, MF_BYCOMMAND)

  End Select

End Sub

Sub zzFormSysMenuReset (ByVal hWndForm%)

 ' Description:
 '  Reset system menu

 ' Parameters:
 '  hWndForm             form handle

 ' Variables:
  Dim hMenu As Integer   ' menu handle

  ' get menu handle
  hMenu = GetSystemMenu(hWndForm, True)

End Sub

