Option Explicit

 ' Description:
 '  Contains clipboard procedures.

Sub zzCBTextAndClip (txtBox As TextBox, ByVal KeyCode%, ByVal Shift%)

 ' Description:
 '  Handles clipboard actions within text box

 ' Parameters:
 '  txtBox             text box
 '  KeyCode            key code
 '  Shift              shift code

  ' handle errors
  On Error Resume Next

  ' control key
  If Shift = 2 Then
    
    ' ctrl+c copy
    If KeyCode = 67 Then
      If txtBox.SelText <> gsEMPTY Then
	Clipboard.SetText txtBox.SelText, CF_TEXT
      End If

    ' ctrl+v paste
    ElseIf KeyCode = 86 Then
      If Clipboard.GetFormat(CF_TEXT) Then
	txtBox.SelText = Clipboard.GetText(CF_TEXT)
      End If

    ' ctrl+x cut
    ElseIf KeyCode = 88 Then
      Clipboard.SetText txtBox.SelText, CF_TEXT
      txtBox.SelText = gsEMPTY
    End If
  
  End If

End Sub

