Option Explicit
  
  Const DS_MODALFRAME& = &H80&                          ' window has modal frame
  Const GWL_STYLE& = (-16)                              ' get window style bits
  Const SEM_NOOPENFILEERRORBOX& = &H8000                ' prevent file not found error message

Function zzThreeDFixedBorder (frm As Form) As Integer

 ' Description:
 '  Returns true if forms window
 '  is fixed double broder

 ' Parameters:
 '  hWndForm                        windows handle
  
 ' Constants:
  Const GWL_STYLE& = (-16)         ' get window style bits
  Const WS_BORDER = &H800000       ' window has border
  Const WS_MAXIMIZEBOX = &H10000   ' window has maximize box
  Const WS_MINIMIZEBOX = &H20000   ' window has minimize box
  Const WS_THICKFRAME = &H40000    ' window is sizeable
                             
 ' Variables:
  Dim lRC As Long            ' return code
  
  ' get window style bits
  lRC = GetWindowLong(frm.hWnd, GWL_STYLE)

  ' check for needed properties
  If (lRC And WS_THICKFRAME) <> False Then Exit Function   ' cannot be sizable window
  If (lRC And WS_BORDER) = False Then Exit Function        ' must have a border
  If (lRC And WS_MAXIMIZEBOX) <> False Then Exit Function  ' cannot have maximize
  If (lRC And WS_MINIMIZEBOX) <> False Then Exit Function  ' cannot have minimize

  ' yes it is
  zzThreeDFixedBorder = True

End Function

Function zzThreeDForm (frm As Form) As Integer

 ' Description:
 '  Sets up form with 3D options
 '  This routine can only be used
 '  for "sub" forms and not the main
 '  form where the registration takes
 '  place.

 ' Parameters:
 '  frm                  form

 ' Variables:
  Dim hDC As Integer     ' device context
  Dim nRC As Integer     ' return code
  Dim lRC As Long        ' return code

  ' handle errors
  On Error Resume Next

  ' prevent "file not found" messages
  nRC = SetErrorMode(SEM_NOOPENFILEERRORBOX)
    
  ' if form does not have fixed double border
  ' or if no registration then cannot continue
  If zzThreeDFixedBorder(frm) = False Then Exit Function

  ' setup form as modal
  lRC = SetWindowLong(frm.hWnd, GWL_STYLE, GetWindowLong(frm.hWnd, GWL_STYLE) Or DS_MODALFRAME)

  ' register form
  Err = 0
  nRC = Ctl3dSubclassDlgEx(frm.hWnd, &H0)
  If Err <> 0 Then nRC = Ctl3dSubclassDlgExV2(frm.hWnd, &H0)
  If Err = 0 Then zzThreeDForm = True
  
  ' reset default error messaging
  nRC = SetErrorMode(0)
    
End Function

Function zzThreeDStart (ByVal sAppTitle$) As Integer
  
 ' Description:
 '  Register application with CTRL3D.DLL or CTRL3DV2.DLL
 '  This should be done within the main form of the
 '  application normally when it is loaded. Use Register3DSubForm
 '  to setup forms for 3D look. This routine will attempt to
 '  use CTRL3D first then try to use CTRL3DV2.

 ' Parameters:
 '  sAppTitle                  application EXE title

 ' Variables:
  Dim hInst        As Integer  ' instance handle
  Dim nRC          As Integer  ' return code

  ' handle missing dll
  On Error Resume Next

  ' make sure .EXE on end
  nRC = InStr(UCase$(sAppTitle), ".EXE")
  If nRC = 0 Then sAppTitle = sAppTitle & ".EXE"

  ' get module handle
  hInst = GetModuleHandle(sAppTitle)
  If hInst = 0 Then hInst = GetModuleHandle("VB.EXE")    ' try vb
  If hInst = 0 Then hInst = GetModuleHandle("VB32.EXE")  ' try vb32
  
  ' if instance handle found
  If hInst <> 0 Then

    ' prevent "file not found" messages
    nRC = SetErrorMode(SEM_NOOPENFILEERRORBOX)
    
    ' reset error indicator
    Err = 0
  
    ' try to register with ctl3d.dll
    nRC = Ctl3DRegister(hInst)
  
    ' if no error
    If Err = 0 Then
  
      ' continue with ctl3d.dll
      nRC = Ctl3DAutoSubclass(hInst)
      If Err = 0 Then zzThreeDStart = 1
  
    ' if error
    Else
      
      ' reset error indicator
      Err = 0
  
      ' try registeration with ctl3dv2.dll
      nRC = Ctl3DRegisterV2(hInst)
  
      ' if no error
      If Err = 0 Then
        
        ' continue with ctl3dv2.dll
        nRC = Ctl3DAutoSubclassV2(hInst)
        If Err = 0 Then zzThreeDStart = 2
  
      End If
  
    End If
  
    ' reset default error messaging
    nRC = SetErrorMode(0)

  End If

End Function

Function zzThreeDStop (ByVal sAppTitle$) As Integer
  
 ' Description:
 '  Un-register application with 3D DLL
 '  This should be done within the main
 '  form of the application normally when
 '  it is unloaded. Use Register3DSubForm
 '  to setup forms for 3D look.
  
 ' Parameters:
 '  sAppTitle                  application EXE title

 ' Variables:
  Dim hInst        As Integer  ' instance handle
  Dim nRC          As Integer  ' return code
  Dim sAppFullName As String   ' full application title

  ' handle errors
  On Error Resume Next

  ' make sure .EXE on end
  nRC = InStr(UCase$(sAppTitle), ".EXE")
  If nRC = 0 Then sAppTitle = sAppTitle & ".EXE"

  ' get module handle
  hInst = GetModuleHandle(sAppTitle)
  If hInst = 0 Then hInst = GetModuleHandle("VB.EXE")    ' try vb
  If hInst = 0 Then hInst = GetModuleHandle("VB32.EXE")  ' try vb32
  
  ' if instance handle found
  If hInst <> 0 Then

    ' prevent "file not found" messages
    nRC = SetErrorMode(SEM_NOOPENFILEERRORBOX)
    
    ' reset error indicator
    Err = 0
  
    ' try to unregister with ctl3d.dll
    nRC = Ctl3DUnRegister(hInst)
    
    ' if no errors
    If Err = 0 Then
    
      zzThreeDStop = True
  
    ' if error
    Else
      
      ' reset error indicator
      Err = 0
  
      ' try unregisteration with ctl3dv2.dll
      nRC = Ctl3DUnRegisterV2(hInst)
      
      ' if no errors
      If Err = 0 Then
        
        zzThreeDStop = True
  
      End If
  
    End If
  
    ' reset default error messaging
    nRC = SetErrorMode(0)

  End If

End Function

