Option Explicit

 ' Description:
 '  This module contains constants that
 '  allow form and window manipulation.
 
 ' Constants:

  ' arrange methods
  Global Const CASCADE = 0
  Global Const TILE_HORIZONTAL = 1
  Global Const TILE_VERTICAL = 2
  Global Const ARRANGE_ICONS = 3

  ' form show methods
  Global Const MODAL = 1
  Global Const MODELESS = 0

  ' window states
  Global Const NORMAL = 0
  Global Const MINIMIZED = 1
  Global Const MAXIMIZED = 2

  ' scale modes
  Global Const USER = 0
  Global Const TWIPS = 1
  Global Const POINTS = 2
  Global Const PIXELS = 3
  Global Const CHARACTERS = 4
  Global Const INCHES = 5
  Global Const MILLIMETERS = 6
  Global Const CENTIMETERS = 7

  ' SetWindowPos flags
  Global Const SWP_NOSIZE = &H1
  Global Const SWP_NOMOVE = &H2
  Global Const SWP_NOZORDER = &H4
  Global Const SWP_NOREDRAW = &H8
  Global Const SWP_NOACTIVATE = &H10
  Global Const SWP_DRAWFRAME = &H20
  Global Const SWP_SHOWWINDOW = &H40
  Global Const SWP_HIDEWINDOW = &H80
  Global Const SWP_NOCOPYBITS = &H100
  Global Const SWP_NOREPOSITION = &H200

  ' border styles
  Global Const NONE = 0
  Global Const FIXED_SINGLE = 1
  Global Const SIZEABLE = 2
  Global Const FIXED_DOUBLE = 3

  ' insert after flags
  Global Const HWND_TOPMOST = -1
  Global Const HWND_NOTOPMOST = -2
  Global Const HWND_TOP = 0
  Global Const HWND_DESKTOP = 0
  Global Const HWND_BOTTOM = 1
  Global Const HWND_BROADCAST = &HFFFF

  ' bits per pixel and number of planes
  Global Const BITSPIXEL = 12
  Global Const PLANES = 14

