VERSION 2.00
Begin Form frm 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Version Information"
   ClientHeight    =   2715
   ClientLeft      =   1170
   ClientTop       =   1485
   ClientWidth     =   5160
   Height          =   3120
   Icon            =   ODVERCHK.FRX:0000
   Left            =   1110
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   2715
   ScaleWidth      =   5160
   Top             =   1140
   Width           =   5280
   Begin CommandButton cmdExit 
      Caption         =   "E&xit"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Left            =   4380
      TabIndex        =   5
      Top             =   1110
      Width           =   735
   End
   Begin TextBox txtDateTime 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Small Fonts"
      FontSize        =   6
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Left            =   2850
      MultiLine       =   -1  'True
      TabIndex        =   13
      TabStop         =   0   'False
      Top             =   660
      Width           =   1485
   End
   Begin TextBox txtSize 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Small Fonts"
      FontSize        =   6
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Left            =   2850
      MultiLine       =   -1  'True
      TabIndex        =   12
      TabStop         =   0   'False
      Top             =   390
      Width           =   1485
   End
   Begin CheckBox chkDeletePrompt 
      Caption         =   "Prompt When Deleting Files"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   60
      TabIndex        =   11
      TabStop         =   0   'False
      Top             =   1890
      Width           =   5055
   End
   Begin CommandButton cmdDelete 
      Caption         =   "&Delete"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Left            =   60
      TabIndex        =   1
      Top             =   570
      Width           =   915
   End
   Begin CheckBox chkSingleLine 
      Caption         =   "Print Single Line For Each File Entry On Report"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   60
      TabIndex        =   10
      TabStop         =   0   'False
      Top             =   1680
      Width           =   5055
   End
   Begin CheckBox chkReportAll 
      Caption         =   "Include Files Without Version Information In Report"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   60
      TabIndex        =   9
      TabStop         =   0   'False
      Top             =   1470
      Width           =   5055
   End
   Begin CommandButton cmdOptions 
      Caption         =   "&Options..."
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Left            =   60
      TabIndex        =   2
      Top             =   1080
      Width           =   915
   End
   Begin TextBox txtDescription 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Small Fonts"
      FontSize        =   6
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   435
      Left            =   1020
      MultiLine       =   -1  'True
      TabIndex        =   8
      TabStop         =   0   'False
      Top             =   930
      Width           =   3315
   End
   Begin TextBox txtFile 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   315
      Left            =   1020
      TabIndex        =   6
      Top             =   90
      Width           =   3315
   End
   Begin CommandButton cmdReport 
      Caption         =   "&Report"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   4380
      TabIndex        =   4
      TabStop         =   0   'False
      Top             =   840
      Visible         =   0   'False
      Width           =   735
   End
   Begin CommandButton cmdNext 
      Caption         =   "&Next"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   4380
      TabIndex        =   3
      TabStop         =   0   'False
      Top             =   600
      Visible         =   0   'False
      Width           =   735
   End
   Begin TextBox txtVersion 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Small Fonts"
      FontSize        =   6
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   555
      Left            =   1020
      MultiLine       =   -1  'True
      TabIndex        =   7
      TabStop         =   0   'False
      Top             =   390
      Width           =   1845
   End
   Begin PictureBox picDragDrop 
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   480
      Left            =   4500
      Picture         =   ODVERCHK.FRX:0302
      ScaleHeight     =   480
      ScaleWidth      =   480
      TabIndex        =   14
      TabStop         =   0   'False
      Top             =   60
      Width           =   480
   End
   Begin CommandButton cmdFile 
      Caption         =   "&File"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   315
      Left            =   60
      TabIndex        =   0
      Top             =   60
      Width           =   915
   End
   Begin CommonDialog dlg 
      DialogTitle     =   "Select File"
      Left            =   60
      Top             =   6360
   End
End
Option Explicit

 ' Constants:
  Const nHeight1 = 1775         ' hide options
  Const nHeight2 = 2495         ' show options
  
  ' no version information
  Const sNO_VER = "No version information"

  ' no text descripption
  Const sNO_TEXT = "No description"

 ' Variables:
  Dim bDeletePrompt As Integer   ' delete prompt
  Dim bNext         As Integer   ' go to next file indicator
  Dim bReport       As Integer   ' produce ASCII text file
  Dim bReportAll    As Integer   ' include files without version info in report
  Dim bSingleLine   As Integer   ' print information on single line
  Dim hDrop         As Integer   ' handle to drop server
  Dim nRC           As Integer   ' return code

  Dim tCD_File     As zzCD_File

Sub chkDeletePrompt_Click ()
  
  ' update ini file
  bDeletePrompt = chkDeletePrompt
  nRC = zzINIPutInteger("DeletePrompt", bDeletePrompt)

End Sub

Sub chkReportAll_Click ()

  ' update ini file
  bReportAll = chkReportAll
  nRC = zzINIPutInteger("ReportAll", bReportAll)

End Sub

Sub chkSingleLine_Click ()

  ' update ini file
  bSingleLine = chkSingleLine
  nRC = zzINIPutInteger("SingleLine", bSingleLine)
  
End Sub

Sub cmdDelete_Click ()

  ' do not continue if no
  If bDeletePrompt Then
    gsMBText = "Are you sure you wish to delete "
    gsMBText = gsMBText & UCase$(txtFile) & "?"
    If MsgBox(gsMBText, MB_ICONQUESTION Or MB_YESNO) = IDNO Then Exit Sub
  End If

  ' delete file show message if error
  On Error Resume Next
  Kill txtFile
  If Err <> 0 Then
    MsgBox Error$, MB_ICONINFORMATION
  Else
    txtFile = gsEMPTY
    txtDescription = gsEMPTY
    txtVersion = gsEMPTY
    txtSize = gsEMPTY
    txtDateTime = gsEMPTY
  End If

  ' if next button shown then go to next file
  If cmdNext.Visible Then Call cmdNext_Click
  
End Sub

Sub cmdExit_Click ()

  Unload Me

End Sub

Sub cmdFile_Click ()

  ' time and date stamp
  Dim vntTimeStamp As Variant
  
  ' select a file to version check
  dlg.Filename = "*.dll;*.exe;*.vbx"
  dlg.Filter = "*.dll;*.exe;*.vbx|*.dll;*.exe;*.vbx|*.dll (Libraries)|*.dll|*.exe (Programs)|*.exe|*.vbx (Controls)|*.vbx|*.* (All Files)|*.*"
  nRC = zzDialogOpen(dlg, tCD_File)
  txtFile = RTrim$(LCase$(tCD_File.Filename))

  ' please wait...
  Me.MousePointer = HOURGLASS

  ' clear fields
  txtVersion = gsEMPTY
  txtDescription = gsEMPTY
  txtSize = gsEMPTY
  txtDateTime = gsEMPTY

  ' get version information
  txtVersion = Trim$(zzVERGetFileVersion(txtFile))
  If txtVersion = gsEMPTY Then
  
    txtVersion = sNO_VER
    txtDescription = sNO_TEXT

  Else

    ' get company name
    txtVersion = txtVersion & gsCHR_CRLF & Trim$(zzVERGetFileCompany(txtFile))

    ' get version information
    txtDescription = Trim$(zzVERGetFileDescription(txtFile))
    If txtDescription = gsEMPTY Then txtDescription = sNO_TEXT

  End If
  
  ' length of file
  txtSize = Format$(FileLen(txtFile)) & " bytes"

  ' handle errors
  On Error Resume Next

  ' date and time
  vntTimeStamp = FileDateTime(txtFile)
  txtDateTime = Format$(vntTimeStamp, "mm/dd/yy")
  txtDateTime = txtDateTime & " " & Format$(vntTimeStamp, "h:mm AM/PM")

  ' handle errors
  On Error GoTo 0

  ' ... no more waiting
  Me.MousePointer = DEFAULT

End Sub

Sub cmdNext_Click ()
  
  ' go to next file
  bNext = True

End Sub

Sub cmdOptions_Click ()

  ' show options
  If Height = nHeight1 Then
    Height = nHeight2
  
  ' hide options
  Else
    Height = nHeight1
  End If

End Sub

Sub cmdReport_Click ()

  ' produce report
  bReport = True

End Sub

Sub DragAndDrop ()

 ' Description:
 '  Allow drag and drop from file
 '  manager to place file name in
 '  text box.

 ' Variables:
  Dim bFileDropped          As Integer    ' file(s) dropped flag
  Dim bReportStarted        As Integer    ' report has started
  Dim iZ                    As Integer    ' loop counter
  Dim nFileCount            As Integer    ' count of files dropped
  Dim nFileNum              As Integer    ' file handle
  Dim nFileNameLength       As Integer    ' length of file name
  Dim nRC                   As Integer    ' return code
  Dim sDir                  As String     ' directory name
  Dim sDirFile              As String     ' directory and file name
  Dim sFile                 As String     ' file name
  Dim sLine                 As String     ' print line
  Dim uMessage              As Msg        ' windows message structure
  Dim vntTimeStamp          As String     ' time and date stamp
  
  ' picture control gets all drops
  Call DragAcceptFiles(picDragDrop.hWnd, True)

  ' eternal background loop
  Do While DoEvents()

    ' see if file(s) dropped on form
    bFileDropped = PeekMessage(uMessage, 0, WM_DROPFILES, WM_DROPFILES, PM_REMOVE Or PM_NOYIELD)

    ' if they have then
    If bFileDropped Then

      ' get handle
      hDrop = uMessage.wParam

      ' get count of files
      nFileCount = DragQueryFile(hDrop, -1, sDirFile, 127)

      ' do we need next and report button
      bNext = False
      bReport = False
      cmdNext.Visible = nFileCount > 1
      cmdReport.Visible = nFileCount > 1
      cmdFile.Enabled = nFileCount <= 1
      
      ' store each file in INI file
      For iZ = 0 To nFileCount - 1

	' get file including path
	sDirFile = Space$(127)
	nFileNameLength = DragQueryFile(hDrop, iZ, sDirFile, 127)
	sDirFile = LCase$(Left$(sDirFile, nFileNameLength))

	' show file name and version
	txtFile = sDirFile
  
	' please wait...
	Me.MousePointer = HOURGLASS

	' clear fields
	txtVersion = gsEMPTY
	txtDescription = gsEMPTY
	txtSize = gsEMPTY
	txtDateTime = gsEMPTY

	' get version information
	txtVersion = Trim$(zzVERGetFileVersion(sDirFile))
	If txtVersion = gsEMPTY Then
	
	  txtVersion = sNO_VER
	  txtDescription = sNO_TEXT
      
	Else
      
	  ' get company name
	  txtVersion = txtVersion & gsCHR_CRLF & Trim$(zzVERGetFileCompany(sDirFile))
      
	  ' get version information
	  txtDescription = Trim$(zzVERGetFileDescription(sDirFile))
	  If txtDescription = gsEMPTY Then txtDescription = sNO_TEXT
      
	End If

	' handle errors
	On Error Resume Next
	
	' length of file
	txtSize = Format$(FileLen(sDirFile)) & " bytes"
      
	' date and time
	vntTimeStamp = FileDateTime(sDirFile)
	txtDateTime = Format$(vntTimeStamp, "mm/dd/yy")
	txtDateTime = txtDateTime & " " & Format$(vntTimeStamp, "h:mm AM/PM")
	
	' handle errors
	On Error GoTo 0
	
	' no more waiting
	Me.MousePointer = DEFAULT

	' if not last one displayed
	If iZ <> (nFileCount - 1) Then
	    
	  bNext = False
	  Do: DoEvents: Loop Until bNext Or bReport
	
	End If

	' if report option taken
	If bReport Then

	  ' seperate directory and file name
	  Call zzFileParse(sDirFile, sDir, sFile)
	  
	  ' if not yet started then
	  If Not bReportStarted Then
	    
	    ' set flag
	    bReportStarted = True

	    ' disable options button
	    cmdOptions.Enabled = False

	    ' tell user to wait
	    Screen.MousePointer = HOURGLASS
	    
	    ' get report settings
	    nRC = zzINIGetInteger("ReportAll", bReportAll)
	    nRC = zzINIGetInteger("SingleLine", bSingleLine)
	    chkReportAll = bReportAll: chkSingleLine = bSingleLine
	    If bSingleLine = False Then
	      sLine = gsCHR_CR & gsCHR_LF & gsCHR_TAB
	    Else
	      sLine = gsCHR_TAB
	    End If
  
	    ' open file
	    nFileNum = FreeFile
	    On Error Resume Next
	    Open App.Path & "\ODVERCHK.TXT" For Output As nFileNum
	    
	    ' if error then cannot continue
	    If Err <> 0 Then
	      Screen.MousePointer = DEFAULT
	      MsgBox "Could not open report file.", MB_ICONSTOP
	      bReport = False
	    
	    ' if no error then
	    Else
	      
	      ' hide buttons
	      cmdNext.Visible = False
	      cmdReport.Visible = False
	      
	      ' print first line
	      If bReportAll <> False Or txtVersion <> sNO_VER Then
		Print #nFileNum, UCase$(sFile);
		Print #nFileNum, sLine; sDir;
		Print #nFileNum, sLine; txtVersion;
		Print #nFileNum, sLine; txtDescription
		If sLine <> gsCHR_TAB Then Print #nFileNum,
	      End If
	      
	    End If

	    ' turn off error handling
	    On Error GoTo 0

	  ' if report already started then
	  Else
	    
	    ' print next line
	    If bReportAll <> False Or txtVersion <> sNO_VER Then
	      Print #nFileNum, UCase$(sFile);
	      Print #nFileNum, sLine; sDir;
	      Print #nFileNum, sLine; txtVersion;
	      Print #nFileNum, sLine; txtDescription
	      If sLine <> gsCHR_TAB Then Print #nFileNum,
	    End If

	  End If

	End If

      Next iZ

      ' ...no more waiting
      Screen.MousePointer = DEFAULT

      ' hide buttons
      cmdNext.Visible = False
      cmdReport.Visible = False
      cmdFile.Enabled = True

      ' free resources
      Call DragFinish(hDrop)

      ' close report
      If bReportStarted Then
	
	' reset flag
	bReportStarted = False
	
	' reenable options button
	cmdOptions.Enabled = True

	' close report
	On Error Resume Next
	Close nFileNum
	On Error GoTo 0

      End If

    End If

  Loop
  
End Sub

Sub Form_Load ()

  ' setup variables
  Call zzSetGlobalVariables
  App.Title = Caption

  ' hide options
  Height = nHeight1

  ' position form
  zzFormCenter Me

  ' always on top
  zzFormFloat Me

  ' get report options
  nRC = zzINISetFile(App.Path & "\ODVERCHK.INI")
  nRC = zzINISetSection("CONFIG")
  nRC = zzINIGetInteger("ReportAll", bReportAll)
  nRC = zzINIGetInteger("SingleLine", bSingleLine)
  nRC = zzINIGetInteger("DeletePrompt", bDeletePrompt)
  chkReportAll = bReportAll
  chkSingleLine = bSingleLine
  chkDeletePrompt = bDeletePrompt
  
  ' enable drag and drop
  Call DragAndDrop

End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)

  ' if in loop then need to
  ' clean up resources
  If cmdNext.Visible Then Call DragFinish(hDrop)

End Sub

Sub Form_Resize ()
  
  ' always on top
  Call zzFormFloat(Me)

End Sub

Sub Form_Unload (Cancel As Integer)

  ' not on top
  zzFormUnfloat Me

  ' end program
  End

End Sub

Sub picDragDrop_GotFocus ()
  
  ' cannot stop here
  SendKeys "{TAB}"

End Sub

Sub txtDateTime_GotFocus ()
  
  ' can't stop here
  SendKeys "{TAB}"

End Sub

Sub txtDescription_GotFocus ()
  
  ' can't stop here
  SendKeys "{TAB}"
  
End Sub

Sub txtFile_GotFocus ()
  
  ' can't stop here
  SendKeys "{TAB}"

End Sub

Sub txtSize_GotFocus ()
  
  ' can't stop here
  SendKeys "{TAB}"

End Sub

Sub txtVersion_GotFocus ()

  ' can't stop here
  SendKeys "{TAB}"
 
End Sub

