Option Explicit

  ' version find file flag
  Global Const VFFF_ISSHAREDFILE = &H1

  ' version install results
  Global Const VIF_TEMPFILE = &H1                              ' temporary file created
  Global Const VIF_MISMATCH = &H2                              ' mismatched parameters
  Global Const VIF_SRCOLD = &H4                                ' source older version
  Global Const VIF_CANNOTCOPY = &H5                            ' cannot copy
  Global Const VIF_BADVERSION = &H6                            ' bad DLL
  Global Const VIF_DIFFLANG = &H8                              ' different language
  Global Const VIF_DIFFCODEPG = &H10                           ' different code page
  Global Const VIF_DIFFTYPE = &H20                             ' different file tpye
  Global Const VIF_WRITEPROT = &H40                            ' destination write protected
  Global Const VIF_FILEINUSE = &H80                            ' file in use
  Global Const VIF_OUTOFSPACE = &H100                          ' out of space
  Global Const VIF_OUTOFSPACETEMP = &H101                      ' out of temporary space
  Global Const VIF_ACCESSVIOLATION = &H200                     ' access violation
  Global Const VIF_SHARINGVIOLATION = &H400                    ' sharing violation
  Global Const VIF_CANNOTCREATE = &H800                        ' cannot create destination
  Global Const VIF_CANNOTDELETE = &H1000                       ' cannot delete destination
  Global Const VIF_CANNOTRENAME = &H2000                       ' cannot rename destination
  Global Const VIF_CANNOTDELETECUR = &H4000                    ' cannot delete current
  Global Const VIF_OUTOFMEMORY = &H8000                        ' out of memory
  Global Const VIF_CANNOTREADSRC = &H10000                     ' cannot read source file
  Global Const VIF_CANNOTREADDST = &H20000                     ' cannot desctination file
  Global Const VIF_BUFFTOOSMALL = &H40000                      ' buffer too small
  Global Const VIF_FILEOMITTED = &H40001                       ' file omitted
  Global Const VIF_CANNOTUNCOMPRESS = &H40002                  ' cannot uncompress
  Global Const VIF_CANNOTCREATEWORK = &H40003                  ' cannot create work file
  Global Const VIF_CRCWRONG = &H40004                          ' CRC doesn't match
  Global Const VIF_NOSHARE = &H40005                           ' no share loaded

  ' install file flags
  Global Const VIFF_NONE = &H0                                 ' none
  Global Const VIFF_FORCEINSTALL = &H1                         ' force
  Global Const VIFF_DONTDELETEOLD = &H2                        ' dont't delete old file

  ' version control resources
  Global Const VS_VERSION_INFO = 1                             ' version stamp ID
  Global Const VS_FILE_INFO = 16                               ' version stamp type
  Global Const VS_USER_DEFINED = 100                           ' User-defined ID

  ' version control flags
  Global Const VS_FFI_SIGNATURE = &HFEEF04BD                   ' FFI header
  Global Const VS_FFI_STRUCVERSION = &H10000                   ' FFI structure version
  Global Const VS_FFI_FILEFLAGSMASK = &H3F&                    ' FFI flags mask

  ' version file flags
  Global Const VS_FF_DEBUG = &H1&
  Global Const VS_FF_PRERELEASE = &H2&
  Global Const VS_FF_PATCHED = &H4&
  Global Const VS_FF_PRIVATEBUILD = &H8&
  Global Const VS_FF_INFOINFERRED = &H10&
  Global Const VS_FF_SPECIALBUILD = &H20&

  ' version codes for operating systems
  Global Const VOS_UNKNOWN = &H0&
  Global Const VOS_DOS = &H10000
  Global Const VOS_OS216 = &H20000
  Global Const VOS_OS232 = &H30000
  Global Const VOS_NT = &H40000
  Global Const VOS__BASE = &H0&
  Global Const VOS__WINDOWS16 = &H1&
  Global Const VOS__PM16 = &H2&
  Global Const VOS__PM32 = &H3&
  Global Const VOS__WINDOWS32 = &H4&
  Global Const VOS_DOS_WINDOWS16 = &H10001
  Global Const VOS_DOS_WINDOWS32 = &H10004
  Global Const VOS_OS216_PM16 = &H20002
  Global Const VOS_OS232_PM32 = &H30003
  Global Const VOS_NT_WINDOWS32 = &H40004

  ' version file types
  Global Const VFT_UNKNOWN = &H0&
  Global Const VFT_APP = &H1&
  Global Const VFT_DLL = &H2&
  Global Const VFT_DRV = &H3&
  Global Const VFT_FONT = &H4&
  Global Const VFT_VXD = &H5&
  Global Const VFT_STATIC_LIB = &H7&

  ' version file sub-types for VFT_DRV
  Global Const VFT2_UNKNOWN = &H0&
  Global Const VFT2_DRV_PRINTER = &H1&
  Global Const VFT2_DRV_KEYBOARD = &H2&
  Global Const VFT2_DRV_LANGUAGE = &H3&
  Global Const VFT2_DRV_DISPLAY = &H4&
  Global Const VFT2_DRV_MOUSE = &H5&
  Global Const VFT2_DRV_NETWORK = &H6&
  Global Const VFT2_DRV_SYSTEM = &H7&
  Global Const VFT2_DRV_INSTALLABLE = &H8&
  Global Const VFT2_DRV_SOUND = &H9&
  Global Const VFT2_DRV_COMM = &HA&

  ' version file sub-types for VFT_FONT
  Global Const VFT2_FONT_RASTER = &H1&
  Global Const VFT2_FONT_VECTOR = &H2&
  Global Const VFT2_FONT_TRUETYPE = &H3&

  ' maximum length of version information
  Global Const MAXVERINFOLENGTH = 64000

  ' english, multilingual translation table
  Global Const TT_ENGLISHMULTI = "040904E4"

  ' search for string info
  Global Const VER_GET_STRINGINFO = "\StringFileInfo\"

  ' open file options
  Global Const OF_DELETE = &H200                               ' delete old file

Function zzGetFFI (ByVal sVersionBlock$) As String

 ' Description:
 '  Get Fixed File Version Information

 ' Parameters:
 '  sVersionBlock    string holding version information

 ' Variables:
  Dim n1             ' work field
  
  ' find start of fixed file info
  n1 = InStr(sVersionBlock, Chr(&HBD) & Chr(&H4) & Chr(&HEF) & Chr(&HFE))

  ' if nothing found then return Nulls
  If n1 = 0 Then
    zzGetFFI = String$(52, 0)
  
  ' else return block
  Else
    zzGetFFI = Mid$(sVersionBlock, n1, 52)
  End If

End Function

Function zzGetFFIFileDateLS (sFFI As String) As Long

 ' Description:
 '  Get FFI Date and Time (Least Significant Bytes)

 ' Parameters:
 '  sFFI        string holding fixed file information

  zzGetFFIFileDateLS = zzGetVerHexValue(Mid$(sFFI, 49, 4))

End Function

Function zzGetFFIFileDateMS (sFFI As String) As Long

 ' Description:
 '   Get FFI Date and Time (Most Significant Bytes)
 
 ' Parameters:
 '  sFFI        string holding fixed file information
 
  zzGetFFIFileDateMS = zzGetVerHexValue(Mid$(sFFI, 45, 4))

End Function

Function zzGetFFIFileFlags (sFFI As String) As Long

 ' Description:
 '  Get FFI File Flags

 ' Parameters:
 '  sFFI        string holding fixed file information
  
  zzGetFFIFileFlags = zzGetVerHexValue(Mid$(sFFI, 29, 4))

End Function

Function zzGetFFIFileFlagsMask (sFFI As String) As Long

 ' Description:
 '  Get FFI File Flag Masks

 ' Parameters:
 '  sFFI        string holding fixed file information
  
  zzGetFFIFileFlagsMask = zzGetVerHexValue(Mid$(sFFI, 25, 4))

End Function

Function zzGetFFIFileOS (sFFI As String) As Long

 ' Description:
 '  Get FFI File Operating System

 ' Parameters:
 '  sFFI        string holding fixed file information
 
  zzGetFFIFileOS = zzGetVerHexValue(Mid$(sFFI, 33, 4))

End Function

Function zzGetFFIFileSubType (sFFI As String) As Long

 ' Description:
 '  Get FFI File Sub-type
 
 ' Parameters:
 '  sFFI        string holding fixed file information
  
  zzGetFFIFileSubType = zzGetVerHexValue(Mid$(sFFI, 41, 4))

End Function

Function zzGetFFIFileType (sFFI As String) As Long

 ' Description:
 '  Get FFI File Type
 
 ' Parameters:
 '  sFFI        string holding fixed file information
 
  zzGetFFIFileType = zzGetVerHexValue(Mid$(sFFI, 37, 4))

End Function

Function zzGetFFIFileVersionLS (sFFI As String, sMajorMinor As String) As Long

 ' Description:
 '  Get FFI File Version (Least Significant Bytes)

 ' Parameters:
 '  sFFI        string holding fixed file information
 '  sMajorMinor major/minor codes
 
 ' Variables:
  Dim lVerNum As Long

  lVerNum = zzGetVerHexValue(Mid$(sFFI, 13, 4))
  sMajorMinor = zzGetFFIsMajorMinor(lVerNum)
  zzGetFFIFileVersionLS = lVerNum

End Function

Function zzGetFFIFileVersionMS (sFFI As String, sMajorMinor As String) As Long

 ' Description:
 '  Get FFI File Version (Most Significant Bytes)

 ' Parameters:
 '  sFFI        string holding fixed file information
 '  sMajorMinor major/minor codes
 
 ' Variables:
  Dim lVerNum As Long

  lVerNum = zzGetVerHexValue(Mid$(sFFI, 9, 4))
  sMajorMinor = zzGetFFIsMajorMinor(lVerNum)
  zzGetFFIFileVersionMS = lVerNum

End Function

Function zzGetFFIProductVersionLS (sFFI As String, sMajorMinor As String) As Long

 ' Description:
 '  Get FFI Product Version (Least Significant Bytes)

 ' Parameters:
 '  sFFI        string holding fixed file information
 '  sMajorMinor major/minor codes
 
 ' Variables:
  Dim lVerNum As Long

  lVerNum = zzGetVerHexValue(Mid$(sFFI, 21, 4))
  sMajorMinor = zzGetFFIsMajorMinor(lVerNum)
  zzGetFFIProductVersionLS = lVerNum

End Function

Function zzGetFFIProductVersionMS (sFFI As String, sMajorMinor As String) As Long

 ' Description:
 '  Get FFI Product Version (Most Significant Bytes)

 ' Parameters:
 '  sFFI        string holding fixed file information
 '  sMajorMinor major/minor codes
 
 ' Variables:
  Dim lVerNum As Long

  lVerNum = zzGetVerHexValue(Mid$(sFFI, 17, 4))
  sMajorMinor = zzGetFFIsMajorMinor(lVerNum)
  zzGetFFIProductVersionMS = lVerNum

End Function

Function zzGetFFISignature (sFFI As String) As Long

 ' Description:
 '  Get FFI Signature

 ' Parameters:
 '  sFFI        string holding fixed file information
 
  zzGetFFISignature = zzGetVerHexValue(Mid$(sFFI, 1, 4))

End Function

Function zzGetFFIsMajorMinor (lVerNum As Long) As String

 ' Description:
 '  Get Major and Minor revisions from 32 bit numeric

 ' Parameters:
 '  lVerNum       version number

 ' Variables:
  Dim nMajor As Integer
  Dim nMinor As Integer

  On Error Resume Next
  nMajor = CInt(lVerNum / &H10000)
  nMinor = CInt(lVerNum And &HFFFF)
  zzGetFFIsMajorMinor = Format$(nMajor) + "." + Format$(nMinor)

End Function

Function zzGetFFIStructure (sFFI As String) As Long

 ' Description:
 '  Get FFI Structure

 ' Parameters:
 '  sFFI        string holding fixed file information
 
  zzGetFFIStructure = zzGetVerHexValue(Mid$(sFFI, 5, 4))

End Function

Sub zzGetTranslationTable (sVersionBlock As String, sTTArray() As String, nTTCount As Integer)

 ' Description:
 '  Returns the translation table values
 '  in sTTArray and a count of tables.
 
 ' Parameters:
 '  sVersionBlock         string holding version information
 '  sTTArray              array of translation tables
 '  nTTCount              number of translation tables

  Dim i1      As Integer ' loop counter
  Dim stt     As String  ' temporary translation table
  Dim sTTable As String  ' translation table

  ' nothing is not valid
  If sVersionBlock = gsEMPTY Then Exit Sub

  ' get translation tables
  stt = zzGetVerData(sVersionBlock, "\VarFileInfo\Translation", False)

  ' get number on translation tables
  ' each 4 bytes is a table
  nTTCount = Len(stt) / 4

  ' if tables present then
  If nTTCount > 0 Then

    ' do each entry
    For i1 = 1 To nTTCount

      ' format
      sTTable = Format$(Hex$(Asc(Mid$(stt, 2, 1))), "00")
      sTTable = sTTable & Format$(Hex$(Asc(Mid$(stt, 1, 1))), "00")
      sTTable = sTTable & Format$(Hex$(Asc(Mid$(stt, 4, 1))), "00")
      sTTable = sTTable & Format$(Hex$(Asc(Mid$(stt, 3, 1))), "00")

      ' put into array
      sTTArray(i1) = sTTable
	
      ' throw away table
      stt = Mid$(stt, 5)

    Next i1
  
  End If

End Sub

Function zzGetVerBlock (sFile As String) As String

 ' Description:
 '  Returns the version information
 '  block for a specific file

 ' Parameters:
 '  sFile                        file to analysis

 ' Variables:
  Dim bBlockFound   As Integer   ' return code when getting version info
  Dim lBlockPtr     As Long      ' pointer to address of version info
  Dim lBlockSize    As Long      ' size, in bytes, of version info
  Dim sVersionBlock As String    ' version info

  ' turn on error handling
  On Error Resume Next
  
  ' get size of version information and pointer to it
  ' if 0 returned then file does not support version stamping
  If Len(Dir$(sFile)) <> 0 And sFile <> gsEMPTY Then
    lBlockSize = GetFileVersionInfoSize(sFile, lBlockPtr)
  End If
  If lBlockSize = 0 Then zzGetVerBlock = gsEMPTY: Exit Function

  ' make string big enough for API but not to big for VB
  If lBlockSize > MAXVERINFOLENGTH Then lBlockSize = MAXVERINFOLENGTH
  sVersionBlock = String$(CInt(lBlockSize) + 1, gsCHR_NUL)

  ' get version information
  ' if 0 returned then could not get version info
  bBlockFound = GetFileVersionInfo(sFile, lBlockPtr, lBlockSize, sVersionBlock)
  If bBlockFound = 0 Then zzGetVerBlock = gsEMPTY: Exit Function

  ' return value to caller
  zzGetVerBlock = sVersionBlock

End Function

Function zzGetVerBlockSize (sVersionBlock As String) As Integer

 ' Description:
 '  Get "real" size of version block

 ' Parameters:
 '  sVersionBlock       string holding version information

  zzGetVerBlockSize = zzGetVerHexValue(Left$(Left$(sVersionBlock, 2) & String$(4, 0), 4))

End Function

Function zzGetVerComments (sVersionBlock As String, sTranslationTable As String) As String

 ' Description:
 '  Get Version Comments

 ' Parameters:
 '  sVersionBlock       string holding version information
 '  sTranslationTable   translation table to be used

  zzGetVerComments = zzGetVerData(sVersionBlock, VER_GET_STRINGINFO & sTranslationTable & "\Comments", True)

End Function

Function zzGetVerCompanyName (sVersionBlock As String, sTranslationTable As String) As String

 ' Description:
 '  Get Version Company Name

 ' Parameters:
 '  sVersionBlock       string holding version information
 '  sTranslationTable   translation table to be used
  
  zzGetVerCompanyName = zzGetVerData(sVersionBlock, VER_GET_STRINGINFO & sTranslationTable & "\CompanyName", True)

End Function

Function zzGetVerData (sVersionBlock As String, sVersionDataName As String, bRemoveNulls As Integer) As String

 ' Description:
 '  Returns specific version information
 '  from the version information block

 ' Parameters:
 '  sVersionBlock              ' block holding information
 '  sVersionDataName           ' key to information to pull out
 '  bRemoveNulls               ' remove trailing trash

 ' Variables:
  Dim i1                   As Integer ' work field

  Dim lStringCopyLength    As Long    ' length of string copied
  Dim lVersionFilePtr      As Long    ' pointer to file version info
  
  Dim nVersionInfoFound    As Integer ' return code when getting version info
  Dim nVersionInfoLength   As Integer ' version info length
  
  Dim sVersionData         As String  ' data obtained

  ' if no data to pull from then exit
  If sVersionBlock = gsEMPTY Then zzGetVerData = gsEMPTY: Exit Function

  ' get specific version information
  nVersionInfoFound = VerQueryValue(sVersionBlock, sVersionDataName, lVersionFilePtr, nVersionInfoLength)

  ' if version stamp was found
  If nVersionInfoFound = VS_VERSION_INFO Then

    ' make string big enough
    sVersionData = String$(nVersionInfoLength, gsCHR_NUL)
    
    ' use pointer to get string from version info field
    lStringCopyLength = lstrcpyn(sVersionData, lVersionFilePtr, nVersionInfoLength + 1)

    ' remove Nulls
    If bRemoveNulls Then

      ' find first Null
      i1 = InStr(sVersionData, gsCHR_NUL)
      Do While i1 > 0
	sVersionData = Left$(sVersionData, i1 - 1) & Mid$(sVersionData, i1 + 1)
	i1 = InStr(sVersionData, gsCHR_NUL)
      Loop

      ' find first carriage return
      i1 = InStr(sVersionData, Chr$(13))
      Do While i1 > 0
	sVersionData = Left$(sVersionData, i1 - 1) & Mid$(sVersionData, i1 + 1)
	i1 = InStr(sVersionData, Chr$(13))
      Loop
      
      ' find first line feed
      i1 = InStr(sVersionData, Chr$(10))
      Do While i1 > 0
	sVersionData = Left$(sVersionData, i1 - 1) & Mid$(sVersionData, i1 + 1)
	i1 = InStr(sVersionData, Chr$(10))
      Loop

    End If

    ' return to caller
    zzGetVerData = sVersionData
    
  ' if no version stamp return nothing
  Else
    zzGetVerData = gsEMPTY
  End If

End Function

Function zzGetVerFileDescription (sVersionBlock As String, sTranslationTable As String) As String
 
 ' Description:
 '  Get description of file from version block

 ' Parameters:
 '  sVersionBlock       string holding version information
 '  sTranslationTable   translation table to be used

  zzGetVerFileDescription = zzGetVerData(sVersionBlock, VER_GET_STRINGINFO & sTranslationTable & "\FileDescription", True)

End Function

Function zzGetVerFileVersion (sVersionBlock As String, sTranslationTable As String) As String

 ' Description:
 '  Get Version File Version

 ' Parameters:
 '  sVersionBlock       string holding version information
 '  sTranslationTable   translation table to be used

  zzGetVerFileVersion = zzGetVerData(sVersionBlock, VER_GET_STRINGINFO & sTranslationTable & "\FileVersion", True)

End Function

Function zzGetVerHexValue (sHexValue As String) As Long

 ' Description:
 '   Get Hex Value from 4 byte string

 ' Parameters:
 '  sHexValue          string holding hex value

 ' Variables:
  Dim sHex As String   ' hex value in correct format

  ' format correctly
  sHex = Format$(Hex$(Asc(Mid$(sHexValue, 4, 1))), "00")
  sHex = sHex & Format$(Hex$(Asc(Mid$(sHexValue, 3, 1))), "00")
  sHex = sHex & Format$(Hex$(Asc(Mid$(sHexValue, 2, 1))), "00")
  sHex = sHex & Format$(Hex$(Asc(Mid$(sHexValue, 1, 1))), "00")

  ' return value to caller
  zzGetVerHexValue = Val("&H" & sHex)

End Function

Function zzGetVerInternalName (sVersionBlock As String, sTranslationTable As String) As String

 ' Description:
 '  Get Version Internal Name
 
 ' Parameters:
 '  sVersionBlock       string holding version information
 '  sTranslationTable   translation table to be used

  zzGetVerInternalName = zzGetVerData(sVersionBlock, VER_GET_STRINGINFO & sTranslationTable & "\InternalName", True)

End Function

Function zzGetVerLegalCopyright (sVersionBlock As String, sTranslationTable As String) As String

 ' Description:
 '  Get Version Legal Copyright
 
 ' Parameters:
 '  sVersionBlock       string holding version information
 '  sTranslationTable   translation table to be used

  zzGetVerLegalCopyright = zzGetVerData(sVersionBlock, VER_GET_STRINGINFO & sTranslationTable & "\LegalCopyright", True)

End Function

Function zzGetVerLegalTrademarks (sVersionBlock As String, sTranslationTable As String) As String

 ' Description:
 '  Get Version Legal Trade Marks
 
 ' Parameters:
 '  sVersionBlock       string holding version information
 '  sTranslationTable   translation table to be used

  zzGetVerLegalTrademarks = zzGetVerData(sVersionBlock, VER_GET_STRINGINFO & sTranslationTable & "\LegalTrademarks", True)

End Function

Function zzGetVerOriginalFilename (sVersionBlock As String, sTranslationTable As String) As String

 ' Description:
 '  Get Version Original File Name
 
 ' Parameters:
 '  sVersionBlock       string holding version information
 '  sTranslationTable   translation table to be used
  
  zzGetVerOriginalFilename = zzGetVerData(sVersionBlock, VER_GET_STRINGINFO & sTranslationTable & "\OriginalFilename", True)

End Function

Function zzGetVerPrivateBuild (sVersionBlock As String, sTranslationTable As String) As String

 ' Description:
 '  Get Version Private Build Information
 
 ' Parameters:
 '  sVersionBlock       string holding version information
 '  sTranslationTable   translation table to be used

  zzGetVerPrivateBuild = zzGetVerData(sVersionBlock, VER_GET_STRINGINFO & sTranslationTable & "\PrivateBuild", True)

End Function

Function zzGetVerProductName (sVersionBlock As String, sTranslationTable As String) As String

 ' Description:
 '  Get Version Product Name

 ' Parameters:
 '  sVersionBlock       string holding version information
 '  sTranslationTable   translation table to be used

  zzGetVerProductName = zzGetVerData(sVersionBlock, VER_GET_STRINGINFO & sTranslationTable & "\ProductName", True)

End Function

Function zzGetVerProductVersion (sVersionBlock As String, sTranslationTable As String) As String

 ' Description:
 '  Get Version Product Version

 ' Parameters:
 '  sVersionBlock       string holding version information
 '  sTranslationTable   translation table to be used

  zzGetVerProductVersion = zzGetVerData(sVersionBlock, VER_GET_STRINGINFO & sTranslationTable & "\ProductVersion", True)

End Function

Function zzGetVerSpecialBuild (sVersionBlock As String, sTranslationTable As String) As String

 ' Description:
 '  Get Version Special Build

 ' Parameters:
 '  sVersionBlock       string holding version information
 '  sTranslationTable   translation table to be used

  zzGetVerSpecialBuild = zzGetVerData(sVersionBlock, VER_GET_STRINGINFO & sTranslationTable & "\SpecialBuild", True)

End Function

Function zzInstallFile (ByVal sSrcFile$, ByVal sDestFile$, ByVal sSrcPath$, ByVal sDestPath$, sVerOfSrcFile$, sVerOfDestFile$, lInstallResult&) As Long

 ' Description:
 '  Install file using "VER.DLL". Returns the
 '  size of the file if successful or if newer
 '  version already exists.

 ' Parameters:
 ' Input:
 '  sSrcFile             file to be installed
 '  sDestFile            file to be created
 '  sSrcPath             directory of file to be installed
 '  sDestPath            directory of file to be created
 ' Both:
 '  sVerOfSrcFile        version level of file to be installed
 '  sVerOfDestFile       version level of file to be created
 ' Output:
 '  lInstallResult       result of install

 ' Variables:
  Dim OFStructRec        As OFStructType ' structure for "OpenFile" API
					 
  ReDim asArray(1 To 1)  As String       ' translation tables

  Dim bDeleteResult      As Integer      ' result of delete
  Dim bInstallComplete   As Integer      ' install attempt complete

  Dim nButton            As Integer      ' message button selected
  Dim nTmpFileLength     As Integer      ' temporary work file length
  Dim nTTCount           As Integer      ' count translation tables
  
  Dim sCurrDir           As String       ' directory containing current version
  Dim sExpandedName      As String       ' expanded file name
  Dim sMBText            As String       ' message box text
  Dim sTmpFile           As String       ' temporary work file
  Dim sTranslationTable  As String       ' version stamping parameters
  Dim sVerBlock          As String       ' version stamping parameters
  Dim sVerDestFile       As String       ' version of destination file
  Dim sVerSrcFile        As String       ' version of source file

  ' assume did not install
  bInstallComplete = False
  
  ' loop until file copied
  ' or process aborted
  Do

    ' get version level of source file
    sVerSrcFile = sSrcPath & sSrcFile
    sVerBlock = zzGetVerBlock(sVerSrcFile)
    Call zzGetTranslationTable(sVerBlock, asArray(), nTTCount)
    sTranslationTable = asArray(1)
    sVerOfSrcFile = zzGetVerFileVersion(sVerBlock, sTranslationTable)
    
    ' get version level of destination file
    sVerDestFile = sDestPath & sDestFile
    sVerBlock = zzGetVerBlock(sVerDestFile)
    Call zzGetTranslationTable(sVerBlock, asArray(), nTTCount)
    sTranslationTable = asArray(1)
    sVerOfDestFile = zzGetVerFileVersion(sVerBlock, sTranslationTable)

    ' if both files have version information
    ' don't install if older file
    If Len(sVerOfSrcFile) <> 0 And Len(sVerOfDestFile) <> 0 Then
      If sVerOfSrcFile <= sVerOfDestFile Then
	lInstallResult = VIF_SRCOLD
	bInstallComplete = True
	Exit Do
      End If
    End If

    ' setup parameters for API call
    sCurrDir = String$(260, 0)
    sTmpFile = String$(260, 0)
    nTmpFileLength = 260

    ' handle bad "ver.dll"
    On Error Resume Next

zzInstallFileTag1:

    ' reset return code
    lInstallResult = 0

    ' call API to install file with no special flags
    lInstallResult = VerInstallFile(VIFF_NONE, sSrcFile, sDestFile, sSrcPath, sDestPath, sCurrDir, sTmpFile, nTmpFileLength)

    ' some kind of API error so assume bad "ver.dll"
    If lInstallResult = 0 Then
      If Err <> 0 Then lInstallResult = VIF_BADVERSION
    End If
  
    ' turn off error handler
    On Error GoTo 0
    
    ' install worked ok
    If lInstallResult = 0 Then
      bInstallComplete = True

    ' source older than existing file
    ElseIf (lInstallResult And VIF_SRCOLD) = VIF_SRCOLD Then
      bInstallComplete = True
  
    ' if different language type
    ElseIf (lInstallResult And VIF_DIFFLANG) = VIF_DIFFLANG Then

      ' force install even though different language
      lInstallResult = VerInstallFile(VIFF_FORCEINSTALL, sSrcFile, sDestFile, sSrcPath, sDestPath, sCurrDir, sTmpFile, nTmpFileLength)
      bInstallComplete = True

    ' if cannot handle split compressed files
    ElseIf (lInstallResult And VIF_CANNOTREADSRC) = VIF_CANNOTREADSRC Then

      ' Use VB's FileCopy statement
      On Error Resume Next
      FileCopy sSrcPath & sSrcFile, sDestPath & sDestFile
      If Err = 0 Then
	lInstallResult = 0
	On Error GoTo 0
      Else
	lInstallResult = VIF_CANNOTCOPY
	On Error GoTo 0
      End If
      bInstallComplete = True
  
    ' other errors
    Else
    
      ' destination file is currently in use
      If (lInstallResult And VIF_FILEINUSE) = VIF_FILEINUSE Then

	' build message
	sMBText = UCase$(sDestFile) & " is in use. "
	sMBText = sMBText & "You may ""Abort"" the installation, "
	sMBText = sMBText & "close all applications and ""Retry"", "
	sMBText = sMBText & "or ""Ignore"" this error and proceed."

	' give use option to abort, ignore, or retry
	nButton = MsgBox(sMBText, MB_ABORTRETRYIGNORE Or MB_ICONQUESTION Or MB_DEFBUTTON3)
	
	' do not install this file
	If nButton = IDABORT Then Exit Do

	' pretend it installed and get size of file in use
	If nButton = IDIGNORE Then bInstallComplete = True
     
      ' file could not be installed
      Else

	' leave loop cannot install
	Exit Do
      
      End If
  
    End If

    ' if temporary file was created then delete it
    If (lInstallResult And VIF_TEMPFILE) = VIF_TEMPFILE Then
      bDeleteResult = OpenFile(sTmpFile, OFStructRec, OF_DELETE)
    End If

  Loop Until bInstallComplete

  ' return length of file installed
  If bInstallComplete Then
    
    ' return length of target file
    ' that was just installed
    zzInstallFile = FileLen(sDestPath & sDestFile)
  
  ' return nothing if file not copied
  Else
    zzInstallFile = 0
  End If

End Function

Function zzInstallFileName (ByVal sCompFile$) As String

 ' Description:
 '  Get expanded name of compressed file

 ' Parameters:
 '  sCompFile              compressed file

 ' Variables
  Dim nRC       As Integer ' return code
  Dim sFileName As String  ' expanded name

  ' setup expanded name field
  sFileName = String$(260, 0)
  
  ' handle errors
  On Error Resume Next

  ' get expanded name
  nRC = GetExpandedNameAPI(sCompFile, sFileName)

  ' remove trash
  sFileName = Left$(sFileName, InStr(sFileName, gsCHR_NUL) - 1)

  ' if nothing return compressed name
  If sFileName = gsEMPTY Then sFileName = sCompFile

  ' return to caller
  zzInstallFileName = sFileName

End Function

Function zzVERGetFileCompany (ByVal sFile$) As String

 ' Description:
 '  Get description of file from version
 '  information within file itself.

 ' Parameters:
 '  sFile            file to analysis

 ' Variables:
  Dim nTTCount                 As Integer ' count of tables
  Dim sVersionBlock            As String  ' version information
  
  ReDim asTranslationTable(10) As String  ' translation table

  ' get version block and translation table
  sVersionBlock = zzGetVerBlock(sFile)
  Call zzGetTranslationTable(sVersionBlock, asTranslationTable(), nTTCount)

  ' if translation table found then
  If nTTCount > 0 Then
    
    ' get description
    zzVERGetFileCompany = zzGetVerCompanyName(sVersionBlock, asTranslationTable(1))

  ' else nothing to get
  Else
    zzVERGetFileCompany = gsEMPTY
  End If
  
End Function

Function zzVERGetFileDescription (ByVal sFile$) As String

 ' Description:
 '  Get description of file from version
 '  information within file itself.

 ' Parameters:
 '  sFile            file to analysis

 ' Variables:
  Dim nTTCount                 As Integer ' count of tables
  Dim sVersionBlock            As String  ' version information
  
  ReDim asTranslationTable(10) As String  ' translation table

  ' get version block and translation table
  sVersionBlock = zzGetVerBlock(sFile)
  Call zzGetTranslationTable(sVersionBlock, asTranslationTable(), nTTCount)

  ' if translation table found then
  If nTTCount > 0 Then
    
    ' get description
    zzVERGetFileDescription = zzGetVerFileDescription(sVersionBlock, asTranslationTable(1))

  ' else nothing to get
  Else
    zzVERGetFileDescription = gsEMPTY
  End If
  
End Function

Function zzVERGetFileVersion (ByVal sFile$) As String

 ' Description:
 '  Get version of file from version
 '  information within file itself.

 ' Parameters:
 '  sFile            file to analysis

 ' Variables:
  Dim nTTCount                 As Integer ' count of tables
  Dim sVersionBlock            As String  ' version information
  
  ReDim asTranslationTable(10) As String  ' translation table

  ' get version block and translation table
  sVersionBlock = zzGetVerBlock(sFile)
  Call zzGetTranslationTable(sVersionBlock, asTranslationTable(), nTTCount)

  ' if translation table found then
  If nTTCount > 0 Then
    
    ' get description
    zzVERGetFileVersion = zzGetVerFileVersion(sVersionBlock, asTranslationTable(1))

  ' else nothing to get
  Else
    zzVERGetFileVersion = gsEMPTY
  End If
  
End Function

