Option Explicit
  
  ' textbox messages
  Const WM_GETFONT = &H31
  Const WM_USER = &H400
  Const EM_GETRECT = (WM_USER + 2)
  Const EM_LINESCROLL = (WM_USER + 6)
  Const EM_GETLINECOUNT = (WM_USER + 10)
  Const EM_SETTABSTOPS = (WM_USER + 27)
  Const EM_SETREADONLY = (WM_USER + 31)

Function zzLBBaseUnitsToTextWidth (ByVal nBaseUnits%) As Integer

 ' Description:
 '  Convert "x" number of base units to a textwidth value.
 '  Used to determine tab settings of a list box.

 ' Parameters:
 '  nBaseUnits             base units to convert
  
 ' Variables:
  Dim lBU       As Long    ' base units
  
  ' get dialog base units
  lBU = GetDialogBaseUnits() And Not &HFFFF0000
  
  ' convert base units to text width
  zzLBBaseUnitsToTextWidth = nBaseUnits * ((lBU * Screen.TwipsPerPixelX) / 4)

End Function

Sub zzTBGoToEnd (ByVal hWndtxtBox%, ByVal nVisibleLines%)

 ' Description:
 '  Put last line of text box at bottom of text box

 ' Parameters:
 '  hWndtxtBox      text box to position
 '  nVisibleLine    number of visible lines

 ' Variables:
  Dim lLastLine As Long             ' last line
  Dim nRC       As Integer          ' API return code

  ' calculate last line
  lLastLine = zzTBLineCount(hWndtxtBox) - nVisibleLines
  If lLastLine < 0 Then lLastLine = 0
  
  ' position at that location
  nRC = SendMessageBynum(hWndtxtBox, EM_LINESCROLL, 0, lLastLine)

  ' refresh text box
  Call InvalidateRect(hWndtxtBox, 0&, False)
  DoEvents

End Sub

Function zzTBLineCount (ByVal hWndtxtBox%) As Long

 ' Description:
 '  Get number of line in a text box

 ' Parameters:
 '  hWndtxtBox    handle of text box to get line count for
 
  ' return number of lines in text box
  zzTBLineCount = SendMessageBynum(hWndtxtBox, EM_GETLINECOUNT, 0, 0&)

End Function

Function zzTBReadOnly (ByVal hWnd%) As Integer

 ' Description:
 '  Makes text box read only

 ' Parameters:
 '  hWnd             handle for text box

  ' set text box to read only
  zzTBReadOnly = SendMessage(hWnd, EM_SETREADONLY, 1, 0)

End Function

Function zzTBVisibleLines (ByVal hWndtxtBox%) As Integer
 
 ' Description:
 '  Determines the number of lines
 '  actually visible in a text box.
 
 ' Parameters:
 '  hWndtxtBox          handle of text box to get line count for

 ' Variables:
  Dim nFont As Integer                ' logical font handle
  Dim nOldFont As Integer             ' old font handle
  Dim nRC As Integer                  ' API return code
  
  Dim hDC As Integer                  ' device context
  
  Dim RECTRec       As RECT           ' rectangle
  Dim TEXTMETRICRec As TEXTMETRIC     ' text characteristics

  ' Get the formatting rectangle - this describes the
  ' rectangle in the control in which text is placed.
  nRC = SendMessage(hWndtxtBox, EM_GETRECT, 0, RECTRec)

  ' Get a handle to the logical font used by the control.
  ' The VB font properties are accurately reflected by
  ' this logical font.
  On Error Resume Next
  nFont = SendMessageBynum(hWndtxtBox, WM_GETFONT, 0, 0&)
  On Error GoTo 0
    
  ' get a device context to the text control.
  hDC = GetDC(hWndtxtBox)

  ' select in the logical font to obtain the exact font metrics.
  If nFont <> 0 Then nOldFont = SelectObject(hDC, nFont)

  ' get font info
  nRC = GetTextMetrics(hDC, TEXTMETRICRec)

  ' select out the logical font
  If nFont <> 0 Then nFont = SelectObject(hDC, nOldFont)

  ' the lines depends on the formatting rectangle and font height
  zzTBVisibleLines = (RECTRec.Bottom - RECTRec.Top) / TEXTMETRICRec.tmHeight

  ' Release the device context when done.
  nRC = ReleaseDC(hWndtxtBox, hDC)

End Function

