Option Explicit

Sub zzToolTip (frm As Form, frmToolTips As Form, ByVal nLeft%, ByVal nTop%, ByVal sTip$)

 ' Description:
 '  Show tool tip specified. Requires that you pass the form for
 '  which the tooltip will be shown. The tooltip form referenced
 '  must have a control named lblToolTips that will be used to
 '  display the tooltip

 ' Parameters:
 '  frm             main form reference
 '  frmToolTips     tooltips form reference
 '  nLeft           main form X location
 '  nTop            main form Y location
 '  sTip            tool tip text

 ' Variables:
  Dim nFormHeight1  As Integer
  Dim nFormHeight2  As Integer
  Dim nFormLeft1    As Integer
  Dim nFormLeft2    As Integer
  Dim nFormTop1     As Integer
  Dim nFormTop2     As Integer
  Dim nFormWidth1   As Integer
  Dim nFormWidth2   As Integer
  Dim nRC           As Integer
  Dim rClient       As RECT
  Dim rWindow       As RECT

  ' if not blank
  If sTip <> gsEMPTY Then

    ' get forms windowing info
    GetClientRect frm.hWnd, rClient
    GetWindowRect frm.hWnd, rWindow

    ' convert to twips info
    Call zzFormLocation(rClient, nFormLeft1, nFormTop1, nFormWidth1, nFormHeight1)
    Call zzFormLocation(rWindow, nFormLeft2, nFormTop2, nFormWidth2, nFormHeight2)

    ' set top as relative location to main form
    frmToolTips.Top = nFormTop2 + (nFormHeight2 - nFormHeight1) + nTop

    ' setup left as relative location to main form
    If nFormLeft2 + (nFormWidth2 - nFormWidth1) + nLeft + frmToolTips.TextWidth(sTip) + 180 > Screen.Width Then
      frmToolTips.Left = Screen.Width - (frmToolTips.TextWidth(sTip) + 180)
    Else
      frmToolTips.Left = nFormLeft2 + (nFormWidth2 - nFormWidth1) + nLeft
    End If

    ' set width of tool tips form based on length of tip
    frmToolTips.Width = frmToolTips.TextWidth(sTip) + 120

    ' set height of tool tips form based on height of tip
    frmToolTips.Height = frmToolTips.TextHeight(sTip) + 60

    ' set text
    frmToolTips!lblToolTips = sTip

    ' show tool tip without resetting focus to tooltip form
    nRC = ShowWindow(frmToolTips.hWnd, 4)

  Else
  
    ' hide tool tips
    frmToolTips.Hide
  
  End If

End Sub

