Option Explicit

Sub zzShell (ByVal sCommand$, ByVal nStyle%)

 ' Description:
 '  Execute shelled program until done

 ' Parameters:
 '  sCommmand               command string to execute
 '  nStyle                  windows style

 ' Variables:
  Dim hModule As Integer   ' module handle

  ' run until done
  hModule = Shell(sCommand, nStyle)
  Do: DoEvents: Loop Until GetModuleUsage(hModule) = 0

End Sub

Sub zzSwapInt (n1%, n2%)

  ' swap two integers
  Dim n3 As Integer
  n3 = n1
  n1 = n2
  n2 = n3

End Sub

Sub zzTimeWait (ByVal nSeconds%)

 ' Description:
 '  Wait a specified number of seconds

 ' Parameters:
 '  nSeconds             number of seconds to wait

 ' Variables:
  Dim Start As Single    ' start time
  
  ' get current time
  Start = Timer

  ' loop til seconds have expired
  While Timer < (Start + nSeconds + 1)
    DoEvents
  Wend

End Sub

Function zzVBRunning (frm As Form) As Integer

 ' Description:
 '  Returns True if running application in design mode

 ' Parameters:
 '  frm                             form reference

 ' Constants
  Const GWW_HINSTANCE& = (-6)       ' get window instance handle

 ' Variables:
  Dim hInst            As Integer   ' instance handle
  Dim nModuleLen       As Integer   ' module name length
  Dim sBuffer          As String    ' work space
  Dim sModuleFileName  As String    ' module name
    
  ' make buffer big enough
  sBuffer = Space$(256)
    
  ' get instance handle
  hInst = GetWindowWord(frm.hWnd, GWW_HINSTANCE)
  
  ' get module name
  nModuleLen = GetModuleFileName(hInst, sBuffer, Len(sBuffer))
  sModuleFileName = UCase$(Left$(sBuffer, nModuleLen))
  
  ' search for VB.EXE in name
  zzVBRunning = InStr(sModuleFileName, "\VB.EXE") > 0 Or InStr(sModuleFileName, "\VB2.EXE") > 0

End Function

