Option Explicit
 
 ' Description:
 '  This module contains procedures required
 '  to perform ASCII to EBCDIC translations

 ' Variables:
  Dim asTableAtoE(0 To 255) As String * 1   ' ASCII to EBCBIC table
  Dim asTableEtoA(0 To 255) As String * 1   ' EBCBIC to ASCII table


Function zzStrASCIItoEBCDIC (ByVal sASCII$) As String

 ' Description:
 '  Converts ASCII string to EBCDIC string

 ' Parameters:
 '  sASCII                  ASCII string to convert

 ' Variables:
  Dim n1      As Integer    ' loop counter
  Dim sEBCDIC As String     ' EBCDIC string

  ' make sure tables setup
  Call zzStrTablesSetup

  ' for each letter in source
  ' convert to EBCDIC and add to target
  For n1 = 1 To Len(sASCII)
    sEBCDIC = sEBCDIC & asTableAtoE(Asc(Mid$(sASCII, n1, 1)))
  Next n1

  ' return as function value
  zzStrASCIItoEBCDIC = sEBCDIC

End Function

Function zzStrEBCDICtoASCII (ByVal sEBCDIC$) As String

 ' Description:
 '  Converts EBCDIC string to ASCII string
 
 ' Parameters:
 '  sEBCDIC                 EBCDIC string to convert

 ' Variables:
  Dim n1      As Integer    ' loop counter
  Dim sASCII  As String     ' ASCII string

  ' make sure tables setup
  Call zzStrTablesSetup

  ' for each letter in source
  ' convert to EBCDIC and add to target
  For n1 = 1 To Len(sEBCDIC)
    sASCII = sASCII & asTableEtoA(Asc(Mid$(sEBCDIC, n1, 1)))
  Next n1

  ' return as function value
  zzStrEBCDICtoASCII = sASCII

End Function

Sub zzStrTablesSetup ()

 ' Description:
 '  Setup translation tables

 ' Variables:
  Static bTablesSetup     As Integer ' tables have been setup flag

  ' tables have been setup
  If bTablesSetup Then
    
  ' tables have not been setup
  Else

    ' ASCII to EBCDIC table
    asTableAtoE(0) = Chr$(0)
    asTableAtoE(1) = Chr$(1)
    asTableAtoE(2) = Chr$(2)
    asTableAtoE(3) = Chr$(3)
    asTableAtoE(4) = Chr$(55)
    asTableAtoE(5) = Chr$(45)
    asTableAtoE(6) = Chr$(46)
    asTableAtoE(7) = Chr$(47)
    asTableAtoE(8) = Chr$(22)
    asTableAtoE(9) = Chr$(5)
    asTableAtoE(10) = Chr$(37)
    asTableAtoE(11) = Chr$(11)
    asTableAtoE(12) = Chr$(12)
    asTableAtoE(13) = Chr$(13)
    asTableAtoE(14) = Chr$(14)
    asTableAtoE(15) = Chr$(15)
    asTableAtoE(16) = Chr$(16)
    asTableAtoE(17) = Chr$(17)
    asTableAtoE(18) = Chr$(18)
    asTableAtoE(19) = Chr$(19)
    asTableAtoE(20) = Chr$(182)
    asTableAtoE(21) = Chr$(181)
    asTableAtoE(22) = Chr$(50)
    asTableAtoE(23) = Chr$(38)
    asTableAtoE(24) = Chr$(24)
    asTableAtoE(25) = Chr$(25)
    asTableAtoE(26) = Chr$(63)
    asTableAtoE(27) = Chr$(39)
    asTableAtoE(28) = Chr$(28)
    asTableAtoE(29) = Chr$(29)
    asTableAtoE(30) = Chr$(30)
    asTableAtoE(31) = Chr$(31)
    asTableAtoE(32) = Chr$(64)
    asTableAtoE(33) = Chr$(90)
    asTableAtoE(34) = Chr$(127)
    asTableAtoE(35) = Chr$(123)
    asTableAtoE(36) = Chr$(91)
    asTableAtoE(37) = Chr$(108)
    asTableAtoE(38) = Chr$(80)
    asTableAtoE(39) = Chr$(125)
    asTableAtoE(40) = Chr$(77)
    asTableAtoE(41) = Chr$(93)
    asTableAtoE(42) = Chr$(92)
    asTableAtoE(43) = Chr$(78)
    asTableAtoE(44) = Chr$(107)
    asTableAtoE(45) = Chr$(96)
    asTableAtoE(46) = Chr$(75)
    asTableAtoE(47) = Chr$(97)
    asTableAtoE(48) = Chr$(240)
    asTableAtoE(49) = Chr$(241)
    asTableAtoE(50) = Chr$(242)
    asTableAtoE(51) = Chr$(243)
    asTableAtoE(52) = Chr$(244)
    asTableAtoE(53) = Chr$(245)
    asTableAtoE(54) = Chr$(246)
    asTableAtoE(55) = Chr$(247)
    asTableAtoE(56) = Chr$(248)
    asTableAtoE(57) = Chr$(249)
    asTableAtoE(58) = Chr$(122)
    asTableAtoE(59) = Chr$(94)
    asTableAtoE(60) = Chr$(76)
    asTableAtoE(61) = Chr$(126)
    asTableAtoE(62) = Chr$(110)
    asTableAtoE(63) = Chr$(111)
    asTableAtoE(64) = Chr$(124)
    asTableAtoE(65) = Chr$(193)
    asTableAtoE(66) = Chr$(194)
    asTableAtoE(67) = Chr$(195)
    asTableAtoE(68) = Chr$(196)
    asTableAtoE(69) = Chr$(197)
    asTableAtoE(70) = Chr$(198)
    asTableAtoE(71) = Chr$(199)
    asTableAtoE(72) = Chr$(200)
    asTableAtoE(73) = Chr$(201)
    asTableAtoE(74) = Chr$(209)
    asTableAtoE(75) = Chr$(210)
    asTableAtoE(76) = Chr$(211)
    asTableAtoE(77) = Chr$(212)
    asTableAtoE(78) = Chr$(213)
    asTableAtoE(79) = Chr$(214)
    asTableAtoE(80) = Chr$(215)
    asTableAtoE(81) = Chr$(216)
    asTableAtoE(82) = Chr$(217)
    asTableAtoE(83) = Chr$(226)
    asTableAtoE(84) = Chr$(227)
    asTableAtoE(85) = Chr$(228)
    asTableAtoE(86) = Chr$(229)
    asTableAtoE(87) = Chr$(230)
    asTableAtoE(88) = Chr$(231)
    asTableAtoE(89) = Chr$(232)
    asTableAtoE(90) = Chr$(233)
    asTableAtoE(91) = Chr$(186)
    asTableAtoE(92) = Chr$(224)
    asTableAtoE(93) = Chr$(187)
    asTableAtoE(94) = Chr$(176)
    asTableAtoE(95) = Chr$(109)
    asTableAtoE(96) = Chr$(121)
    asTableAtoE(97) = Chr$(129)
    asTableAtoE(98) = Chr$(130)
    asTableAtoE(99) = Chr$(131)
    asTableAtoE(100) = Chr$(132)
    asTableAtoE(101) = Chr$(133)
    asTableAtoE(102) = Chr$(134)
    asTableAtoE(103) = Chr$(135)
    asTableAtoE(104) = Chr$(136)
    asTableAtoE(105) = Chr$(137)
    asTableAtoE(106) = Chr$(145)
    asTableAtoE(107) = Chr$(146)
    asTableAtoE(108) = Chr$(147)
    asTableAtoE(109) = Chr$(148)
    asTableAtoE(110) = Chr$(149)
    asTableAtoE(111) = Chr$(150)
    asTableAtoE(112) = Chr$(151)
    asTableAtoE(113) = Chr$(152)
    asTableAtoE(114) = Chr$(153)
    asTableAtoE(115) = Chr$(162)
    asTableAtoE(116) = Chr$(163)
    asTableAtoE(117) = Chr$(164)
    asTableAtoE(118) = Chr$(165)
    asTableAtoE(119) = Chr$(166)
    asTableAtoE(120) = Chr$(167)
    asTableAtoE(121) = Chr$(168)
    asTableAtoE(122) = Chr$(169)
    asTableAtoE(123) = Chr$(192)
    asTableAtoE(124) = Chr$(79)
    asTableAtoE(125) = Chr$(208)
    asTableAtoE(126) = Chr$(161)
    asTableAtoE(127) = Chr$(255)
    asTableAtoE(128) = Chr$(104)
    asTableAtoE(129) = Chr$(220)
    asTableAtoE(130) = Chr$(81)
    asTableAtoE(131) = Chr$(66)
    asTableAtoE(132) = Chr$(67)
    asTableAtoE(133) = Chr$(68)
    asTableAtoE(134) = Chr$(71)
    asTableAtoE(135) = Chr$(72)
    asTableAtoE(136) = Chr$(82)
    asTableAtoE(137) = Chr$(83)
    asTableAtoE(138) = Chr$(84)
    asTableAtoE(139) = Chr$(87)
    asTableAtoE(140) = Chr$(86)
    asTableAtoE(141) = Chr$(88)
    asTableAtoE(142) = Chr$(99)
    asTableAtoE(143) = Chr$(103)
    asTableAtoE(144) = Chr$(113)
    asTableAtoE(145) = Chr$(156)
    asTableAtoE(146) = Chr$(158)
    asTableAtoE(147) = Chr$(203)
    asTableAtoE(148) = Chr$(204)
    asTableAtoE(149) = Chr$(205)
    asTableAtoE(150) = Chr$(219)
    asTableAtoE(151) = Chr$(221)
    asTableAtoE(152) = Chr$(223)
    asTableAtoE(153) = Chr$(236)
    asTableAtoE(154) = Chr$(252)
    asTableAtoE(155) = Chr$(74)
    asTableAtoE(156) = Chr$(177)
    asTableAtoE(157) = Chr$(178)
    asTableAtoE(158) = Chr$(191)
    asTableAtoE(159) = Chr$(7)
    asTableAtoE(160) = Chr$(69)
    asTableAtoE(161) = Chr$(85)
    asTableAtoE(162) = Chr$(206)
    asTableAtoE(163) = Chr$(222)
    asTableAtoE(164) = Chr$(73)
    asTableAtoE(165) = Chr$(105)
    asTableAtoE(166) = Chr$(154)
    asTableAtoE(167) = Chr$(155)
    asTableAtoE(168) = Chr$(171)
    asTableAtoE(169) = Chr$(175)
    asTableAtoE(170) = Chr$(95)
    asTableAtoE(171) = Chr$(184)
    asTableAtoE(172) = Chr$(183)
    asTableAtoE(173) = Chr$(170)
    asTableAtoE(174) = Chr$(138)
    asTableAtoE(175) = Chr$(139)
    asTableAtoE(176) = Chr$(43)
    asTableAtoE(177) = Chr$(44)
    asTableAtoE(178) = Chr$(9)
    asTableAtoE(179) = Chr$(33)
    asTableAtoE(180) = Chr$(40)
    asTableAtoE(181) = Chr$(101)
    asTableAtoE(182) = Chr$(98)
    asTableAtoE(183) = Chr$(100)
    asTableAtoE(184) = Chr$(180)
    asTableAtoE(185) = Chr$(56)
    asTableAtoE(186) = Chr$(49)
    asTableAtoE(187) = Chr$(52)
    asTableAtoE(188) = Chr$(51)
    asTableAtoE(189) = Chr$(112)
    asTableAtoE(190) = Chr$(128)
    asTableAtoE(191) = Chr$(36)
    asTableAtoE(192) = Chr$(34)
    asTableAtoE(193) = Chr$(23)
    asTableAtoE(194) = Chr$(41)
    asTableAtoE(195) = Chr$(6)
    asTableAtoE(196) = Chr$(32)
    asTableAtoE(197) = Chr$(42)
    asTableAtoE(198) = Chr$(70)
    asTableAtoE(199) = Chr$(102)
    asTableAtoE(200) = Chr$(26)
    asTableAtoE(201) = Chr$(53)
    asTableAtoE(202) = Chr$(8)
    asTableAtoE(203) = Chr$(57)
    asTableAtoE(204) = Chr$(54)
    asTableAtoE(205) = Chr$(48)
    asTableAtoE(206) = Chr$(58)
    asTableAtoE(207) = Chr$(159)
    asTableAtoE(208) = Chr$(140)
    asTableAtoE(209) = Chr$(172)
    asTableAtoE(210) = Chr$(114)
    asTableAtoE(211) = Chr$(115)
    asTableAtoE(212) = Chr$(116)
    asTableAtoE(213) = Chr$(10)
    asTableAtoE(214) = Chr$(117)
    asTableAtoE(215) = Chr$(118)
    asTableAtoE(216) = Chr$(119)
    asTableAtoE(217) = Chr$(35)
    asTableAtoE(218) = Chr$(21)
    asTableAtoE(219) = Chr$(20)
    asTableAtoE(220) = Chr$(4)
    asTableAtoE(221) = Chr$(106)
    asTableAtoE(222) = Chr$(120)
    asTableAtoE(223) = Chr$(59)
    asTableAtoE(224) = Chr$(238)
    asTableAtoE(225) = Chr$(89)
    asTableAtoE(226) = Chr$(235)
    asTableAtoE(227) = Chr$(237)
    asTableAtoE(228) = Chr$(207)
    asTableAtoE(229) = Chr$(239)
    asTableAtoE(230) = Chr$(160)
    asTableAtoE(231) = Chr$(142)
    asTableAtoE(232) = Chr$(174)
    asTableAtoE(233) = Chr$(254)
    asTableAtoE(234) = Chr$(251)
    asTableAtoE(235) = Chr$(253)
    asTableAtoE(236) = Chr$(141)
    asTableAtoE(237) = Chr$(173)
    asTableAtoE(238) = Chr$(188)
    asTableAtoE(239) = Chr$(190)
    asTableAtoE(240) = Chr$(202)
    asTableAtoE(241) = Chr$(143)
    asTableAtoE(242) = Chr$(27)
    asTableAtoE(243) = Chr$(185)
    asTableAtoE(244) = Chr$(60)
    asTableAtoE(245) = Chr$(61)
    asTableAtoE(246) = Chr$(225)
    asTableAtoE(247) = Chr$(157)
    asTableAtoE(248) = Chr$(144)
    asTableAtoE(249) = Chr$(189)
    asTableAtoE(250) = Chr$(179)
    asTableAtoE(251) = Chr$(218)
    asTableAtoE(252) = Chr$(250)
    asTableAtoE(253) = Chr$(234)
    asTableAtoE(254) = Chr$(62)
    asTableAtoE(255) = Chr$(65)

    ' EBCDIC to ASCII table
    asTableEtoA(0) = Chr$(0)
    asTableEtoA(1) = Chr$(1)
    asTableEtoA(2) = Chr$(2)
    asTableEtoA(3) = Chr$(3)
    asTableEtoA(4) = Chr$(220)
    asTableEtoA(5) = Chr$(9)
    asTableEtoA(6) = Chr$(195)
    asTableEtoA(7) = Chr$(159)
    asTableEtoA(8) = Chr$(202)
    asTableEtoA(9) = Chr$(178)
    asTableEtoA(10) = Chr$(213)
    asTableEtoA(11) = Chr$(11)
    asTableEtoA(12) = Chr$(12)
    asTableEtoA(13) = Chr$(13)
    asTableEtoA(14) = Chr$(14)
    asTableEtoA(15) = Chr$(15)
    asTableEtoA(16) = Chr$(16)
    asTableEtoA(17) = Chr$(17)
    asTableEtoA(18) = Chr$(18)
    asTableEtoA(19) = Chr$(19)
    asTableEtoA(20) = Chr$(219)
    asTableEtoA(21) = Chr$(218)
    asTableEtoA(22) = Chr$(8)
    asTableEtoA(23) = Chr$(193)
    asTableEtoA(24) = Chr$(24)
    asTableEtoA(25) = Chr$(25)
    asTableEtoA(26) = Chr$(200)
    asTableEtoA(27) = Chr$(242)
    asTableEtoA(28) = Chr$(28)
    asTableEtoA(29) = Chr$(29)
    asTableEtoA(30) = Chr$(30)
    asTableEtoA(31) = Chr$(31)
    asTableEtoA(32) = Chr$(196)
    asTableEtoA(33) = Chr$(179)
    asTableEtoA(34) = Chr$(192)
    asTableEtoA(35) = Chr$(217)
    asTableEtoA(36) = Chr$(191)
    asTableEtoA(37) = Chr$(10)
    asTableEtoA(38) = Chr$(23)
    asTableEtoA(39) = Chr$(27)
    asTableEtoA(40) = Chr$(180)
    asTableEtoA(41) = Chr$(194)
    asTableEtoA(42) = Chr$(197)
    asTableEtoA(43) = Chr$(176)
    asTableEtoA(44) = Chr$(177)
    asTableEtoA(45) = Chr$(5)
    asTableEtoA(46) = Chr$(6)
    asTableEtoA(47) = Chr$(7)
    asTableEtoA(48) = Chr$(205)
    asTableEtoA(49) = Chr$(186)
    asTableEtoA(50) = Chr$(22)
    asTableEtoA(51) = Chr$(188)
    asTableEtoA(52) = Chr$(187)
    asTableEtoA(53) = Chr$(201)
    asTableEtoA(54) = Chr$(204)
    asTableEtoA(55) = Chr$(4)
    asTableEtoA(56) = Chr$(185)
    asTableEtoA(57) = Chr$(203)
    asTableEtoA(58) = Chr$(206)
    asTableEtoA(59) = Chr$(223)
    asTableEtoA(60) = Chr$(244)
    asTableEtoA(61) = Chr$(245)
    asTableEtoA(62) = Chr$(254)
    asTableEtoA(63) = Chr$(26)
    asTableEtoA(64) = Chr$(32)
    asTableEtoA(65) = Chr$(255)
    asTableEtoA(66) = Chr$(131)
    asTableEtoA(67) = Chr$(132)
    asTableEtoA(68) = Chr$(133)
    asTableEtoA(69) = Chr$(160)
    asTableEtoA(70) = Chr$(198)
    asTableEtoA(71) = Chr$(134)
    asTableEtoA(72) = Chr$(135)
    asTableEtoA(73) = Chr$(164)
    asTableEtoA(74) = Chr$(155)
    asTableEtoA(75) = Chr$(46)
    asTableEtoA(76) = Chr$(60)
    asTableEtoA(77) = Chr$(40)
    asTableEtoA(78) = Chr$(43)
    asTableEtoA(79) = Chr$(124)
    asTableEtoA(80) = Chr$(38)
    asTableEtoA(81) = Chr$(130)
    asTableEtoA(82) = Chr$(136)
    asTableEtoA(83) = Chr$(137)
    asTableEtoA(84) = Chr$(138)
    asTableEtoA(85) = Chr$(161)
    asTableEtoA(86) = Chr$(140)
    asTableEtoA(87) = Chr$(139)
    asTableEtoA(88) = Chr$(141)
    asTableEtoA(89) = Chr$(225)
    asTableEtoA(90) = Chr$(33)
    asTableEtoA(91) = Chr$(36)
    asTableEtoA(92) = Chr$(42)
    asTableEtoA(93) = Chr$(41)
    asTableEtoA(94) = Chr$(59)
    asTableEtoA(95) = Chr$(170)
    asTableEtoA(96) = Chr$(45)
    asTableEtoA(97) = Chr$(47)
    asTableEtoA(98) = Chr$(182)
    asTableEtoA(99) = Chr$(142)
    asTableEtoA(100) = Chr$(183)
    asTableEtoA(101) = Chr$(181)
    asTableEtoA(102) = Chr$(199)
    asTableEtoA(103) = Chr$(143)
    asTableEtoA(104) = Chr$(128)
    asTableEtoA(105) = Chr$(165)
    asTableEtoA(106) = Chr$(221)
    asTableEtoA(107) = Chr$(44)
    asTableEtoA(108) = Chr$(37)
    asTableEtoA(109) = Chr$(95)
    asTableEtoA(110) = Chr$(62)
    asTableEtoA(111) = Chr$(63)
    asTableEtoA(112) = Chr$(189)
    asTableEtoA(113) = Chr$(144)
    asTableEtoA(114) = Chr$(210)
    asTableEtoA(115) = Chr$(211)
    asTableEtoA(116) = Chr$(212)
    asTableEtoA(117) = Chr$(214)
    asTableEtoA(118) = Chr$(215)
    asTableEtoA(119) = Chr$(216)
    asTableEtoA(120) = Chr$(222)
    asTableEtoA(121) = Chr$(96)
    asTableEtoA(122) = Chr$(58)
    asTableEtoA(123) = Chr$(35)
    asTableEtoA(124) = Chr$(64)
    asTableEtoA(125) = Chr$(39)
    asTableEtoA(126) = Chr$(61)
    asTableEtoA(127) = Chr$(34)
    asTableEtoA(128) = Chr$(190)
    asTableEtoA(129) = Chr$(97)
    asTableEtoA(130) = Chr$(98)
    asTableEtoA(131) = Chr$(99)
    asTableEtoA(132) = Chr$(100)
    asTableEtoA(133) = Chr$(101)
    asTableEtoA(134) = Chr$(102)
    asTableEtoA(135) = Chr$(103)
    asTableEtoA(136) = Chr$(104)
    asTableEtoA(137) = Chr$(105)
    asTableEtoA(138) = Chr$(174)
    asTableEtoA(139) = Chr$(175)
    asTableEtoA(140) = Chr$(208)
    asTableEtoA(141) = Chr$(236)
    asTableEtoA(142) = Chr$(231)
    asTableEtoA(143) = Chr$(241)
    asTableEtoA(144) = Chr$(248)
    asTableEtoA(145) = Chr$(106)
    asTableEtoA(146) = Chr$(107)
    asTableEtoA(147) = Chr$(108)
    asTableEtoA(148) = Chr$(109)
    asTableEtoA(149) = Chr$(110)
    asTableEtoA(150) = Chr$(111)
    asTableEtoA(151) = Chr$(112)
    asTableEtoA(152) = Chr$(113)
    asTableEtoA(153) = Chr$(114)
    asTableEtoA(154) = Chr$(166)
    asTableEtoA(155) = Chr$(167)
    asTableEtoA(156) = Chr$(145)
    asTableEtoA(157) = Chr$(247)
    asTableEtoA(158) = Chr$(146)
    asTableEtoA(159) = Chr$(207)
    asTableEtoA(160) = Chr$(230)
    asTableEtoA(161) = Chr$(126)
    asTableEtoA(162) = Chr$(115)
    asTableEtoA(163) = Chr$(116)
    asTableEtoA(164) = Chr$(117)
    asTableEtoA(165) = Chr$(118)
    asTableEtoA(166) = Chr$(119)
    asTableEtoA(167) = Chr$(120)
    asTableEtoA(168) = Chr$(121)
    asTableEtoA(169) = Chr$(122)
    asTableEtoA(170) = Chr$(173)
    asTableEtoA(171) = Chr$(168)
    asTableEtoA(172) = Chr$(209)
    asTableEtoA(173) = Chr$(237)
    asTableEtoA(174) = Chr$(232)
    asTableEtoA(175) = Chr$(169)
    asTableEtoA(176) = Chr$(94)
    asTableEtoA(177) = Chr$(156)
    asTableEtoA(178) = Chr$(157)
    asTableEtoA(179) = Chr$(250)
    asTableEtoA(180) = Chr$(184)
    asTableEtoA(181) = Chr$(21)
    asTableEtoA(182) = Chr$(20)
    asTableEtoA(183) = Chr$(172)
    asTableEtoA(184) = Chr$(171)
    asTableEtoA(185) = Chr$(243)
    asTableEtoA(186) = Chr$(91)
    asTableEtoA(187) = Chr$(93)
    asTableEtoA(188) = Chr$(238)
    asTableEtoA(189) = Chr$(249)
    asTableEtoA(190) = Chr$(239)
    asTableEtoA(191) = Chr$(158)
    asTableEtoA(192) = Chr$(123)
    asTableEtoA(193) = Chr$(65)
    asTableEtoA(194) = Chr$(66)
    asTableEtoA(195) = Chr$(67)
    asTableEtoA(196) = Chr$(68)
    asTableEtoA(197) = Chr$(69)
    asTableEtoA(198) = Chr$(70)
    asTableEtoA(199) = Chr$(71)
    asTableEtoA(200) = Chr$(72)
    asTableEtoA(201) = Chr$(73)
    asTableEtoA(202) = Chr$(240)
    asTableEtoA(203) = Chr$(147)
    asTableEtoA(204) = Chr$(148)
    asTableEtoA(205) = Chr$(149)
    asTableEtoA(206) = Chr$(162)
    asTableEtoA(207) = Chr$(228)
    asTableEtoA(208) = Chr$(125)
    asTableEtoA(209) = Chr$(74)
    asTableEtoA(210) = Chr$(75)
    asTableEtoA(211) = Chr$(76)
    asTableEtoA(212) = Chr$(77)
    asTableEtoA(213) = Chr$(78)
    asTableEtoA(214) = Chr$(79)
    asTableEtoA(215) = Chr$(80)
    asTableEtoA(216) = Chr$(81)
    asTableEtoA(217) = Chr$(82)
    asTableEtoA(218) = Chr$(251)
    asTableEtoA(219) = Chr$(150)
    asTableEtoA(220) = Chr$(129)
    asTableEtoA(221) = Chr$(151)
    asTableEtoA(222) = Chr$(163)
    asTableEtoA(223) = Chr$(152)
    asTableEtoA(224) = Chr$(92)
    asTableEtoA(225) = Chr$(246)
    asTableEtoA(226) = Chr$(83)
    asTableEtoA(227) = Chr$(84)
    asTableEtoA(228) = Chr$(85)
    asTableEtoA(229) = Chr$(86)
    asTableEtoA(230) = Chr$(87)
    asTableEtoA(231) = Chr$(88)
    asTableEtoA(232) = Chr$(89)
    asTableEtoA(233) = Chr$(90)
    asTableEtoA(234) = Chr$(253)
    asTableEtoA(235) = Chr$(226)
    asTableEtoA(236) = Chr$(153)
    asTableEtoA(237) = Chr$(227)
    asTableEtoA(238) = Chr$(224)
    asTableEtoA(239) = Chr$(229)
    asTableEtoA(240) = Chr$(48)
    asTableEtoA(241) = Chr$(49)
    asTableEtoA(242) = Chr$(50)
    asTableEtoA(243) = Chr$(51)
    asTableEtoA(244) = Chr$(52)
    asTableEtoA(245) = Chr$(53)
    asTableEtoA(246) = Chr$(54)
    asTableEtoA(247) = Chr$(55)
    asTableEtoA(248) = Chr$(56)
    asTableEtoA(249) = Chr$(57)
    asTableEtoA(250) = Chr$(252)
    asTableEtoA(251) = Chr$(234)
    asTableEtoA(252) = Chr$(154)
    asTableEtoA(253) = Chr$(235)
    asTableEtoA(254) = Chr$(233)
    asTableEtoA(255) = Chr$(127)

    ' turn flag on
    bTablesSetup = True

  End If

End Sub

