Option Explicit

 ' Description:
 
 '  Copyright  1994, 1995, 1996
 '  Genesis Software, Inc. ALL RIGHTS RESERVED.
 
 '  The code found herein and all other code modules provided
 '  by Genesis Software, Inc. may not be reproduced, used, or distributed
 '  in any form without permission in writing from Genesis Software,
 '  except for noncommercial, private use and adaptation granted by
 '  U.S. copyright law. Redistribution of this code, or the
 '  distribution of derivative works, is expressly prohibited.
 '  This copyright notice must remain in all private-use copies.
 
 ' Constants:
  Const lDELETE_ENTRY = 0&                              ' cause entry to be removed
  Const nMAX_ENTRY_LENGTH = 255                         ' maximum entry length
  Const sWIN_INI = "WIN.INI"                            ' WIN INI file reference
  
 ' Variables:
  Dim sINIFile         As String                        ' current file
  Dim sINISection      As String                        ' current section
  Dim sINISeperator    As String                        ' current seperator

Function zzINIDelSection (ByVal sSection$) As Integer
 
 ' Description:
 '  Delete a section from an "INI" file.
 
 ' Parameters:
 '  sSection                section to delete

  ' no file or section specified
  If sINIFile = gsEMPTY Or sSection = gsEMPTY Then
    zzINIDelSection = False

  ' WIN.INI used
  ElseIf UCase$(sINIFile) = sWIN_INI Then
    zzINIDelSection = (WriteWININIProfileString(sSection, lDELETE_ENTRY, lDELETE_ENTRY)) <> 0
  
  ' private file
  Else
    zzINIDelSection = (WritePrivateProfileString(sSection, lDELETE_ENTRY, lDELETE_ENTRY, sINIFile)) <> 0
  End If

End Function

Function zzINIDelTopic (ByVal sTopic$) As Integer

 ' Description:
 '  Delete a topic from an "INI" file.
 
 ' Parameters:
 '  sTopic              topic to delete

  ' no file or section specified
  If sINIFile = gsEMPTY Or sINISection = gsEMPTY Or sTopic = gsEMPTY Then
    zzINIDelTopic = False

  ' WIN.INI used
  ElseIf UCase$(sINIFile) = sWIN_INI Then
    zzINIDelTopic = (WriteWININIProfileString(sINISection, sTopic, lDELETE_ENTRY)) <> 0
  
  ' private file
  Else
    zzINIDelTopic = (WritePrivateProfileString(sINISection, sTopic, lDELETE_ENTRY, sINIFile)) <> 0
  End If

End Function

Function zzINIGetInteger (ByVal sTopic$, nValue%) As Integer
 
 ' Description:
 '  Returns integer variable from "INI" file.

 ' Parameters:
 '  sTopic           topic to get
 '  nValue           integer value returned

  ' no file or section or topic specified
  If sINIFile = gsEMPTY Or sINISection = gsEMPTY Or sTopic = gsEMPTY Then
    zzINIGetInteger = False

  ' WIN.INI used
  ElseIf UCase$(sINIFile) = sWIN_INI Then
    nValue = GetProfileInt(sINISection, sTopic, 0)
    zzINIGetInteger = True
  
  ' private file
  Else
    nValue = GetPrivateProfileInt(sINISection, sTopic, 0, sINIFile)
    zzINIGetInteger = True
  End If

End Function

Function zzINIGetIntegerArray (ByVal sTopic$, anArray%(), ByVal nElements%) As Integer

 ' Description:
 '  Returns integer array from ini file.  Reads string
 '  value like "n1,n2,...". Can also handle single numbers
 '  without the seperator including hex values.

 ' Parameters:
 '  sTopic                 topic
 '  anArray                array to contain results
 '  nElements              number of elements
 
 ' Variables:
  Dim nDex                 As Integer    ' loop counter
  Dim nLowerBoundary      As Integer      ' lower boundary of array
  Dim nSepLocation         As Integer    ' seperator location
  Dim sTmp                 As String     ' temporary work string

  ' get entire string
  nDex = zzINIGetString(sTopic, sTmp)
  
  ' if any required parameters not setup
  If sINIFile = gsEMPTY Or sINISection = gsEMPTY Or sTopic = gsEMPTY Or sINISeperator = gsEMPTY Or nElements < 1 Or sTmp = gsEMPTY Then
    zzINIGetIntegerArray = False

  Else

    ' get number of elements
    nLowerBoundary = LBound(anArray)
  
    ' loop for each element
    For nDex = nLowerBoundary To nElements

      ' try to find next seperator location
      nSepLocation = InStr(sTmp, sINISeperator)

      ' if none found then
      If nSepLocation = 0 Then
      
	' use whole string
	nSepLocation = Len(sTmp)
      
	' if nothing left to read exit
	If nSepLocation = 0 Then Exit For

      ' move back one from seperator
      Else
	nSepLocation = nSepLocation - 1
      End If

      ' convert to numeric, remove from string
      anArray(nDex) = Val(Left$(sTmp, nSepLocation))
      sTmp = Mid$(sTmp, nSepLocation + 2)

    Next nDex

    ' function worked
    zzINIGetIntegerArray = True

  End If

End Function

Function zzINIGetString (ByVal sTopic$, sValue$) As Integer

 ' Description:
 '  Returns string variable from "INI" file.

 ' Parameters:
 '  sTopic           topic to get

 ' Variables:
  Dim nTopicLength      As Integer         ' length of topic returned
  Dim sTmp              As String          ' temporary work string

  ' create work space
  sTmp = Space$(nMAX_ENTRY_LENGTH)

  ' no file or section or topic specified
  If sINIFile = gsEMPTY Or sINISection = gsEMPTY Or sTopic = gsEMPTY Then
    zzINIGetString = False

  ' WIN.INI used
  ElseIf UCase$(sINIFile) = sWIN_INI Then
    nTopicLength = GetWININIProfileString(sINISection, sTopic, gsEMPTY, sTmp, nMAX_ENTRY_LENGTH)
    sValue = Left$(sTmp, nTopicLength)
    zzINIGetString = True
  
  ' private file
  Else
    nTopicLength = GetPrivateProfileString(sINISection, sTopic, gsEMPTY, sTmp, nMAX_ENTRY_LENGTH, sINIFile)
    sValue = Left$(sTmp, nTopicLength)
    zzINIGetString = True
  End If

End Function

Function zzINIGetStringArray (ByVal sTopic$, asArray$(), ByVal nElements%) As Integer

 ' Description:
 '  Returns string array from ini file.  Reads string
 '  value like "n1,n2,...".

 ' Parameters:
 '  sTopic                 topic
 '  asArray                array to contain results
 '  nElements              number of elements
 
 ' Variables:
  Dim nDex                 As Integer    ' loop counter
  Dim nLowerBoundary       As Integer    ' lower boundary of array
  Dim nSepLocation         As Integer    ' seperator location
  Dim sTmp                 As String     ' temporary work string

  ' get entire string
  nDex = zzINIGetString(sTopic, sTmp)
  
  ' if any required parameters not setup
  If sINIFile = gsEMPTY Or sINISection = gsEMPTY Or sTopic = gsEMPTY Or sINISeperator = gsEMPTY Or nElements < 1 Or sTmp = gsEMPTY Then
    zzINIGetStringArray = False

  Else

    ' get number of elements
    nLowerBoundary = LBound(asArray)
  
    ' loop for each element
    For nDex = nLowerBoundary To nElements

      ' try to find next seperator location
      nSepLocation = InStr(sTmp, sINISeperator)

      ' if none found then
      If nSepLocation = 0 Then
      
	' use whole string
	nSepLocation = Len(sTmp)
      
	' if nothing left to read exit
	If nSepLocation = 0 Then Exit For

      ' move back one from seperator
      Else
	nSepLocation = nSepLocation - 1
      End If

      ' convert to numeric, remove from string
      asArray(nDex) = Left$(sTmp, nSepLocation)
      sTmp = Mid$(sTmp, nSepLocation + 2)

    Next nDex

    ' function worked
    zzINIGetStringArray = True

  End If

End Function

Function zzINIGetStringIntoTB (ByVal sTopic$, Ctl As Control) As Integer

 ' Description:
 '  Returns string variable from "INI" file.

 ' Parameters:
 '  sTopic           topic to get

 ' Variables:
  Dim nTopicLength      As Integer         ' length of topic returned
  Dim sTmp              As String          ' temporary work string

  ' create work space
  sTmp = Space$(nMAX_ENTRY_LENGTH)

  ' no file or section or topic specified
  If sINIFile = gsEMPTY Or sINISection = gsEMPTY Or sTopic = gsEMPTY Then
    zzINIGetStringIntoTB = False

  ' WIN.INI used
  ElseIf UCase$(sINIFile) = sWIN_INI Then
    nTopicLength = GetWININIProfileString(sINISection, sTopic, gsEMPTY, sTmp, nMAX_ENTRY_LENGTH)
    Ctl.Text = Left$(sTmp, nTopicLength)
    zzINIGetStringIntoTB = True
  
  ' private file
  Else
    nTopicLength = GetPrivateProfileString(sINISection, sTopic, gsEMPTY, sTmp, nMAX_ENTRY_LENGTH, sINIFile)
    Ctl.Text = Left$(sTmp, nTopicLength)
    zzINIGetStringIntoTB = True
  End If

End Function

Function zzINIPutInteger (ByVal sTopic$, ByVal nValue%) As Integer
 
 ' Description:
 '  Writes a integer variable to ini file.
 '  Returns zero if unsuccessful returns length
 '  of data if successful.

 ' Parameters:
 '  nValue         Integer to write

  ' no file or section or topic specified
  If sINIFile = gsEMPTY Or sINISection = gsEMPTY Or sTopic = gsEMPTY Then
    zzINIPutInteger = False

  ' WIN.INI used
  ElseIf UCase$(sINIFile) = sWIN_INI Then
    zzINIPutInteger = WriteWININIProfileString(sINISection, sTopic, Format$(nValue))
    zzINIPutInteger = True
  
  ' private file
  Else
    zzINIPutInteger = WritePrivateProfileString(sINISection, sTopic, Format$(nValue), sINIFile)
    zzINIPutInteger = True
  End If

End Function

Function zzINIPutIntegerArray (ByVal sTopic$, anArray%(), ByVal nElements%) As Integer

 ' Description:
 '  Writes integer array to ini file as "n1,n2,..."
 '  string.  Returns the string written out to as string value.

 ' Parameters:
 '  sTopic              topic to write
 '  anArray             integer array
 '  nElements           number of elements

 ' Variables:
  Dim nLowerBoundary    As Integer      ' lower boundary of array
  Dim nDex              As Integer      ' loop counter
  Dim sValue            As String       ' temporary work string

  ' if any required parameters not setup
  If sINIFile = gsEMPTY Or sINISection = gsEMPTY Or sTopic = gsEMPTY Or sINISeperator = gsEMPTY Or nElements < 1 Then
    zzINIPutIntegerArray = False

  Else
    
    ' get number of elements
    nLowerBoundary = LBound(anArray)
  
    ' loop for each element
    For nDex = nLowerBoundary To nElements
      sValue = sValue & Format$(anArray(nDex)) & sINISeperator
    Next nDex
    
    ' remove last hanging seperator
    sValue = Left$(sValue, Len(sValue) - 1)
    
    ' return string written out
    nDex = zzINIPutString(sTopic, sValue)
    zzINIPutIntegerArray = True
  
  End If
  
End Function

Function zzINIPutString (ByVal sTopic$, ByVal sValue$) As Integer
 
 ' Description:
 '  Writes a integer variable to ini file.
 '  Returns zero if unsuccessful returns length
 '  of data if successful.

 ' Parameters:
 '  sValue         string to write

  ' no file or section or topic specified
  If sINIFile = gsEMPTY Or sINISection = gsEMPTY Or sTopic = gsEMPTY Then
    zzINIPutString = False

  ' WIN.INI used
  ElseIf UCase$(sINIFile) = sWIN_INI Then
    zzINIPutString = (WriteWININIProfileString(sINISection, sTopic, sValue)) <> 0
  
  ' private file
  Else
    zzINIPutString = (WritePrivateProfileString(sINISection, sTopic, sValue, sINIFile)) <> 0
  End If

End Function

Function zzINIPutStringArray (ByVal sTopic$, asArray$(), ByVal nElements%) As Integer

 ' Description:
 '  Writes string array to ini file as "n1,n2,..."
 '  string.  Returns the string written out to as string value.

 ' Parameters:
 '  sTopic              topic to write
 '  asArray             integer array
 '  nElements           number of elements

 ' Variables:
  Dim nLowerBoundary    As Integer      ' lower boundary of array
  Dim nDex              As Integer      ' loop counter
  Dim sValue            As String       ' temporary work string

  ' if any required parameters not setup
  If sINIFile = gsEMPTY Or sINISection = gsEMPTY Or sTopic = gsEMPTY Or sINISeperator = gsEMPTY Or nElements < 1 Then
    zzINIPutStringArray = False

  Else
    
    ' get number of elements
    nLowerBoundary = LBound(asArray)
  
    ' loop for each element
    For nDex = nLowerBoundary To nElements
      sValue = sValue & Format$(asArray(nDex)) & sINISeperator
    Next nDex
    
    ' remove last hanging seperator
    sValue = Left$(sValue, Len(sValue) - 1)
    
    ' return string written out
    nDex = zzINIPutString(sTopic, sValue)
    zzINIPutStringArray = True
  
  End If

End Function

Function zzINISetFile (ByVal sFile$) As Integer

 ' Description:
 '  Sets the current INI file

 ' Parameters:
 '  sFiles       file to set tp

  sINIFile = sFile
  zzINISetFile = (sFile <> gsEMPTY)

End Function

Function zzINISetSection (ByVal sSection$) As Integer

 ' Description:
 '  Sets the current INI section

 ' Parameters:
 '  sSection    section to set tp

  sINISection = sSection
  zzINISetSection = (sSection <> gsEMPTY)

End Function

Function zzINISetSeperator (ByVal sSeperator$) As Integer

 ' Description:
 '  Sets the current INI section

 ' Parameters:
 '  sSection    seperator to use

  sINISeperator = sSeperator
  zzINISetSeperator = (sSeperator <> gsEMPTY)

End Function

