Option Explicit

Sub zzFormFade (frm As Form, ByVal lStartingColor&, ByVal nGradient%)

 ' Description:
 '  Fade form starting with special color

 ' Parameters:
 '  frm                     form to fade
 '  lStartingColor          starting color
 '  nGradient               gradient option
 '                           0 = diagonal
 '                           1 = vertical
 '                           2 = horizontal
 
 ' Constants:
  
  ' mapping modes
  Const MM_TEXT = 1
  Const MM_LOMETRIC = 2
  Const MM_HIMETRIC = 3
  Const MM_LOENGLISH = 4
  Const MM_HIENGLISH = 5
  Const MM_TWIPS = 6
  Const MM_ISOTROPIC = 7
  Const MM_ANISOTROPIC = 8

  ' bits per pixwl and number of planes
  Const BITSPIXEL = 12
  Const PLANES = 14
 
 ' Variables:
  Dim hBrush         As Integer     ' brush handle
  Dim nDC            As Integer     ' device context
  Dim nBitsPixel     As Integer     ' bits per pixel
  Dim nBlue          As Integer     ' current amount of blue
  Dim nGreen         As Integer     ' current amount of green
  Dim nI             As Integer     ' loop counter
  Dim nIntBlue       As Integer     ' blue color change within regions
  Dim nIntGreen      As Integer     ' green color change within regions
  Dim nIntRed        As Integer     ' red color change within regions
  Dim nIntervalX     As Integer     ' horizontal interval in pixels
  Dim nIntervalY     As Integer     ' vertical internal in pixels
  Dim nNbrPlanes     As Integer     ' number of planes
  Dim nNbrRegions    As Integer     ' number of paint regions
  Dim nOldScaleMode  As Integer     ' previous scalemode
  Dim nRC            As Integer     ' return value for fill API
  Dim nRed           As Integer     ' current amount of red
  Dim nScaleHeight   As Integer     ' form height
  Dim nScaleWidth    As Integer     ' form width
  Dim nStepInterval  As Integer     ' distance between each region
  Dim tFillArea      As RECT        ' rectangle
  Dim r              As RECT
    
  ' get device context
  nDC = GetDC(frm.hWnd)

  ' get current mapping mode
  nOldScaleMode = GetMapMode(nDC)

  ' reset to pixels
  nRC = SetMapMode(nDC, MM_TEXT)
  
  ' get forms windowing info
  GetWindowRect frm.hWnd, r

  ' get height and width in pixels
  nScaleHeight = r.Bottom - r.Top
  nScaleWidth = r.Right - r.Left
  
  ' reset to old mapping mode
  nRC = SetMapMode(nDC, nOldScaleMode)
  
  ' determine number of bits per pixel
  nBitsPixel = GetDeviceCaps(nDC, BITSPIXEL)
  
  ' determine number of planes supported
  nNbrPlanes = GetDeviceCaps(nDC, PLANES)

  ' calculate the number of screen regions
  Select Case nBitsPixel * nNbrPlanes
    Case 24:     nNbrRegions = 256     ' 16M colors
    Case 16, 15: nNbrRegions = 32      ' 64K, 32K colors
    Case 8, 4:   nNbrRegions = 64      ' 256, 16 colors
    Case Else:   nNbrRegions = 64      ' other
  End Select

  ' handle bogus values
  If lStartingColor < 0 Then
    lStartingColor = lStartingColor + 65536
  End If

  ' get starting mixture of colors
  Call zzColorGetRGB(lStartingColor, nRed, nGreen, nBlue)

  ' color differences between regions
  nIntBlue = nBlue \ nNbrRegions
  nIntGreen = nGreen \ nNbrRegions
  nIntRed = nRed \ nNbrRegions

  ' must be at least one if color present
  If nBlue > 0 And nIntBlue = 0 Then nIntBlue = 1
  If nGreen > 0 And nIntGreen = 0 Then nIntGreen = 1
  If nRed > 0 And nIntRed = 0 Then nIntRed = 1
  
  ' pixels per region
  nIntervalY = nScaleHeight \ nNbrRegions  ' vertical
  nIntervalX = nScaleWidth \ nNbrRegions   ' horizontal
    
  ' define top fill area
  tFillArea.Left = 0
  tFillArea.Top = 0
  tFillArea.Right = nScaleWidth
  tFillArea.Bottom = nScaleHeight

  ' start with black
  nRed = 0: nGreen = 0: nBlue = 0
  
  ' for each region
  For nI = 1 To nNbrRegions
	
    ' create brush
    hBrush = CreateSolidBrush(RGB(nRed, nGreen, nBlue))

    ' gradient option
    Select Case nGradient

      ' vertical
      Case 1
	nRC = FillRect(nDC, tFillArea, hBrush)
	tFillArea.Bottom = tFillArea.Bottom - nIntervalY
	tFillArea.Top = tFillArea.Top - nIntervalY
      
      ' horizontal
      Case 2
	nRC = FillRect(nDC, tFillArea, hBrush)
	tFillArea.Right = tFillArea.Right - nIntervalX
	tFillArea.Left = tFillArea.Left - nIntervalX
      
      ' diagonal
      Case Else
	nRC = FillRect(nDC, tFillArea, hBrush)
	tFillArea.Bottom = tFillArea.Bottom - nIntervalY
	tFillArea.Top = tFillArea.Top - nIntervalY
	tFillArea.Right = tFillArea.Right - nIntervalX
	tFillArea.Left = tFillArea.Left - nIntervalX

    End Select

    ' delete brush
    nRC = DeleteObject(hBrush)
	
    ' move toward original color
    nBlue = nBlue + nIntBlue
    nGreen = nGreen + nIntGreen
    nRed = nRed + nIntRed

  Next nI
    
End Sub

