Option Explicit

Function zzColorGetOpposite (ByVal lColor&) As Long

 ' Description:
 '  Get opposite color of one passed in

 ' Parameters:
 '  lColor               color to get opposite for
 
 ' Variables:
  Dim nRed As Integer
  Dim nGreen As Integer
  Dim nBlue As Integer

  ' handle bogus value
  If lColor < 0 Then lColor = lColor + 65536

  ' break down color
  Call zzColorGetRGB(lColor, nRed, nGreen, nBlue)

  ' shift to opposite side
  nRed = Abs(nRed - 256)
  nGreen = Abs(nGreen - 256)
  nBlue = Abs(nBlue - 256)

  ' return to caller
  zzColorGetOpposite = RGB(nRed, nGreen, nBlue)

End Function

Sub zzColorGetRGB (ByVal lColor&, nRed%, nGreen%, nBlue%)

 ' Description:
 '  Returns RGB color components for a screen color

 ' Parameters:
 '  lColor               color to breakout
 '  nRed                 red component
 '  nGreen               green component
 '  nBlue                blue component

 ' Variables:
  Dim lBlue     As Long
  Dim lGreen    As Long
  Dim lRed      As Long

  ' get blue component
  lBlue = lColor \ 65536

  ' get green component
  lGreen = (lColor - (65536 * lBlue)) \ 256

  ' get red component
  lRed = lColor - ((65536 * lBlue) + (lGreen * 256))

  ' put into integers
  nBlue = lBlue
  nGreen = lGreen
  nRed = lRed

End Sub

