Option Explicit

Sub zzFormLocation (r As RECT, nLeft%, nTop%, nWidth%, nHeight%)

 ' Description:
 '  Returns form's location and size in twips after
 '  receiving rectangle information in pixels

 ' Parameters:
 ' Input:
 '  r              rectangle
 ' Output:
 '  nLeft          left location
 '  nTop           top location
 '  nWidth         width
 '  nHeight        height

  ' get data from rectangle and convert to twips
  nLeft = zzPixelsToTwipsX(r.Left)
  nTop = zzPixelsToTwipsY(r.Top)
  nWidth = zzPixelsToTwipsX(r.Right - r.Left)
  nHeight = zzPixelsToTwipsY(r.Bottom - r.Top)

End Sub

Function zzPixelsToTwipsX (ByVal nPixels%) As Integer

  zzPixelsToTwipsX = nPixels * Screen.TwipsPerPixelX

End Function

Function zzPixelsToTwipsY (ByVal nPixels%) As Integer

  zzPixelsToTwipsY = nPixels * Screen.TwipsPerPixelY

End Function

Function zzTwipsToPixelsX (ByVal nTwips%) As Integer

  zzTwipsToPixelsX = nTwips \ Screen.TwipsPerPixelX

End Function

Function zzTwipsToPixelsY (ByVal nTwips%) As Integer

  zzTwipsToPixelsY = nTwips \ Screen.TwipsPerPixelY

End Function

