Option Explicit

 ' Description:
 '  This module contains the constants for the
 '  data translation APIs and the wrappers for the
 '  EBCDIC to ASCII and ASCII to EBCDIC conversions.

 ' Constants:
  
  ' Data Translation: return codes
  Global Const gnDT_SUCCESS = &H0                            ' function successful
  Global Const gnDT_TABLE_NOT_FOUND = &HFFFC                 ' conversion table not found
  Global Const gnDT_NULL_POINTER = &HFFFD                    ' null pointer passed
  Global Const gnDT_OVEFFLOW = &HFFFE                        ' overflow occurred
  Global Const gnDT_MEM_ALLOC = &HFFFF                       ' memory allocation error

 ' Variables:
  Dim nDTrc As Integer                       ' API return code

 ' APIs:
  Declare Function EHNDT_ASCIIToEBCDIC% Lib "EHNAPPC.DLL" (ByVal hWnd%, ByVal sCV_ASCII$, ByVal sCV_EBCDIC$, ByVal nCV_ASCIILen%, nCV_EBCDICLen%)
  Declare Function EHNDT_EBCDICToASCII% Lib "EHNAPPC.DLL" (ByVal hWnd%, ByVal sCV_EBCDIC$, ByVal sCV_ASCII$, ByVal nCV_EBCDICLen%, nCV_ASCIILen%)

Function zzCV_ASCIIToEBCDIC (ByVal hWnd%, ByVal sASCII$) As String

 ' Description:
 '  Converts ASCII string to EBCDIC string

 ' Parameters:
 '  hWnd                       windows handle
 '  sASCII                     ASCII string to convert

 ' Variables:
  Dim sEBCDIC As String        ' EBCDIC string

  ' make target field same size
  sEBCDIC = sASCII
  
  ' convert
  nDTrc = EHNDT_ASCIIToEBCDIC(hWnd, sASCII, sEBCDIC, Len(sASCII), Len(sEBCDIC))

  ' return value to caller
  zzCV_ASCIIToEBCDIC = sEBCDIC

End Function

Function zzCV_EBCDICToASCII (ByVal hWnd%, ByVal sEBCDIC$) As String
 
 ' Description:
 '  Converts EBCDIC string to ASCII
 
 ' Parameters:
 '  hWnd                       windows handle
 '  sEBCDIC                    EBCDIC string to convert

 ' Variables:
  Dim sASCII As String         ' ASCII string

  ' make target field same size
  sASCII = sEBCDIC
  
  ' convert and then test for error
  nDTrc = EHNDT_EBCDICToASCII(hWnd, sEBCDIC, sASCII, Len(sEBCDIC), Len(sASCII))
  
  ' put into function, clear work space
  zzCV_EBCDICToASCII = sASCII

End Function

