Option Explicit

 ' Description:
 '  This module contains constants and wrappers related
 '  to the IBM PC Support/400 APPC BASIC conversations.

Function zzCAConvStartBasic (ByVal hWnd%, ByVal nCABuffSize%, ByVal sCASystem$, ByVal sCALibPgm$, ByVal sCAPipData$, nCArc%) As Long
 
 ' Description:
 '  Allocates a basic conversion without confirmation.
 '  If successful will return the conversation ID as
 '  the function value. If not the error code will be
 '  returned in nCArc.

 ' Parameters:
 ' Input:
 '  hWnd                   windows handle
 '  nCABuffSize            desired buffer size
 '  sCASystem              AS/400 system name
 '  sCALibPgm              partner program "library/program"
 '  sCAPipData             PIP data
 ' Output:
 '  nCArc                  API return code

 ' Variables:
  Dim lCAConvId As Long    ' conversation ID

  ' handle DOS errors
  On Error Resume Next
 
  ' allocate conversation
  nCArc = EHNAPPC_Allocate(hWnd, nCABuffSize, gnCA_BASIC, gnCA_SYNCLVL_NONE, sCASystem & gsCHR_NUL, sCALibPgm & gsCHR_NUL, Len(sCAPipData), sCAPipData, lCAConvId)

  ' if DOS then then return generic error number
  If Err <> 0 Then nCArc = gnCA_UNDEFINED

  ' return conversation ID as function value
  zzCAConvStartBasic = lCAConvId

End Function

Function zzCAConvStartBasicConfirm (ByVal hWnd%, ByVal nCABuffSize%, ByVal sCASystem$, ByVal sCALibPgm$, ByVal sCAPipData$, nCArc%) As Long
 
 ' Description:
 '  Allocates a basic conversion without confirmation.
 '  If successful will return the conversation ID as
 '  the function value. If not the error code will be
 '  returned in nCArc.

 ' Parameters:
 ' Input:
 '  hWnd                   windows handle
 '  nCABuffSize            desired buffer size
 '  sCASystem              AS/400 system name
 '  sCALibPgm              partner program "library/program"
 '  sCAPipData             PIP data
 ' Output:
 '  nCArc                  API return code

 ' Variables:
  Dim lCAConvId As Long    ' conversation ID

  ' handle DOS errors
  On Error Resume Next
 
  ' allocate conversation
  nCArc = EHNAPPC_Allocate(hWnd, nCABuffSize, gnCA_BASIC, gnCA_SYNCLVL_CONFIRM, sCASystem & gsCHR_NUL, sCALibPgm & gsCHR_NUL, Len(sCAPipData), sCAPipData, lCAConvId)

  ' if DOS then then return generic error number
  If Err <> 0 Then nCArc = gnCA_UNDEFINED

  ' return conversation ID as function value
  zzCAConvStartBasicConfirm = lCAConvId

End Function

Function zzCAReceiveBasic (ByVal hWnd%, ByVal lCAConvId&, ByVal nCADataLen%, sCAData$, nCAWhatRcvd%, bCAPartnerWishesToSend%) As Integer
 
 ' Description:
 '  Receive data immediately through a basic conversation,
 '  but do not wait for it.
 
 ' Parameters:
 '  hWnd                           windows handle
 '  lCAConvID                      conversation ID
 '  nCADataLen                     length of data to be received
 '  sCAData                        data received
 '  nCAWhatRcvd                    what received
 '  bCAPartnerWishesToSend         partner wishes to send

 ' Variables:
  Dim lCADataLen  As Long          ' length of data received
  Dim nCArc       As Integer       ' API return code

  ' add "header" bytes
  sCAData = Space$(nCADataLen + gnCA_BASIC_HEADER_LEN)

  ' attempt receive of data from partner
  nCArc = EHNAPPC_ReceiveImmediate(hWnd, lCAConvId, gnCA_FILL_BUFFER, nCADataLen + gnCA_BASIC_HEADER_LEN, sCAData, nCAWhatRcvd, bCAPartnerWishesToSend, lCADataLen)

  ' set to a "real" True if not zero (False)
  bCAPartnerWishesToSend = bCAPartnerWishesToSend <> 0

  ' if no error encountered
  If nCArc = gnCA_OK Then
    
    ' get data from the buffer
    sCAData = Left$(sCAData, lCADataLen)
    
  ' if error then nothing to return
  Else
    sCAData = gsEMPTY
  End If
  
  ' return code to caller
  zzCAReceiveBasic = nCArc

End Function

Function zzCASendBasic (ByVal hWnd%, ByVal lCAConvId&, ByVal sCAData$, ByVal nCADataLen%, bCAPartnerWishesToSend%) As Integer
 
 ' Description:
 '  This procedure will send data to
 '  the partner program after placing
 '  the required general data stream
 '  identifiers on the front of the
 '  data.

 ' Parameters:
 ' Input:
 '  hWnd                            windows handle
 '  lCAConvID                       conversation ID
 '  sCAData                         data to be sent
 '  nCADataLen                      length of data to be sent
 ' Output:
 '  bCAPartnerWishesToSend          partner wishes to send
 
 ' Constants:
  
 ' Variables:
  Dim nCARealDataLen As Integer     ' length of data actually sent
  Dim sCARealData    As String      ' data actually sent
  
  ' setup data length
  nCARealDataLen = nCADataLen + gnCA_BASIC_HEADER_LEN

  ' put in required "LL" field information
  sCARealData = Chr$(nCARealDataLen \ 256) & Chr$(nCARealDataLen Mod 256)
  
  ' put in data with trailing nulls
  sCARealData = sCARealData & Left$(sCAData & String$(nCADataLen, 0), nCADataLen)

  ' send data
  zzCASendBasic = EHNAPPC_SendData(hWnd, lCAConvId, nCARealDataLen, sCARealData, bCAPartnerWishesToSend)

  ' set to a "real" True if not zero
  bCAPartnerWishesToSend = bCAPartnerWishesToSend <> 0

End Function

