Option Explicit

 ' Description:
 '  The module contains a routine which
 '  returns a text description of the
 '  APPC API return code that is passed
 '  to it and a routine that returns
 '  a text description of the conversation
 '  state.

Function zzCAGetRCText (ByVal nCArc%, ByVal bAddHex%) As String

 ' Description:
 '  Returns a text description for an APPC return code

 ' Parameters:
 '  nCArc              APPC return code
 '  bAddHex            add hex notation at end of message

 ' Variables:
  Dim sMsg As String   ' message text

  ' message based on error number
  Select Case nCArc
    
    Case gnCA_OK
      zzCAGetRCText = gsEMPTY
      Exit Function
    
    Case gnCA_PARMCHK_INVALID_CONVERID
      sMsg = "Invalid conversation ID"

    Case gnCA_UNSUCCESSFUL
      sMsg = "APPC API unsuccessful"
    
    Case gnCA_APPC_BUSY
      sMsg = "APPC API busy"

    Case gnCA_PARMCHK_INVALID_CONVERID
      sMsg = "Invalid conversation ID"
    
    Case gnCA_PARMCHK_BUFFER_CROSS_SEG
      sMsg = "Buffer crossing segment boundary"
    
    Case gnCA_PARMCHK_INV_CONVER_TYPE
      sMsg = "Invalid conversation type"

    Case gnCA_PARMCHK_CONF_NOT_ALLOWED
      sMsg = "Confirmation not allowed"

    Case gnCA_STATECHK_NOT_IN_CONF_STAT
      sMsg = "Not in confirmed state"

    Case gnCA_STATECHK_NOT_IN_RECEIVE
      sMsg = "Not in receive state"

    Case gnCA_STATECHK_REQ_SND_BAD_STAT
      sMsg = "Cannot request-to-send in current state"
  
    Case gnCA_STATECHK_SND_IN_BAD_STATE
      sMsg = "Cannot send in current state"
    
    Case gnCA_STATECHK_SND_ERR_BAD_STAT
    sMsg = "Cannot send error in current state"

    Case gnCA_ALLOCERR_NO_RETRY To gnCA_ALLOCERR_SYNCH_LEVEL
      sMsg = "APPC allocate error"
    
    Case gnCA_ROUTER_NOT_INSTALLED
      sMsg = "Router not loaded"

    Case gnCA_PCSWIN_NOT_LOADED
      sMsg = "PCSWIN not loaded"

    Case gnCA_DEALLOC_ABEND_PROGRAM
      sMsg = "Conversation ended abnormally"

    Case gnCA_UNDEFINED
      sMsg = "Undefined APPC error"

    Case Else
      sMsg = "APPC error number x'" & Right$("0000" & Hex$(nCArc), 4) & "'"
      zzCAGetRCText = sMsg
      Exit Function

  End Select

  ' add hex notation
  If bAddHex Then sMsg = sMsg & " (x'" & Right$("0000" & Hex$(nCArc), 4) & "')"

  ' return value to caller
  zzCAGetRCText = sMsg

End Function

Function zzCAGetStateText (ByVal nCAConvState%, ByVal bAddHex%) As String

 ' Description:
 '  Returns a text description of conversation state

 ' Parameters:
 '  nCAConvState       APPC conversation state
 '  bAddHex            add hex notation at end of message

 ' Variables:
  Dim sMsg As String   ' message text

  ' message based on what received
  Select Case nCAConvState
    Case gnCA_RESET_STATE: sMsg = "Reset"
    Case gnCA_SEND_STATE: sMsg = "Send"
    Case gnCA_RECEIVE_STATE: sMsg = "Receive"
    Case gnCA_RCVD_CONF_STATE: sMsg = "Received confirmation request"
    Case gnCA_RCVD_CONF_SEND_STATE: sMsg = "Sent confirmation request"
    Case gnCA_RCVD_CONF_DEALL_STATE: sMsg = "Sent deallocate request"
    Case gnCA_PEND_DEALLOCATE_STATE: sMsg = "Pending deallocation"
    Case gnCA_INVALID_STATE: sMsg = "Invalid"
  End Select

  ' add common verbage
  sMsg = sMsg & " state"

  ' add hex notation
  If bAddHex Then sMsg = sMsg & " (x'" & Right$("00" & Hex$(nCAConvState), 2) & "')"

  ' return value to caller
  zzCAGetStateText = sMsg

End Function

Function zzCAGetWhatReceivedText (ByVal nCAWhatRcvd%, ByVal bAddHex%) As String

 ' Description:
 '  Returns a text description for an APPC return code

 ' Parameters:
 '  nCAWhatRcvd        APPC what received flag
 '  bAddHex            add hex notation at end of message

 ' Variables:
  Dim sMsg As String   ' message text

  ' message based on what received
  Select Case nCAWhatRcvd

    Case gnCA_RCVD_DATA
      sMsg = "maximum amount or end of data"
    
    Case gnCA_RCVD_DATA_COMPLETE
      sMsg = "complete logical record or last part of record"

    Case gnCA_RCVD_DATA_INCOMPLETE
      sMsg = "less than a complete logical record"
    
    Case gnCA_RCVD_CONFIRM
      sMsg = "confirmation request"
    
    Case gnCA_RCVD_CONFIRM_SEND
      sMsg = "prepare to receive indication"
    
    Case gnCA_RCVD_CONFIRM_DEALLOCATE
      sMsg = "deallocation request"
    
    Case gnCA_RCVD_SEND
      sMsg = "may now send indication"

  End Select

  ' add common verbage
  sMsg = "Received " & sMsg

  ' add hex notation
  If bAddHex Then sMsg = sMsg & " (x'" & Right$("00" & Hex$(nCAWhatRcvd), 2) & "')"

  ' return value to caller
  zzCAGetWhatReceivedText = sMsg

End Function

