Option Explicit
 
 ' Description:
 '  This modules contains the common type declarations
 '  used within the Windows environment.

 ' Constants:

  ' windows messages
  Global Const WM_DROPFILES = &H233
  Global Const WM_GETFONT = &H31
  Global Const WM_GETMINMAXINFO = &H24
  Global Const WM_MENUSELECT = &H11F
  Global Const WM_USER = &H400

  ' listbox messages
  Global Const LB_SETTABSTOPS = (WM_USER + 19)
  Global Const LB_GETHORIZONTALEXTENT = (WM_USER + 20)
  Global Const LB_SETHORIZONTALEXTENT = (WM_USER + 21)

  ' textbox messages
  Global Const EM_GETRECT = (WM_USER + 2)
  Global Const EM_LINESCROLL = (WM_USER + 6)
  Global Const EM_GETLINECOUNT = (WM_USER + 10)
  Global Const EM_SETTABSTOPS = (WM_USER + 27)
  Global Const EM_SETREADONLY = (WM_USER + 31)

  ' PeekMessage Options
  Global Const PM_NOREMOVE = 0
  Global Const PM_REMOVE = 1
  Global Const PM_NOYIELD = 2
 
 ' Sub-Types:

  ' define a location
  Type POINTAPI
    X                            As Integer         ' x axis location
    Y                            As Integer         ' y axis location
  End Type

 ' Types:
  
  ' bitmap information
  Type BITMAP
    bmType                       As Integer
    bmWidth                      As Integer
    bmHeight                     As Integer
    bmWidthBytes                 As Integer
    bmPlanes                     As String * 1
    bmBitsPixel                  As String * 1
    bmBits                       As Long
  End Type

  Type MINMAXINFO
    ptReserved                   As POINTAPI
    ptMaxSize                    As POINTAPI
    ptMaxPosition                As POINTAPI
    ptMinTrackSize               As POINTAPI
    ptMaxTrackSize               As POINTAPI
  End Type
  
  ' model information for a control
  Type MODELINFO
   usVersion                     As Integer         ' Model info
   fl                            As Long            ' MODEL flags
   fsClassStyle                  As Integer         ' Default Class style
   flWndStyle                    As Long            ' Default Window style
   DefCtlName                    As String * 40     ' Default control name
   ClassName                     As String * 40     ' Class name
   ParentClassName               As String * 40     ' Parent class name
  End Type

  ' windows message
  Type msg
    hWnd                         As Integer         ' windows handle
    Message                      As Integer         ' message number
    wParam                       As Integer         ' 16 bit parameter
    lParam                       As Long            ' 32 bit parameter
    Time                         As Long            ' time in milliseconds
    pt                           As POINTAPI        ' cursor location
  End Type

  ' multi-key help structure
  Type MULTIKEYHELP
    mkSize                       As Integer         ' size
    mkKeylist                    As String * 1      ' key
    szKeyphrase                  As String * 253    ' phrase
  End Type

  ' open file API structure
  Type OFStructType
    cBytes                       As String * 1
    fFixedDisk                   As String * 1
    nErrCode                     As Integer
    reserved                     As String * 4
    szPathName                   As String * 128
  End Type

  ' rectangular area
  Type RECT
    Left                         As Integer         ' left border
    Top                          As Integer         ' top border
    Right                        As Integer         ' right border
    Bottom                       As Integer         ' bottom border
  End Type

  ' text metrics (31 bytes)
  Type TEXTMETRIC
    tmHeight                     As Integer
    tmAscent                     As Integer
    tmDescent                    As Integer
    tmInternalLeading            As Integer
    tmExternalLeading            As Integer
    tmAveCharWidth               As Integer
    tmMaxCharWidth               As Integer
    tmWeight                     As Integer
    tmItalic                     As String * 1
    tmUnderlined                 As String * 1
    tmStruckOut                  As String * 1
    tmFirstChar                  As String * 1
    tmLastChar                   As String * 1
    tmDefaultChar                As String * 1
    tmBreakChar                  As String * 1
    tmPitchAndFamily             As String * 1
    tmCharSet                    As String * 1
    tmOverhang                   As Integer
    tmDigitizedAspectX           As Integer
    tmDigitizedAspectY           As Integer
  End Type

 ' APIs:
  
  Declare Function AppendMenuByString% Lib "USER" Alias "AppendMenu" (ByVal hMenu%, ByVal wFlags%, ByVal wIDNewItem%, ByVal lpNewItem$)
  Declare Function BitBlt% Lib "GDI" (ByVal hDestDC%, ByVal X%, ByVal Y%, ByVal nWidth%, ByVal nHeight%, ByVal hSrcDC%, ByVal XSrc%, ByVal YSrc%, ByVal dwRop&)
       Declare Sub BringWindowToTop Lib "USER" (ByVal hWnd%)
  Declare Function CreateCompatibleBitmap Lib "GDI" (ByVal hDC, ByVal w, ByVal h)
  Declare Function CreateCompatibleDC% Lib "GDI" (ByVal hDC%)
  Declare Function CreateEllipticRgn% Lib "GDI" (ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%)
  Declare Function CreatePen% Lib "GDI" (ByVal nPenStyle%, ByVal nWidth%, ByVal crColor&)
  Declare Function CreateRectRgnIndirect% Lib "GDI" (lpRect As RECT)
  Declare Function CreateSolidBrush% Lib "GDI" (ByVal crColor&)
  Declare Function Ctl3DAutoSubclass% Lib "CTL3D.DLL" Alias "#16" (ByVal hInst%)
  Declare Function Ctl3DAutoSubclassV2% Lib "CTL3DV2.DLL" Alias "#16" (ByVal hInst%)
  Declare Function Ctl3DRegister% Lib "CTL3D.DLL" Alias "#12" (ByVal hInst%)
  Declare Function Ctl3DRegisterV2% Lib "CTL3DV2.DLL" Alias "#12" (ByVal hInst%)
  Declare Function Ctl3dSubclassDlgEx% Lib "CTL3D.DLL" Alias "#21" (ByVal hWnd%, ByVal Flags&)
  Declare Function Ctl3dSubclassDlgExV2% Lib "CTL3DV2.DLL" Alias "#21" (ByVal hWnd%, ByVal Flags&)
  Declare Function Ctl3DUnRegister% Lib "CTL3D.DLL" Alias "#13" (ByVal hInst%)
  Declare Function Ctl3DUnRegisterV2% Lib "CTL3DV2.DLL" Alias "#13" (ByVal hInst%)
  Declare Function DeleteDC% Lib "GDI" (ByVal hDC%)
  Declare Function DeleteMenu% Lib "USER" (ByVal hMenu%, ByVal nPosition%, ByVal wFlags%)
  Declare Function DeleteObject% Lib "GDI" (ByVal hObject%)
  Declare Function DestroyIcon% Lib "USER" (ByVal hIcon%)
  Declare Function DiskSpaceFree& Lib "SETUPKIT.DLL" ()
       Declare Sub DragAcceptFiles Lib "SHELL.DLL" (ByVal hWnd%, ByVal bAccept%)
       Declare Sub DragFinish Lib "SHELL.DLL" (ByVal hDrop%)
  Declare Function DragQueryFile% Lib "SHELL.DLL" (ByVal hDrop%, ByVal nIndex%, ByVal sFileName$, ByVal nSize%)
  Declare Function EnableWindow% Lib "USER" (ByVal hWnd%, ByVal aBool%)
  Declare Function EnumWindows% Lib "USER" (ByVal lpAddr&, ByVal lpData&)
  Declare Function ExitWindows% Lib "USER" (ByVal lReturnCode&, ByVal nReserved%)
  Declare Function ExtFloodFill Lib "GDI" (ByVal hDC, ByVal X, ByVal Y, ByVal crColor As Long, ByVal wFillType)
  Declare Function ExtractIcon% Lib "SHELL" (ByVal hInst%, ByVal filename$, ByVal iIcon%)
  Declare Function FillRect% Lib "USER" (ByVal hDC%, lpRect As RECT, ByVal hBrush%)
  Declare Function FillRgn% Lib "GDI" (ByVal hDC%, ByVal hRgn%, ByVal hBrush%)
  Declare Function FindResource% Lib "Kernel" (ByVal hInstance%, ByVal lpName$, ByVal lpType As Any)
  Declare Function FrameRgn% Lib "GDI" (ByVal hDC%, ByVal hRgn%, ByVal hBrush%, ByVal nWidth%, ByVal nHeight%)
       Declare Sub FreeLibrary Lib "Kernel" (ByVal hLibModule As Integer)
  Declare Function GetActiveWindow% Lib "USER" ()
  Declare Function GetBkColor& Lib "GDI" (ByVal hDC%)
  Declare Function GetBkMode% Lib "GDI" (ByVal hDC%)
  Declare Function GetBitmapBits Lib "GDI" (ByVal hBitmap, ByVal dwCount As Long, ByVal lpBits As Long) As Long
       Declare Sub GetClientRect Lib "USER" (ByVal hWnd%, lpRect As RECT)
       Declare Sub GetCursorPos Lib "USER" (lpPoint As POINTAPI)
  Declare Function GetDC% Lib "USER" (ByVal Handle%)
  Declare Function GetDeviceCaps% Lib "GDI" (ByVal hDC%, ByVal nIndex%)
  Declare Function GetDialogBaseUnits& Lib "USER" ()
  Declare Function GetDesktopWindow% Lib "USER" ()
  Declare Function GetExpandedNameAPI% Lib "LZEXPAND.DLL" Alias "GetExpandedName" (ByVal lpszSource$, ByVal lpszBuffer$)
  Declare Function GetFileVersionInfo% Lib "VER.DLL" (ByVal filename$, ByVal Handle&, ByVal Buffer&, ByVal lpData$)
  Declare Function GetFileVersionInfoSize% Lib "VER.DLL" (ByVal filename$, Handle&)
  Declare Function GetFocus% Lib "USER" ()
  Declare Function GetMapMode% Lib "GDI" (ByVal hDC%)
  Declare Function GetMenu Lib "USER" (ByVal hWnd)
  Declare Function GetModuleFileName% Lib "Kernel" (ByVal hModule%, ByVal lpFileName$, ByVal nSize%)
  Declare Function GetModuleHandle% Lib "Kernel" (ByVal sModuleName$)
  Declare Function GetModuleUsage% Lib "Kernel" (ByVal hModule%)
  Declare Function GetNearestColor Lib "GDI" (ByVal hDC, ByVal RGBColor As Long) As Long
  Declare Function GetObj% Lib "GDI" Alias "GetObject" (ByVal hObject%, ByVal nCount%, lpObject As BITMAP)
  Declare Function GetParent% Lib "USER" (ByVal hWnd%)
  Declare Function GetPrivateProfileInt% Lib "Kernel" (ByVal lpgsAppTitle$, ByVal lpKeyName$, ByVal nDefault%, ByVal lpFileName$)
  Declare Function GetPrivateProfileString% Lib "Kernel" (ByVal lpApplicationName$, ByVal lpKeyName$, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%, ByVal lpFileName$)
  Declare Function GetProfileInt% Lib "Kernel" (ByVal lpgsAppTitle$, ByVal lpKeyName$, ByVal nDefault%)
  Declare Function GetSubMenu Lib "USER" (ByVal hWnd, ByVal Position)
  Declare Function GetSysColor& Lib "USER" (ByVal nIndex%)
  Declare Function GetSystemDirectory% Lib "Kernel" (ByVal lpBuffer$, ByVal nSize%)
  Declare Function GetSystemMenu% Lib "USER" (ByVal hWnd%, ByVal bRevert%)
  Declare Function GetSystemMetrics% Lib "USER" (ByVal nIndex%)
  Declare Function GetTextColor& Lib "GDI" (ByVal hDC%)
  Declare Function GetTextMetrics% Lib "GDI" (ByVal hDC%, lpMetrics As TEXTMETRIC)
  Declare Function GetVersion& Lib "Kernel" ()
  Declare Function GetWindowLong& Lib "USER" (ByVal hWnd%, ByVal nIndex%)
       Declare Sub GetWindowRect Lib "USER" (ByVal hWnd%, lpRect As RECT)
  Declare Function GetWindowsDirectory% Lib "Kernel" (ByVal lpBuffer$, ByVal nSize%)
  Declare Function GetWindowTask% Lib "USER" (ByVal hWnd%)
  Declare Function GetWindowWord% Lib "USER" (ByVal hWnd%, ByVal nIndex%)
  Declare Function GetWindow% Lib "USER" (ByVal hWnd%, ByVal wCmd%)
  Declare Function GetWinFlags& Lib "Kernel" ()
  Declare Function GetWININIProfileString% Lib "Kernel" Alias "GetProfileString" (ByVallpgsAppTitle$, ByVal lpKeyName$, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%)
  Declare Function GlobalAlloc% Lib "Kernel" (ByVal nFlags%, ByVal lBytes&)
  Declare Function GlobalFree% Lib "Kernel" (ByVal nhMem%)
  Declare Function GlobalLock& Lib "Kernel" (ByVal hGlobal%)
  Declare Function GlobalSize& Lib "Kernel" (ByVal hGlobal%)
  Declare Function GlobalUnlock% Lib "Kernel" (ByVal hGlobal%)
       Declare Sub HideCaret Lib "USER" (ByVal nHandle%)
       Declare Sub hMemCpy Lib "Kernel" (ByVal hpDest&, ByVal hpSource&, ByVal cbCopy&)
       Declare Sub hMemcpyAny Lib "Kernel" Alias "hMemcpy" (hpvDest As Any, hpvSource As Any, ByVal lCopy&)
       Declare Sub hMemCpyAny2 Lib "Kernel" Alias "hMemcpy" (ByVal hpvDest As Any, ByVal hpvSource&, ByVal cbCopy&)
  Declare Function hRead& Lib "Kernel" Alias "_hread" (ByVal hf%, ByVal hpvBuffer&, ByVal cbBuffer&)
  Declare Function hWrite& Lib "Kernel" Alias "_hwrite" (ByVal hf%, ByVal hpvBuffer&, ByVal cbBuffer&)
       Declare Sub InflateRect Lib "USER" (lpRect As RECT, ByVal X%, ByVal Y%)
       Declare Sub InvalidateRect Lib "USER" (ByVal hWnd%, ByVal lpRect&, ByVal bErase%)
  Declare Function InvertRect Lib "USER" (ByVal hDC, lpRect As RECT)
  Declare Function IsWindowVisible% Lib "USER" (ByVal hWnd%)
  Declare Function VerQueryValue% Lib "VER.DLL" (ByVal Block$, ByVal SubBlock$, Buffer&, lpcb%)
  Declare Function LoadBitmap% Lib "USER" (ByVal hInstance As Integer, ByVal lpBitmapName As Any)
  Declare Function LoadLibrary% Lib "Kernel" (ByVal sFile$)
  Declare Function LoadResource% Lib "Kernel" (ByVal hInstance%, ByVal hResInfo%)
  Declare Function LoadString% Lib "USER" (ByVal hInstance%, ByVal wID%, ByVal lpBuffer$, ByVal nBufferMax%)
  Declare Function LockResource& Lib "Kernel" (ByVal hResData%)
  Declare Function LstrCpy& Lib "Kernel" (anyDestination As Any, anySource As Any)
  Declare Function lstrcpyn& Lib "Kernel" (ByVal lpszString1 As Any, ByVal lpszString2&, ByVal cChars%)
  Declare Function LstrCpynByAny$ Lib "Kernel" Alias "LstrCpyn" (ByVal anyDestination As Any, ByVal anySource As Any, ByVal nChars%)
  Declare Function MessageBox% Lib "USER" (ByVal hWnd%, ByVal lpText$, ByVal lpCaption$, ByVal wType%)
       Declare Sub MoveWindow Lib "USER" (ByVal hWnd%, ByVal X%, ByVal Y%, ByVal nWidth%, ByVal nHeight%, ByVal bRepaint%)
  Declare Function OpenFile% Lib "Kernel" (ByVal lpFileName$, lpReOpenBuff As OFStructType, ByVal wStyle%)
  Declare Function PeekMessage% Lib "USER" (tMsg As msg, ByVal hWnd%, ByVal nMsgFilterMin%, ByVal nMsgFilterMax%, ByVal bRemoveMsg%)
  Declare Function PostMessage& Lib "USER" (ByVal hWnd%, ByVal nMsg%, ByVal nParam%, anyParam As Any)
  Declare Function PostMessageBynum& Lib "USER" Alias "PostMessage" (ByVal hWnd%, ByVal nMsg%, ByVal nParam%, ByVal lParam&)
  Declare Function PostMessageByString& Lib "USER" Alias "PostMessage" (ByVal hWnd%, ByVal nMsg%, ByVal nParam%, ByVal sParam$)
  Declare Function Rectangle% Lib "GDI" (ByVal hDC%, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%)
  Declare Function RedrawWindow% Lib "USER" (ByVal hWnd%, lprcUpdate As RECT, ByVal hrgnUpdate%, ByVal fuRedraw%)
  Declare Function ReleaseDC% Lib "USER" (ByVal hWnd%, ByVal hDC%)
  Declare Function RemoveMenu Lib "USER" (ByVal hMenu, ByVal nPosition, ByVal wFlags)
  Declare Function SelectObject% Lib "GDI" (ByVal hDC%, ByVal hObject%)
  Declare Function SendMessage& Lib "USER" (ByVal hWnd%, ByVal nMsg%, ByVal nParam%, anyParam As Any)
  Declare Function SendMessageBynum& Lib "USER" Alias "SendMessage" (ByVal hWnd%, ByVal nMsg%, ByVal nParam%, ByVal lParam&)
  Declare Function SendMessageByString& Lib "USER" Alias "SendMessage" (ByVal hWnd%, ByVal nMsg%, ByVal nParam%, ByVal sParam$)
  Declare Function SetBitmapBits Lib "GDI" (ByVal hBitmap, ByVal dwCount As Long, ByVal lpBits As Long) As Long
  Declare Function SetBkColor& Lib "GDI" (ByVal hDC%, ByVal crColor&)
  Declare Function SetBkMode% Lib "GDI" (ByVal hDC%, ByVal nBkMode%)
  Declare Function SetErrorMode% Lib "Kernel" (ByVal wMode%)
  Declare Function SetFocusAPI% Lib "USER" Alias "SetFocus" (ByVal hWnd%)
  Declare Function SetMapMode% Lib "GDI" (ByVal hDC%, ByVal nMapMode%)
  Declare Function SetParent% Lib "USER" (ByVal hWndChild%, ByVal hWndNewParent%)
  Declare Function SetTextColor& Lib "GDI" (ByVal hDC%, ByVal crColor&)
  Declare Function SetWindowLong& Lib "USER" (ByVal hWnd%, ByVal nIndex%, ByVal dwNewLong&)
       Declare Sub SetWindowPos Lib "USER" (ByVal hWnd%, ByVal hWndInsertAfter%, ByVal X%, ByVal Y%, ByVal cx%, ByVal cy%, ByVal wFlags%)
       Declare Sub ShellAbout Lib "SHELL" (ByVal hWnd%, ByVal sTitle$, ByVal sDialogText$, ByVal lptrIcon%)
       Declare Sub ShowCaret Lib "USER" (ByVal nHandle%)
  Declare Function ShowCursor% Lib "USER" (ByVal bShow%)
  Declare Function ShowWindow% Lib "USER" (ByVal hWnd%, ByVal nCmdShow%)
  Declare Function SndPlaySound% Lib "MMSYSTEM" (ByVal sWAVFile$, ByVal wFlags%)
  Declare Function SndPlaySoundByNum% Lib "MMSYSTEM" Alias "SndPlaySound" (ByVal lpMemory As Long, ByVal snd_async%)
  Declare Function StretchBlt% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal nWidth%, ByVal nHeight%, ByVal hSrcDC%, ByVal XSrc%, ByVal YSrc%, ByVal nSrcWidth%, ByVal nSrcHeight%, ByVal dwRop&)
  Declare Function TextOut% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal lpString$, ByVal nCount%)
  Declare Function TrackPopupMenu Lib "USER" (ByVal hMenu, ByVal r1, ByVal X, ByVal Y, ByVal r2, ByVal hWnd, ByVal r3 As Long)
  Declare Function VarPtr& Lib "VBRUN300.DLL" (anyVar As Any)
  Declare Function VerFindFile% Lib "VER.DLL" (ByVal Flags%, ByVal filename$, ByVal WinDir&, ByVal AppDir$, ByVal CurrDir$, CurDirLen%, ByVal DestDir$, DestDirLen%)
  Declare Function VerInstallFile& Lib "VER.DLL" (ByVal Flags%, ByVal SrcFile$, ByVal DestFile$, ByVal SrcPath$, ByVal DestPath$, ByVal CurrDir$, ByVal TmpFile$, lpwTmpFileLen%)
  Declare Function WindowFromPoint% Lib "USER" (ByVal lpPointY%, ByVal lpPointX%)
  Declare Function WinHelp% Lib "USER" (ByVal hWnd%, ByVal sHelpFile$, ByVal nCommand%, anyData As Any)
  Declare Function WinHelpLong% Lib "USER" Alias "WINHELP" (ByVal hWnd%, ByVal sHelpFile$, ByVal nCommand%, ByVal lData&)
  Declare Function WinHelpString% Lib "USER" Alias "WINHELP" (ByVal hWnd%, ByVal sHelpFile$, ByVal nCommand%, ByVal sData$)
  Declare Function WritePrivateProfileString% Lib "Kernel" (ByVal lpgsAppTitle$, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lplFileName$)
  Declare Function WriteWININIProfileString% Lib "Kernel" Alias "WriteProfileString" (ByVal lpgsAppTitle$, ByVal lpKeyName As Any, ByVal lpString As Any)











