VERSION 2.00
Begin Form frmTracker 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "AS/400 Library Backup Tracker"
   ClientHeight    =   4020
   ClientLeft      =   840
   ClientTop       =   1635
   ClientWidth     =   7365
   Height          =   4425
   Icon            =   TRACKER.FRX:0000
   Left            =   780
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4020
   ScaleWidth      =   7365
   Top             =   1290
   Width           =   7485
   Begin ComboBox cboSystems 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   300
      Left            =   120
      Sorted          =   -1  'True
      TabIndex        =   0
      Top             =   360
      Width           =   1455
   End
   Begin Grid grdHistory 
      Cols            =   6
      FixedCols       =   0
      FixedRows       =   0
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   2895
      Left            =   120
      Rows            =   100
      TabIndex        =   2
      Top             =   960
      Width           =   7095
   End
   Begin ComboBox cboLibraries 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   300
      Left            =   1800
      Sorted          =   -1  'True
      Style           =   2  'Dropdown List
      TabIndex        =   1
      Top             =   360
      Width           =   1455
   End
   Begin CommandButton cmdDelete 
      Caption         =   "&Delete"
      Height          =   495
      Left            =   4920
      TabIndex        =   4
      Top             =   120
      Width           =   975
   End
   Begin CommandButton cmdUpdate 
      Caption         =   "&Update"
      Height          =   495
      Left            =   3600
      TabIndex        =   3
      Top             =   120
      Width           =   975
   End
   Begin CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   495
      Left            =   6240
      TabIndex        =   5
      Top             =   120
      Width           =   975
   End
   Begin Label zlblSystems 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      Caption         =   "System"
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Top             =   120
      Width           =   1455
   End
   Begin Label zlblHistory 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      Caption         =   "Backup History"
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   120
      TabIndex        =   7
      Top             =   720
      Width           =   7095
   End
   Begin Label zlblLibraries 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      Caption         =   "Library"
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   1800
      TabIndex        =   6
      Top             =   120
      Width           =   1455
   End
End
Option Explicit

 ' Constants:
  Const lNO_CALLBACK = 0&                   ' no call back used in TRACKER
  Const nMAX_NUMBER_OF_RECORDS = 100        ' maximum number of records shown
  Const sNO_BACKUP_DATE = "01/01/01"        ' a backup record not found
  Const sNO_BACKUP_RECORD = "None"          ' a backup record not found
  Const sNO_BACKUP_TIME = "00:00:00"        ' a backup record not found
  Const sSAVE_FILE = "Save file "           ' save device when save file used
  Const sSYSTEM_LIBRARY = "QSYS"            ' system library

 ' Variables:
  Dim sPriorSystem As String                ' last AS400 choosen

Sub cboLibraries_Click ()

 ' Description:
 '  When library selected put backup
 '  records into grid

 ' Variable:
  Dim nNumberofRecords  As Integer ' number of clip rows written
  Dim nVolumeNumber     As Integer ' current tape volume number
  Dim sClip             As String  ' data to put into clip
  Dim sVolume           As String  ' current tape volume

  ' please wait...
  Screen.MousePointer = HOURGLASS
  
  ' handle errors
  On Error Resume Next
  
  ' find first record
  tblBackup.Index = "Primary"
  tblBackup.Seek ">=", cboSystems.Text, sSYSTEM_LIBRARY, cboLibraries.List(cboLibraries.ListIndex)
  If tblBackup.NoMatch = False Then

    ' loop to read all records into grid
    Do While Trim$(cboSystems.Text) = Trim$(tblBackup("System")) And sSYSTEM_LIBRARY = Trim$(tblBackup("Library")) And Trim$(cboLibraries.Text) = Trim$(tblBackup("Object"))
	
      ' can only handle maximum number of records
      If nNumberofRecords = nMAX_NUMBER_OF_RECORDS Then Exit Do

      ' 1st column is empty
      sClip = sClip & gsCHR_TAB

      ' if no backup command then
      If tblBackup("Command") = sNO_BACKUP_RECORD Then

	' no backups present
	sClip = sClip & Format$(Date$, "SHORT DATE") & gsCHR_TAB
	sClip = sClip & Format$(Time$, "MEDIUM TIME") & gsCHR_TAB
	sClip = sClip & "No Backups"

      ' valid backup record
      Else
	
	' add date
	sClip = sClip & Format$(tblBackup("When"), "SHORT DATE") & gsCHR_TAB

	' add time
	sClip = sClip & Format$(tblBackup("When"), "MEDIUM TIME") & gsCHR_TAB

	' add command
	sClip = sClip & tblBackup("Command") & gsCHR_TAB

	' add device
	sClip = sClip & tblBackup("Device") & gsCHR_TAB

	' if save file used
	If tblBackup("Device") = sSAVE_FILE Then
	  
	  ' extract save file and library
	  sClip = sClip & tblBackup("Volumes") & gsCHR_TAB

	' if tape volumes used
	Else
 
	  ' extract volume 1
	  sClip = sClip & zzStrExtract((tblBackup("Volumes")), 1, 6)
       
	  ' extract volumes 2-10
	  For nVolumeNumber = 2 To 10
	    sVolume = zzStrExtract((tblBackup("Volumes")), nVolumeNumber, 6)
	    If Len(sVolume) > 0 Then sClip = sClip & "," & sVolume Else Exit For
	  Next nVolumeNumber

	End If

      End If
      
      ' add new row indicator
      sClip = sClip & gsCHR_CR

      ' increment counter
      nNumberofRecords = nNumberofRecords + 1
	
      ' get next, if none then exit
      tblBackup.MoveNext
      If tblBackup.EOF = True Then Exit Do
    
    Loop
  
  End If

  ' reset rows to current number
  If nNumberofRecords = 0 Then nNumberofRecords = nMAX_NUMBER_OF_RECORDS
  grdHistory.Rows = nNumberofRecords

  ' add data to grid
  grdHistory.SelStartRow = 0
  grdHistory.SelEndRow = nNumberofRecords - 1
  grdHistory.SelStartCol = 0
  grdHistory.SelEndCol = 5
  grdHistory.Clip = sClip
  grdHistory.Row = 0
  grdHistory_Click

  ' ...no more waiting
  Screen.MousePointer = DEFAULT

End Sub

Sub cboSystems_Change ()
  
  ' cannot be longer than eight characters
  If Len(cboSystems.Text) > 8 Then
    cboSystems.Text = Left$(cboSystems.Text, 8)
    cboSystems.SelStart = 8
  End If

End Sub

Sub cboSystems_Click ()
  
  ' if different system selected
  If sPriorSystem <> cboSystems.Text Then zfUpdateLibraryList

End Sub

Sub cboSystems_GotFocus ()

  ' store current system selected
  sPriorSystem = cboSystems.Text

End Sub

Sub cboSystems_KeyDown (KeyCode As Integer, Shift As Integer)

  ' enter is same as click
  If KeyCode = KEY_RETURN Then
    If sPriorSystem <> cboSystems.Text Then
      zfUpdateLibraryList
    End If
  End If

End Sub

Sub cboSystems_KeyPress (KeyAscii As Integer)
  
  ' convert to upper case
  KeyAscii = Asc(UCase$(Chr$(KeyAscii)))

End Sub

Sub cboSystems_LostFocus ()

  ' if different system selected
  If sPriorSystem <> cboSystems.Text Then zfUpdateLibraryList

End Sub

Sub cmdDelete_Click ()

 ' Description:
 '  Delete selected backup records

 ' Variables:
  Dim nPriorListIndex   As Integer     ' list index for cboLibraries
  Dim sDeleteDate       As String      ' date selected by user
  Dim vntNumericDate    As Variant     ' valid date checker

  ' build message to be displayed
  gsMBText = "All backup records for library " & RTrim$(cboLibraries.Text)
  gsMBText = gsMBText & " dated prior to date entered below"
  gsMBText = gsMBText & " will be deleted."
  
  ' loop until cancel choosen or valid date entered
  Do
    
    sDeleteDate = InputBox(gsMBText, App.Title)
    If sDeleteDate = gsEMPTY Then Exit Sub
    
    ' use date value function to validate date
    On Error Resume Next
    vntNumericDate = DateValue(sDeleteDate)
    On Error GoTo 0

  Loop Until vntNumericDate <> 0

  ' use primary index
  tblBackup.Index = "Primary"

  ' if first record found
  tblBackup.Seek ">=", cboSystems.Text, sSYSTEM_LIBRARY, cboLibraries.Text
  If tblBackup.NoMatch = False Then

    ' loop to read all matching records for system and library
    Do While Trim$(tblBackup("System")) = Trim$(cboSystems.Text) And Trim$(tblBackup("Library")) = sSYSTEM_LIBRARY And Trim$(tblBackup("Object")) = Trim$(cboLibraries.Text)

     ' if before selected date then delete
     If DateValue(tblBackup("When")) < vntNumericDate Then
       tblBackup.Delete
     End If

     ' get next record
     tblBackup.MoveNext
     If tblBackup.EOF Then Exit Do

    Loop

  End If

  ' save for reset after library rebuild
  nPriorListIndex = cboLibraries.ListIndex

  ' relist libraries
  zfUpdateLibraryList

  ' reset to library selected
  If cboLibraries.ListCount > nPriorListIndex Then
    cboLibraries.ListIndex = nPriorListIndex
  End If

End Sub

Sub cmdExit_Click ()
  
  ' unload main form
  Unload Me

End Sub

Sub cmdUpdate_Click ()

 ' Description:
 '  Perform process which will generate AS/400
 '  file which contains latest backup information
 '  and then download that file to the personal
 '  computer and update the Tracker data base.

 ' Variables:
  
  ' dspobjd command variables
  Dim nCmdRC              As Integer  ' return code
  Dim nRecordsDownloaded  As Integer  ' total records downloaded
  Dim nRecordsUpdated     As Integer  ' total records updated
  Dim sCmd                As String   ' command to submit
  Dim sCmdMsgs            As String   ' messages returned
  Dim sLibsNotBackedup    As String   ' list of librarys not backed up
  
  ' save information
  Dim sSaveCentury        As String   ' century
  Dim sSaveCmd            As String   ' command
  Dim sSaveDate           As String   ' date
  Dim sSaveDevice         As String   ' device
  Dim sSaveLibrary        As String   ' library
  Dim sSaveObj            As String   ' object
  Dim sSaveTime           As String   ' time
  Dim sSaveVols           As String   ' volumes 1-10 or SaveFile
  Dim vntSaveDateAndTime  As Variant  ' date and time

  ' file transfer variables
  Dim lTfrConvID          As Long     ' conversation id
  Dim nTfrRC              As Integer  ' return code
  Dim nTfrNumTemplates    As Integer  ' number of fields
  Dim sTfrDataRtnd        As String   ' data returned
  Dim sTfrRequest         As String   ' buffer

  ' disable all controls
  Call ControlsEnabled(False)
  
  ' does user want to continue with process
  If MsgBox("Are you sure you want to update backup history for " & cboSystems.Text & " at this time?", MB_YESNO Or MB_ICONQUESTION) = IDYES Then

    ' build the DSPOBJD command
    sCmd = "DSPOBJD "
    sCmd = sCmd & "OBJ(QSYS/*ALL) "
    sCmd = sCmd & "OBJTYPE(*LIB) "
    sCmd = sCmd & "OUTPUT(*OUTFILE) "
    sCmd = sCmd & "OUTFILE(QGPL/LIBLIST4VB)"
    
    ' please wait...
    Screen.MousePointer = HOURGLASS
    
    ' execute command
    nCmdRC = zzSRCmdFormatMsgsAndEnd(Me.hWnd, cboSystems.Text, sCmd, sCmdMsgs)
    
    ' ...no more waiting
    Screen.MousePointer = DEFAULT

    ' if command worked
    If nCmdRC = gnSR_OK Then

      ' build transfer request
      sTfrRequest = "SELECT * FROM QGPL/LIBLIST4VB"
      
      ' please wait...
      Screen.MousePointer = HOURGLASS
      
      ' execute file transfer
      nTfrRC = zzTFOpen(Me.hWnd, lNO_CALLBACK, lTfrConvID, sTfrRequest, cboSystems.Text, nTfrNumTemplates)
      
      ' ...no more waiting
      Screen.MousePointer = DEFAULT
	
      ' if select worked
      If nTfrRC = gnTF_OK Then

	' clear fields
	sLibsNotBackedup = gsEMPTY
	nRecordsDownloaded = 0
	nRecordsUpdated = 0

	' please wait...
	Screen.MousePointer = HOURGLASS
	
	' set beginning of transactions
	dbBackup.BeginTrans

	' retrieve records
	Do
    
	  DoEvents
    
	  ' get next record
	  nTfrRC = zzTFGetRecord(Me.hWnd, lNO_CALLBACK, lTfrConvID, cboSystems.Text, gnTF_NO_CONVERSION, sTfrDataRtnd)
      
	  ' exit on error or EOF
	  If nTfrRC <> gnTF_OK Then Exit Do

	  ' increment counter
	  nRecordsDownloaded = nRecordsDownloaded + 1
    
	  ' get library, object, and save century
	  sSaveLibrary = zzCV_EBCDICtoASCII(Me.hWnd, Mid$(sTfrDataRtnd, 14, 10))
	  sSaveObj = zzCV_EBCDICtoASCII(Me.hWnd, Mid$(sTfrDataRtnd, 24, 10))
	  sSaveCentury = RTrim$(zzCV_EBCDICtoASCII(Me.hWnd, Mid$(sTfrDataRtnd, 134, 1)))
    
	  ' show user object name
	  zlblLibraries.Caption = RTrim$(sSaveObj)
	  zlblLibraries.Refresh

	  ' not saved
	  If sSaveCentury = gsEMPTY Then

	    ' add to list for later message box
	    sLibsNotBackedup = sLibsNotBackedup & RTrim$(sSaveObj) & ", "

	    sSaveDate = sNO_BACKUP_DATE
	    sSaveTime = sNO_BACKUP_TIME
	    sSaveCmd = sNO_BACKUP_RECORD
	    sSaveDevice = sNO_BACKUP_RECORD
	    sSaveVols = sNO_BACKUP_RECORD

	  ' saved
	  Else

	    ' get date and format it
	    sSaveDate = zzCV_EBCDICtoASCII(Me.hWnd, Mid$(sTfrDataRtnd, 135, 6))
	    sSaveCentury = IIf(sSaveCentury = "0", "19", "20")
	    sSaveDate = DateSerial(Val(sSaveCentury & Mid$(sSaveDate, 5, 2)), Val(Mid$(sSaveDate, 1, 2)), Val(Mid$(sSaveDate, 3, 2)))

	    ' get time and format it
	    sSaveTime = zzCV_EBCDICtoASCII(Me.hWnd, Mid$(sTfrDataRtnd, 141, 6))
	    sSaveTime = Mid$(sSaveTime, 1, 2) & ":" & Mid$(sSaveTime, 3, 2) & ":" & Mid$(sSaveTime, 5, 2)
	    
	    ' get command, device, volume labels
	    sSaveCmd = zzCV_EBCDICtoASCII(Me.hWnd, Mid$(sTfrDataRtnd, 147, 10))
	    sSaveDevice = zzCV_EBCDICtoASCII(Me.hWnd, Mid$(sTfrDataRtnd, 165, 10))

	    ' if save file then get it
	    If sSaveDevice = sSAVE_FILE Then
	      sSaveVols = RTrim$(zzCV_EBCDICtoASCII(Me.hWnd, Mid$(sTfrDataRtnd, 371, 10)))
	      sSaveVols = sSaveVols & "/" & RTrim$(zzCV_EBCDICtoASCII(Me.hWnd, Mid$(sTfrDataRtnd, 361, 10)))
	    
	    ' if volumes used get them
	    Else
	      sSaveVols = zzCV_EBCDICtoASCII(Me.hWnd, Mid$(sTfrDataRtnd, 175, 60))
	    End If
  
	  End If

	  ' put date and time together
	  vntSaveDateAndTime = sSaveDate & " " & Format$(sSaveTime, "LONG TIME")

	  ' see if same record already exists
	  tblBackup.Index = "Primary"
	  tblBackup.Seek "=", cboSystems.Text, sSaveLibrary, sSaveObj, vntSaveDateAndTime

	  ' if it does not then write it
	  If tblBackup.NoMatch Then
	    
	    ' setup for new record
	    tblBackup.AddNew
	    
	    ' set fields
	    tblBackup("System") = cboSystems.Text
	    tblBackup("Library") = sSaveLibrary
	    tblBackup("Object") = sSaveObj
	    tblBackup("When") = vntSaveDateAndTime
	    tblBackup("Command") = sSaveCmd
	    tblBackup("Device") = sSaveDevice
	    tblBackup("Volumes") = sSaveVols
	    
	    ' update record
	    tblBackup.Update
	    
	    ' increment record count
	    nRecordsUpdated = nRecordsUpdated + 1

	  End If
	
	Loop

	' execute tranactions
	dbBackup.CommitTrans
	
	' close the conversation
	nTfrRC = zzTFEndConversation(Me.hWnd, lNO_CALLBACK, lTfrConvID, cboSystems.Text)
	
	' ...no more waiting
	Screen.MousePointer = DEFAULT

	' relist libraries
	zfUpdateLibraryList
  
	' sendup and show completion message
	gsMBText = "Update of backup records for " & cboSystems.Text & " complete. Backup information for "
	gsMBText = gsMBText & Format$(nRecordsDownloaded) & " libraries was downloaded, "
	If nRecordsUpdated = 0 Then
	  gsMBText = gsMBText & "no"
	Else
	  gsMBText = gsMBText & Format$(nRecordsUpdated)
	End If
	gsMBText = gsMBText & " libraries were updated with more recent backup data."
	If sLibsNotBackedup <> gsEMPTY Then
	  gsMBText = gsMBText & " The following libraries have not been backed up at all: "
	  gsMBText = gsMBText & Left$(sLibsNotBackedup, Len(sLibsNotBackedup) - 2) & "."
	End If
	MsgBox gsMBText, MB_ICONINFORMATION
      
      ' SELECT did not work
      Else
	gsMBText = "SELECT did not work, update terminated abnormally."
	MsgBox gsMBText, MB_ICONSTOP
      End If
    
    ' DSPOBJD did not work
    Else
      gsMBText = sCmdMsgs
      gsMBText = gsMBText & "Unable to display library descriptions."
      gsMBText = gsMBText & " Update terminated abnormally."
      MsgBox gsMBText, MB_ICONSTOP
    End If

  End If
  
  ' enable controls
  Call ControlsEnabled(True)

End Sub

Sub ControlsEnabled (ByVal bTrueorFalse%)

 ' Description:
 '  Turns controls off or on.

  cboLibraries.Enabled = bTrueorFalse
  cboSystems.Enabled = bTrueorFalse
  cmdDelete.Enabled = bTrueorFalse
  cmdExit.Enabled = bTrueorFalse
  cmdUpdate.Enabled = bTrueorFalse
  grdHistory.Enabled = bTrueorFalse

End Sub

Sub Form_Load ()

 ' Description:
 '  This procedure which runs when the Tracker
 '  form is loaded: opens the data base file,
 '  determines if the router is loaded, puts
 '  the list of available systems into a
 '  combo box, and setups the form location
 '  and the grid specifications.

 ' Variables:
  Dim nSystemCount As Integer   ' number of systems
  
  ' set caption to application title
  Caption = App.Title & " [" & gsTrackerDir & "]"

  ' open database
  On Error Resume Next
  Set dbBackup = OpenDatabase(gsTrackerDir & "\tracker.mdb", True, False)
  Call ShowErrMsg
  Set tblBackup = dbBackup.OpenTable("Backups")
  Call ShowErrMsg
  On Error GoTo 0
  
  ' if router loaded then
  If zzCARouterLoaded(Me.hWnd) Then

    ' place list of AS/400s into control
    Call zzCAPutSystemListIntoCtrl(Me.hWnd, cboSystems)
    
    ' get count of systems
    nSystemCount = zzCAGetSystemCount(Me.hWnd)
  
    ' if systems available
    If nSystemCount > 0 Then

      ' display system count in label
      zlblSystems.Caption = Format$(nSystemCount) & " System"
      If nSystemCount > 1 Then zlblSystems.Caption = zlblSystems.Caption & "s"

    Else
    
      ' no update if no systems
      cmdUpdate.Enabled = False

    End If

  ' no update if router not loaded
  Else
    cmdUpdate.Enabled = False
  End If
  
  ' center form
  Call zzFormCenter(Me)

  ' set grid rows and column widths
  grdHistory.Rows = nMAX_NUMBER_OF_RECORDS
  grdHistory.ColWidth(0) = 1
  grdHistory.ColWidth(1) = TextWidth("99/99/9999")
  grdHistory.ColWidth(2) = TextWidth("99:99 XX")
  grdHistory.ColWidth(3) = TextWidth("XXXXXXXXXX")
  grdHistory.ColWidth(4) = grdHistory.ColWidth(3)
  grdHistory.ColWidth(5) = grdHistory.ColWidth(3) * 7

  ' reset grid
  grdHistory_Click

  ' show the form
  Show
  Refresh

  ' set to first system on list
  If cboSystems.ListCount > 0 Then
    cboSystems.ListIndex = 0
  
  ' if no systems force clear of other controls
  Else
    Call zfUpdateLibraryList
  End If

End Sub

Sub Form_Unload (Cancel As Integer)

  ' handle errors
  On Error Resume Next
  
  ' close database
  tblBackup.Close
  dbBackup.Close

  ' end program
  End

End Sub

Sub grdHistory_Click ()

 ' Description:
 '  Make sure grid is reset when
 '  user trys to click on it

  ' no selected area
  grdHistory.SelStartRow = 0
  grdHistory.SelEndRow = 0
  grdHistory.SelStartCol = 0
  grdHistory.SelEndCol = 0

  ' current column
  grdHistory.Col = 0
  
  ' always show left most column
  grdHistory.LeftCol = 0

End Sub

Sub ShowErrMsg ()

 ' Description:
 '  Show error message

 ' Parameters:
 '  nErr          error number

 ' Variables

  ' if error occurred
  If Err <> 0 Then

    ' get and format message
    gsMBText = Error$
    If Right$(gsMBText, 1) <> "." Then
       gsMBText = gsMBText & "."
    End If

    ' show message
    MsgBox gsMBText, MB_ICONEXCLAMATION

    ' reset error number
    Err = 0

  End If

End Sub

Sub zfUpdateLibraryList ()

 ' Description:
 '  Rebuild library combo box from database

 ' Variables:
  Dim nLibraryCount As Integer  ' count of libraries selected
  Dim sPriorObject  As String  ' last object read from file
  
  ' please wait...
  Screen.MousePointer = HOURGLASS

  ' update prior system choosen
  sPriorSystem = cboSystems.Text

  ' clear the library list
  cboLibraries.Clear
  
  ' turn on error handling
  On Error Resume Next
  
  ' use index with only system and library as key
  tblBackup.Index = "Secondary"
  
  ' loop til no more unique libraries
  Do

    ' find next library for selected system
    tblBackup.Seek ">", sPriorSystem, sSYSTEM_LIBRARY, sPriorObject
    If tblBackup.NoMatch Then Exit Do

    ' must be the same system
    If tblBackup("System") <> sPriorSystem Then Exit Do
    
    ' place library from record into control
    sPriorObject = tblBackup("Object")
    cboLibraries.AddItem sPriorObject

    ' increment counter
    nLibraryCount = nLibraryCount + 1

    ' display every 50th library change
    If nLibraryCount Mod 50 = 0 Then
      zlblLibraries = Format$(nLibraryCount) & " Libraries"
      zlblLibraries.Refresh
    End If

  Loop
  
  ' no more error handling
  On Error GoTo 0
  
  ' refresh list and set delete button
  If cboLibraries.ListCount > 0 Then
    
    ' show final count
    zlblLibraries = Format$(cboLibraries.ListCount) & " Libraries"

    ' select first library
    cboLibraries.ListIndex = 0
    cmdDelete.Enabled = True

  Else
    
    ' no libraries found
    zlblLibraries = "No Libraries"
    
    ' reset the control
    cboLibraries_Click
    cmdDelete.Enabled = False

  End If
  
  ' ...no more waiting
  Screen.MousePointer = DEFAULT

End Sub

