PARSE UPPER ARG savf action dtaf mbr

  /*---------------------------------------------------------------*/
  /* SAVFREX - Copies data to and from a savefile.                 */
  /*---------------------------------------------------------------*/
  /*                                                               */
  /* Arguments:                                                    */
  /*   savf - Library and savefile name seperated by a '/'.        */
  /*   action - 'TOSAVF' - Data file to Savefile.                  */
  /*            'FROMSAVF' - Savefile to Data file.                */
  /*   dtaf - Library and data file name seperated by a '/'.       */
  /*   mbr - data file member name                                 */
  /*                                                               */
  /*---------------------------------------------------------------*/

/* fix the member name */
If Length(mbr) == 0 Then mbr = '*First'

/* Evaluate the action argument */
SELECT

  When action = 'TOSAVF' THEN DO
    /* copy the data from data file to savefile */
    'OVRDBF FILE(STDIN) TOFILE('dtaf') MBR('mbr')'
    'OVRDBF FILE(STDOUT) TOFILE('savf')'
  END

  When action = 'FROMSAVF' THEN DO
    /* copy the data from savf to data file */
    'OVRDBF FILE(STDIN) TOFILE('savf')'
    'OVRDBF FILE(STDOUT) TOFILE('dtaf') MBR('mbr')'
  END

  Otherwise
    /* exit program if action is not found */
    Exit

END                            /* End Select */

/* reads a line from stdin and writes it to stdout */
DO FOREVER
  PARSE LINEIN line            /* read a line from stdin */
  IF line == '' THEN LEAVE     /* leave do if no data */
  SAY line                     /* write to stdout */
END

RETURN                         /* return to caller */
