VERSION 2.00
Begin Form frmViewer 
   Caption         =   "Icon Viewer"
   ClientHeight    =   5820
   ClientLeft      =   1095
   ClientTop       =   1485
   ClientWidth     =   7365
   Height          =   6225
   Icon            =   ICONVIEW.FRX:0000
   KeyPreview      =   -1  'True
   Left            =   1035
   LinkTopic       =   "Form1"
   ScaleHeight     =   388
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   491
   Top             =   1140
   Width           =   7485
   Begin VScrollBar vsbIcons 
      Height          =   4275
      Left            =   2070
      TabIndex        =   1
      Top             =   0
      Visible         =   0   'False
      Width           =   270
   End
   Begin PictureBox picIcons 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   0  'None
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "System"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   4245
      Left            =   0
      MousePointer    =   10  'Up Arrow
      ScaleHeight     =   283
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   138
      TabIndex        =   0
      TabStop         =   0   'False
      Top             =   0
      Width           =   2070
   End
End
Option Explicit

Sub Form_KeyDown (KeyCode As Integer, Shift As Integer)

 ' Description:
 '  Handle keystrokes

  ' ALT+F4: exit
  If Shift = 4 And KeyCode = 115 Then
    Unload frmMorph
  
  ' CTRL+B: toggle borders
  ElseIf Shift = 2 And KeyCode = 66 Then
    Call zzBordersToggle
  
  ' CTRL+C: copy icon
  ElseIf Shift = 2 And KeyCode = 67 Then
    Call zzCopyIcon
  
  ' CTRL+F: float options window
  ElseIf Shift = 2 And KeyCode = 70 Then
    Call zzOptionsFloat
    If Not frmMorph!mnuOpFloat.Checked Then Me.SetFocus
    
  ' CTRL+G: grey background
  ElseIf Shift = 2 And KeyCode = 71 Then
    Call zzGreyToggle

  ' CTRL+I: morph and save all
  ElseIf Shift = 2 And KeyCode = 73 Then
    Call zzSaveIcons

  ' CTRL+M: morph and save one
  ElseIf Shift = 2 And KeyCode = 77 Then
    Call zzMorphOne
  
  ' CTRL+N: rename icon
  ElseIf Shift = 2 And KeyCode = 78 Then
    Call zzRenameIcon
  
  ' CTRL+O: set directory change flag
  ElseIf Shift = 2 And KeyCode = 79 Then
    frmMorph!mnuOpShowOnChange.Checked = Not frmMorph!mnuOpShowOnChange.Checked
  
  ' CTRL+P: save files in program directory flag
  ElseIf Shift = 2 And KeyCode = 80 Then
    frmMorph!mnuOpSaveAppDir.Checked = Not frmMorph!mnuOpSaveAppDir.Checked
  
  ' CTRL+R: refresh listing
  ElseIf Shift = 2 And KeyCode = 82 Then
    Call zzRefreshIcons
  
  ' CTRL+V: show viewer
  ElseIf Shift = 2 And KeyCode = 86 Then
    Call zzViewerToggle
  
  ' CTRL+W: overwrite warning
  ElseIf Shift = 2 And KeyCode = 87 Then
    frmMorph!mnuOpWarn.Checked = Not frmMorph!mnuOpWarn.Checked
    gbWarning = frmMorph!mnuOpWarn.Checked
  
  ' CTRL+Y: warning before delete
  ElseIf Shift = 2 And KeyCode = 89 Then
    frmMorph!mnuOpDeleteWarn.Checked = Not frmMorph!mnuOpDeleteWarn.Checked

  ' DEL: delete icon
  ElseIf KeyCode = 46 Then
    zzDeleteIcon
  End If

End Sub

Sub Form_Load ()

  ' calculate minimum form size
  gnWidthViewerMin = (vsbIcons.Left + vsbIcons.Width + glICON_CELL + 2) * 15 + (Width - ScaleWidth * 15)
  gnHeightViewerMin = glICON_CELL * 6 * 15 + (Height - ScaleHeight * 15)
  
  ' set size
  Me.Width = gnWidthViewerMin
  Me.Height = frmMorph.Height

  ' remove close option
  Call zzFormSysMenuRemove(Me.hWnd, SC_CLOSE)

End Sub

Sub Form_QueryUnload (Cancel As Integer, unloadmode As Integer)

  ' if user closing then just hide
  If unloadmode = 0 Then
    
    ' reset menu option
    frmMorph!mnuOpViewer.Checked = False
    
    ' cancel close and hide
    Cancel = True: Hide

  End If
  
End Sub

Sub Form_Resize ()

  ' perform resize
  Call zzResizeViewer
 
End Sub

Sub picIcons_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)

 ' Description:
 '  Select an icon

 ' Variables:
  Dim nIconX        As Integer     ' column location
  Dim nIconY        As Integer     ' row location
  Dim nIconSelected As Integer     ' icon selected

  ' calculate the column of the selected Icon position.
  nIconX = X \ glICON_CELL
        
  ' if any icons exist in that column
  If nIconX < gnIconCols Then
  
    ' calculate row
    nIconY = (Y \ glICON_CELL) + vsbIcons.Value

    ' calculate selected icon
    nIconSelected = (nIconY * gnIconCols) + nIconX

    ' if valid icon select from listbox
    If nIconSelected < frmMorph!lstFiles.ListCount Then
      frmMorph!lstFiles.ListIndex = -1
      frmMorph!lstFiles.ListIndex = nIconSelected
    End If
  
  End If

  ' if right button
  If Button = 2 Then PopupMenu frmMorph!mnuOp, 2
  
End Sub

Sub picIcons_Paint ()

  ' update viewing area
  If frmMorph!lstFiles.ListCount > 0 Then zzDisplayIcons

End Sub

Sub vsbIcons_Change ()

  ' scroll icons
  zzDisplayIcons

End Sub

