VERSION 2.00
Begin Form frmMorph 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Mighty Morphing Icon Program"
   ClientHeight    =   4815
   ClientLeft      =   3690
   ClientTop       =   3225
   ClientWidth     =   5865
   ClipControls    =   0   'False
   FontBold        =   0   'False
   FontItalic      =   0   'False
   FontName        =   "Courier"
   FontSize        =   9.75
   FontStrikethru  =   0   'False
   FontTransparent =   0   'False
   FontUnderline   =   0   'False
   ForeColor       =   &H00000000&
   Height          =   5550
   Icon            =   ICONMORF.FRX:0000
   Left            =   3630
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   ScaleHeight     =   26
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   160
   Tag             =   "IconWrks Viewer"
   Top             =   2550
   Width           =   5985
   Begin PictureBox picBitmap 
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   855
      Left            =   1770
      ScaleHeight     =   855
      ScaleWidth      =   885
      TabIndex        =   29
      Top             =   7710
      Width           =   885
   End
   Begin FileListBox filList 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   2760
      Left            =   90
      Pattern         =   "*.ico"
      TabIndex        =   28
      TabStop         =   0   'False
      Top             =   7710
      Visible         =   0   'False
      Width           =   1515
   End
   Begin PictureBox picStorage 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   0  'None
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "System"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   555
      Index           =   2
      Left            =   120
      ScaleHeight     =   37
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   33
      TabIndex        =   26
      TabStop         =   0   'False
      Top             =   6810
      Width           =   495
   End
   Begin PictureBox picStorage 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   0  'None
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "System"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   555
      Index           =   1
      Left            =   120
      ScaleHeight     =   37
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   33
      TabIndex        =   25
      TabStop         =   0   'False
      Top             =   6210
      Width           =   495
   End
   Begin Frame fraPath 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Path"
      Height          =   3135
      Left            =   60
      TabIndex        =   12
      Top             =   30
      Width           =   3225
      Begin DirListBox dirList 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   1830
         Left            =   120
         TabIndex        =   0
         Top             =   510
         Width           =   3015
      End
      Begin DriveListBox drvList 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   150
         TabIndex        =   1
         Top             =   2700
         Width           =   3015
      End
      Begin Label zlblDirs 
         BackStyle       =   0  'Transparent
         Caption         =   "&Directories:"
         Height          =   210
         Left            =   120
         TabIndex        =   13
         Top             =   240
         Width           =   1365
      End
      Begin Label zlblDrives 
         BackStyle       =   0  'Transparent
         Caption         =   "Dri&ves:"
         Height          =   210
         Left            =   120
         TabIndex        =   14
         Top             =   2460
         Width           =   1365
      End
   End
   Begin Frame fraIcons 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Icons"
      Height          =   3135
      Left            =   3360
      TabIndex        =   22
      Top             =   60
      Width           =   2445
      Begin OptionButton optPattern 
         BackColor       =   &H00C0C0C0&
         Caption         =   "*.*"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   3
         Left            =   1650
         TabIndex        =   31
         Top             =   2400
         Width           =   615
      End
      Begin OptionButton optPattern 
         BackColor       =   &H00C0C0C0&
         Caption         =   "*.ico"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   2
         Left            =   1650
         TabIndex        =   5
         Top             =   1860
         Width           =   615
      End
      Begin ListBox lstFiles 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   2760
         Left            =   120
         TabIndex        =   2
         Top             =   240
         Width           =   1455
      End
      Begin OptionButton optPattern 
         BackColor       =   &H00C0C0C0&
         Caption         =   "*.bmp"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   1
         Left            =   1650
         TabIndex        =   4
         Top             =   1350
         Width           =   705
      End
      Begin OptionButton optPattern 
         BackColor       =   &H00C0C0C0&
         Caption         =   "*.ico"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   0
         Left            =   1650
         TabIndex        =   3
         Top             =   870
         Width           =   615
      End
      Begin PictureBox picSelectedIcon 
         AutoRedraw      =   -1  'True
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "System"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   480
         Left            =   1710
         ScaleHeight     =   32
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   32
         TabIndex        =   23
         Top             =   270
         Width           =   480
      End
      Begin PictureBox picPrint 
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   0  'None
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Left            =   120
         ScaleHeight     =   285
         ScaleWidth      =   1515
         TabIndex        =   27
         Top             =   270
         Visible         =   0   'False
         Width           =   1515
      End
      Begin Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "*.bmp"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Left            =   1860
         TabIndex        =   30
         Top             =   2070
         Width           =   405
      End
      Begin Shape shpSelectedIcon 
         Height          =   555
         Left            =   1680
         Top             =   240
         Width           =   555
      End
   End
   Begin Frame fraMorph 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Bitmap Size To Save To Disk"
      Height          =   1575
      Left            =   60
      TabIndex        =   16
      Top             =   3180
      Width           =   5745
      Begin OptionButton optMorph 
         BackColor       =   &H00C0C0C0&
         Caption         =   "64x64"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   5
         Left            =   4590
         TabIndex        =   11
         Top             =   1290
         Width           =   795
      End
      Begin PictureBox picMorph 
         AutoRedraw      =   -1  'True
         AutoSize        =   -1  'True
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "System"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   960
         Index           =   5
         Left            =   4620
         ScaleHeight     =   64
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   64
         TabIndex        =   24
         Top             =   270
         Width           =   960
      End
      Begin OptionButton optMorph 
         BackColor       =   &H00C0C0C0&
         Caption         =   "16x16"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   0
         Left            =   150
         TabIndex        =   6
         Top             =   1290
         Width           =   735
      End
      Begin OptionButton optMorph 
         BackColor       =   &H00C0C0C0&
         Caption         =   "20x20"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   1
         Left            =   960
         TabIndex        =   7
         Top             =   1290
         Width           =   765
      End
      Begin OptionButton optMorph 
         BackColor       =   &H00C0C0C0&
         Caption         =   "24x24"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   2
         Left            =   1830
         TabIndex        =   8
         Top             =   1290
         Width           =   795
      End
      Begin OptionButton optMorph 
         BackColor       =   &H00C0C0C0&
         Caption         =   "32x32"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   3
         Left            =   2730
         TabIndex        =   9
         Top             =   1290
         Width           =   735
      End
      Begin OptionButton optMorph 
         BackColor       =   &H00C0C0C0&
         Caption         =   "48x48"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   4
         Left            =   3600
         TabIndex        =   10
         Top             =   1290
         Width           =   795
      End
      Begin PictureBox picMorph 
         AutoRedraw      =   -1  'True
         AutoSize        =   -1  'True
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "System"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   720
         Index           =   4
         Left            =   3630
         ScaleHeight     =   48
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   48
         TabIndex        =   21
         Top             =   510
         Width           =   720
      End
      Begin PictureBox picMorph 
         AutoRedraw      =   -1  'True
         AutoSize        =   -1  'True
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "System"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   480
         Index           =   3
         Left            =   2760
         ScaleHeight     =   32
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   32
         TabIndex        =   20
         Top             =   750
         Width           =   480
      End
      Begin PictureBox picMorph 
         AutoRedraw      =   -1  'True
         AutoSize        =   -1  'True
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "System"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   360
         Index           =   2
         Left            =   1860
         ScaleHeight     =   24
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   24
         TabIndex        =   19
         Top             =   870
         Width           =   360
      End
      Begin PictureBox picMorph 
         AutoRedraw      =   -1  'True
         AutoSize        =   -1  'True
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "System"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   300
         Index           =   1
         Left            =   990
         ScaleHeight     =   20
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   20
         TabIndex        =   18
         Top             =   930
         Width           =   300
      End
      Begin PictureBox picMorph 
         AutoRedraw      =   -1  'True
         AutoSize        =   -1  'True
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "System"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   240
         Index           =   0
         Left            =   180
         ScaleHeight     =   16
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   16
         TabIndex        =   17
         Top             =   990
         Width           =   240
      End
      Begin Shape shpMorph 
         Height          =   1035
         Index           =   5
         Left            =   4590
         Top             =   240
         Width           =   1035
      End
      Begin Shape shpMorph 
         Height          =   795
         Index           =   4
         Left            =   3600
         Top             =   480
         Width           =   795
      End
      Begin Shape shpMorph 
         Height          =   555
         Index           =   3
         Left            =   2730
         Top             =   720
         Width           =   555
      End
      Begin Shape shpMorph 
         Height          =   435
         Index           =   2
         Left            =   1830
         Top             =   840
         Width           =   435
      End
      Begin Shape shpMorph 
         Height          =   375
         Index           =   1
         Left            =   960
         Top             =   900
         Width           =   375
      End
      Begin Shape shpMorph 
         Height          =   315
         Index           =   0
         Left            =   150
         Top             =   960
         Width           =   315
      End
   End
   Begin PictureBox picStorage 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   0  'None
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "System"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   555
      Index           =   0
      Left            =   120
      ScaleHeight     =   37
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   33
      TabIndex        =   15
      TabStop         =   0   'False
      Top             =   5610
      Width           =   495
   End
   Begin Menu mnuOp 
      Caption         =   "&Options"
      Begin Menu mnuOpMorphOne 
         Caption         =   "&Morph And &Save Icon"
         Shortcut        =   ^M
      End
      Begin Menu mnuOpCopy 
         Caption         =   "&Copy Icon"
         Shortcut        =   ^C
      End
      Begin Menu mnuOpDelete 
         Caption         =   "&Delete Icon"
         Shortcut        =   {DEL}
      End
      Begin Menu mnuOpRename 
         Caption         =   "Re&name Icon"
         Shortcut        =   ^N
      End
      Begin Menu mnuOpZ05 
         Caption         =   "-"
      End
      Begin Menu mnuOpMorphAll 
         Caption         =   "Morph And Save All &Icons"
         Shortcut        =   ^I
      End
      Begin Menu mnuOpDeleteAll 
         Caption         =   "Delete All"
      End
      Begin Menu mnuOpZ10 
         Caption         =   "-"
      End
      Begin Menu mnuOpViewer 
         Caption         =   "Display &Viewer"
         Checked         =   -1  'True
         Shortcut        =   ^V
      End
      Begin Menu mnuOpFloat 
         Caption         =   "&Float Options Window"
         Shortcut        =   ^F
      End
      Begin Menu mnuOpGrey 
         Caption         =   "&Grey Background"
         Shortcut        =   ^G
      End
      Begin Menu mnuOpBorders 
         Caption         =   "Show &Borders"
         Checked         =   -1  'True
         Shortcut        =   ^B
      End
      Begin Menu mnuOpZ20 
         Caption         =   "-"
      End
      Begin Menu mnuOpShowAll 
         Caption         =   "&Refresh All Icons"
         Shortcut        =   ^R
      End
      Begin Menu mnuOpShowOnChange 
         Caption         =   "Refresh Icons &On Directory Change"
         Checked         =   -1  'True
         Shortcut        =   ^O
      End
      Begin Menu mnuOpZ50 
         Caption         =   "-"
      End
      Begin Menu mnuOpSaveAppDir 
         Caption         =   "Save Files To &Program Directory"
         Shortcut        =   ^P
      End
      Begin Menu mnuOpZ70 
         Caption         =   "-"
      End
      Begin Menu mnuOpDeleteWarn 
         Caption         =   "Displa&y Warning Before Deleting File"
         Checked         =   -1  'True
         Shortcut        =   ^Y
      End
      Begin Menu mnuOpWarn 
         Caption         =   "Display &Warning Before Overwriting File"
         Shortcut        =   ^W
      End
      Begin Menu mnuOpZ75 
         Caption         =   "-"
      End
      Begin Menu mnuOpMorph 
         Caption         =   "&16 x 16 Bitmap"
         Index           =   0
      End
      Begin Menu mnuOpMorph 
         Caption         =   "&20 x 20 Bitmap"
         Index           =   1
      End
      Begin Menu mnuOpMorph 
         Caption         =   "24 x 24 &Bitmap"
         Index           =   2
      End
      Begin Menu mnuOpMorph 
         Caption         =   "&32 x 32 Bitmap"
         Index           =   3
      End
      Begin Menu mnuOpMorph 
         Caption         =   "&48 x 48 Bitmap"
         Index           =   4
      End
      Begin Menu mnuOpMorph 
         Caption         =   "&64 x 64 Bitmap"
         Index           =   5
      End
      Begin Menu mnuOpZ80 
         Caption         =   "-"
      End
      Begin Menu mnuOpAbout 
         Caption         =   "&About"
      End
      Begin Menu mnuOpZ99 
         Caption         =   "-"
      End
      Begin Menu mnuOpExit 
         Caption         =   "E&xit"
      End
   End
End
Option Explicit

Sub dirList_Change ()
  
  ' change to selected directory
  ChDir dirList.Path
  
  ' update file list box
  filList.Path = dirList.Path

End Sub

Sub dirList_KeyPress (KeyAscii As Integer)

  ' change path with enter
  If KeyAscii = 13 Then
    dirList.Path = dirList.List(dirList.ListIndex)
  End If

End Sub

Sub drvList_Change ()

 ' Description:
 '  Check if drive is ready
    
 ' Variables
  Dim s1 As String

  ' handle errors
  On Error Resume Next
  Err = False

  ' make error happen
  s1 = Dir$(Left$(drvList.Drive, 2))

  ' if drive was not ready
  If Err Then

    MsgBox Error, MB_ICONSTOP
    drvList.Drive = Left$(dirList.Path, 2)

  ' if OK
  Else
    ChDrive drvList.Drive
    dirList.Path = CurDir$
  End If

End Sub

Sub filList_PathChange ()

 ' Description:
 '  When the path or file name changes
 '  because of code or events then this
 '  routine will execute.
 
 '  It updates the display of the selected
 '  icon and if the option is turned on will
 '  update the viewer also.
    
  ' erase displayed icon
  ' and morphed versions
  Call zzClearIcon

  ' if all icons being shown on directory change
  If mnuOpShowOnChange.Checked Then
    
    ' show all icons
    mnuOpShowAll_Click

  Else

    ' set to first icon in list
    If filList.ListCount > 0 Then
      filList.ListIndex = -1
      filList.ListIndex = 0

    ' clear viewing window if none
    Else
      mnuOpShowAll_Click
    End If
  
  End If

  ' display the number of icons in the current directory
  fraIcons.Caption = Format$(filList.ListCount) + " &Icons"
  
  ' enable/disable menu options
  Call zzResetMenuOptions

End Sub

Sub Form_Load ()

  ' loading process
  gbLoading = True

  ' setup global variables
  Call zzSetGlobalVariables

  ' setup title
  App.Title = Caption

  ' load viewer
  Load frmViewer

  ' position forms
  Me.Left = Screen.Width \ 2 - ((Me.Width + frmViewer.Width) \ 2)
  Me.Top = Screen.Height \ 2 - Me.Height \ 2
  frmViewer.Left = Me.Left + Me.Width
  frmViewer.Top = Me.Top
  
  ' show forms
  frmViewer.Show
  Me.Show

  ' place borders on pictures
  zfSurroundPicture shpSelectedIcon, picSelectedIcon
  zfSurroundPicture shpMorph(0), picMorph(0)
  zfSurroundPicture shpMorph(1), picMorph(1)
  zfSurroundPicture shpMorph(2), picMorph(2)
  zfSurroundPicture shpMorph(3), picMorph(3)
  zfSurroundPicture shpMorph(4), picMorph(4)
  zfSurroundPicture shpMorph(5), picMorph(5)

  ' setup menu caption
  mnuOpExit.Caption = "E&xit" & gsCHR_TAB & "Alt+F4"

  ' setup bitmap sizes
  gnBMPx(0) = 16: gnBMPy(0) = 16
  gnBMPx(1) = 20: gnBMPy(1) = 20
  gnBMPx(2) = 24: gnBMPy(2) = 24
  gnBMPx(3) = 32: gnBMPy(3) = 32
  gnBMPx(4) = 48: gnBMPy(4) = 48
  gnBMPx(5) = 64: gnBMPy(5) = 64
  
  ' default to 20 x 20 bitmap
  Call mnuOpMorph_Click(1)

  ' default to warning on overwrite
  ' of an existing file
  Call mnuOpWarn_Click

  ' setup icon list caption
  fraIcons.Caption = Format$(filList.ListCount) + " &Icons"

  ' use *.ico
  optPattern(0).Value = 1

  ' loading process done
  gbLoading = False

End Sub

Sub Form_Unload (Cancel As Integer)

  ' unload viewer
  Unload frmViewer

  ' end program
  End

End Sub

Sub lstFiles_Click ()

  ' if file selected
  If lstFiles.ListIndex >= 0 Then
    
    ' if valid icon then load to picture
    If zzFileType(lstFiles.List(lstFiles.ListIndex), True) <> gnTYPE_BAD Then
      Call zzLoadIcon(lstFiles.List(lstFiles.ListIndex))

    ' else clear picture
    Else
      Call zzClearIcon
    End If

  End If

End Sub

Sub mnuOpAbout_Click ()

  Dim s1 As String
  
  s1 = "This program converts icons to bitmaps"
  s1 = s1 & " of various sizes so they can be used"
  s1 = s1 & " on toolbars."
  
  s1 = s1 & " You may toggle the background color"
  s1 = s1 & " of the bitmap from white to grey to"
  s1 = s1 & " reduce the amount of work you have"
  s1 = s1 & " to do to create a button."
  
  s1 = s1 & " You may vary the size of the bitmap"
  s1 = s1 & " from 64x64 down to 16x16. Each icon"
  s1 = s1 & " ""morphed"" will cause the creation"
  s1 = s1 & " of a bitmap with the same name but"
  s1 = s1 & " with a .BMP extension."
  
  s1 = s1 & " Be careful because any existing file"
  s1 = s1 & " will be overridden when ""morphing""!"
  
  s1 = s1 & "  Enjoy... Genesis Software."
  
  MsgBox s1, MB_ICONINFORMATION

End Sub

Sub mnuOpBorders_Click ()

  ' show and hide borders
  Call zzBordersToggle

End Sub

Sub mnuOpCopy_Click ()

  ' delete selected icon
  Call zzCopyIcon

End Sub

Sub mnuOpDelete_Click ()
 
  ' delete selected icon
  Call zzDeleteIcon

End Sub

Sub mnuOpDeleteAll_Click ()

  Call zzDeleteIcons

End Sub

Sub mnuOpDeleteWarn_Click ()

  ' toggle warning
  mnuOpDeleteWarn.Checked = Not mnuOpDeleteWarn.Checked

End Sub

Sub mnuOpExit_Click ()

  Unload Me

End Sub

Sub mnuOpFloat_Click ()

  ' toggle float option
  Call zzOptionsFloat
  
End Sub

Sub mnuOpGrey_Click ()

  ' toggle between grey and white
  Call zzGreyToggle

End Sub

Sub mnuOpMorph_Click (Index As Integer)

  ' setup bitmap size selected
  gnBMP = Index

  ' toggle menu options
  mnuOpMorph(0).Checked = False
  mnuOpMorph(1).Checked = False
  mnuOpMorph(2).Checked = False
  mnuOpMorph(3).Checked = False
  mnuOpMorph(4).Checked = False
  mnuOpMorph(5).Checked = False
  mnuOpMorph(gnBMP).Checked = True

  ' set morph option button
  optMorph(gnBMP) = True

  ' display item with new size
  Call lstFiles_Click

End Sub

Sub mnuOpMorphAll_Click ()
  
  ' morph all icons
  zzSaveIcons

End Sub

Sub mnuOpMorphOne_Click ()

  ' morph selected icon
  Call zzMorphOne

End Sub

Sub mnuOpRename_Click ()

  ' rename icon
  Call zzRenameIcon

End Sub

Sub mnuOpSaveAppDir_Click ()

  ' toggle switch to save to local directory
  mnuOpSaveAppDir.Checked = Not mnuOpSaveAppDir.Checked

End Sub

Sub mnuOpShowAll_Click ()

  ' refresh all icons
  Call zzRefreshIcons

End Sub

Sub mnuOpShowOnChange_Click ()
  
  ' toggle the checked property
  mnuOpShowOnChange.Checked = Not mnuOpShowOnChange.Checked

End Sub

Sub mnuOpViewer_Click ()

  ' switch viewer off and on
  Call zzViewerToggle

End Sub

Sub mnuOpWarn_Click ()

  ' toggle warning
  mnuOpWarn.Checked = Not mnuOpWarn.Checked
  gbWarning = mnuOpWarn.Checked
  
End Sub

Sub optMorph_Click (Index As Integer)
  
  ' call menu routine that sets option
  Call mnuOpMorph_Click(Index)

End Sub

Sub optPattern_Click (Index As Integer)

  ' change pattern
  If Index = 0 Then
    filList.Pattern = "*.ico"
  ElseIf Index = 1 Then
    filList.Pattern = "*.bmp"
  ElseIf Index = 2 Then
    filList.Pattern = "*.ico;*.bmp"
  ElseIf Index = 3 Then
    filList.Pattern = "*.*"
  End If

  ' set global variable
  gnFilter = Index

  ' redisplay stuff
  Call mnuOpShowAll_Click

End Sub

Sub zfSurroundPicture (shp As Shape, pic As PictureBox)

  ' position shapre around picture
  shp.Left = pic.Left - 10: shp.Top = pic.Top - 10
  shp.Width = pic.Width + 30: shp.Height = pic.Height + 30
  
End Sub

