VERSION 2.00
Begin Form frmExtract 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Stash File Image Extractor"
   ClientHeight    =   2670
   ClientLeft      =   3495
   ClientTop       =   3270
   ClientWidth     =   4605
   Height          =   3390
   Icon            =   FRXTRACT.FRX:0000
   Left            =   3435
   LinkTopic       =   "Form1"
   ScaleHeight     =   2670
   ScaleWidth      =   4605
   Top             =   2610
   Width           =   4725
   Begin CommandButton cmdOpen 
      Caption         =   "&Open Stash File..."
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   375
      Left            =   150
      TabIndex        =   0
      Top             =   2160
      Width           =   1665
   End
   Begin CommandButton cmdExit 
      Caption         =   "E&xit"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   375
      Left            =   2670
      TabIndex        =   1
      Top             =   2160
      Width           =   1665
   End
   Begin Frame fraDir 
      Caption         =   "Store Extracted Images In..."
      Height          =   1965
      Left            =   60
      TabIndex        =   8
      Top             =   90
      Width           =   4425
      Begin CheckBox chkMsg 
         Caption         =   "Prompt Before Extracting"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Left            =   150
         TabIndex        =   9
         Top             =   1650
         Width           =   2355
      End
      Begin CheckBox chkOverWrite 
         Caption         =   "Overwrite Existing Files"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Left            =   150
         TabIndex        =   7
         Top             =   1350
         Width           =   1995
      End
      Begin ComboBox cboOther 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   870
         TabIndex        =   5
         Top             =   960
         Width           =   3435
      End
      Begin CommandButton cmdBrowse 
         Caption         =   "Browse..."
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   375
         Left            =   2610
         TabIndex        =   6
         Top             =   1410
         Width           =   1665
      End
      Begin OptionButton optDir 
         Caption         =   "Same Directory That Contains Image Extractor"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   345
         Index           =   0
         Left            =   120
         TabIndex        =   2
         Top             =   270
         Width           =   4125
      End
      Begin OptionButton optDir 
         Caption         =   "Same Directory That Contains Stash File (.FRX)"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Index           =   1
         Left            =   120
         TabIndex        =   3
         Top             =   630
         Width           =   4155
      End
      Begin OptionButton optDir 
         Caption         =   "Other:"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Index           =   2
         Left            =   120
         TabIndex        =   4
         Top             =   960
         Width           =   825
      End
   End
   Begin CommonDialog cdl 
      Left            =   420
      Top             =   9960
   End
   Begin Menu mnuFi 
      Caption         =   "&File"
      Begin Menu mnuFiOpen 
         Caption         =   "&Open Stash File..."
      End
      Begin Menu mnuFiZ50 
         Caption         =   "-"
      End
      Begin Menu mnuFiAbout 
         Caption         =   "&About"
      End
      Begin Menu mnuFiZ99 
         Caption         =   "-"
      End
      Begin Menu mnuFiExit 
         Caption         =   "E&xit"
      End
   End
End
Option Explicit

 ' Variables:
  Dim n1    As Integer           ' loop counter
  Dim nRC   As Integer           ' return code
  Dim s1    As String            ' work string

Sub cboOther_KeyPress (KeyAscii As Integer)

  ' make sure it is caps
  KeyAscii = Asc(UCase$(Chr$(KeyAscii)))

End Sub

Sub cboOther_LostFocus ()

  ' see if selected path already in combo box
  s1 = UCase$(cboOther.Text)
  For n1 = 0 To cboOther.ListCount - 1
    If s1 = cboOther.List(n1) Then
      cboOther.ListIndex = n1
      Exit Sub
    End If
  Next n1

  ' add item and set to that item
  cboOther.AddItem s1, 0
  cboOther.ListIndex = 0

End Sub

Sub cmdBrowse_Click ()

  ' load directory browse form
  Load frmDirectory
  
  ' position in relationship to this form
  frmDirectory.Left = Left + Screen.Width / 10
  frmDirectory.Top = Top + Screen.Height / 10

  ' start with current directory
  On Error Resume Next
  frmDirectory!dirList.Path = cboOther.Text

  ' show the form
  frmDirectory.Show MODAL

End Sub

Sub cmdExit_Click ()
    
  ' unload form
  Unload Me

End Sub

Sub cmdOpen_Click ()

  ' call open option
  Call mnuFiOpen_Click

End Sub

Sub Form_Load ()

  ' setup global variables
  Call zzSetGlobalVariables

  ' center the form
  zzFormCenter Me

  ' setup title
  App.Title = Caption

  ' get previously selected directories
  nRC = zzINISetFile(App.Path & "\FRXTRACT.INI")
  nRC = zzINISetSection("CONFIG")

  ' get previous directory selections
  ' and place them into combo box
  For n1 = 0 To 9
    nRC = zzINIGetString("Directory" & Format$(n1), s1)
    If s1 <> gsEMPTY Then cboOther.AddItem s1
  Next n1
  
  ' selected directory
  nRC = zzINIGetInteger("DirNumber", n1)
  If cboOther.ListCount > 0 Then cboOther.ListIndex = n1

  ' setup save to option
  nRC = zzINIGetInteger("Option", n1)
  optDir(n1).Value = True

  ' setup override option
  nRC = zzINIGetInteger("OverWrite", n1)
  chkOverWrite.Value = n1

  ' setup message option
  nRC = zzINIGetInteger("Prompt", n1)
  chkMsg.Value = n1

End Sub

Sub Form_Unload (Cancel As Integer)

  ' delete entire INI section
  nRC = zzINIDelSection("CONFIG")
  
  ' get current directory selections
  ' and save them to INI file
  For n1 = 0 To 9
    s1 = cboOther.List(n1 - 1)
    nRC = zzINIPutString("Directory" & Format$(n1), s1)
  Next n1

  ' selected directory
  nRC = zzINIPutInteger("DirNumber", cboOther.ListIndex)
  
  ' save option
  If optDir(0).Value Then
    nRC = zzINIPutInteger("Option", 0)
  ElseIf optDir(1).Value Then
    nRC = zzINIPutInteger("Option", 1)
  ElseIf optDir(2).Value Then
    nRC = zzINIPutInteger("Option", 2)
  End If

  ' save override option
  nRC = zzINIPutInteger("OverWrite", chkOverWrite.Value)

  ' save prompt option
  nRC = zzINIPutInteger("Prompt", chkMsg.Value)

  ' end program
  End

End Sub

Sub mnuFiAbout_Click ()

  ' about box
  Call zzAboutBox(Me, Me.Caption, "Genesis Software, Inc.", Me.Icon)

End Sub

Sub mnuFiExit_Click ()

  ' unload form
  Unload Me

End Sub

Sub mnuFiOpen_Click ()

 ' Description:
 '  Select stash file and process

 ' Variables:
  Dim nRC     As Integer      ' return code
  Dim tCDFile As zzCD_FILE    ' file information

  tCDFile.Title = "Open Stash (.FRX) File"
  tCDFile.Filename = "*.frx"
  tCDFile.Filter(1) = "*.frx"
  tCDFile.FilterText(1) = "Stash Files"
  tCDFile.Filter(2) = "*.*"
  tCDFile.FilterText(2) = "All Files"
  tCDFile.FilterCount = 2
  tCDFile.InitDir = "*.frx"

  ' if file selected then
  If zzDialogOpen(cdl, tCDFile) Then

    ' extract all pictures from it
    StashExtract RTrim$(UCase$(tCDFile.Filename))

  End If

End Sub

Sub optDir_Click (Index As Integer)

  ' hide controls based on option buttons
  cboOther.Visible = (Index = 2)
  cmdBrowse.Visible = (Index = 2)

  ' move to combo box
  On Error Resume Next
  If Index = 2 Then cboOther.SetFocus

End Sub

Sub StashExtract (ByVal sStashFile$)

 ' Description:
 '  sExtensionract pictures from stash file

 ' Constants:
  Const BMP = &H4D42             ' indicates a bitmap
  Const WMF = &H9AC6CDD7         ' indicates a windows metafile
  
 ' Variables:
  Dim lCurPos1         As Long     ' current position in file
  Dim lFileLen1        As Long     ' length of stash file
  Dim lMemoryAddress1  As Long     ' address of global memory
  Dim lPictureSize1    As Long     ' size of current picture
  Dim lRC              As Long     ' long return code
  Dim lWMFFlag         As Long     ' number to compare to constants above
  Dim nBMPFlag         As Integer  ' number to compare to constants above
  Dim nFileHandle1     As Integer  ' file handle for stash file
  Dim nFileHandle2     As Integer  ' file handle for new file
  Dim nFileNum1        As Integer  ' file number for stash file
  Dim nFileNum2        As Integer  ' file number for new file
  Dim nFileNum3        As Integer  ' file number for print file
  Dim nImageNumber     As Integer  ' image number
  Dim nImagesExtracted As Integer  ' images extracted
  Dim nMemoryHandle1   As Integer  ' handle to global memory
  Dim sExtension       As String   ' file name extension
  Dim sFileDir         As String   ' file name
  Dim sFileName        As String   ' file directory
  Dim sNewFile         As String   ' new file name
  Dim sPath            As String   ' current save path
            
  ' give user a chance to cancel
  If chkMsg = CHECKED Then
    s1 = "Do you wish to extract images from" & gsCHR_CRLF
    s1 = s1 & sStashFile & "?"
    If MsgBox(s1, MB_ICONQUESTION Or MB_YESNO) = IDNO Then Exit Sub
  End If

  ' please wait ...
  MousePointer = HOURGLASS
  
  ' handle errors
  On Error Resume Next
  
  ' get length of file
  lFileLen1 = FileLen(sStashFile)
  If Err <> 0 Then MousePointer = DEFAULT: MsgBox Error$, MB_ICONSTOP: Exit Sub
  
  ' open the file for extraction
  nFileNum1 = FreeFile
  Open sStashFile For Binary As #nFileNum1
  If Err <> 0 Then MousePointer = DEFAULT: MsgBox Error$, MB_ICONSTOP: Exit Sub

  ' open the file to hold files written
  nFileNum3 = FreeFile
  Open App.Path & "\FRXTRACT.TXT" For Output As #nFileNum3
  
  ' use program's directory
  If optDir(0) Then
    sPath = App.Path
  
  ' use stash file's directory
  ElseIf optDir(1) Then
    Call zzFileParse(sStashFile, sFileDir, sFileName)
    sPath = sFileDir

  ' use specific directory
  ElseIf optDir(2) Then
    sPath = cboOther.Text
  End If

  ' format path name
  sPath = zzPathFormat(sPath)

  ' start at first position
  lCurPos1 = 1
  
  ' loop til entire file read
  Do Until lCurPos1 >= lFileLen1

    ' get size of nsExtension picture
    Get #nFileNum1, lCurPos1, lPictureSize1

    ' increment current position
    lCurPos1 = lCurPos1 + 4

    ' avoid reading past end of file
    If lCurPos1 + lPictureSize1 - 1 > lFileLen1 Then Exit Do

    ' get flag indicate type of file
    Get #nFileNum1, lCurPos1, nBMPFlag

    ' is it a bitmap?
    If nBMPFlag = BMP Then    'check for bitmap
      sExtension = ".BMP"

    ' is it something else
    Else

      ' get bytes that indicates its a meta-file
      Get #nFileNum1, lCurPos1, lWMFFlag
      
      ' is it a metafile
      If lWMFFlag = WMF Then
        sExtension = ".WMF"
      
      ' only other option is ICON
      Else
        sExtension = ".ICO"
      End If
    
    End If

    ' reposition
    Seek #nFileNum1, lCurPos1
    
    ' get file handle
    nFileHandle1 = FileAttr(nFileNum1, 2)
    
    ' allocate chunk of global memory
    nMemoryHandle1 = GlobalAlloc(GMEM_HANDLE, lPictureSize1)
    
    ' lock memory which returns address
    lMemoryAddress1 = GlobalLock(nMemoryHandle1)
    
    ' read data from stash file
    lRC = hread(nFileHandle1, lMemoryAddress1, lPictureSize1)

    ' loop to determine proper name name

    Do
      nImageNumber = nImageNumber + 1
      sNewFile = UCase$(sPath & "stash" & Right$("00" & Format$(nImageNumber), 3) & sExtension)
    Loop Until Not zzFileExists(sNewFile) Or chkOverWrite = CHECKED
    
    ' get available file number
    nFileNum2 = FreeFile

    ' open new file
    Err = 0
    Open sNewFile For Output As nFileNum2
    Close nFileNum2
    Err = 0
    Open sNewFile For Binary As nFileNum2
    If Err <> 0 Then
      
      ' show message
      MousePointer = DEFAULT
      MsgBox Error$, MB_ICONSTOP
      
      ' free global memory
      lRC = GlobalUnlock(nMemoryHandle1)
      lRC = GlobalFree(nMemoryHandle1)
      
      ' leave loop
      Exit Do

    End If

    ' get file handle
    nFileHandle2 = FileAttr(nFileNum2, 2)

    ' write data to new file
    lRC = hwrite(nFileHandle2, lMemoryAddress1, lPictureSize1)

    ' free global memory
    lRC = GlobalUnlock(nMemoryHandle1)
    lRC = GlobalFree(nMemoryHandle1)
    
    ' close new file
    Close nFileNum2
  
    ' move to end of current picture
    lCurPos1 = lCurPos1 + lPictureSize1

    ' print entry into history file
    s1 = sNewFile & "   " & Format$(lFileLen1) & " bytes"
    Print #nFileNum3, s1
  
    ' increment counter of images extracted
    nImagesExtracted = nImagesExtracted + 1

  ' end of loop
  Loop

  ' tell user done
  s1 = "Extraction completed with " & Format$(nImagesExtracted)
  If nImagesExtracted <> 1 Then
    s1 = s1 & " images extracted from " & sStashFile & "."
  Else
    s1 = s1 & " image extracted from " & sStashFile & "."
  End If
  Print #nFileNum3,
  Print #nFileNum3, s1

  ' ... no more waiting
  MousePointer = DEFAULT

  MsgBox s1, MB_ICONINFORMATION

  ' close the stash and print file
  Close nFileNum1
  Close nFileNum3

End Sub

