VERSION 2.00
Begin Form frmDQTest 
   Caption         =   "Data Queue Tester Program"
   ClientHeight    =   5850
   ClientLeft      =   1185
   ClientTop       =   1635
   ClientWidth     =   9015
   Height          =   6255
   Icon            =   DQTEST.FRX:0000
   KeyPreview      =   -1  'True
   Left            =   1125
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5850
   ScaleWidth      =   9015
   Top             =   1290
   Width           =   9135
   Begin Timer tmrDrag 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   60
      Top             =   6420
   End
   Begin Frame fra 
      Caption         =   "Return Code and Error Message"
      Height          =   1575
      Index           =   5
      Left            =   60
      TabIndex        =   35
      Top             =   4200
      Width           =   3675
      Begin TextBox txtReturned 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   1155
         Left            =   120
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   16
         Top             =   300
         Width           =   3435
      End
   End
   Begin CommandButton cmdFunction 
      Caption         =   "&Functionality"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   315
      Left            =   60
      TabIndex        =   1
      Top             =   1020
      Width           =   1395
   End
   Begin Frame fra 
      Caption         =   "Receive Message"
      Height          =   3915
      Index           =   4
      Left            =   3840
      TabIndex        =   33
      Top             =   1860
      Width           =   5115
      Begin TextBox txtDQReceiveKey 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   2580
         TabIndex        =   28
         Top             =   660
         Width           =   1035
      End
      Begin ComboBox cboSearch 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   300
         Left            =   1140
         Style           =   2  'Dropdown List
         TabIndex        =   27
         Top             =   660
         Width           =   675
      End
      Begin TextBox txtDQReceiveKeySize 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   4440
         TabIndex        =   26
         Top             =   300
         Width           =   615
      End
      Begin TextBox txtDQReceiveSize 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   3000
         TabIndex        =   25
         Top             =   300
         Width           =   615
      End
      Begin TextBox txtDQReceive 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   120
         TabIndex        =   24
         Top             =   300
         Width           =   1935
      End
      Begin TextBox txtDQReceiveData 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   2355
         Left            =   120
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   29
         Top             =   1080
         Width           =   4875
      End
      Begin CommandButton cmdReceive 
         Caption         =   "&One"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   120
         TabIndex        =   30
         Top             =   3480
         Width           =   1215
      End
      Begin CommandButton cmdGroup 
         Caption         =   "&Group"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   1440
         TabIndex        =   31
         Top             =   3480
         Width           =   1215
      End
      Begin Label zlbl 
         BackColor       =   &H00FFFFFF&
         Caption         =   "Key"
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   12
         Left            =   2100
         TabIndex        =   50
         Top             =   720
         Width           =   435
      End
      Begin Label zlbl 
         BackColor       =   &H00FFFFFF&
         Caption         =   "Search For"
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   9
         Left            =   120
         TabIndex        =   47
         Top             =   720
         Width           =   975
      End
      Begin Label zlbl 
         BackColor       =   &H00FFFFFF&
         Caption         =   "Key Size"
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   6
         Left            =   3660
         TabIndex        =   43
         Top             =   360
         Width           =   855
      End
      Begin Label zlbl 
         BackColor       =   &H00FFFFFF&
         Caption         =   "Data Size"
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   3
         Left            =   2100
         TabIndex        =   44
         Top             =   360
         Width           =   855
      End
   End
   Begin Frame fra 
      Caption         =   "Send Message"
      Height          =   1755
      Index           =   3
      Left            =   3840
      TabIndex        =   45
      Top             =   60
      Width           =   5115
      Begin TextBox txtDQSendKeySize 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   4440
         TabIndex        =   19
         Top             =   300
         Width           =   615
      End
      Begin TextBox txtDQSend 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   120
         TabIndex        =   17
         Top             =   300
         Width           =   1935
      End
      Begin CommandButton cmdSend 
         Caption         =   "&Send"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Index           =   0
         Left            =   120
         TabIndex        =   22
         Top             =   1320
         Width           =   1215
      End
      Begin CommandButton cmdSend 
         Caption         =   "&Put"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Index           =   1
         Left            =   1440
         TabIndex        =   23
         Top             =   1320
         Width           =   1215
      End
      Begin TextBox txtDQSendData 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   120
         TabIndex        =   20
         Top             =   900
         Width           =   4275
      End
      Begin TextBox txtDQSendSize 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   3000
         TabIndex        =   18
         Top             =   300
         Width           =   495
      End
      Begin TextBox txtDQSendKey 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   4440
         TabIndex        =   21
         Top             =   900
         Width           =   615
      End
      Begin Label zlbl 
         BackColor       =   &H00FFFFFF&
         Caption         =   "Key Size"
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   13
         Left            =   3600
         TabIndex        =   51
         Top             =   360
         Width           =   855
      End
      Begin Label zlbl 
         BackColor       =   &H00FFFFFF&
         Caption         =   "Data"
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   4
         Left            =   120
         TabIndex        =   36
         Top             =   660
         Width           =   1095
      End
      Begin Label zlbl 
         BackColor       =   &H00FFFFFF&
         Caption         =   "Data Size"
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   5
         Left            =   2100
         TabIndex        =   37
         Top             =   360
         Width           =   915
      End
      Begin Label zlbl 
         BackColor       =   &H00FFFFFF&
         Caption         =   "Key"
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   1
         Left            =   4440
         TabIndex        =   38
         Top             =   660
         Width           =   435
      End
   End
   Begin Frame fra 
      Caption         =   "Start Program"
      Height          =   1275
      Index           =   2
      Left            =   1560
      TabIndex        =   40
      Top             =   60
      Width           =   2175
      Begin TextBox txtProgram 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   120
         TabIndex        =   2
         Top             =   300
         Width           =   1995
      End
      Begin CommandButton cmdStart 
         Caption         =   "S&tart"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   120
         TabIndex        =   3
         Top             =   720
         Width           =   1215
      End
   End
   Begin Frame fra 
      Caption         =   "Create/Clear/Attributes/Delete"
      Height          =   2775
      Index           =   0
      Left            =   60
      TabIndex        =   39
      Top             =   1380
      Width           =   3675
      Begin ComboBox cboAuth 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   300
         Left            =   1080
         Style           =   2  'Dropdown List
         TabIndex        =   8
         Top             =   1020
         Width           =   915
      End
      Begin ComboBox cboSeq 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   300
         Left            =   1080
         Style           =   2  'Dropdown List
         TabIndex        =   7
         Top             =   660
         Width           =   915
      End
      Begin TextBox txtDQCreateText 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   120
         TabIndex        =   11
         Top             =   1560
         Width           =   3435
      End
      Begin CheckBox chkDQCreateForce 
         Caption         =   "Force"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Left            =   2100
         TabIndex        =   9
         Top             =   960
         Width           =   735
      End
      Begin CheckBox chkDQCreateSenderID 
         Caption         =   "Sender ID"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Left            =   2100
         TabIndex        =   10
         Top             =   1200
         Value           =   1  'Checked
         Width           =   1035
      End
      Begin CommandButton cmdDelete 
         Caption         =   "&Delete"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   1440
         TabIndex        =   15
         Top             =   2340
         Width           =   1215
      End
      Begin TextBox txtDQCreateSize 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   3000
         TabIndex        =   5
         Top             =   300
         Width           =   615
      End
      Begin TextBox txtDQCreateKeySize 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   3000
         TabIndex        =   6
         Top             =   660
         Width           =   615
      End
      Begin CommandButton cmdClear 
         Caption         =   "&Clear"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   120
         TabIndex        =   13
         Top             =   2340
         Width           =   1215
      End
      Begin CommandButton cmdAttrib 
         Caption         =   "&Attributes"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   1440
         TabIndex        =   14
         Top             =   1980
         Width           =   1215
      End
      Begin TextBox txtDQCreate 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   120
         TabIndex        =   4
         Top             =   270
         Width           =   1935
      End
      Begin CommandButton cmdCreate 
         Caption         =   "Crea&te"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   120
         TabIndex        =   12
         Top             =   1980
         Width           =   1215
      End
      Begin Label zlbl 
         BackColor       =   &H00FFFFFF&
         Caption         =   "Authority"
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   11
         Left            =   120
         TabIndex        =   49
         Top             =   1080
         Width           =   855
      End
      Begin Label zlbl 
         BackColor       =   &H00FFFFFF&
         Caption         =   "Sequence"
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   10
         Left            =   120
         TabIndex        =   48
         Top             =   720
         Width           =   855
      End
      Begin Label zlbl 
         BackColor       =   &H00FFFFFF&
         Caption         =   "Description"
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   8
         Left            =   120
         TabIndex        =   46
         Top             =   1320
         Width           =   1155
      End
      Begin Label zlbl 
         BackColor       =   &H00FFFFFF&
         Caption         =   "Data Size"
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   7
         Left            =   2100
         TabIndex        =   42
         Top             =   360
         Width           =   855
      End
      Begin Label zlbl 
         BackColor       =   &H00FFFFFF&
         Caption         =   "Key Size"
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   2
         Left            =   2100
         TabIndex        =   41
         Top             =   720
         Width           =   855
      End
   End
   Begin CommandButton cmdExit 
      Caption         =   "E&xit"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   315
      Left            =   60
      TabIndex        =   32
      Top             =   60
      Width           =   1395
   End
   Begin ComboBox cboSystem 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   300
      Left            =   60
      Style           =   2  'Dropdown List
      TabIndex        =   0
      Top             =   660
      Width           =   1395
   End
   Begin Label zlbl 
      Alignment       =   2  'Center
      BackColor       =   &H00800000&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "System"
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Index           =   0
      Left            =   60
      TabIndex        =   34
      Top             =   420
      Width           =   1395
   End
End
Option Explicit

 ' Variables:
  Dim bButtonDown        As Integer   ' mouse button down
  Dim lDQMaxLen          As Long      ' maximum length
  Dim lDQWait            As Long      ' wait parameter
  Dim nDQAuthority       As Integer   ' authority
  Dim nDQDataLen         As Integer   ' length of data returned
  Dim nDQFunLvl          As Integer   ' funtionality level
  Dim nDQForce           As Integer   ' force write
  Dim nDQKeyLen          As Integer   ' key length
  Dim nDQrc              As Integer   ' DQ return code
  Dim nDQSenderID        As Integer   ' include sender ID
  Dim nDQSeq             As Integer   ' handling sequence
  Dim nDQWaitTotal       As Integer   ' total wait time for loop
  Dim nFileNum           As Integer   ' file handle
  Dim sCALib             As String    ' program library
  Dim sCAPgm             As String    ' program name
  Dim sCAProgram         As String    ' library/program
  Dim sDQData            As String    ' data sent
  Dim sDQErrMsg          As String    ' error message
  Dim sDQKey             As String    ' key value
  Dim sDQKeyRtnd         As String    ' key returned
  Dim sDQSearch          As String    ' search option
  Dim sDQSenderIDRtnd    As String    ' sender ID returned
  Dim sDQText            As String    ' DQ description

Sub cboSeq_Click ()

  ' show key size prompt and text box
  zlbl(2).Visible = (cboSeq.ListIndex = 2)
  txtDQCreateKeySize.Visible = (cboSeq.ListIndex = 2)

End Sub

Sub cboSystem_LostFocus ()
  
  ' setup for no automatic data conversion or peek
  nDQrc = zzDQConvertNo(Me.hWnd, cboSystem.Text, False, sDQErrMsg)
  Call FormatReturned

End Sub

Sub cmdAttrib_Click ()

 ' Description:
 '  Retrieve DQ descriptions

  MousePointer = HOURGLASS
  nDQrc = zzDQQueryAttributes(Me.hWnd, txtDQCreate.Text, cboSystem.Text, lDQMaxLen, nDQSeq, nDQForce, nDQSenderID, sDQText, nDQKeyLen, sDQErrMsg)
  Call FormatReturned
  MousePointer = DEFAULT

  ' other parameters
  txtDQCreateSize.Text = Format$(lDQMaxLen)
  cboSeq.ListIndex = nDQSeq
  chkDQCreateForce.Value = nDQForce
  chkDQCreateSenderID.Value = nDQSenderID
  txtDQCreateText.Text = sDQText
  txtDQCreateKeySize.Text = Format$(nDQKeyLen)

End Sub

Sub cmdClear_Click ()

  ' clear data queue
  MousePointer = HOURGLASS
  nDQrc = zzDQClear(Me.hWnd, txtDQCreate.Text, cboSystem.Text, sDQErrMsg)
  Call FormatReturned
  MousePointer = DEFAULT

End Sub

Sub cmdCreate_Click ()

 ' Description:
 '  Create a DQ

  ' setup parameters
  lDQMaxLen = Val(txtDQCreateSize.Text)
  nDQSeq = cboSeq.ListIndex
  nDQForce = chkDQCreateForce.Value
  nDQAuthority = cboAuth.ListIndex
  nDQKeyLen = Val(txtDQCreateKeySize.Text)
  nDQSenderID = chkDQCreateSenderID.Value
  sDQText = txtDQCreateText.Text
  
  MousePointer = HOURGLASS

  ' if creating data queue without key
  If nDQSeq <> 2 Then
    nDQrc = zzDQCreate(Me.hWnd, txtDQCreate.Text, cboSystem.Text, lDQMaxLen, nDQSeq, nDQForce, nDQAuthority, nDQSenderID, sDQText, sDQErrMsg)
  
  ' if creating data queue with key
  Else
    If nDQKeyLen > 0 Then
      nDQrc = zzDQCreateKeyed(Me.hWnd, txtDQCreate.Text, cboSystem.Text, lDQMaxLen, nDQSeq, nDQForce, nDQAuthority, nDQSenderID, sDQText, nDQKeyLen, sDQErrMsg)
    Else
      txtDQCreateKeySize.SetFocus
    End If
  End If
  
  ' show any messages returned
  Call FormatReturned
  MousePointer = DEFAULT

End Sub

Sub cmdDelete_Click ()
  
  ' delete data queue
  gsMBText = "Are you sure you wish to delete the "
  gsMBText = gsMBText & txtDQCreate.Text & " data queue?"
  If MsgBox(gsMBText, MB_ICONQUESTION Or MB_YESNO) = IDYES Then
    MousePointer = HOURGLASS
    nDQrc = zzDQDelete(Me.hWnd, txtDQCreate.Text, cboSystem.Text, sDQErrMsg)
    Call FormatReturned
    MousePointer = DEFAULT
  End If

End Sub

Sub cmdExit_Click ()
  
  ' end program
  Unload Me

End Sub

Sub cmdFunction_Click ()
  
  ' get function level
  MousePointer = HOURGLASS
  nDQrc = zzDQGetCapability(Me.hWnd, cboSystem.Text, nDQFunLvl, sDQErrMsg)
  txtReturned.Text = "Functional level: " & Format$(nDQFunLvl) & gsCHR_CRLF & "Return code: x'" & Hex$(nDQrc) & "'" & gsCHR_CRLF & sDQErrMsg
  MousePointer = DEFAULT

End Sub

Sub cmdGroup_Click ()

  MousePointer = HOURGLASS
  
  ' get search parameter
  sDQSearch = cboSearch.List(cboSearch.ListIndex)
  
  ' get length of message and key
  lDQMaxLen = Val(txtDQReceiveSize.Text)
  nDQKeyLen = Val(txtDQReceiveKeySize.Text)
  
  ' get key to search for
  sDQKey = Left$(txtDQReceiveKey & Space$(nDQKeyLen), nDQKeyLen)
  
  ' no waiting for single record
  lDQWait = 0
  
  ' wait 3 second before leaving loop
  nDQWaitTotal = 3
  
  ' get block of records
  sDQData = zzDQReceiveBlock(Me.hWnd, txtDQReceive.Text, cboSystem.Text, lDQMaxLen, sDQKey, sDQSearch, lDQWait, nDQWaitTotal, nDQrc, sDQErrMsg)
  txtDQReceiveData.Text = zzCV_EBCDICToASCII(Me.hWnd, sDQData)

  ' format return code and message
  Call FormatReturned

  MousePointer = DEFAULT

End Sub

Sub cmdReceive_Click ()

 ' Description:
 '  Receive a single record

  MousePointer = HOURGLASS

  ' get search parameter
  sDQSearch = cboSearch.List(cboSearch.ListIndex)

  ' get length of message and key
  lDQMaxLen = Val(txtDQReceiveSize.Text)
  nDQKeyLen = Val(txtDQReceiveKeySize.Text)
  
  ' get key to search for
  sDQKey = Left$(txtDQReceiveKey & Space$(nDQKeyLen), nDQKeyLen)
  
  ' no waiting
  lDQWait = 0

  ' get record from data queue
  nDQrc = zzDQReceive(Me.hWnd, txtDQReceive.Text, cboSystem.Text, lDQMaxLen, sDQKey, sDQSearch, 1, lDQWait, sDQData, sDQKeyRtnd, sDQSenderIDRtnd, nDQDataLen, sDQErrMsg)
  
  ' format return code and message
  Call FormatReturned
  
  ' get record
  sDQData = zzCV_EBCDICToASCII(Me.hWnd, sDQData)
  txtDQReceiveData.Text = sDQData

  ' write it out to disk
  nFileNum = FreeFile
  Open App.Path & "\dqtest.txt" For Output As nFileNum
  Print #nFileNum, sDQData
  Close nFileNum

  MousePointer = DEFAULT

End Sub

Sub cmdSend_Click (Index As Integer)

 ' Description:
 '  Send DQ record

  ' please wait
  MousePointer = HOURGLASS
  
  ' convert data to EBCDIC
  sDQData = zzCV_ASCIIToEBCDIC(Me.hWnd, txtDQSendData.Text)

  ' convert key to EBCDIC
  nDQKeyLen = Val(txtDQSendKeySize.Text)
  sDQKey = Left$(txtDQSendKey.Text & Space$(nDQKeyLen), nDQKeyLen)
  sDQKey = zzCV_ASCIIToEBCDIC(Me.hWnd, sDQKey)

  ' write keyed record
  If nDQKeyLen > 0 Then
    If Index = 0 Then
      nDQrc = zzDQSendKeyed(Me.hWnd, txtDQSend.Text, cboSystem.Text, sDQData, sDQKey, sDQErrMsg)
    Else
      nDQrc = zzDQPutKeyed(Me.hWnd, txtDQSend.Text, cboSystem.Text, sDQData, sDQKey, sDQErrMsg)
    End If

  ' write non-keyed record
  Else
    If Index = 0 Then
      nDQrc = zzDQSend(Me.hWnd, txtDQSend.Text, cboSystem.Text, sDQData, sDQErrMsg)
    Else
      nDQrc = zzDQPut(Me.hWnd, txtDQSend.Text, cboSystem.Text, sDQData, sDQErrMsg)
    End If
  End If
  
  ' show returned messages
  Call FormatReturned

  ' no more waiting
  MousePointer = DEFAULT
  
End Sub

Sub cmdStart_Click ()

 ' Description:
 '  Start Program

 ' Variables:
  Dim nPos          As Integer     ' location of "/"
  
  ' refresh program name
  sCAProgram = txtProgram.Text
  
  ' find separator
  nPos = InStr(sCAProgram, "/")

  ' must have library and program
  If Len(Trim$(sCAProgram)) = 0 Then
    gsMBText = "Please enter a program name in"
    gsMBText = gsMBText & " 'library/program' format."
    MsgBox gsMBText, MB_ICONSTOP
    txtProgram.SetFocus
    Exit Sub
  
  ' must be in correct format
  ElseIf nPos = 0 Then
    gsMBText = "Program must be specified in"
    gsMBText = gsMBText & " 'library/program' format."
    MsgBox gsMBText, MB_ICONSTOP
    txtProgram.SetFocus
    Exit Sub
  End If
  
  ' separate library and program name
  sCALib = Left$(sCAProgram, nPos - 1)
  sCAPgm = Mid$(sCAProgram, nPos + 1)
  
  ' start the program
  MousePointer = HOURGLASS
  nDQrc = zzCAStartProgram(Me.hWnd, cboSystem.Text, sCALib, sCAPgm, gsCHR_NUL)
  sDQErrMsg = gsEMPTY
  Call FormatReturned
  MousePointer = DEFAULT

End Sub

Sub Form_KeyPress (KeyAscii As Integer)

  ' everything uppercase
  KeyAscii = Asc(UCase$(Chr$(KeyAscii)))

End Sub

Sub Form_Load ()

  ' setup global variables
  Call zzSetGlobalVariables

  ' don't allow more than one
  App.Title = Caption
  If App.PrevInstance Then End

  ' center the form
  zzFormCenter Me
  
  ' put list of systems into combo
  Call zzCAPutSystemListIntoCtrl(Me.hWnd, cboSystem)

  ' build sequence combo
  cboSeq.AddItem "LIFO"
  cboSeq.AddItem "FIFO"
  cboSeq.AddItem "Keyed"
  cboSeq.ListIndex = 1
  
  ' build authority combo
  cboAuth.AddItem "All"
  cboAuth.AddItem "Exclude"
  cboAuth.AddItem "Change"
  cboAuth.AddItem "Use"
  cboAuth.AddItem "Create"
  cboAuth.ListIndex = 0
  
  ' build search combo
  cboSearch.AddItem "NE"
  cboSearch.AddItem "EQ"
  cboSearch.AddItem "GT"
  cboSearch.AddItem "LT"
  cboSearch.AddItem "GE"
  cboSearch.AddItem "LE"
  cboSearch.ListIndex = 0

  ' setup drag icon
  txtDQCreate.DragIcon = Icon

End Sub

Sub Form_Unload (Cancel As Integer)

  ' stop DQ activity
  nDQrc = zzDQStop(Me.hWnd, cboSystem.Text)
  If nDQrc < gnDQ_SUCCESS Then
    sDQErrMsg = "Data queue activity not stopped."
    Call FormatReturned
    MsgBox txtReturned.Text, MB_ICONINFORMATION
  End If
  
  ' end program
  End

End Sub

Sub FormatReturned ()
  
  ' format return code and any message
  txtReturned.Text = "Return code: x'" & Hex$(nDQrc) & "'" & gsCHR_CRLF & sDQErrMsg

End Sub

Sub tmrDrag_Timer ()
  
  ' if mouse still down
  If bButtonDown Then
    
    ' enable drag mode
    txtDQCreate.Drag 1
    
    ' turn off flag
    bButtonDown = False

  End If
  
  ' turn off timer
  tmrDrag.Enabled = False

End Sub

Sub txtDQCreate_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)

  ' button is down
  bButtonDown = True

  ' turn on timer
  tmrDrag.Enabled = True
  
End Sub

Sub txtDQCreate_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
  
  ' button is not down
  bButtonDown = False

End Sub

Sub txtDQReceive_DragDrop (Source As Control, X As Single, Y As Single)
  
  ' make receive info same as create
  txtDQReceive.Text = txtDQCreate.Text
  txtDQReceiveSize.Text = txtDQCreateSize.Text
  txtDQReceiveKeySize.Text = txtDQCreateKeySize.Text

End Sub

Sub txtDQSend_DragDrop (Source As Control, X As Single, Y As Single)

  ' make send info same as create
  txtDQSend.Text = txtDQCreate.Text
  txtDQSendSize.Text = txtDQCreateSize.Text
  txtDQSendKeySize.Text = txtDQCreateKeySize.Text

End Sub

Sub txtDQSendData_Change ()
  
  ' show size of data being sent
  txtDQSendSize.Text = Format$(Len(txtDQSendData.Text))

End Sub

